/*
 * Decompiled with CFR 0.152.
 */
package com.byh.nursingcarenewserver.aspect;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/*
 * Exception performing whole class analysis ignored.
 */
@Aspect
@Component
public class LogAspect {
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    ThreadLocal<Long> startTime = new ThreadLocal();

    @Pointcut(value="execution( * com.byh.nursingcarenewserver.controller..*.*(..))")
    public void pointcut() {
    }

    @Before(value="pointcut()")
    public void doBefore(JoinPoint joinPoint) {
        this.startTime.set(System.currentTimeMillis());
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = requestAttributes.getRequest();
        Object[] args = joinPoint.getArgs();
        String params = "";
        if (args.length > 0) {
            if ("POST".equals(request.getMethod())) {
                Object object = args[0];
                if (Objects.nonNull(object)) {
                    Map map = LogAspect.getKeyAndValue((Object)object);
                    params = JSON.toJSONString((Object)map);
                }
            } else if ("GET".equals(request.getMethod())) {
                params = request.getQueryString();
            }
        }
        log.info("\n---------------------------------------\u8bf7\u6c42\u5f00\u59cb-------------------------------------------\n=======\u8bf7\u6c42\u5730\u5740: " + request.getRequestURL().toString() + "    \u8bf7\u6c42\u65b9\u6cd5: " + request.getMethod() + "\n=======User-Agent: " + request.getHeader("User-Agent") + "\n=======Class Method: " + joinPoint.getSignature().getDeclaringTypeName() + "." + joinPoint.getSignature().getName() + "\n=======Cookies: " + Arrays.toString(request.getCookies()) + "\n=======\u8bf7\u6c42\u53c2\u6570: " + params);
    }

    @AfterReturning(returning="ret", pointcut="pointcut()")
    public void doAfterReturning(Object ret) {
        log.info("\n=======\u8017\u65f6 : " + (System.currentTimeMillis() - (Long)this.startTime.get()) + "ms\n=======\u8fd4\u56de\u7ed3\u679c\u4e3a: " + JSON.toJSONString((Object)ret) + "\n=======AppLogAspect.doAfterReturning()\n---------------------------------------\u8bf7\u6c42\u7ed3\u675f-------------------------------------------");
    }

    public static Map<String, Object> getKeyAndValue(Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Class<?> userCla = obj.getClass();
        Field[] fs = userCla.getDeclaredFields();
        for (int i = 0; i < fs.length; ++i) {
            Field f = fs[i];
            f.setAccessible(true);
            Object val = new Object();
            try {
                val = f.get(obj);
                map.put(f.getName(), val);
                continue;
            }
            catch (Exception e) {
                log.error("Exception", (Throwable)e);
            }
        }
        return map;
    }
}

