/*
 * Decompiled with CFR 0.152.
 */
package com.byh.nursingcarenewserver.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.nursingcarenewserver.common.execption.BusinessException;
import com.byh.nursingcarenewserver.mapper.AppointmentJunkMapper;
import com.byh.nursingcarenewserver.mapper.AppointmentMapper;
import com.byh.nursingcarenewserver.pojo.dto.DetailJunkDto;
import com.byh.nursingcarenewserver.pojo.dto.SelectListJunkDto;
import com.byh.nursingcarenewserver.pojo.entity.Appointment;
import com.byh.nursingcarenewserver.pojo.entity.AppointmentJunk;
import com.byh.nursingcarenewserver.pojo.vo.SaveAppointmentJunkVo;
import com.byh.nursingcarenewserver.pojo.vo.SelectListJunkVo;
import com.byh.nursingcarenewserver.pojo.vo.UpdateJunkVo;
import com.byh.nursingcarenewserver.service.AppointmentJunkService;
import com.byh.nursingcarenewserver.utils.DateUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class AppointmentJunkServiceImpl
extends ServiceImpl<AppointmentJunkMapper, AppointmentJunk>
implements AppointmentJunkService {
    private static final Logger log = LoggerFactory.getLogger(AppointmentJunkServiceImpl.class);
    @Autowired
    private AppointmentJunkMapper appointmentJunkMapper;
    @Autowired
    private AppointmentMapper appointmentMapper;
    private static final String EXCEPTION_INFO_NO_RESULT = "\u6ca1\u6709\u76f8\u5173\u8bb0\u5f55";

    @Transactional
    public String saveAppointmentJunk(SaveAppointmentJunkVo saveAppointmentJunkVo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"view_id", (Object)saveAppointmentJunkVo.getAppointmentId());
        Appointment appointment = (Appointment)this.appointmentMapper.selectOne((Wrapper)queryWrapper);
        if (ObjectUtils.isEmpty((Object)appointment)) {
            throw new BusinessException(EXCEPTION_INFO_NO_RESULT);
        }
        AppointmentJunk appointmentJunk = new AppointmentJunk();
        BeanUtils.copyProperties((Object)saveAppointmentJunkVo, (Object)appointmentJunk);
        int insert = this.appointmentJunkMapper.insert((Object)appointmentJunk);
        if (insert != 1) {
            return "NO";
        }
        return "YES";
    }

    public DetailJunkDto getAppointmentJunkDetail(String junkId) {
        AppointmentJunk appointmentJunk = (AppointmentJunk)this.appointmentJunkMapper.selectById((Serializable)((Object)junkId));
        if (ObjectUtils.isEmpty((Object)appointmentJunk)) {
            throw new BusinessException(EXCEPTION_INFO_NO_RESULT);
        }
        DetailJunkDto detailJunkDto = new DetailJunkDto();
        BeanUtils.copyProperties((Object)appointmentJunk, (Object)detailJunkDto);
        Date handleTime = DateUtils.phpTimeToJavaTime((Integer)appointmentJunk.getHandleTime());
        detailJunkDto.setHandleTime(handleTime);
        return detailJunkDto;
    }

    @Transactional
    public String deleteAppointmentJunk(String junkId) {
        AppointmentJunk appointmentJunk = (AppointmentJunk)this.appointmentJunkMapper.selectById((Serializable)((Object)junkId));
        if (ObjectUtils.isEmpty((Object)appointmentJunk)) {
            throw new BusinessException(EXCEPTION_INFO_NO_RESULT);
        }
        int num = this.appointmentJunkMapper.deleteById((Serializable)((Object)junkId));
        if (num != 1) {
            return "NO";
        }
        return "YES";
    }

    public List<SelectListJunkDto> selectListJunk(SelectListJunkVo selectListJunkVo) {
        ArrayList<SelectListJunkDto> selectListJunkDtos = new ArrayList<SelectListJunkDto>();
        String appointmentId = selectListJunkVo.getAppointmentId();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"appointment_id", (Object)selectListJunkVo.getAppointmentId())).orderByDesc((Object)"handle_time");
        List junkList = this.appointmentJunkMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)junkList)) {
            return selectListJunkDtos;
        }
        junkList.forEach(junk -> {
            SelectListJunkDto JunkDto = new SelectListJunkDto();
            BeanUtils.copyProperties((Object)junk, (Object)JunkDto);
            Date handleTime = DateUtils.phpTimeToJavaTime((Integer)junk.getHandleTime());
            JunkDto.setHandleTime(handleTime);
            selectListJunkDtos.add(JunkDto);
        });
        return selectListJunkDtos;
    }

    public String editJunkDetail(UpdateJunkVo updateJunkVo) {
        AppointmentJunk junk = (AppointmentJunk)this.appointmentJunkMapper.selectById((Serializable)((Object)updateJunkVo.getId()));
        if (ObjectUtils.isEmpty((Object)junk)) {
            throw new BusinessException(EXCEPTION_INFO_NO_RESULT);
        }
        AppointmentJunk appointmentJunk = new AppointmentJunk();
        BeanUtils.copyProperties((Object)updateJunkVo, (Object)appointmentJunk);
        boolean update = this.updateById((Object)appointmentJunk);
        if (!update) {
            return "NO";
        }
        return "YES";
    }
}

