/*
 * Decompiled with CFR 0.152.
 */
package com.byh.nursingcarenewserver.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.byh.nursingcarenewserver.constant.ComponentConstant;
import com.byh.nursingcarenewserver.mapper.AppointmentMapper;
import com.byh.nursingcarenewserver.mapper.OrderMapper;
import com.byh.nursingcarenewserver.mapper.ProductSubitemMapper;
import com.byh.nursingcarenewserver.pojo.entity.Appointment;
import com.byh.nursingcarenewserver.pojo.entity.OrderInvoice;
import com.byh.nursingcarenewserver.pojo.entity.Orders;
import com.byh.nursingcarenewserver.pojo.entity.ProductSubitem;
import com.byh.nursingcarenewserver.pojo.enums.AppointmentStatusEnum;
import com.byh.nursingcarenewserver.pojo.enums.OrderStatusDescribeEnum;
import com.byh.nursingcarenewserver.pojo.enums.OrderStatusEnum;
import com.byh.nursingcarenewserver.pojo.vo.InvoiceChargeVo;
import com.byh.nursingcarenewserver.pojo.vo.InvoiceListDetailVo;
import com.byh.nursingcarenewserver.pojo.vo.InvoicePayChannelVo;
import com.byh.nursingcarenewserver.pojo.vo.InvoiceVo;
import com.byh.nursingcarenewserver.pojo.vo.RedInvoiceVo;
import com.byh.nursingcarenewserver.service.AppWebPushService;
import com.byh.nursingcarenewserver.service.OrderInvoiceService;
import com.byh.nursingcarenewserver.utils.DateUtils;
import com.byh.nursingcarenewserver.utils.InvoiceUtils;
import com.byh.nursingcarenewserver.utils.PushParamUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ScheduledService {
    private static final Logger log = LoggerFactory.getLogger(ScheduledService.class);
    @Autowired
    private AppointmentMapper appointmentMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private ProductSubitemMapper productSubitemMapper;
    @Autowired
    private AppWebPushService appWebPushService;
    @Resource
    private OrderInvoiceService orderInvoiceService;
    @Resource
    private InvoiceUtils invoiceUtils;
    @Resource
    private PushParamUtil pushParamUtil;
    @Resource
    private ComponentConstant componentConstant;

    @Scheduled(cron="0 0 23 * * ?")
    public void deleteUnpaidOrder() {
        log.info("\u8fdb\u5165\u5b9a\u65f6\u4efb\u52a1====\u5220\u9664\u672a\u652f\u4ed8\u8ba2\u5355===");
        List idList = this.orderMapper.selectUnpaidOrder();
        if (CollectionUtils.isEmpty((Collection)idList)) {
            log.info("\u65e0\u672a\u652f\u4ed8\u8ba2\u5355\uff0c\u5b9a\u65f6\u4efb\u52a1\u9000\u51fa");
            return;
        }
        log.info("\u5220\u9664\u672a\u652f\u4ed8\u8ba2\u5355id\u96c6\u5408\u4e3a{}", (Object)JSONObject.toJSONString((Object)idList));
        int i = this.orderMapper.deleteBatchIds((Collection)idList);
        log.info("\u5220\u9664\u672a\u652f\u4ed8\u8ba2\u5355\uff0c\u5f71\u54cd\u884c\u6570\u4e3a{}", (Object)i);
    }

    @Scheduled(cron="0 0 23 * * ?")
    @Transactional(rollbackFor={Exception.class})
    public void overdueOrders() {
        List ordersList = this.orderMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"status", (Object)OrderStatusEnum.ORDER_STATUS_SYZ.getValue()));
        for (Orders orders : ordersList) {
            try {
                ProductSubitem productSubitem = this.productSubitemMapper.queryById(orders.getProductSubitemId());
                if (Objects.isNull(productSubitem)) {
                    log.info("\u672a\u627e\u5230\u8ba2\u5355,{}", (Object)orders.getId());
                    continue;
                }
                log.info("\u627e\u5230\u8ba2\u5355:{}", (Object)JSON.toJSONString((Object)productSubitem));
                Date plusDay = null;
                plusDay = DateUtils.plusDay1((int)productSubitem.getUsefulLife(), (String)DateUtils.dateToString((Date)orders.getCreateTime()));
                log.info("\u8ba2\u5355\uff1a{},\u7684\u8fc7\u671f\u65e5\u671f\u662f\uff1a{}", (Object)orders.getId(), (Object)DateUtils.dateFormat((Date)plusDay));
                Date date = new Date();
                int compareTo = date.compareTo(plusDay);
                if (compareTo <= 0) continue;
                orders.setStatus(OrderStatusEnum.ORDER_STATUS_YGQ.getValue());
                orders.setStatusDescribe(OrderStatusDescribeEnum.STATUS_YGQ.getDisplay());
                orders.setServerResidueNum(Integer.valueOf(0));
                this.orderMapper.update((Object)orders, (Wrapper)new UpdateWrapper().eq((Object)"id", (Object)orders.getId()));
            }
            catch (Exception e) {
                log.error("\u5b9a\u65f6\u4efb\u52a1\u8fc7\u671f\u8ba2\u5355\u5904\u7406\uff0c\u51fa\u9519\u8ba2\u5355\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)orders.getId(), (Object)e.getMessage());
            }
        }
    }

    @Scheduled(cron="0 0 * * * ?")
    public void todayBeforeTwoPush() {
        log.info("===========\u5f53\u5929\u9884\u7ea6\u5355\u9884\u7ea6\u524d2\u5c0f\u65f6\u63a8\u9001\u5f00\u59cb=========");
        String date = "";
        try {
            date = DateUtils.getDate((Date)new Date());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5f53\u524d\u65e5\u671f\u9519\u8bef");
        }
        Integer dateTime = DateUtils.dateToTimeStamp((String)DateUtils.javaDateParseStringByPattern((Date)new Date(), (String)"yyyy-MM-dd HH"), (String)"yyyy-MM-dd HH");
        log.info("\u83b7\u53d6\u5f53\u524d\u65f6\u95f4\u6574\u5c0f\u65f6\u7684\u65f6\u95f4\u6233\u4e3a:{}", (Object)dateTime);
        Integer dateBeforeTime = dateTime + 7200;
        log.info("\u83b7\u53d6\u4e24\u4e2a\u5c0f\u65f6\u5019\u540e\u7684\u65f6\u95f4\u6233\u4e3a:{}", (Object)dateBeforeTime);
        Integer dateAfterTime = dateBeforeTime + 3600;
        log.info("\u83b7\u53d6\u4e24\u4e2a\u5c0f\u65f6\u5019\u540e\u7684\u65f6\u95f4\u6233\u4e3a:{}", (Object)dateBeforeTime);
        List appointmentList = this.appointmentMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"status", (Object)AppointmentStatusEnum.APPOINTMENT_STATUS_DFW.getValue())).like((Object)"appointment_time", (Object)date));
        if (CollectionUtils.isNotEmpty((Collection)appointmentList)) {
            for (Appointment appointment : appointmentList) {
                Integer appointmentTimeInteger = null;
                String appointmentTime = null;
                String[] split1 = null;
                try {
                    String[] split = appointment.getAppointmentTime().split(" ");
                    split1 = split[1].split("-");
                    appointmentTime = split[0] + " " + split1[0] + ":00";
                    appointmentTimeInteger = DateUtils.dateToTimeStamp((String)appointmentTime, (String)"yyyy-MM-dd HH:mm:ss");
                }
                catch (Exception e) {
                    log.error("\u9884\u7ea6\u65f6\u95f4\u683c\u5f0f\u51fa\u73b0\u9519\u8bef\uff0c\u65e0\u6cd5\u6b63\u786e\u5206\u89e3\uff0c\u76f4\u63a5\u8df3\u8fc7\u3002\u9519\u8bef\u5982\u4e0b\uff1a", (Throwable)e);
                    continue;
                }
                log.info("appointmentTime:{},appTimeInteger:{}", (Object)appointmentTime, (Object)appointmentTimeInteger);
                log.info("appointmentTimeBefore:{}", (Object)dateBeforeTime);
                log.info("appointmentTimeAfter:{}", (Object)dateAfterTime);
                try {
                    if (appointmentTimeInteger < dateBeforeTime || appointmentTimeInteger >= dateAfterTime) continue;
                    log.info("\u5f53\u5929\u9884\u7ea6\u5355\u9884\u7ea6\u524d2\u5c0f\u65f6\u63a8\u9001id:{}", (Object)appointment.getId());
                    String userId = this.pushParamUtil.getUserIdByDoctorId(appointment.getDoctorId(), appointment.getDoctorOrganId().toString());
                    this.appWebPushService.todayBeforeTwoPush(this.componentConstant.getAppCode(), userId, split1[0]);
                }
                catch (Exception e) {
                    log.info("\u5f53\u5929\u9884\u7ea6\u5355\u9884\u7ea6\u524d2\u5c0f\u65f6\u63a8\u9001\u5f02\u5e38id\uff1a{}", (Object)appointment.getId());
                }
            }
        } else {
            log.info("===========\u5f53\u5929\u9884\u7ea6\u5355\u9884\u7ea6\u524d2\u5c0f\u65f6\u63a8  \u65e0\u8ba2\u5355=========");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    @Scheduled(cron="0 0 18 * * ?")
    public void doInvoice() {
        log.info("\u8fdb\u5165\u5b9a\u65f6\u4efb\u52a1===\u626b\u63cf\u6240\u6709\u5df2\u5b8c\u6210\u8ba2\u5355===\u5f00\u53d1\u7968");
        List invoiceDtoList = this.orderMapper.selectFinishOrderInvoiceInfo();
        if (CollectionUtils.isEmpty((Collection)invoiceDtoList)) {
            return;
        }
        ArrayList<InvoiceVo> invoiceVoList = new ArrayList<InvoiceVo>();
        invoiceDtoList.forEach(invoiceDto -> {
            InvoiceVo invoiceVo = new InvoiceVo();
            BeanUtils.copyProperties((Object)invoiceDto, (Object)invoiceVo);
            invoiceVo.setAppCode(this.componentConstant.getAppCode());
            invoiceVo.setServiceName("HLZH");
            invoiceVo.setBusDateTime(DateUtils.javaDateParseStringByPattern((Date)invoiceDto.getBusDateTime(), null));
            invoiceVo.setBusType("02");
            invoiceVo.setCardType("1101");
            ArrayList<InvoiceChargeVo> chargeDetail = new ArrayList<InvoiceChargeVo>();
            InvoiceChargeVo invoiceChargeVo = new InvoiceChargeVo();
            invoiceChargeVo.setAmt(invoiceDto.getTotalAmt());
            invoiceChargeVo.setChargeCode("4479903");
            invoiceChargeVo.setChargeName("\u62a4\u7406\u8d39");
            invoiceChargeVo.setNumber("1");
            invoiceChargeVo.setSelfAmt(invoiceDto.getTotalAmt());
            invoiceChargeVo.setSortNo("1");
            invoiceChargeVo.setStd(invoiceDto.getTotalAmt());
            invoiceChargeVo.setUnit("\u6b21");
            chargeDetail.add(invoiceChargeVo);
            invoiceVo.setChargeDetail(chargeDetail);
            invoiceVo.setConsultationDate(DateUtils.javaDateParseStringByPattern((Date)invoiceDto.getConsultationDate(), null));
            invoiceVo.setIdCardNo(invoiceDto.getCardNo());
            ArrayList<InvoiceListDetailVo> listDetailVos = new ArrayList<InvoiceListDetailVo>();
            InvoiceListDetailVo invoiceListDetailVo = new InvoiceListDetailVo();
            invoiceListDetailVo.setAmt(invoiceDto.getTotalAmt());
            invoiceListDetailVo.setChargeCode("4479903");
            invoiceListDetailVo.setChargeName("\u62a4\u7406\u8d39");
            invoiceListDetailVo.setCode("");
            invoiceListDetailVo.setName(invoiceDto.getName());
            invoiceListDetailVo.setNumber("1");
            invoiceListDetailVo.setSelfAmt(invoiceDto.getTotalAmt());
            invoiceListDetailVo.setSortNo("1");
            invoiceListDetailVo.setStd(invoiceDto.getTotalAmt());
            listDetailVos.add(invoiceListDetailVo);
            invoiceVo.setListDetail(listDetailVos);
            invoiceVo.setMedicalCareType("\u81ea\u8d39");
            invoiceVo.setOtherfundPay("0");
            invoiceVo.setOwnPay(invoiceDto.getTotalAmt());
            invoiceVo.setPatientId(invoiceDto.getCardNo());
            invoiceVo.setPatientNo(invoiceDto.getCardNo());
            ArrayList<InvoicePayChannelVo> payChannelDetail = new ArrayList<InvoicePayChannelVo>();
            InvoicePayChannelVo invoicePayChannelVo = new InvoicePayChannelVo();
            invoicePayChannelVo.setPayChannelCode("05");
            invoicePayChannelVo.setPayChannelValue(invoiceDto.getTotalAmt());
            payChannelDetail.add(invoicePayChannelVo);
            invoiceVo.setPayChannelDetail(payChannelDetail);
            invoiceVo.setPayerType("1");
            invoiceVo.setSelfCashPay(invoiceDto.getTotalAmt());
            invoiceVoList.add(invoiceVo);
        });
        invoiceVoList.forEach(invoiceVo -> {
            String response = this.invoiceUtils.createInvoice(invoiceVo);
            if (!JSON.parseObject((String)response).getString("code").equals("1")) {
                log.info("\u5f00\u53d1\u7968\u5931\u8d25\u7684\u8ba2\u5355,\u8ba2\u5355\u7f16\u53f7{}", (Object)invoiceVo.getBusNo());
                return;
            }
            Orders orders = new Orders();
            orders.setViewId(invoiceVo.getBusNo());
            orders.setInvoiceFlag(Integer.valueOf(1));
            UpdateWrapper updateWrapper = (UpdateWrapper)new UpdateWrapper().eq((Object)"view_id", (Object)invoiceVo.getBusNo());
            this.orderMapper.update((Object)orders, (Wrapper)updateWrapper);
            JSONObject dataJson = JSON.parseObject((String)response).getJSONObject("data");
            String pictureNetUrl = dataJson.get((Object)"pictureNetUrl").toString();
            String billNo = dataJson.get((Object)"billNo").toString();
            OrderInvoice one = (OrderInvoice)this.orderInvoiceService.getOne((Wrapper)new QueryWrapper().eq((Object)"order_view_id", (Object)invoiceVo.getBusNo()));
            if (ObjectUtils.isEmpty((Object)one)) {
                OrderInvoice orderInvoice = new OrderInvoice();
                orderInvoice.setBillNo(billNo);
                orderInvoice.setOrderViewId(invoiceVo.getBusNo());
                orderInvoice.setPictureNetUrl(pictureNetUrl);
                this.orderInvoiceService.save((Object)orderInvoice);
            } else {
                one.setBillNo(billNo);
                one.setOrderViewId(invoiceVo.getBusNo());
                one.setPictureNetUrl(pictureNetUrl);
                this.orderInvoiceService.updateById((Object)one);
            }
        });
    }

    @Scheduled(cron="0 0 23 * * ?")
    public void doRedInvoice() {
        log.info("\u5b9a\u65f6\u4efb\u52a1==\u51b2\u7ea2\u53d1\u7968\u4efb\u52a1==\u9488\u5bf9\u6240\u6709\u5df2\u5f00\u53d1\u7968\u4f46\u72b6\u6001\u53d8\u4e3a\u5df2\u9000\u6b3e\u7684\u8ba2\u5355");
        List ordersList = this.orderMapper.findUnRedOrder();
        if (CollectionUtils.isEmpty((Collection)ordersList)) {
            return;
        }
        List<Orders> collect = ordersList.stream().filter(o -> o.getStatus().equals(OrderStatusEnum.ORDER_STATUS_YTK.getValue())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return;
        }
        collect.forEach(order -> {
            RedInvoiceVo redInvoiceVo = new RedInvoiceVo();
            redInvoiceVo.setAppCode(this.componentConstant.getAppCode());
            redInvoiceVo.setServiceName("HLZH");
            List appointmentList = this.appointmentMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"service_order_id", (Object)order.getId()));
            Long doctorOrganId = ((Appointment)appointmentList.get(0)).getDoctorOrganId();
            redInvoiceVo.setHospitalId(String.valueOf(doctorOrganId));
            redInvoiceVo.setBusType("02");
            redInvoiceVo.setBusNo(order.getViewId());
            redInvoiceVo.setPatientId(order.getPatientIdCard());
            String response = this.invoiceUtils.writeOffInvoice(redInvoiceVo);
            if (!JSON.parseObject((String)response).getString("code").equals("1")) {
                log.info("\u51b2\u7ea2\u53d1\u7968\u5931\u8d25,\u8ba2\u5355\u7f16\u53f7{}", (Object)order.getViewId());
                return;
            }
            JSONObject dataJson = JSON.parseObject((String)response).getJSONObject("data");
            String pictureNetUrl = dataJson.get((Object)"pictureNetUrl").toString();
            String billNo = dataJson.get((Object)"billNo").toString();
            OrderInvoice orderInvoice = (OrderInvoice)this.orderInvoiceService.getOne((Wrapper)new QueryWrapper().eq((Object)"order_view_id", (Object)order.getViewId()));
            orderInvoice.setRedFlag(Integer.valueOf(1));
            orderInvoice.setPicutureRedUrl(pictureNetUrl);
            orderInvoice.setBillRedNo(billNo);
            boolean update = this.orderInvoiceService.updateById((Object)orderInvoice);
            log.info("\u9000\u6b3e\u8ba2\u5355\u6240\u5f00\u53d1\u7968\u5df2\u51b2\u7ea2\uff0c\u66f4\u6539order_invoice\u8868\u7ed3\u679c\u4e3a\u3010{}\u3011", (Object)update);
        });
    }
}

