/*
 * Decompiled with CFR 0.152.
 */
package com.byh.nursingcarenewserver.mq;

import com.byh.nursingcarenewserver.mapper.OrderMapper;
import com.byh.nursingcarenewserver.pojo.entity.HospitalConfig;
import com.byh.nursingcarenewserver.pojo.entity.Orders;
import com.byh.nursingcarenewserver.pojo.enums.OrderStatusEnum;
import com.byh.nursingcarenewserver.service.HospitalConfigService;
import com.byh.nursingcarenewserver.service.ProgramPushService;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Component
public class ReturnVisitMQListener {
    private static final Logger log = LoggerFactory.getLogger(ReturnVisitMQListener.class);
    @Resource
    private OrderMapper orderMapper;
    @Resource
    private ProgramPushService programPushService;
    @Resource
    private HospitalConfigService hospitalConfigService;

    @RabbitHandler
    @RabbitListener(queues={"return.visit.notify.queue"})
    @Transactional(rollbackFor={Exception.class})
    public void process(String info) {
        log.info("\u5df2\u5b8c\u6210\u8ba2\u535515\u5929\u540e\u590d\u8d2d\u63d0\u9192\uff0c\u8fdb\u5165\u6d88\u606f\u5904\u7406\uff0c\u53c2\u6570\u4e3a\uff1a{}", (Object)info);
        if (StringUtils.isEmpty((CharSequence)info)) {
            log.info("\u53c2\u6570\u4e3a\u7a7a\uff0c\u9000\u51fa");
            return;
        }
        Orders order = this.orderMapper.queryByViewId(info);
        if (ObjectUtils.isEmpty((Object)order)) {
            log.info("\u8ba2\u5355\u4e0d\u5b58\u5728,viewId = {}", (Object)info);
        }
        if (!order.getStatus().equals(OrderStatusEnum.ORDER_STATUS_YWC.getValue())) {
            log.info("\u8ba2\u5355\u72b6\u6001\u4e0d\u662f'\u5df2\u5b8c\u6210'\uff0c\u9000\u51fa");
            return;
        }
        HospitalConfig hospitalConfig = (HospitalConfig)this.hospitalConfigService.list().get(0);
        try {
            this.programPushService.returnVisitNotify(hospitalConfig.getAppCode(), order.getViewId());
        }
        catch (Exception e) {
            log.error("\u590d\u8d2d\u6d88\u606f\u63a8\u9001\u51fa\u9519", (Throwable)e);
        }
        log.info("\u590d\u8d2d\u63d0\u9192\u63a8\u9001\u6210\u529f\uff0c\u6d88\u606f\u961f\u5217\u6d88\u8d39\u5b8c\u6bd5\uff01");
    }
}

