/*
 * Decompiled with CFR 0.152.
 */
package com.byh.nursingcarenewserver.service.impl;

import com.alibaba.fastjson.JSON;
import com.byh.nursingcarenewserver.pojo.enums.ChannelCodeEnum;
import com.byh.nursingcarenewserver.pojo.req.UmPushMsgAndroidReqVO;
import com.byh.nursingcarenewserver.pojo.req.UmPushMsgIOSReqVo;
import com.byh.nursingcarenewserver.pojo.res.PushConfigurationDetailVO;
import com.byh.nursingcarenewserver.pojo.res.UserLastLoginDeviceRespVo;
import com.byh.nursingcarenewserver.service.AppWebPushService;
import com.byh.nursingcarenewserver.utils.AppWebPushUtil;
import com.byh.nursingcarenewserver.utils.PushParamUtil;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AppWebPushServiceImpl
implements AppWebPushService {
    private static final Logger log = LoggerFactory.getLogger(AppWebPushServiceImpl.class);
    private static final String LOGGER_MSG = "\u6ca1\u6709\u627e\u5230\u8be5\u7528\u6237\u7684\u8bbe\u5907\u53f7\uff0c\u4e0d\u6267\u884c\u63a8\u9001\u903b\u8f91";
    private static final String NEW_APPOINTMENT_MSG = "\u60a8\u6709\u4e00\u7b14\u65b0\u7684\u62a4\u7406\u9884\u7ea6\u5355\u53ef\u62a2\u5355\uff0c\u8bf7\u53ca\u65f6\u5904\u7406";
    private static final String PUSH_TITLE_ROB = "\u62a4\u7406\u62a2\u5355\u63d0\u9192";
    private static final String ROB_BUSICODE = "HLZH_502";
    private static final String PUSHCODE_STR = "pushCode";
    private static final String CONTENT_STR = "content";
    private static final String UN_SERVICE_APPOINTMENT_MSG = "\u6709\u4e00\u7b14\u62a4\u7406\u9884\u7ea6\u5355\u5f85\u670d\u52a1\uff0c\u8bf7\u53ca\u65f6\u5904\u7406";
    private static final String PUSH_TITLE_READY = "\u62a4\u7406\u5373\u5c06\u5f00\u59cb\u63d0\u9192";
    private static final String UN_SERVICE_BUSICODE = "HLZH_504";
    private static final String PUSH_TITLE_REPLAN = "\u62a4\u7406\u670d\u52a1\u91cd\u65b0\u5206\u914d\u63d0\u9192";
    private static final String PUSH_TITLE_PLAN = "\u62a4\u7406\u670d\u52a1\u5206\u914d\u63d0\u9192";
    @Resource
    private PushParamUtil pushParamUtil;
    @Resource
    private AppWebPushUtil appWebPushUtil;

    public void addAppointmentPush(String userId, String appCode) {
        HashMap<String, String> map;
        PushConfigurationDetailVO pushConfig;
        UserLastLoginDeviceRespVo userLastLoginDeviceRespVo = this.pushParamUtil.getDocUserDeviceToken(userId, new Short("1"));
        if (userLastLoginDeviceRespVo == null || StringUtils.isEmpty((CharSequence)userLastLoginDeviceRespVo.getDeviceType())) {
            log.info(LOGGER_MSG);
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.IOS.getValue())) {
            pushConfig = this.pushParamUtil.getPushConfig(appCode, "youmengPush", "doctor", "IOS");
            UmPushMsgIOSReqVo iosPush = new UmPushMsgIOSReqVo();
            iosPush.setBusiCode(ROB_BUSICODE);
            iosPush.setTitle(PUSH_TITLE_ROB);
            iosPush.setSubTitle(PUSH_TITLE_ROB);
            iosPush.setUserId(userId);
            iosPush.setUserType(Integer.valueOf(1));
            iosPush.setClientCode(pushConfig.getClientCode());
            iosPush.setDeviceTokens(userLastLoginDeviceRespVo.getDeviceNumber());
            iosPush.setDescription(NEW_APPOINTMENT_MSG);
            iosPush.setBody(NEW_APPOINTMENT_MSG);
            iosPush.setBusiStyle(NEW_APPOINTMENT_MSG);
            iosPush.setText(NEW_APPOINTMENT_MSG);
            map = new HashMap();
            map.put(PUSHCODE_STR, "502");
            map.put(CONTENT_STR, NEW_APPOINTMENT_MSG);
            HashMap<String, String> custom = new HashMap<String, String>();
            custom.putAll(map);
            String customJsonString = JSON.toJSONString(custom);
            iosPush.setCustom(customJsonString);
            iosPush.setExtra(map);
            this.appWebPushUtil.pushIOSMessage(iosPush);
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.ANDROID.getValue())) {
            pushConfig = this.pushParamUtil.getPushConfig(appCode, "youmengPush", "doctor", "Android");
            UmPushMsgAndroidReqVO androidPush = new UmPushMsgAndroidReqVO();
            androidPush.setBusiCode(ROB_BUSICODE);
            androidPush.setTitle(PUSH_TITLE_ROB);
            androidPush.setUserId(userId);
            androidPush.setClientCode(pushConfig.getClientCode());
            androidPush.setDeviceTokens(userLastLoginDeviceRespVo.getDeviceNumber());
            androidPush.setText(NEW_APPOINTMENT_MSG);
            androidPush.setDescription(NEW_APPOINTMENT_MSG);
            androidPush.setTicker(PUSH_TITLE_ROB);
            map = new HashMap<String, String>();
            map.put(PUSHCODE_STR, "502");
            androidPush.setExtra(map);
            this.appWebPushUtil.pushAndroidMessage(androidPush);
        }
    }

    public void todayBeforeTwoPush(String appCode, String userId, String time) {
        HashMap<String, String> map;
        PushConfigurationDetailVO pushConfig;
        UserLastLoginDeviceRespVo userLastLoginDeviceRespVo = this.pushParamUtil.getDocUserDeviceToken(userId, new Short("1"));
        if (userLastLoginDeviceRespVo == null || StringUtils.isEmpty((CharSequence)userLastLoginDeviceRespVo.getDeviceType())) {
            log.info(LOGGER_MSG);
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.IOS.getValue())) {
            pushConfig = this.pushParamUtil.getPushConfig(appCode, "youmengPush", "doctor", "IOS");
            UmPushMsgIOSReqVo iosPush = new UmPushMsgIOSReqVo();
            iosPush.setBusiCode(UN_SERVICE_BUSICODE);
            iosPush.setTitle(PUSH_TITLE_READY);
            iosPush.setUserId(userId);
            iosPush.setUserType(Integer.valueOf(1));
            iosPush.setClientCode(pushConfig.getClientCode());
            iosPush.setDeviceTokens(userLastLoginDeviceRespVo.getDeviceNumber());
            iosPush.setSubTitle(PUSH_TITLE_READY);
            iosPush.setDescription("\u60a8\u4eca\u5929" + time + UN_SERVICE_APPOINTMENT_MSG);
            iosPush.setBody("\u60a8\u4eca\u5929" + time + UN_SERVICE_APPOINTMENT_MSG);
            iosPush.setText(UN_SERVICE_APPOINTMENT_MSG);
            iosPush.setBusiStyle("\u60a8\u4eca\u5929" + time + UN_SERVICE_APPOINTMENT_MSG);
            map = new HashMap();
            map.put(PUSHCODE_STR, "504");
            map.put(CONTENT_STR, UN_SERVICE_APPOINTMENT_MSG);
            iosPush.setExtra(map);
            HashMap<String, String> custom = new HashMap<String, String>();
            custom.putAll(map);
            String customJsonString = JSON.toJSONString(custom);
            iosPush.setCustom(customJsonString);
            this.appWebPushUtil.pushIOSMessage(iosPush);
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.ANDROID.getValue())) {
            pushConfig = this.pushParamUtil.getPushConfig(appCode, "youmengPush", "doctor", "Android");
            UmPushMsgAndroidReqVO androidPush = new UmPushMsgAndroidReqVO();
            androidPush.setBusiCode(UN_SERVICE_BUSICODE);
            androidPush.setBusiStyle(PUSH_TITLE_READY);
            androidPush.setTitle(PUSH_TITLE_READY);
            androidPush.setUserId(userId);
            androidPush.setClientCode(pushConfig.getClientCode());
            androidPush.setDeviceTokens(userLastLoginDeviceRespVo.getDeviceNumber());
            androidPush.setText("\u60a8\u4eca\u5929" + time + UN_SERVICE_APPOINTMENT_MSG);
            androidPush.setDescription("\u60a8\u4eca\u5929" + time + UN_SERVICE_APPOINTMENT_MSG);
            androidPush.setTicker(PUSH_TITLE_READY);
            map = new HashMap<String, String>();
            map.put(PUSHCODE_STR, "504");
            androidPush.setExtra(map);
            this.appWebPushUtil.pushAndroidMessage(androidPush);
        }
    }

    public void manageDistributionWalk(String userId, String appCode, String time, String doctorName) {
        HashMap<String, String> map;
        PushConfigurationDetailVO pushConfig;
        String msg = "\u60a8\u7684" + time + "\u7684\u62a4\u7406\u670d\u52a1\u5355\uff0c\u5df2\u88ab\u7ba1\u7406\u5458\u91cd\u65b0\u5206\u914d\u7ed9" + doctorName + "\u62a4\u58eb\uff0c\u539f\u670d\u52a1\u5355\u5df2\u5220\u9664";
        UserLastLoginDeviceRespVo userLastLoginDeviceRespVo = this.pushParamUtil.getDocUserDeviceToken(userId, new Short("1"));
        if (userLastLoginDeviceRespVo == null || StringUtils.isEmpty((CharSequence)userLastLoginDeviceRespVo.getDeviceType())) {
            log.info(LOGGER_MSG);
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.IOS.getValue())) {
            pushConfig = this.pushParamUtil.getPushConfig(appCode, "youmengPush", "doctor", "IOS");
            UmPushMsgIOSReqVo iosPush = new UmPushMsgIOSReqVo();
            iosPush.setBusiCode("HLZH_501");
            iosPush.setTitle(PUSH_TITLE_REPLAN);
            iosPush.setUserId(userId);
            iosPush.setClientCode(pushConfig.getClientCode());
            iosPush.setDeviceTokens(userLastLoginDeviceRespVo.getDeviceNumber());
            iosPush.setSubTitle(PUSH_TITLE_REPLAN);
            iosPush.setDescription(msg);
            iosPush.setBody(msg);
            iosPush.setBusiStyle(msg);
            map = new HashMap<String, String>();
            map.put(PUSHCODE_STR, "501");
            map.put(CONTENT_STR, msg);
            iosPush.setExtra(map);
            iosPush.setUserType(Integer.valueOf(1));
            iosPush.setText(msg);
            HashMap<String, String> custom = new HashMap<String, String>();
            custom.putAll(map);
            String customJsonString = JSON.toJSONString(custom);
            iosPush.setCustom(customJsonString);
            this.appWebPushUtil.pushIOSMessage(iosPush);
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.ANDROID.getValue())) {
            pushConfig = this.pushParamUtil.getPushConfig(appCode, "youmengPush", "doctor", "Android");
            UmPushMsgAndroidReqVO androidPush = new UmPushMsgAndroidReqVO();
            androidPush.setBusiCode("HLZH_501");
            androidPush.setBusiStyle(PUSH_TITLE_REPLAN);
            androidPush.setTitle(PUSH_TITLE_REPLAN);
            androidPush.setUserId(userId);
            androidPush.setClientCode(pushConfig.getClientCode());
            androidPush.setDeviceTokens(userLastLoginDeviceRespVo.getDeviceNumber());
            androidPush.setText(msg);
            androidPush.setDescription(msg);
            androidPush.setTicker(PUSH_TITLE_REPLAN);
            map = new HashMap();
            map.put(PUSHCODE_STR, "501");
            androidPush.setExtra(map);
            this.appWebPushUtil.pushAndroidMessage(androidPush);
        }
    }

    public void manageDistribution(String userId, String appCode, String time) {
        HashMap<String, String> map;
        PushConfigurationDetailVO pushConfig;
        String msg = "\u60a8\u6536\u5230\u7ba1\u7406\u5458\u5206\u914d\u7684" + time + "\u7684\u62a4\u7406\u670d\u52a1\u5355\uff0c\u8bf7\u53ca\u65f6\u5904\u7406";
        UserLastLoginDeviceRespVo userLastLoginDeviceRespVo = this.pushParamUtil.getDocUserDeviceToken(userId, new Short("1"));
        if (userLastLoginDeviceRespVo == null || StringUtils.isEmpty((CharSequence)userLastLoginDeviceRespVo.getDeviceType())) {
            log.info(LOGGER_MSG);
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.IOS.getValue())) {
            pushConfig = this.pushParamUtil.getPushConfig(appCode, "youmengPush", "doctor", "IOS");
            UmPushMsgIOSReqVo iosPush = new UmPushMsgIOSReqVo();
            iosPush.setBusiCode("HLZH_503");
            iosPush.setTitle(PUSH_TITLE_PLAN);
            iosPush.setUserId(userId);
            iosPush.setClientCode(pushConfig.getClientCode());
            iosPush.setDeviceTokens(userLastLoginDeviceRespVo.getDeviceNumber());
            iosPush.setSubTitle(PUSH_TITLE_PLAN);
            iosPush.setDescription(msg);
            iosPush.setBody(msg);
            iosPush.setBusiStyle(msg);
            map = new HashMap<String, String>();
            map.put(PUSHCODE_STR, "503");
            map.put(CONTENT_STR, msg);
            iosPush.setExtra(map);
            iosPush.setUserType(Integer.valueOf(1));
            iosPush.setText(msg);
            HashMap<String, String> custom = new HashMap<String, String>();
            custom.putAll(map);
            String customJsonString = JSON.toJSONString(custom);
            iosPush.setCustom(customJsonString);
            this.appWebPushUtil.pushIOSMessage(iosPush);
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.ANDROID.getValue())) {
            pushConfig = this.pushParamUtil.getPushConfig(appCode, "youmengPush", "doctor", "Android");
            UmPushMsgAndroidReqVO androidPush = new UmPushMsgAndroidReqVO();
            androidPush.setBusiCode("HLZH_503");
            androidPush.setTitle(PUSH_TITLE_PLAN);
            androidPush.setUserId(userId);
            androidPush.setClientCode(pushConfig.getClientCode());
            androidPush.setDeviceTokens(userLastLoginDeviceRespVo.getDeviceNumber());
            androidPush.setText(msg);
            androidPush.setDescription(msg);
            androidPush.setTicker(PUSH_TITLE_PLAN);
            map = new HashMap();
            map.put(PUSHCODE_STR, "503");
            androidPush.setExtra(map);
            this.appWebPushUtil.pushAndroidMessage(androidPush);
        }
    }
}

