/*
 * Decompiled with CFR 0.152.
 */
package com.byh.nursingcarenewserver.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.nursingcarenewserver.common.execption.BusinessException;
import com.byh.nursingcarenewserver.mapper.MaterialItemMapper;
import com.byh.nursingcarenewserver.mapper.MaterialPackageMapper;
import com.byh.nursingcarenewserver.mapper.ProductSubitemMapper;
import com.byh.nursingcarenewserver.pojo.dto.DetailMaterialDto;
import com.byh.nursingcarenewserver.pojo.dto.DetailMaterialItemDto;
import com.byh.nursingcarenewserver.pojo.dto.DetailMaterialPackageDto;
import com.byh.nursingcarenewserver.pojo.dto.ManagementMaterialListDto;
import com.byh.nursingcarenewserver.pojo.dto.QueryListItemDto;
import com.byh.nursingcarenewserver.pojo.dto.QueryListMaterialDto;
import com.byh.nursingcarenewserver.pojo.dto.QueryListPackageDto;
import com.byh.nursingcarenewserver.pojo.entity.MaterialItem;
import com.byh.nursingcarenewserver.pojo.entity.MaterialPackage;
import com.byh.nursingcarenewserver.pojo.vo.DeleteMaterialItemVo;
import com.byh.nursingcarenewserver.pojo.vo.SaveMaterialItemVo;
import com.byh.nursingcarenewserver.pojo.vo.SaveMaterialPackageVo;
import com.byh.nursingcarenewserver.pojo.vo.SaveMaterialVo;
import com.byh.nursingcarenewserver.pojo.vo.UpdateMaterialItemVo;
import com.byh.nursingcarenewserver.pojo.vo.UpdateMaterialPackageVo;
import com.byh.nursingcarenewserver.service.MaterialPackageService;
import com.byh.nursingcarenewserver.utils.UniqueKeyGenerator;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class MaterialPackageServiceImpl
extends ServiceImpl<MaterialPackageMapper, MaterialPackage>
implements MaterialPackageService {
    private static final Logger log = LoggerFactory.getLogger(MaterialPackageServiceImpl.class);
    @Autowired
    private MaterialPackageMapper materialPackageMapper;
    @Autowired
    private MaterialItemMapper materialItemMapper;
    @Autowired
    private ProductSubitemMapper productSubitemMapper;
    private static final String MATERIAL_PACKAGE_ID = "material_package_id";
    private static final String VIEW_ID = "view_id";

    @Transactional
    public String saveMaterialPackage(SaveMaterialVo saveMaterialVo) {
        SaveMaterialPackageVo saveMaterialPackageVo = saveMaterialVo.getSaveMaterialPackageVo();
        List packageList = this.materialPackageMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"name", (Object)saveMaterialPackageVo.getPackageName()));
        if (CollectionUtils.isNotEmpty((Collection)packageList)) {
            return "\u8017\u6750\u5305\u540d\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u8f93\u5165";
        }
        MaterialPackage materialPackage = new MaterialPackage();
        materialPackage.setViewId(UniqueKeyGenerator.generateUUID());
        materialPackage.setAppCode(saveMaterialPackageVo.getAppCode());
        materialPackage.setName(saveMaterialPackageVo.getPackageName());
        materialPackage.setTotalPrice(saveMaterialPackageVo.getTotalPrice());
        int insert = this.materialPackageMapper.insert((Object)materialPackage);
        List saveMaterialItemVoList = saveMaterialVo.getSaveMaterialItemVoList();
        if (!CollectionUtils.isEmpty((Collection)saveMaterialItemVoList)) {
            List collect = saveMaterialItemVoList.stream().map(SaveMaterialItemVo::getItemName).distinct().collect(Collectors.toList());
            if (collect.size() != saveMaterialItemVoList.size()) {
                return "\u8017\u6750\u540d\u79f0\u6709\u91cd\u590d";
            }
            for (SaveMaterialItemVo saveMaterialItemVo : saveMaterialItemVoList) {
                MaterialItem materialItem = new MaterialItem();
                materialItem.setMaterialPackageId(materialPackage.getId());
                materialItem.setName(saveMaterialItemVo.getItemName());
                materialItem.setPrice(saveMaterialItemVo.getPrice());
                materialItem.setQuantity(saveMaterialItemVo.getQuantity());
                this.materialItemMapper.insert((Object)materialItem);
            }
        }
        return "YES";
    }

    public BaseResponse<PageResult<QueryListMaterialDto>> queryListMaterial(String search, Long pageIndex, Long pageSize) {
        PageResult pageResult = new PageResult();
        Page page = new Page(pageIndex.longValue(), pageSize.longValue(), true);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.like((Object)"name", (Object)search);
        wrapper.orderByDesc((Object)"create_time");
        Page materialPackagePage = (Page)this.materialPackageMapper.selectPage((IPage)page, (Wrapper)wrapper);
        List materialPackagesList = materialPackagePage.getRecords();
        ArrayList<QueryListMaterialDto> list = new ArrayList<QueryListMaterialDto>();
        for (MaterialPackage materialPackage : materialPackagesList) {
            QueryListMaterialDto queryListMaterialDto = new QueryListMaterialDto();
            QueryListPackageDto queryListPackageDto = new QueryListPackageDto();
            queryListPackageDto.setPackageName(materialPackage.getName());
            queryListPackageDto.setPackageViewId(materialPackage.getViewId());
            queryListPackageDto.setPackageCreateTime(materialPackage.getCreateTime());
            queryListPackageDto.setPackageTotalPrice(materialPackage.getTotalPrice());
            queryListMaterialDto.setQueryListPackageDto(queryListPackageDto);
            ArrayList<QueryListItemDto> queryListItemDtoList = new ArrayList<QueryListItemDto>();
            QueryWrapper wrapperItem = new QueryWrapper();
            wrapperItem.eq((Object)MATERIAL_PACKAGE_ID, (Object)materialPackage.getId());
            List materialItems = this.materialItemMapper.selectList((Wrapper)wrapperItem);
            for (MaterialItem materialItem : materialItems) {
                QueryListItemDto queryListItemDto = new QueryListItemDto();
                queryListItemDto.setItemName(materialItem.getName());
                queryListItemDto.setItemPrice(materialItem.getPrice());
                queryListItemDto.setItemQuantity(materialItem.getQuantity());
                queryListItemDtoList.add(queryListItemDto);
            }
            queryListMaterialDto.setQueryListItemDtoList(queryListItemDtoList);
            list.add(queryListMaterialDto);
        }
        pageResult.setContent(list);
        pageResult.setTotal(Integer.parseInt(Long.toString(materialPackagePage.getTotal())));
        pageResult.setTotalPages(Integer.parseInt(Long.toString(materialPackagePage.getPages())));
        pageResult.setPageSize(pageSize.intValue());
        pageResult.setPageNum(pageIndex.intValue());
        return BaseResponse.success((Object)pageResult);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> deleteMaterialPackage(List<String> packageViewIds) {
        for (String viewId : packageViewIds) {
            int delete;
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)VIEW_ID, (Object)viewId);
            MaterialPackage materialPackage = (MaterialPackage)this.materialPackageMapper.selectOne((Wrapper)queryWrapper);
            if (ObjectUtils.isEmpty((Object)materialPackage)) {
                throw new BusinessException("\u8017\u6750\u5305\u4e0d\u5b58\u5728");
            }
            List productSubitemList = this.productSubitemMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"material_id", (Object)materialPackage.getId()));
            if (CollectionUtils.isNotEmpty((Collection)productSubitemList)) {
                return BaseResponse.error((String)"\u8be5\u8017\u6750\u6b63\u5728\u4f7f\u7528\u4e2d");
            }
            QueryWrapper deleteWrapper = new QueryWrapper();
            deleteWrapper.eq((Object)MATERIAL_PACKAGE_ID, (Object)materialPackage.getId());
            List materialItems = this.materialItemMapper.selectList((Wrapper)deleteWrapper);
            if (CollectionUtils.isNotEmpty((Collection)materialItems) && (delete = this.materialItemMapper.delete((Wrapper)deleteWrapper)) == 0) {
                log.info("\u5220\u9664\u8be6\u7ec6\u8868\u5931\u8d25");
                return BaseResponse.error((String)"\u5931\u8d25");
            }
            int delete1 = this.materialPackageMapper.delete((Wrapper)queryWrapper);
            if (delete1 != 0) continue;
            throw new BusinessException("\u5220\u9664\u8017\u6750\u5305\u5931\u8d25");
        }
        return BaseResponse.success();
    }

    public BaseResponse<DetailMaterialDto> detailMaterialPackage(String packageViewId) {
        DetailMaterialDto detailMaterialDto = new DetailMaterialDto();
        QueryWrapper materialPackageQueryWrapper = new QueryWrapper();
        materialPackageQueryWrapper.eq((Object)VIEW_ID, (Object)packageViewId);
        MaterialPackage materialPackage = (MaterialPackage)this.materialPackageMapper.selectOne((Wrapper)materialPackageQueryWrapper);
        DetailMaterialPackageDto detailMaterialPackageDto = new DetailMaterialPackageDto();
        detailMaterialPackageDto.setAppCode(materialPackage.getAppCode());
        detailMaterialPackageDto.setName(materialPackage.getName());
        detailMaterialPackageDto.setTotalPrice(materialPackage.getTotalPrice());
        detailMaterialPackageDto.setId(materialPackage.getId());
        detailMaterialPackageDto.setViewId(materialPackage.getViewId());
        detailMaterialPackageDto.setCreateTime(materialPackage.getCreateTime());
        detailMaterialPackageDto.setUpdateTime(materialPackage.getUpdateTime());
        detailMaterialDto.setDetailMaterialPackageDto(detailMaterialPackageDto);
        QueryWrapper materialItemQueryWrapper = new QueryWrapper();
        materialItemQueryWrapper.eq((Object)MATERIAL_PACKAGE_ID, (Object)materialPackage.getId());
        List materialItems = this.materialItemMapper.selectList((Wrapper)materialItemQueryWrapper);
        ArrayList<DetailMaterialItemDto> detailMaterialItemDtos = new ArrayList<DetailMaterialItemDto>();
        for (MaterialItem materialItem : materialItems) {
            DetailMaterialItemDto detailMaterialItemDto = new DetailMaterialItemDto();
            detailMaterialItemDto.setId(materialItem.getId());
            detailMaterialItemDto.setMaterialPackageId(materialItem.getMaterialPackageId());
            detailMaterialItemDto.setName(materialItem.getName());
            detailMaterialItemDto.setPrice(materialItem.getPrice());
            detailMaterialItemDto.setQuantity(materialItem.getQuantity());
            detailMaterialItemDtos.add(detailMaterialItemDto);
        }
        detailMaterialDto.setDetailMaterialItemDtoList(detailMaterialItemDtos);
        return BaseResponse.success((Object)detailMaterialDto);
    }

    @Transactional
    public BaseResponse<String> deleteMaterialItem(DeleteMaterialItemVo deleteMaterialItemVo) {
        List itemIds = deleteMaterialItemVo.getItemIds();
        itemIds.stream().forEach(itemId -> this.materialItemMapper.deleteById((Serializable)itemId));
        return BaseResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public String updateMaterialPackage(UpdateMaterialPackageVo updateMaterialPackageVo) {
        int delete;
        QueryWrapper packageQueryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)VIEW_ID, (Object)updateMaterialPackageVo.getMaterialPackageViewId());
        MaterialPackage materialPackage = (MaterialPackage)this.materialPackageMapper.selectOne((Wrapper)packageQueryWrapper);
        List packageList = this.materialPackageMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"name", (Object)updateMaterialPackageVo.getMaterialPackageName()));
        if (!materialPackage.getName().equals(updateMaterialPackageVo.getMaterialPackageName()) && CollectionUtils.isNotEmpty((Collection)packageList)) {
            return "\u8017\u6750\u5305\u540d\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u8f93\u5165";
        }
        materialPackage.setName(updateMaterialPackageVo.getMaterialPackageName());
        materialPackage.setTotalPrice(updateMaterialPackageVo.getTotalPrice());
        int update = this.materialPackageMapper.updateById((Object)materialPackage);
        if (update != 1) {
            return "NO";
        }
        QueryWrapper itemQueryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)MATERIAL_PACKAGE_ID, (Object)materialPackage.getId());
        List materialItems = this.materialItemMapper.selectList((Wrapper)itemQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)materialItems) && (delete = this.materialItemMapper.delete((Wrapper)itemQueryWrapper)) == 0) {
            throw new RuntimeException();
        }
        List updateMaterialItemVos = updateMaterialPackageVo.getUpdateMaterialItemVoList();
        if (!CollectionUtils.isEmpty((Collection)updateMaterialItemVos)) {
            List collect = updateMaterialItemVos.stream().map(UpdateMaterialItemVo::getItemName).distinct().collect(Collectors.toList());
            if (collect.size() != updateMaterialItemVos.size()) {
                return "\u8017\u6750\u540d\u79f0\u6709\u91cd\u590d";
            }
            for (UpdateMaterialItemVo updateMaterialItemVo : updateMaterialItemVos) {
                MaterialItem materialItem = new MaterialItem();
                materialItem.setMaterialPackageId(materialPackage.getId());
                materialItem.setName(updateMaterialItemVo.getItemName());
                materialItem.setPrice(updateMaterialItemVo.getPrice());
                materialItem.setQuantity(updateMaterialItemVo.getQuantity());
                int insert1 = this.materialItemMapper.insert((Object)materialItem);
                if (insert1 != 0) continue;
                return "NO";
            }
        }
        return "YES";
    }

    public List<ManagementMaterialListDto> managementMaterialList() {
        ArrayList<ManagementMaterialListDto> list = new ArrayList<ManagementMaterialListDto>();
        List materialPackageList = this.materialPackageMapper.selectList((Wrapper)new QueryWrapper().orderByDesc((Object)"create_time"));
        for (MaterialPackage materialPackage : materialPackageList) {
            ManagementMaterialListDto managementMaterialListDto = new ManagementMaterialListDto();
            managementMaterialListDto.setMaterialId(materialPackage.getId());
            managementMaterialListDto.setMaterialViewId(materialPackage.getViewId());
            managementMaterialListDto.setMaterialName(materialPackage.getName());
            list.add(managementMaterialListDto);
        }
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<ManagementMaterialListDto>();
        }
        return list;
    }
}

