/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.Task;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.outpatient.api.hsModel.request.SetlinfoRequest;
import com.byh.outpatient.api.hsModel.request.SigninRequest;
import com.byh.outpatient.api.hsModel.respones.HsBaseResponse;
import com.byh.outpatient.api.hsModel.respones.HsSigninResponse;
import com.byh.outpatient.api.hsModel.respones.Signinoutb;
import com.byh.outpatient.api.model.admission.AdmissionEntity;
import com.byh.outpatient.api.model.medicalRecord.OutMedicalRecordDiagnosis;
import com.byh.outpatient.api.model.order.OutOrder;
import com.byh.outpatient.api.model.order.OutOrderPayment;
import com.byh.outpatient.api.model.patient.PatientEntity;
import com.byh.outpatient.api.sysModel.request.SysDoctorDto;
import com.byh.outpatient.api.sysModel.respones.SysDoctorIdVo;
import com.byh.outpatient.api.util.DateUtils;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.data.repository.AdmissionMapper;
import com.byh.outpatient.data.repository.OutHsSettlementInfoMapper;
import com.byh.outpatient.data.repository.OutMedicalRecordDiagnosisMapper;
import com.byh.outpatient.data.repository.OutOrderMapper;
import com.byh.outpatient.data.repository.OutOrderPaymentMapper;
import com.byh.outpatient.data.repository.PatientMapper;
import com.byh.outpatient.web.Task.AutoHsSetlInfoUploadTask;
import com.byh.outpatient.web.feign.HsServiceFeign;
import com.byh.outpatient.web.feign.SysServiceFeign;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class AutoHsSetlInfoUploadTask {
    private static final Logger log = LoggerFactory.getLogger(AutoHsSetlInfoUploadTask.class);
    @Autowired
    private OutHsSettlementInfoMapper outHsSettlementInfoMapper;
    @Autowired
    private HsServiceFeign hsServiceFeign;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private OutOrderPaymentMapper outOrderPaymentMapper;
    @Autowired
    private OutMedicalRecordDiagnosisMapper outMedicalRecordDiagnosisMapper;
    @Autowired
    private OutOrderMapper outOrderMapper;
    @Autowired
    private SysServiceFeign sysServiceFeign;
    private Integer tenantId = 1;

    @Scheduled(cron="0 0 2 * * ?")
    public void autoUpload() {
        log.info("==============================\u533b\u4fdd\u7ed3\u7b97\u6e05\u5355\u81ea\u52a8\u4e0a\u4f20=========================");
        try {
            String signNo;
            String preDate = DateUtils.getPreDate();
            List hsSettlementInfoEntityList = this.outHsSettlementInfoMapper.queryHsSettlmentInfoByDate(preDate + " 00:00:00", preDate + " 23:59:59", this.tenantId);
            log.info("\u533b\u4fdd\u4e0a\u4f20\u4fe1\u606f", (Object)JSONObject.toJSONString((Object)hsSettlementInfoEntityList));
            SigninRequest signinRequest = new SigninRequest();
            signinRequest.setOpter_no("57");
            signinRequest.setTenantId(Integer.valueOf(1));
            log.info("\u533b\u4fdd\u767b\u5f55signinRequest\uff1a{}", (Object)signinRequest);
            ResponseData hsBaseResponseResponseData = this.hsServiceFeign.hsSignin(signinRequest);
            if (hsBaseResponseResponseData.isSuccess() && !Objects.isNull(hsBaseResponseResponseData.getData())) {
                1 typeReference = new /* Unavailable Anonymous Inner Class!! */;
                HsBaseResponse hsBaseResponse = (HsBaseResponse)JSONObject.parseObject((String)JSONObject.toJSONString((Object)hsBaseResponseResponseData.getData()), (Type)typeReference.getType(), (Feature[])new Feature[0]);
                log.info("\u533b\u4fdd\u767b\u5f55\u8fd4\u56de\uff1a{}", (Object)hsBaseResponse);
                Signinoutb signinoutb = ((HsSigninResponse)hsBaseResponse.getOutput()).getSigninoutb();
                signNo = signinoutb.getSign_no();
            } else {
                signNo = "99999";
            }
            hsSettlementInfoEntityList.stream().forEach(hsSettlementInfoEntity -> {
                try {
                    Thread.sleep(5000L);
                    String outpatientNo = this.outOrderPaymentMapper.queryPaymentRecordBySetlId(hsSettlementInfoEntity.getSetl_id(), this.tenantId);
                    if (outpatientNo == null) {
                        List outOrderPayments = this.outOrderPaymentMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutOrderPayment::getPsnNo, (Object)hsSettlementInfoEntity.getPsn_no())).eq(OutOrderPayment::getAmount, (Object)hsSettlementInfoEntity.getMedfee_sumamt())).eq(OutOrderPayment::getPubCost, (Object)hsSettlementInfoEntity.getFund_pay_sumamt())).eq(OutOrderPayment::getStatus, (Object)1)).last("and DATE_FORMAT(payment_time, '%Y-%m-%d') = '" + hsSettlementInfoEntity.getSetl_time().substring(0, 10) + "'"));
                        outpatientNo = ((OutOrderPayment)outOrderPayments.get(0)).getOutpatientNo();
                    }
                    log.info("===================outpatientNo" + outpatientNo);
                    AdmissionEntity admission = this.admissionMapper.queryAdmissionByOutpatientNoOne(outpatientNo, this.tenantId);
                    PatientEntity patientEntity = this.patientMapper.queryPatientByCardNoAndTenantId(hsSettlementInfoEntity.getCertno(), this.tenantId);
                    SetlinfoRequest setlinfoRequest = new SetlinfoRequest();
                    setlinfoRequest.setOpter("57");
                    setlinfoRequest.setSign_no(signNo);
                    setlinfoRequest.setOpter_type("1");
                    setlinfoRequest.setOpter_name("\u533b\u4fdd\u79d1");
                    setlinfoRequest.setPsn_no(hsSettlementInfoEntity.getPsn_no());
                    setlinfoRequest.setMdtrt_id(hsSettlementInfoEntity.getMdtrt_id());
                    setlinfoRequest.setSetl_id(hsSettlementInfoEntity.getSetl_id());
                    setlinfoRequest.setHi_no(hsSettlementInfoEntity.getPsn_no());
                    setlinfoRequest.setMedcasno(patientEntity.getMedicalRecordNo());
                    setlinfoRequest.setDcla_time(DateUtils.getCurrentDateToString());
                    setlinfoRequest.setNtly("CHN");
                    setlinfoRequest.setPrfs("90");
                    setlinfoRequest.setCurr_addr(patientEntity.getAddress());
                    setlinfoRequest.setEmp_name("");
                    setlinfoRequest.setEmp_addr("");
                    setlinfoRequest.setEmp_tel("");
                    setlinfoRequest.setPoscode("");
                    setlinfoRequest.setPatn_rlts("01");
                    setlinfoRequest.setConer_name(patientEntity.getName());
                    setlinfoRequest.setConer_addr(StrUtil.isBlank((CharSequence)patientEntity.getAddress()) ? "\u6c5f\u897f" : patientEntity.getAddress());
                    setlinfoRequest.setConer_tel(StrUtil.isBlank((CharSequence)patientEntity.getPhone()) ? "4006608933" : patientEntity.getPhone());
                    setlinfoRequest.setNwb_adm_type("");
                    setlinfoRequest.setMul_nwb_bir_wt("");
                    setlinfoRequest.setMul_nwb_adm_wt("");
                    setlinfoRequest.setOpsp_diag_caty("");
                    if (admission == null) {
                        setlinfoRequest.setOpsp_mdtrt_date(DateUtils.dateToFullString((Date)hsSettlementInfoEntity.getCreate_time()));
                    } else {
                        setlinfoRequest.setOpsp_mdtrt_date(DateUtils.dateToFullString((Date)(Objects.isNull(admission.getVisitTime()) ? admission.getCreateTime() : admission.getVisitTime())));
                    }
                    setlinfoRequest.setAdm_way("2");
                    setlinfoRequest.setTrt_type("");
                    setlinfoRequest.setAdm_time("");
                    setlinfoRequest.setRefldept_dept("");
                    setlinfoRequest.setDscg_caty("");
                    QueryWrapper outDiagnosis = new QueryWrapper();
                    outDiagnosis.eq((Object)"tenant_id", (Object)this.tenantId);
                    outDiagnosis.eq((Object)"outpatient_no", (Object)outpatientNo);
                    List outMedicalRecordDiagnoses = this.outMedicalRecordDiagnosisMapper.selectList((Wrapper)outDiagnosis);
                    if (!Objects.isNull(outMedicalRecordDiagnoses) && !outMedicalRecordDiagnoses.isEmpty()) {
                        OutMedicalRecordDiagnosis outMedicalRecordDiagnosis = (OutMedicalRecordDiagnosis)outMedicalRecordDiagnoses.get(0);
                        if (outMedicalRecordDiagnosis.getDiagnosticType() != null && 1 == outMedicalRecordDiagnosis.getDiagnosticType()) {
                            setlinfoRequest.setOtp_tcm_dise(outMedicalRecordDiagnosis.getDiagnosis());
                            setlinfoRequest.setTcm_dise_code(outMedicalRecordDiagnosis.getIcdCode());
                        } else {
                            setlinfoRequest.setOtp_wm_dise(outMedicalRecordDiagnosis.getDiagnosis());
                            setlinfoRequest.setWm_dise_code(outMedicalRecordDiagnosis.getIcdCode());
                        }
                    }
                    setlinfoRequest.setVent_used_dura("");
                    setlinfoRequest.setPwcry_bfadm_coma_dura("");
                    setlinfoRequest.setPwcry_afadm_coma_dura("");
                    setlinfoRequest.setDscg_way("");
                    setlinfoRequest.setAcp_medins_name("");
                    setlinfoRequest.setAcp_optins_code("");
                    setlinfoRequest.setBill_code("");
                    QueryWrapper queryWrapper = new QueryWrapper();
                    queryWrapper.eq((Object)"order_no", (Object)admission.getOrderNo());
                    OutOrder outOrder = (OutOrder)this.outOrderMapper.selectOne((Wrapper)queryWrapper);
                    if (outOrder == null) {
                        outOrder = new OutOrder();
                    }
                    String billInfo = Objects.isNull(outOrder.getInvoiceNo()) ? outpatientNo : outOrder.getInvoiceNo();
                    setlinfoRequest.setBill_no(billInfo);
                    setlinfoRequest.setBill_code(billInfo);
                    setlinfoRequest.setBiz_sn(billInfo);
                    setlinfoRequest.setDays_rinp_pup_31("");
                    setlinfoRequest.setDays_rinp_flag_31("");
                    SysDoctorDto sysDoctorDto = new SysDoctorDto();
                    sysDoctorDto.setId(admission.getDoctorId());
                    ResponseData sysDoctorIdVoResponseData = this.sysServiceFeign.doctorById(sysDoctorDto);
                    if (!Objects.isNull(sysDoctorIdVoResponseData) || sysDoctorIdVoResponseData.isSuccess()) {
                        SysDoctorIdVo sysDoctorIdVo = (SysDoctorIdVo)sysDoctorIdVoResponseData.getData();
                        setlinfoRequest.setChfpdr_code(sysDoctorIdVo.getHsCode());
                    }
                    setlinfoRequest.setSetl_begn_date(DateUtils.stringToSimpleDate((String)hsSettlementInfoEntity.getSetl_time()));
                    setlinfoRequest.setSetl_end_date(DateUtils.stringToSimpleDate((String)hsSettlementInfoEntity.getSetl_time()));
                    setlinfoRequest.setMedins_fill_dept("\u533b\u4fdd\u79d1");
                    setlinfoRequest.setMedins_fill_psn("\u533b\u4fdd\u7ecf\u529e\u4eba\u5458");
                    setlinfoRequest.setResp_nurs_code("");
                    setlinfoRequest.setStas_type("1");
                    setlinfoRequest.setHi_paymtd("1");
                    setlinfoRequest.setTenantId(this.tenantId);
                    ResponseData responseData = this.hsServiceFeign.settlementDetailUpload(setlinfoRequest);
                    log.info("\u4e0a\u4f20\u6e05\u5355\u8fd4\u56de\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)responseData));
                    if (!Objects.isNull(responseData) && responseData.isSuccess()) {
                        hsSettlementInfoEntity.setUpload_status("1");
                        hsSettlementInfoEntity.setSetl_list_id(JSONObject.toJSONString((Object)responseData));
                        this.outHsSettlementInfoMapper.updateById(hsSettlementInfoEntity);
                    } else {
                        hsSettlementInfoEntity.setUpload_status("2");
                        hsSettlementInfoEntity.setSetl_list_id(responseData.getMsg());
                        this.outHsSettlementInfoMapper.updateById(hsSettlementInfoEntity);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            log.error("\u533b\u4fdd\u7ed3\u7b97\u6e05\u5355\u81ea\u52a8\u4e0a\u4f20\u5f02\u5e38,msg:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }
}

