/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.config;

import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.CustomExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.ExchangeBuilder;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.annotation.EnableRabbit;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableRabbit
public class RabbitMQConfig {
    private static final Logger log = LoggerFactory.getLogger(RabbitMQConfig.class);
    public static final String ORDINARY_EXCHANGE = "outpatient.ordinary.exchange";
    public static final String ORDINARY_QUEUE = "outpatient.demo.queue";
    public static final String ORDINARY_ROUTEKEY = "outpatient.demo.routeKey";
    public static final String DELAYED_EXCHANGE = "outpatient.delayed.exchange";
    public static final String DELAYED_ORDER_OVERTIME_KEY = "outpatient.delayed.orderOvertime.key";
    public static final String DELAYED_PRESCRIPTION_OVERTIME_KEY = "outpatient.delayed.prescriptionOvertime.key";
    public static final String DELAYED_PRESCRIPTION_OVERTIME_QUEUE = "outpatient.delayed.prescriptionOvertime.queue";
    public static final String DELAYED_OUTPATIENT_ARCHIVING_OVERTIME_KEY = "outpatient.delayed.outpatientArchivingOvertime.key";
    public static final String DELAYED_OUTPATIENT_ARCHIVING_OVERTIME_QUEUE = "outpatient.delayed.outpatientArchivingOvertime.queue";
    public static final String DELAYED_ORDER_OVERTIME_QUEUE = "outpatient.delayed.orderOvertime.queue";
    public static final String DELAYED_PAYMENT_ORDER_TIMEOUT_KEY = "outpatient.payment.order.timeout.key";
    public static final String DELAYED_PAYMENT_ORDER_TIMEOUT_QUEUE = "outpatient.payment.order.timeout.queue";
    public static final String DELAYED_RESVERATION_OVERTIME_KEY = "outpatient.delayed.resverationOvertime.key";
    public static final String DELAYED_RESVERATION_OVERTIME_QUEUE = "outpatient.delayed.resverationOvertime.queue";

    @Bean
    public Exchange directExchange() {
        return ExchangeBuilder.directExchange((String)ORDINARY_EXCHANGE).durable(true).build();
    }

    @Bean
    public Queue confirmOrderQueue() {
        return new Queue(ORDINARY_QUEUE, true, false, true);
    }

    @Bean
    public Binding confirmOrderBinding() {
        return BindingBuilder.bind((Queue)this.confirmOrderQueue()).to(this.directExchange()).with(ORDINARY_ROUTEKEY).noargs();
    }

    @Bean
    public CustomExchange delayedExchange() {
        HashMap<String, String> arguments = new HashMap<String, String>(1);
        arguments.put("x-delayed-type", "direct");
        return new CustomExchange(DELAYED_EXCHANGE, "x-delayed-message", true, false, arguments);
    }

    @Bean
    public Queue orderOvertimeQueue() {
        return new Queue(DELAYED_ORDER_OVERTIME_QUEUE, true, false, false);
    }

    @Bean
    public Queue prescriptionOvertimeQueue() {
        return new Queue(DELAYED_PRESCRIPTION_OVERTIME_QUEUE, true, false, false);
    }

    @Bean
    public Binding prescriptionOvertimeBind() {
        return BindingBuilder.bind((Queue)this.prescriptionOvertimeQueue()).to((Exchange)this.delayedExchange()).with(DELAYED_PRESCRIPTION_OVERTIME_KEY).noargs();
    }

    @Bean
    public Queue outpatientArchivingOvertimeQueue() {
        return new Queue(DELAYED_OUTPATIENT_ARCHIVING_OVERTIME_QUEUE, true, false, false);
    }

    @Bean
    public Binding outpatientArchivingOvertimeBind() {
        return BindingBuilder.bind((Queue)this.outpatientArchivingOvertimeQueue()).to((Exchange)this.delayedExchange()).with(DELAYED_OUTPATIENT_ARCHIVING_OVERTIME_KEY).noargs();
    }

    @Bean
    public Binding orderOvertimeBind() {
        return BindingBuilder.bind((Queue)this.orderOvertimeQueue()).to((Exchange)this.delayedExchange()).with(DELAYED_ORDER_OVERTIME_KEY).noargs();
    }

    @Bean
    public Queue paymentOrderTimeoutQueue() {
        return new Queue(DELAYED_PAYMENT_ORDER_TIMEOUT_QUEUE, true, false, false);
    }

    @Bean
    public Binding paymentOrderTimeoutBind() {
        return BindingBuilder.bind((Queue)this.paymentOrderTimeoutQueue()).to((Exchange)this.delayedExchange()).with(DELAYED_PAYMENT_ORDER_TIMEOUT_KEY).noargs();
    }

    @Bean
    public Queue reservationTimeoutQueue() {
        return new Queue(DELAYED_ORDER_OVERTIME_QUEUE, true, false, false);
    }

    @Bean
    public Binding reservationTimeoutBind() {
        return BindingBuilder.bind((Queue)this.reservationTimeoutQueue()).to((Exchange)this.delayedExchange()).with(DELAYED_RESVERATION_OVERTIME_KEY).noargs();
    }
}

