/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.outpatient.api.dto.cdss.EmrEntity;
import com.byh.outpatient.api.dto.cdss.OutpatientRecordsEntity;
import com.byh.outpatient.api.dto.cdss.PatientInformaEntity;
import com.byh.outpatient.api.dto.cdss.StaffInformaEntity;
import com.byh.outpatient.api.dto.cdss.Whole;
import com.byh.outpatient.api.dto.medicalRecord.AddDiseaseCourseRecordsDto;
import com.byh.outpatient.api.dto.medicalRecord.CheckDrugTypeDto;
import com.byh.outpatient.api.dto.medicalRecord.ContentDto;
import com.byh.outpatient.api.dto.medicalRecord.GenerateMedicalRecordsDto;
import com.byh.outpatient.api.dto.medicalRecord.InvalidCourseOfIllnessDto;
import com.byh.outpatient.api.dto.medicalRecord.OutPatientHealthRecordDto;
import com.byh.outpatient.api.dto.medicalRecord.Out_AllergyHistoryDto;
import com.byh.outpatient.api.dto.medicalRecord.Out_FamilyHistoryDto;
import com.byh.outpatient.api.dto.medicalRecord.Out_PastHistoryDto;
import com.byh.outpatient.api.dto.medicalRecord.Out_PersonalHistoryDto;
import com.byh.outpatient.api.dto.medicalRecord.OutpatientInfomationDto;
import com.byh.outpatient.api.dto.medicalRecord.QueryDiseaseCourserecordsDto;
import com.byh.outpatient.api.dto.medicalRecord.QueryPatientHealthRecordDto;
import com.byh.outpatient.api.dto.medicalRecord.QueryPatientMedicalDto;
import com.byh.outpatient.api.dto.medicalRecord.UpdateOutpatientInfomationDto;
import com.byh.outpatient.api.dto.medicalRecord.UpdateOutpatientMedicalRecords;
import com.byh.outpatient.api.dto.medicalRecord.UpdateSourceHospitalDto;
import com.byh.outpatient.api.dto.treatment.QueryItemsDto;
import com.byh.outpatient.api.enums.AdmissionSourceEnum;
import com.byh.outpatient.api.enums.AdmissionStatusEnum;
import com.byh.outpatient.api.enums.OutMedicalDiagnosisTypeEnum;
import com.byh.outpatient.api.enums.OutMedicalRecordTypeEnum;
import com.byh.outpatient.api.enums.OutpatientDataStatusEnum;
import com.byh.outpatient.api.exception.BusinessException;
import com.byh.outpatient.api.model.OutEtubePatientDossierEntity;
import com.byh.outpatient.api.model.OutEtubePatientInfoEntity;
import com.byh.outpatient.api.model.admission.AdmissionEntity;
import com.byh.outpatient.api.model.medicalRecord.OutMedicalRecord;
import com.byh.outpatient.api.model.medicalRecord.OutMedicalRecordDiagnosis;
import com.byh.outpatient.api.model.patient.PatientEntity;
import com.byh.outpatient.api.sysModel.request.SysDoctorDto;
import com.byh.outpatient.api.sysModel.respones.SysDoctorIdVo;
import com.byh.outpatient.api.util.DateUtils;
import com.byh.outpatient.api.util.ExceptionUtils;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.StringUtil;
import com.byh.outpatient.api.util.UUIDUtils;
import com.byh.outpatient.api.vo.cdss.CDSSDiagnoseResponse;
import com.byh.outpatient.api.vo.medicalRecord.CheckDrugTypeVo;
import com.byh.outpatient.api.vo.medicalRecord.GetDrugTypeVo;
import com.byh.outpatient.api.vo.medicalRecord.GetSysParamVo;
import com.byh.outpatient.api.vo.medicalRecord.QueryDiagnosisRecordsVo;
import com.byh.outpatient.api.vo.medicalRecord.QueryDiagnosisTotalsVo;
import com.byh.outpatient.api.vo.medicalRecord.QueryDiseaseCourserecordsVo;
import com.byh.outpatient.api.vo.medicalRecord.QueryHistoricalDiagnosisVo;
import com.byh.outpatient.api.vo.medicalRecord.QueryOutpatientInfomationVo;
import com.byh.outpatient.api.vo.medicalRecord.QueryOutpatientMedicalRecordsVo;
import com.byh.outpatient.api.vo.medicalRecord.QueryOutpatientPrintingDataVo;
import com.byh.outpatient.api.vo.prescription.QueryVisitInformationVo;
import com.byh.outpatient.data.repository.AdmissionMapper;
import com.byh.outpatient.data.repository.OutEtubePatientDossierMapper;
import com.byh.outpatient.data.repository.OutEtubePatientInfoMapper;
import com.byh.outpatient.data.repository.OutMedicalRecordMapper;
import com.byh.outpatient.data.repository.OutPrescriptionMapper;
import com.byh.outpatient.data.repository.OutTreatmentItemsMapper;
import com.byh.outpatient.data.repository.PatientMapper;
import com.byh.outpatient.web.feign.SdkServiceFeign;
import com.byh.outpatient.web.feign.SysServiceFeign;
import com.byh.outpatient.web.mvc.controller.RocketMQProducerController;
import com.byh.outpatient.web.mvc.exception.RunDisplayException;
import com.byh.outpatient.web.rocket.RocketMQProducer;
import com.byh.outpatient.web.service.ExpertStudioService;
import com.byh.outpatient.web.service.OutMedicalRecordDiagnosisService;
import com.byh.outpatient.web.service.OutMedicalRecordService;
import com.byh.outpatient.web.service.OutPatientHealthRecordService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.SendCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class OutMedicalRecordServiceImpl
implements OutMedicalRecordService {
    private static final Logger log = LoggerFactory.getLogger(OutMedicalRecordServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(RocketMQProducerController.class);
    private static final String topic = "rocketMQ-out-doctor";
    private static final String patientTopic = "rocketMQ-out-patientTopic";
    private static final String patientPaymentTopic = "rocketMQ-out-patientPaymentTopic";
    private static final String admissionTopic = "rocketMQ-out-admissionTopic";
    private static final String prescriptionDetailTopic = "rocketMQ-out-prescriptionDetailTopic";
    private static final String treatmentItemsTopic = "rocketMQ-out-treatmentItemsTopic";
    private final RocketMQProducer rocketMQProducer;
    @Autowired
    private ExpertStudioService expertStudioService;
    @Autowired
    private OutEtubePatientDossierMapper outEtubePatientDossierMapper;
    @Resource
    private OutEtubePatientInfoMapper outEtubePatientInfoMapper;
    @Autowired
    private OutMedicalRecordMapper outMedicalRecordMapper;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private OutPatientHealthRecordService outPatientHealthRecordService;
    @Autowired
    private OutMedicalRecordDiagnosisService outMedicalRecordDiagnosisService;
    @Autowired
    private OutPrescriptionMapper outPrescriptionMapper;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private OutTreatmentItemsMapper outTreatmentItemsMapper;
    @Autowired
    private SdkServiceFeign sdkServiceFeign;
    @Autowired
    private SysServiceFeign sysServiceFeign;

    @Transactional(rollbackFor={BusinessException.class})
    public void updateSourceHospital(UpdateSourceHospitalDto dto) {
        String outpatientNo = dto.getOutpatientNo();
        String sourceHospital = dto.getSourceHospital();
        Integer tenantId = dto.getTenantId();
        Integer operatorId = dto.getOperatorId();
        String operatorName = dto.getOperatorName();
        if ("\u5176\u5b83".equals(sourceHospital) || "\u65e0".equals(sourceHospital)) {
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)"\u7f16\u8f91\u5904\u65b9\u6765\u6e90\u533b\u9662\u65f6\uff0c\u4e0d\u53ef\u9009\u62e9\uff08\u5176\u5b83\uff09\u6216\uff08\u65e0\uff09\uff01");
        }
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.eq(tenantId != null, OutMedicalRecord::getTenantId, (Object)tenantId)).eq(OutMedicalRecord::getOutpatientNo, (Object)outpatientNo)).set(OutMedicalRecord::getUpdateId, (Object)operatorId)).set(OutMedicalRecord::getUpdateName, (Object)operatorName)).set(OutMedicalRecord::getSourceHospital, (Object)sourceHospital);
        this.outMedicalRecordMapper.update(null, (Wrapper)updateWrapper);
    }

    public CheckDrugTypeVo checkDrugType(CheckDrugTypeDto dto) {
        String paramValue;
        GetSysParamVo param;
        Integer tenantId = dto.getTenantId();
        String outpatientNo = dto.getOutpatientNo();
        List drugIds = dto.getDrugIds();
        List drugTypeList = this.outMedicalRecordMapper.selectDrugTypeByIds(tenantId, drugIds);
        if (drugTypeList.isEmpty()) {
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)"\u68c0\u6d4b\u836f\u54c1\u5904\u65b9\u65f6\uff0c\u6839\u636e\u836f\u54c1\u7f16\u53f7\u96c6\u5408\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u836f\u54c1\u4fe1\u606f\uff01");
        }
        if ((param = this.outMedicalRecordMapper.selectParamByName(tenantId, "check_drug_type")) == null) {
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)"\u68c0\u6d4b\u836f\u54c1\u5904\u65b9\u65f6\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u53c2\u6570\u914d\u7f6e\uff01\u53c2\u6570\u540d\uff1acheck_drug_type");
        }
        if (StrUtil.isEmpty((CharSequence)(paramValue = param.getParamValue()))) {
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)"\u68c0\u6d4b\u836f\u54c1\u5904\u65b9\u65f6\uff0c\u5bf9\u5e94\u7684\u53c2\u6570\u914d\u7f6e\u4e2d\uff0c\u53c2\u6570\u503c\u4e3a\u7a7a\uff01\u53c2\u6570\u540d\uff1acheck_drug_type");
        }
        Map<Object, Object> map = new LinkedHashMap();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            List list = (List)objectMapper.readValue(paramValue, (com.fasterxml.jackson.core.type.TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            map = list.stream().collect(Collectors.toMap(item -> (Integer)item.get("classificationId"), item -> (String)item.get("classificationName")));
        }
        catch (Exception e) {
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)e.getMessage());
        }
        StringBuilder drugInfoBuilder = new StringBuilder();
        for (GetDrugTypeVo vo : drugTypeList) {
            String typeName = map.getOrDefault(vo.getClassificationId(), "");
            if (!StrUtil.isNotEmpty((CharSequence)typeName)) continue;
            drugInfoBuilder.append("\uff08").append(vo.getDrugId()).append("\uff09").append(vo.getDrugName()).append("\uff0c");
        }
        String drugInfo = drugInfoBuilder.toString();
        CheckDrugTypeVo drugTypeVo = new CheckDrugTypeVo();
        if (StrUtil.isNotEmpty((CharSequence)drugInfo)) {
            String sourceHospital;
            LambdaQueryWrapper medicalRecordQueryWrapper = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)medicalRecordQueryWrapper.eq(tenantId != null, OutMedicalRecord::getTenantId, (Object)tenantId)).eq(OutMedicalRecord::getOutpatientNo, (Object)outpatientNo);
            OutMedicalRecord medicalRecord = (OutMedicalRecord)this.outMedicalRecordMapper.selectOne((Wrapper)medicalRecordQueryWrapper);
            if (medicalRecord == null) {
                ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)"\u68c0\u6d4b\u5904\u65b9\u836f\u54c1\u65f6\uff0c\u6839\u636e\u95e8\u8bca\u53f7\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u95e8\u8bca\u75c5\u5386\uff01");
            }
            if (StrUtil.isEmpty((CharSequence)(sourceHospital = medicalRecord.getSourceHospital())) || "\u5176\u5b83".equals(sourceHospital) || "\u65e0".equals(sourceHospital)) {
                drugTypeVo.setFlag(true);
                drugInfo = "\u68c0\u6d4b\u5230\u5b58\u5728\u7279\u6b8a\u7c7b\u578b\u836f\u54c1\uff1a" + drugInfo + "\u9700\u8981\u6b63\u786e\u8f93\u5165\u60a3\u8005\u6765\u6e90\uff08\u533b\u9662\uff09,\u4e0d\u53ef\u9009\u62e9\uff08\u5176\u5b83\uff09\u6216\uff08\u65e0\uff09\uff01";
                drugTypeVo.setRemark(drugInfo);
            }
        }
        return drugTypeVo;
    }

    public ResponseData<QueryOutpatientInfomationVo> queryOutpatientInformation(OutpatientInfomationDto queryParameter) {
        QueryWrapper queryWrapperAdmission = new QueryWrapper();
        queryWrapperAdmission.eq((Object)"outpatient_no", (Object)queryParameter.getOutpatientNo());
        AdmissionEntity admissionEntity = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)queryWrapperAdmission);
        if (ObjectUtils.isEmpty((Object)admissionEntity)) {
            return ResponseData.error((String)"\u6302\u53f7\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01");
        }
        OutMedicalRecord outMedicalRecord = this.CheckOutpatientInformation(queryParameter, admissionEntity);
        QueryOutpatientInfomationVo queryOutpatientInfomationVo = OutMedicalRecordServiceImpl.builedOutpatientInformation((OutMedicalRecord)outMedicalRecord, (AdmissionEntity)admissionEntity);
        PatientEntity patientEntity = this.patientMapper.queryById(admissionEntity.getPatientId().intValue());
        queryOutpatientInfomationVo.setChronicDisease(patientEntity.getChronicDisease());
        return ResponseData.success((Object)queryOutpatientInfomationVo);
    }

    public ResponseData<QueryOutpatientInfomationVo> updateOutpatientInformation(UpdateOutpatientInfomationDto parameter) {
        List medicalRecordList;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"outpatient_no", (Object)parameter.getOutpatientNo());
        AdmissionEntity admissionEntity = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)query);
        if (admissionEntity == null) {
            return ResponseData.error((String)"\u6302\u53f7\u4fe1\u606f\u67e5\u8be2\u5931\u8d25!");
        }
        if (AdmissionStatusEnum.ARCHIVED.getValue().equals(admissionEntity.getStatus())) {
            return ResponseData.error((String)(AdmissionStatusEnum.ARCHIVED.getDesc() + "\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01"));
        }
        if (StrUtil.isNotEmpty((CharSequence)parameter.getMedicalType()) || StrUtil.isNotEmpty((CharSequence)parameter.getMedicalOutpatientType())) {
            admissionEntity.setMedicalType(parameter.getMedicalType());
            admissionEntity.setMedicalOutpatientType(parameter.getMedicalOutpatientType());
            this.admissionMapper.updateById((Object)admissionEntity);
        }
        OutMedicalRecord outMedicalRecord = new OutMedicalRecord();
        BeanUtils.copyProperties((Object)parameter, (Object)outMedicalRecord);
        outMedicalRecord.setUpdateId(parameter.getOperatorId());
        outMedicalRecord.setUpdateName(parameter.getOperatorName());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"outpatient_no", (Object)parameter.getOutpatientNo());
        queryWrapper.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
        queryWrapper.eq((Object)"tenant_id", (Object)parameter.getTenantId());
        int num = this.outMedicalRecordMapper.update((Object)outMedicalRecord, (Wrapper)queryWrapper);
        if ((outMedicalRecord.getId() == null || outMedicalRecord.getPatientId() == null) && (medicalRecordList = this.outMedicalRecordMapper.selectList((Wrapper)queryWrapper)).size() > 0) {
            outMedicalRecord.setId(((OutMedicalRecord)medicalRecordList.get(0)).getId());
            outMedicalRecord.setPatientId(((OutMedicalRecord)medicalRecordList.get(0)).getPatientId());
        }
        if (num == 0) {
            return ResponseData.error((String)"\u672a\u4fee\u6539!");
        }
        Double weight = parameter.getWeight();
        String height = parameter.getHeight();
        OutEtubePatientInfoEntity isEmpty = (OutEtubePatientInfoEntity)this.outEtubePatientInfoMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(OutEtubePatientInfoEntity::getPatientId, (Object)outMedicalRecord.getPatientId()));
        if (isEmpty != null && (height != null || weight != null)) {
            OutEtubePatientDossierEntity dossier = new OutEtubePatientDossierEntity();
            dossier.setTenantId(outMedicalRecord.getTenantId());
            dossier.setPatientId(outMedicalRecord.getPatientId());
            List outEtubePatientDossierEntities = this.outEtubePatientDossierMapper.queryRequired(dossier);
            if (outEtubePatientDossierEntities.size() > 0) {
                OutEtubePatientDossierEntity item = (OutEtubePatientDossierEntity)outEtubePatientDossierEntities.get(0);
                item.setWeight(weight != null ? weight + "" : "");
                item.setHeight(StringUtil.isNotBlank((String)height) ? height : "");
                this.expertStudioService.updatePatientDossier(item);
            }
        }
        try {
            ArrayList<PatientEntity> list = new ArrayList<PatientEntity>();
            PatientEntity patientEntity = new PatientEntity();
            patientEntity.setId(outMedicalRecord.getPatientId());
            Integer narrator = outMedicalRecord.getNarrator();
            Integer type = outMedicalRecord.getType();
            String bloodType = outMedicalRecord.getBloodType();
            String bloodPressureType = outMedicalRecord.getBloodPressureType();
            String status = outMedicalRecord.getStatus();
            String recordType = outMedicalRecord.getRecordType();
            if (StringUtils.isNotBlank((CharSequence)recordType)) {
                switch (recordType) {
                    case "1": {
                        outMedicalRecord.setRecordTypeName("\u7535\u8bdd");
                        break;
                    }
                    case "2": {
                        outMedicalRecord.setRecordTypeName("\u77ed\u4fe1");
                        break;
                    }
                    case "3": {
                        outMedicalRecord.setRecordTypeName("\u5fae\u4fe1");
                        break;
                    }
                    case "4": {
                        outMedicalRecord.setRecordTypeName("\u5176\u4ed6");
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)status)) {
                switch (status) {
                    case "1": {
                        outMedicalRecord.setStatusName("\u6b63\u5e38");
                        break;
                    }
                    case "0": {
                        outMedicalRecord.setStatusName("\u4f5c\u5e9f");
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)bloodPressureType)) {
                switch (bloodPressureType) {
                    case "1": {
                        outMedicalRecord.setBloodPressureTypeName("\u8d77\u5e8a1\u5c0f\u65f6");
                        break;
                    }
                    case "2": {
                        outMedicalRecord.setBloodPressureTypeName("\u5348\u9910\u540e");
                        break;
                    }
                    case "3": {
                        outMedicalRecord.setBloodPressureTypeName("\u665a\u9910\u540e");
                        break;
                    }
                    case "4": {
                        outMedicalRecord.setBloodPressureTypeName("\u5165\u7761\u524d");
                        break;
                    }
                    case "5": {
                        outMedicalRecord.setBloodPressureTypeName("\u5176\u5b83");
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)bloodType)) {
                switch (bloodType) {
                    case "1": {
                        outMedicalRecord.setBloodTypeName("\u7a7a\u8179");
                        break;
                    }
                    case "2": {
                        outMedicalRecord.setBloodTypeName("\u65e9\u9910\u540e");
                        break;
                    }
                    case "3": {
                        outMedicalRecord.setBloodTypeName("\u5348\u9910\u524d");
                        break;
                    }
                    case "4": {
                        outMedicalRecord.setBloodTypeName("\u5348\u9910\u540e");
                        break;
                    }
                    case "5": {
                        outMedicalRecord.setBloodTypeName("\u665a\u9910\u524d");
                        break;
                    }
                    case "6": {
                        outMedicalRecord.setBloodTypeName("\u665a\u9910\u540e");
                        break;
                    }
                    case "7": {
                        outMedicalRecord.setBloodTypeName("\u7761\u524d");
                    }
                }
            }
            if (narrator != null) {
                switch (narrator) {
                    case 1: {
                        outMedicalRecord.setNarratorStr("\u672c\u4eba");
                        break;
                    }
                    case 2: {
                        outMedicalRecord.setNarratorStr("\u5176\u4ed6");
                    }
                }
            }
            if (type != null) {
                switch (type) {
                    case 1: {
                        outMedicalRecord.setTypeName("\u75c5\u5386");
                        break;
                    }
                    case 2: {
                        outMedicalRecord.setTypeName("\u75c5\u7a0b");
                    }
                }
            }
            ArrayList<OutMedicalRecord> medicalRecordList2 = new ArrayList<OutMedicalRecord>();
            medicalRecordList2.add(outMedicalRecord);
            patientEntity.setMedicalRecordList(medicalRecordList2);
            list.add(patientEntity);
            String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
            String msg = JSONObject.toJSONString(list);
            this.rocketMQProducer.asyncSendCallbackTimeoutLevel("rocketMQ-out-patientTopic", "TAG3", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        QueryOutpatientInfomationVo queryOutpatientInfomationVo = new QueryOutpatientInfomationVo();
        BeanUtils.copyProperties((Object)parameter, (Object)queryOutpatientInfomationVo);
        return ResponseData.success((Object)queryOutpatientInfomationVo);
    }

    public ResponseData<QueryOutpatientMedicalRecordsVo> queryOutpatientMedicalRecords(OutpatientInfomationDto queryParameter) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(OutMedicalRecord.getOutpatientMedicalRecords());
        queryWrapper.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
        queryWrapper.eq((Object)"tenant_id", (Object)queryParameter.getTenantId());
        queryWrapper.eq((Object)"outpatient_no", (Object)queryParameter.getOutpatientNo());
        OutMedicalRecord outMedicalRecord = (OutMedicalRecord)this.outMedicalRecordMapper.selectOne((Wrapper)queryWrapper);
        String sourceHospital = "";
        String sourceDoctor = "";
        if (outMedicalRecord != null) {
            sourceDoctor = outMedicalRecord.getSourceDoctor();
            sourceHospital = outMedicalRecord.getSourceHospital();
        }
        if (StringUtil.isBlank((String)sourceHospital)) {
            OutMedicalRecord item;
            QueryWrapper queryWrapperList = new QueryWrapper();
            queryWrapperList.select(OutMedicalRecord.getOutpatientMedicalRecords());
            queryWrapperList.notIn((Object)"status", new Object[]{OutpatientDataStatusEnum.DELETE.getValue(), OutpatientDataStatusEnum.STATUS_VOID.getValue()});
            queryWrapperList.eq((Object)"tenant_id", (Object)queryParameter.getTenantId());
            if (outMedicalRecord != null) {
                queryWrapperList.eq((Object)"patient_id", (Object)outMedicalRecord.getPatientId());
            }
            queryWrapperList.orderByDesc((Object)"create_time");
            List outMedicalRecords = this.outMedicalRecordMapper.selectList((Wrapper)queryWrapperList);
            if (outMedicalRecords.size() > 1 && (item = (OutMedicalRecord)outMedicalRecords.get(1)) != null) {
                outMedicalRecord.setSourceDoctor(item.getSourceDoctor());
                outMedicalRecord.setSourceHospital(item.getSourceHospital());
            }
        }
        QueryOutpatientMedicalRecordsVo queryOutpatientMedicalRecordsVo = OutMedicalRecordServiceImpl.getQueryOutpatientMedicalRecordsVo((OutMedicalRecord)outMedicalRecord);
        List outMedicalRecordDiagnoses = this.outMedicalRecordDiagnosisService.queryMedicalRecordDiagnosis(queryParameter.getTenantId(), outMedicalRecord.getPatientId(), queryParameter.getOutpatientNo());
        OutMedicalRecordServiceImpl.supplementaryMedicalRecords((List)outMedicalRecordDiagnoses, (QueryOutpatientMedicalRecordsVo)queryOutpatientMedicalRecordsVo);
        return ResponseData.success((Object)queryOutpatientMedicalRecordsVo);
    }

    public ResponseData updateOutpatientMedicalRecords(UpdateOutpatientMedicalRecords parameter) {
        List medicalRecordList;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"outpatient_no", (Object)parameter.getOutpatientNo());
        AdmissionEntity admissionEntity = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)query);
        if (admissionEntity == null) {
            return ResponseData.error((String)"\u6302\u53f7\u4fe1\u606f\u67e5\u8be2\u5931\u8d25!");
        }
        OutMedicalRecord outMedicalRecord = OutMedicalRecordServiceImpl.getOutMedicalRecord((UpdateOutpatientMedicalRecords)parameter);
        outMedicalRecord.setPatientId(admissionEntity.getPatientId());
        outMedicalRecord.setPatientCardNo(admissionEntity.getPatientCardNo());
        outMedicalRecord.setMedicalRecordNo(admissionEntity.getMedicalRecordNo());
        String sourceHospital = parameter.getSourceHospital();
        String sourceDoctor = parameter.getSourceDoctor();
        if (StringUtil.isNotBlank((String)sourceHospital)) {
            outMedicalRecord.setSourceHospital(sourceHospital);
        }
        if (StringUtil.isNotBlank((String)sourceDoctor)) {
            outMedicalRecord.setSourceDoctor(sourceDoctor);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"outpatient_no", (Object)parameter.getOutpatientNo());
        queryWrapper.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
        queryWrapper.eq((Object)"tenant_id", (Object)parameter.getTenantId());
        int num = this.outMedicalRecordMapper.update((Object)outMedicalRecord, (Wrapper)queryWrapper);
        if (num == 0) {
            return ResponseData.error((String)"\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        if ((outMedicalRecord.getId() == null || outMedicalRecord.getPatientId() == null) && (medicalRecordList = this.outMedicalRecordMapper.selectList((Wrapper)queryWrapper)).size() > 0) {
            outMedicalRecord.setId(((OutMedicalRecord)medicalRecordList.get(0)).getId());
            outMedicalRecord.setPatientId(((OutMedicalRecord)medicalRecordList.get(0)).getPatientId());
        }
        try {
            ArrayList<PatientEntity> list = new ArrayList<PatientEntity>();
            PatientEntity patientEntity = new PatientEntity();
            patientEntity.setId(outMedicalRecord.getPatientId());
            Integer narrator = outMedicalRecord.getNarrator();
            Integer type = outMedicalRecord.getType();
            String bloodType = outMedicalRecord.getBloodType();
            String bloodPressureType = outMedicalRecord.getBloodPressureType();
            String status = outMedicalRecord.getStatus();
            String recordType = outMedicalRecord.getRecordType();
            if (StringUtils.isNotBlank((CharSequence)recordType)) {
                switch (recordType) {
                    case "1": {
                        outMedicalRecord.setRecordTypeName("\u7535\u8bdd");
                        break;
                    }
                    case "2": {
                        outMedicalRecord.setRecordTypeName("\u77ed\u4fe1");
                        break;
                    }
                    case "3": {
                        outMedicalRecord.setRecordTypeName("\u5fae\u4fe1");
                        break;
                    }
                    case "4": {
                        outMedicalRecord.setRecordTypeName("\u5176\u4ed6");
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)status)) {
                switch (status) {
                    case "1": {
                        outMedicalRecord.setStatusName("\u6b63\u5e38");
                        break;
                    }
                    case "0": {
                        outMedicalRecord.setStatusName("\u4f5c\u5e9f");
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)bloodPressureType)) {
                switch (bloodPressureType) {
                    case "1": {
                        outMedicalRecord.setBloodPressureTypeName("\u8d77\u5e8a1\u5c0f\u65f6");
                        break;
                    }
                    case "2": {
                        outMedicalRecord.setBloodPressureTypeName("\u5348\u9910\u540e");
                        break;
                    }
                    case "3": {
                        outMedicalRecord.setBloodPressureTypeName("\u665a\u9910\u540e");
                        break;
                    }
                    case "4": {
                        outMedicalRecord.setBloodPressureTypeName("\u5165\u7761\u524d");
                        break;
                    }
                    case "5": {
                        outMedicalRecord.setBloodPressureTypeName("\u5176\u5b83");
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)bloodType)) {
                switch (bloodType) {
                    case "1": {
                        outMedicalRecord.setBloodTypeName("\u7a7a\u8179");
                        break;
                    }
                    case "2": {
                        outMedicalRecord.setBloodTypeName("\u65e9\u9910\u540e");
                        break;
                    }
                    case "3": {
                        outMedicalRecord.setBloodTypeName("\u5348\u9910\u524d");
                        break;
                    }
                    case "4": {
                        outMedicalRecord.setBloodTypeName("\u5348\u9910\u540e");
                        break;
                    }
                    case "5": {
                        outMedicalRecord.setBloodTypeName("\u665a\u9910\u524d");
                        break;
                    }
                    case "6": {
                        outMedicalRecord.setBloodTypeName("\u665a\u9910\u540e");
                        break;
                    }
                    case "7": {
                        outMedicalRecord.setBloodTypeName("\u7761\u524d");
                    }
                }
            }
            if (narrator != null) {
                switch (narrator) {
                    case 1: {
                        outMedicalRecord.setNarratorStr("\u672c\u4eba");
                        break;
                    }
                    case 2: {
                        outMedicalRecord.setNarratorStr("\u5176\u4ed6");
                    }
                }
            }
            if (type != null) {
                switch (type) {
                    case 1: {
                        outMedicalRecord.setTypeName("\u75c5\u5386");
                        break;
                    }
                    case 2: {
                        outMedicalRecord.setTypeName("\u75c5\u7a0b");
                    }
                }
            }
            ArrayList<OutMedicalRecord> medicalRecordList2 = new ArrayList<OutMedicalRecord>();
            medicalRecordList2.add(outMedicalRecord);
            patientEntity.setMedicalRecordList(medicalRecordList2);
            list.add(patientEntity);
            String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
            String msg = JSONObject.toJSONString(list);
            this.rocketMQProducer.asyncSendCallbackTimeoutLevel("rocketMQ-out-patientTopic", "TAG3", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateMedicalRecordDiagnosis(admissionEntity.getTenantId(), admissionEntity.getPatientId(), admissionEntity.getOutpatientNo(), parameter);
        this.updatePatientHealthRecords(outMedicalRecord);
        return ResponseData.success((Object)"\u4fee\u6539\u6210\u529f");
    }

    public ResponseData<QueryDiagnosisRecordsVo> queryDiagnosisTreatmentRecords(QueryPatientMedicalDto parameter) {
        QueryDiagnosisRecordsVo queryDiagnosisRecordsVo = new QueryDiagnosisRecordsVo();
        parameter.setStatus(Collections.singletonList(AdmissionStatusEnum.ARCHIVED.getValue()));
        List queryDiagnosisTreatmentRecordsVos = this.outMedicalRecordMapper.queryDiagnosisTreatmentRecords(parameter);
        queryDiagnosisRecordsVo.setDiagnosisTreatmentRecordsList(queryDiagnosisTreatmentRecordsVos);
        List queryDiagnosisTotalsVos = this.outMedicalRecordMapper.queryDiagnosisTypeSize(parameter);
        if (!CollectionUtils.isEmpty((Collection)queryDiagnosisTotalsVos)) {
            Integer count = 0;
            for (QueryDiagnosisTotalsVo vo : queryDiagnosisTotalsVos) {
                vo.setStrName(AdmissionSourceEnum.getEnum((String)String.valueOf(vo.getStrValue())).getDesc());
                count = count + vo.getSize();
            }
            queryDiagnosisRecordsVo.setTotalList(queryDiagnosisTotalsVos);
            queryDiagnosisRecordsVo.setTotalQuantity(count);
        }
        return ResponseData.success((Object)queryDiagnosisRecordsVo);
    }

    public ResponseData<List<QueryHistoricalDiagnosisVo>> queryHistoricalDiagnosis(QueryPatientHealthRecordDto parameter) {
        List queryMedicalRecordDiagnosis = this.outMedicalRecordDiagnosisService.queryHistoricalDiagnosis(parameter.getTenantId(), parameter.getPatientId(), OutMedicalDiagnosisTypeEnum.DIAGNOSIS.getValue());
        return ResponseData.success((Object)queryMedicalRecordDiagnosis);
    }

    public ResponseData<List<QueryDiseaseCourserecordsVo>> queryDiseaseCourserecords(QueryDiseaseCourserecordsDto parameter) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"tenant_id", (Object)parameter.getTenantId())).eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue())).eq((Object)"type", (Object)OutMedicalRecordTypeEnum.DISEASE_COURSE.getValue())).eq((Object)"patient_id", (Object)parameter.getPatientId())).eq(!ObjectUtils.isEmpty((Object)parameter.getRecordType()), (Object)"record_type", (Object)parameter.getRecordType())).like(!ObjectUtils.isEmpty((Object)parameter.getCreateName()), (Object)"create_name", (Object)parameter.getCreateName())).between(!ObjectUtils.isEmpty((Object)parameter.getEndTime()) && !ObjectUtils.isEmpty((Object)parameter.getStartTime()), (Object)"create_name", (Object)parameter.getStartTime(), (Object)parameter.getEndTime())).orderByDesc((Object)"update_time");
        List outMedicalRecords = this.outMedicalRecordMapper.selectList((Wrapper)wrapper);
        ArrayList<QueryDiseaseCourserecordsVo> queryDiseaseCourserecordsVos = new ArrayList<QueryDiseaseCourserecordsVo>();
        for (OutMedicalRecord outMedicalRecord : outMedicalRecords) {
            QueryDiseaseCourserecordsVo queryDiseaseCourserecordsVo = new QueryDiseaseCourserecordsVo();
            BeanUtils.copyProperties((Object)outMedicalRecord, (Object)queryDiseaseCourserecordsVo);
            queryDiseaseCourserecordsVo.setTime(outMedicalRecord.getUpdateTime());
            queryDiseaseCourserecordsVos.add(queryDiseaseCourserecordsVo);
        }
        return ResponseData.success(queryDiseaseCourserecordsVos);
    }

    public ResponseData<String> addDiseaseCourseRecords(AddDiseaseCourseRecordsDto parameter) {
        PatientEntity patientEntity = this.patientMapper.queryById(parameter.getPatientId().intValue());
        if (patientEntity == null) {
            return ResponseData.error((String)"\u627e\u4e0d\u5230\u60a3\u8005\uff01");
        }
        OutMedicalRecord outMedicalRecord = new OutMedicalRecord();
        BeanUtils.copyProperties((Object)parameter, (Object)outMedicalRecord);
        outMedicalRecord.setSourceHospital(parameter.getSourceHospital());
        outMedicalRecord.setPatientId(patientEntity.getId());
        outMedicalRecord.setPatientCardNo(patientEntity.getCardNo());
        outMedicalRecord.setPatientName(patientEntity.getName());
        outMedicalRecord.setMedicalRecordNo(patientEntity.getMedicalRecordNo());
        outMedicalRecord.setCreateId(parameter.getOperatorId());
        outMedicalRecord.setCreateName(parameter.getOperatorName());
        outMedicalRecord.setStatus(OutpatientDataStatusEnum.NORMAL.getStringValue());
        outMedicalRecord.setType(OutMedicalRecordTypeEnum.DISEASE_COURSE.getValue());
        int size = this.outMedicalRecordMapper.insert((Object)outMedicalRecord);
        if (size == 0) {
            return ResponseData.error((String)"\u5931\u8d25");
        }
        return ResponseData.success((Object)"\u6210\u529f");
    }

    public ResponseData<Boolean> invalidCourseOfIllness(InvalidCourseOfIllnessDto parameter) {
        OutMedicalRecord outMedicalRecord = (OutMedicalRecord)this.outMedicalRecordMapper.selectById((Serializable)parameter.getId());
        if (outMedicalRecord == null) {
            return ResponseData.error((String)"\u627e\u4e0d\u5230\u8bb0\u5f55");
        }
        outMedicalRecord.setUpdateName(parameter.getOperatorName());
        outMedicalRecord.setUpdateId(parameter.getOperatorId());
        outMedicalRecord.setStatus(OutpatientDataStatusEnum.STATUS_VOID.getStringValue());
        outMedicalRecord.setRemark(parameter.getRemark());
        int size = this.outMedicalRecordMapper.updateById((Object)outMedicalRecord);
        return ResponseData.success((Object)(size == 1 ? 1 : 0));
    }

    public ResponseData<QueryVisitInformationVo> queryVisitInformation(OutpatientInfomationDto parameter) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
        queryWrapper.eq((Object)"tenant_id", (Object)parameter.getTenantId());
        queryWrapper.eq((Object)"outpatient_no", (Object)parameter.getOutpatientNo());
        OutMedicalRecord outMedicalRecord = (OutMedicalRecord)this.outMedicalRecordMapper.selectOne((Wrapper)queryWrapper);
        if (outMedicalRecord == null) {
            return ResponseData.error((String)"\u67e5\u8be2\u4e0d\u5230\u95e8\u8bca\u8bb0\u5f55\uff01");
        }
        QueryWrapper queryAdmissionEntity = new QueryWrapper();
        queryAdmissionEntity.eq((Object)"outpatient_no", (Object)parameter.getOutpatientNo());
        AdmissionEntity admissionEntity = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)queryAdmissionEntity);
        if (ObjectUtils.isEmpty((Object)admissionEntity)) {
            throw new RunDisplayException("\u95e8\u8bca\u8bb0\u5f55\u67e5\u8be2\u5931\u8d25");
        }
        List outMedicalRecordDiagnoses = this.outMedicalRecordDiagnosisService.queryMedicalRecordDiagnosis(outMedicalRecord.getTenantId(), outMedicalRecord.getPatientId(), outMedicalRecord.getOutpatientNo());
        QueryVisitInformationVo queryVisitInformationVo = OutMedicalRecordServiceImpl.getQueryVisitInformationVo((OutMedicalRecord)outMedicalRecord, (List)outMedicalRecordDiagnoses);
        queryVisitInformationVo.setGender(admissionEntity.getPatientSex());
        queryVisitInformationVo.setAge(admissionEntity.getPatientAge());
        queryVisitInformationVo.setPhone(admissionEntity.getPhone());
        return ResponseData.success((Object)queryVisitInformationVo);
    }

    public ResponseData<QueryOutpatientPrintingDataVo> queryOutpatientPrintingData(OutpatientInfomationDto parameter) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
        queryWrapper.eq((Object)"tenant_id", (Object)parameter.getTenantId());
        queryWrapper.eq((Object)"outpatient_no", (Object)parameter.getOutpatientNo());
        OutMedicalRecord outMedicalRecord = (OutMedicalRecord)this.outMedicalRecordMapper.selectOne((Wrapper)queryWrapper);
        if (ObjectUtils.isEmpty((Object)outMedicalRecord)) {
            throw new RunDisplayException("\u75c5\u5386\u67e5\u8be2\u5931\u8d25");
        }
        List outMedicalRecordDiagnoses = this.outMedicalRecordDiagnosisService.queryMedicalRecordDiagnosis(parameter.getTenantId(), outMedicalRecord.getPatientId(), parameter.getOutpatientNo());
        if (CollectionUtils.isEmpty((Collection)outMedicalRecordDiagnoses)) {
            throw new RunDisplayException("\u8bca\u65ad\u67e5\u8be2\u5931\u8d25");
        }
        List prescriptionsVos = this.outPrescriptionMapper.queryNotRefundWesternMedicinePrescriptions(parameter.getTenantId(), parameter.getOutpatientNo(), parameter.getPrescriptionType(), null, null, null, null, null, null);
        QueryItemsDto itemsParameter = new QueryItemsDto();
        BeanUtils.copyProperties((Object)parameter, (Object)itemsParameter);
        List outTreatmentItems = this.outTreatmentItemsMapper.queryItems(itemsParameter);
        QueryOutpatientMedicalRecordsVo queryOutpatientMedicalRecordsVo = OutMedicalRecordServiceImpl.getQueryOutpatientMedicalRecordsVo((OutMedicalRecord)outMedicalRecord);
        OutMedicalRecordServiceImpl.supplementaryMedicalRecords((List)outMedicalRecordDiagnoses, (QueryOutpatientMedicalRecordsVo)queryOutpatientMedicalRecordsVo);
        QueryOutpatientPrintingDataVo queryOutpatientPrintingDataVo = new QueryOutpatientPrintingDataVo();
        BeanUtils.copyProperties((Object)queryOutpatientMedicalRecordsVo, (Object)queryOutpatientPrintingDataVo);
        QueryWrapper queryAdmissionEntity = new QueryWrapper();
        queryAdmissionEntity.eq((Object)"outpatient_no", (Object)parameter.getOutpatientNo());
        AdmissionEntity admissionEntity = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)queryAdmissionEntity);
        if (ObjectUtils.isEmpty((Object)admissionEntity)) {
            throw new RunDisplayException("\u95e8\u8bca\u8bb0\u5f55\u67e5\u8be2\u5931\u8d25");
        }
        PatientEntity patientEntity = this.patientMapper.queryById(admissionEntity.getPatientId().intValue());
        queryOutpatientPrintingDataVo.setAdmissionEntity(admissionEntity);
        queryOutpatientPrintingDataVo.setPatientEntity(patientEntity);
        queryOutpatientPrintingDataVo.setPrescriptions(prescriptionsVos);
        queryOutpatientPrintingDataVo.setOutTreatmentItems(outTreatmentItems);
        queryOutpatientPrintingDataVo.setRecordTime(outMedicalRecord.getCreateTime());
        return ResponseData.success((Object)queryOutpatientPrintingDataVo);
    }

    public ResponseData generateMedicalRecord(GenerateMedicalRecordsDto parameter) {
        OutpatientInfomationDto queryParameter = new OutpatientInfomationDto();
        BeanUtils.copyProperties((Object)parameter, (Object)queryParameter);
        ResponseData queryOutpatientInfomationVoResponseData = this.queryOutpatientInformation(queryParameter);
        if (!queryOutpatientInfomationVoResponseData.isSuccess()) {
            return queryOutpatientInfomationVoResponseData;
        }
        List attachmentAddressList = parameter.getAttachmentAddressList();
        if (CollectionUtils.isEmpty((Collection)attachmentAddressList)) {
            return ResponseData.error((String)"\u9644\u4ef6\u4fe1\u606f\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<ContentDto> contentDtos = new ArrayList<ContentDto>(attachmentAddressList.size());
        for (String attachmentAddress : attachmentAddressList) {
            if (StringUtils.isEmpty((CharSequence)attachmentAddress)) {
                return ResponseData.error((String)"\u9644\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            ContentDto contentDto = new ContentDto();
            contentDto.setType("image");
            contentDto.setUrl(attachmentAddress);
            contentDtos.add(contentDto);
        }
        log.info("\u83b7\u53d6\u75c5\u5386\u64cd\u4f5c\u5165\u53c2:{}", (Object)JSON.toJSONString(contentDtos));
        ResponseData responseData = this.sdkServiceFeign.generateMedicalRecord(contentDtos);
        log.info("\u83b7\u53d6\u75c5\u5386\u7ed3\u679c\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)responseData));
        if (!responseData.isSuccess()) {
            return responseData;
        }
        QueryOutpatientMedicalRecordsVo queryOutpatientMedicalRecordsVo = (QueryOutpatientMedicalRecordsVo)JSON.parseObject((String)JSON.toJSONString((Object)responseData.getData()), QueryOutpatientMedicalRecordsVo.class);
        ResponseData cdssInformation = this.buildCdssInformation(parameter, queryOutpatientMedicalRecordsVo);
        if (cdssInformation.isSuccess()) {
            queryOutpatientMedicalRecordsVo.setCdssDiagnoseResponse((CDSSDiagnoseResponse)cdssInformation.getData());
        }
        return ResponseData.success((Object)queryOutpatientMedicalRecordsVo);
    }

    private ResponseData<CDSSDiagnoseResponse> buildCdssInformation(GenerateMedicalRecordsDto parameter, QueryOutpatientMedicalRecordsVo queryOutpatientMedicalRecordsVo) {
        Whole whole = new Whole();
        EmrEntity emr = new EmrEntity();
        emr.setTrigger("\u63d0\u4ea4");
        emr.set\u573a\u666f(Arrays.asList("\u95e8\u8bca\u8bb0\u5f55"));
        SysDoctorDto sysDoctorDto = new SysDoctorDto();
        sysDoctorDto.setId(parameter.getOperatorId());
        ResponseData sysDoctorIdVoResponseData = this.sysServiceFeign.doctorById(sysDoctorDto);
        if (Objects.isNull(sysDoctorIdVoResponseData) || !sysDoctorIdVoResponseData.isSuccess()) {
            return ResponseData.error((String)"\u67e5\u8be2\u533b\u751f\u4fe1\u606f\u5931\u8d25{}", (String)JSONObject.toJSONString((Object)sysDoctorIdVoResponseData));
        }
        SysDoctorIdVo sysDoctorVo = (SysDoctorIdVo)sysDoctorIdVoResponseData.getData();
        StaffInformaEntity staffInformaEntity = new StaffInformaEntity();
        staffInformaEntity.set\u533b\u9662("\u5357\u660c\u4f17\u5eb7\u533b\u9662");
        staffInformaEntity.set\u79d1\u5ba4(sysDoctorVo.getDepartmentName());
        staffInformaEntity.set\u59d3\u540d(sysDoctorVo.getUserName());
        staffInformaEntity.set\u8d26\u53f7ID(sysDoctorVo.getUserId() + "");
        staffInformaEntity.set\u89d2\u8272(sysDoctorVo.getDoctorTitle());
        emr.set\u5de5\u4f5c\u4eba\u5458\u4fe1\u606f(staffInformaEntity);
        QueryWrapper queryWrapperAdmission = new QueryWrapper();
        queryWrapperAdmission.eq((Object)"outpatient_no", (Object)parameter.getOutpatientNo());
        AdmissionEntity admissionEntity = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)queryWrapperAdmission);
        if (ObjectUtils.isEmpty((Object)admissionEntity)) {
            return ResponseData.error((String)"\u6302\u53f7\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01");
        }
        PatientEntity patientEntity = this.patientMapper.queryById(admissionEntity.getPatientId().intValue());
        PatientInformaEntity patientInformaEntity = new PatientInformaEntity();
        patientInformaEntity.set\u5c31\u8bca\u7c7b\u578b("\u95e8\u8bca");
        patientInformaEntity.set\u5c31\u8bcaID(parameter.getOutpatientNo());
        patientInformaEntity.set\u60a3\u8005ID(admissionEntity.getPatientId() + "");
        patientInformaEntity.set\u5e74\u9f84(patientEntity.getAge() + "");
        patientInformaEntity.set\u6027\u522b(patientEntity.getSex());
        patientInformaEntity.set\u51fa\u751f\u65e5\u671f(patientEntity.getBirthday());
        emr.set\u60a3\u8005\u4fe1\u606f(patientInformaEntity);
        OutpatientRecordsEntity outpatientRecordsEntity = new OutpatientRecordsEntity();
        outpatientRecordsEntity.set\u662f\u5426\u590d\u8bca("\u5426");
        outpatientRecordsEntity.set\u79d1\u5ba4(admissionEntity.getDeptName());
        outpatientRecordsEntity.set\u8bb0\u5f55ID(parameter.getOutpatientNo());
        outpatientRecordsEntity.set\u8bb0\u5f55\u65f6\u95f4(admissionEntity.getRegTime());
        outpatientRecordsEntity.set\u5c31\u8bca\u65f6\u95f4(Objects.nonNull(admissionEntity.getVisitTime()) ? DateUtils.dateFormat((Date)admissionEntity.getVisitTime(), (String)"yyyy-MM-dd HH:mm:ss") : "");
        outpatientRecordsEntity.set\u4e3b\u8bc9(queryOutpatientMedicalRecordsVo.getChiefComplaint());
        outpatientRecordsEntity.set\u73b0\u75c5\u53f2(queryOutpatientMedicalRecordsVo.getPresentMedicalHistory());
        outpatientRecordsEntity.set\u65e2\u5f80\u53f2(queryOutpatientMedicalRecordsVo.getMedicalHistory());
        outpatientRecordsEntity.set\u8fc7\u654f\u53f2(queryOutpatientMedicalRecordsVo.getAllergyHistoryText());
        outpatientRecordsEntity.set\u4f53\u683c\u68c0\u67e5(queryOutpatientMedicalRecordsVo.getPhysicalExam());
        outpatientRecordsEntity.set\u8f85\u52a9\u68c0\u67e5(queryOutpatientMedicalRecordsVo.getAuxiliaryInspection());
        emr.set\u95e8\u8bca\u8bb0\u5f55(outpatientRecordsEntity);
        whole.setEmr(emr);
        ResponseData responseData = this.sdkServiceFeign.getCDSSDiagnosePortrait(whole);
        log.info("\u7591\u4f3c\u75c5\u5386\u8c03\u7528\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)responseData));
        if (!responseData.isSuccess()) {
            return ResponseData.error((String)responseData.getMsg());
        }
        if (Objects.nonNull(responseData.getData())) {
            CDSSDiagnoseResponse cdssDiagnoseResponse = (CDSSDiagnoseResponse)JSON.parseObject((String)JSON.toJSONString((Object)responseData.getData()), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            return ResponseData.success((Object)cdssDiagnoseResponse);
        }
        return ResponseData.success();
    }

    private static QueryVisitInformationVo getQueryVisitInformationVo(OutMedicalRecord outMedicalRecord, List<OutMedicalRecordDiagnosis> outMedicalRecordDiagnoses) {
        QueryVisitInformationVo queryVisitInformationVo = new QueryVisitInformationVo();
        BeanUtils.copyProperties((Object)outMedicalRecord, (Object)queryVisitInformationVo);
        Map diagnosisDtoMap = OutMedicalDiagnosisTypeEnum.getDiagnosisListMap(outMedicalRecordDiagnoses);
        queryVisitInformationVo.setCTime(outMedicalRecord.getCreateTime());
        queryVisitInformationVo.setDiagnosis((List)diagnosisDtoMap.get(OutMedicalDiagnosisTypeEnum.DIAGNOSIS.getValue()));
        return queryVisitInformationVo;
    }

    @Async
    public void updatePatientHealthRecords(OutMedicalRecord outMedicalRecord) {
        OutPatientHealthRecordDto recordDto = new OutPatientHealthRecordDto();
        BeanUtils.copyProperties((Object)outMedicalRecord, (Object)recordDto);
        recordDto.setOperator(outMedicalRecord.getUpdateId());
        recordDto.setOperatorName(outMedicalRecord.getUpdateName());
        this.outPatientHealthRecordService.updatePatientHealthRecords(recordDto);
    }

    @Async
    public void updateMedicalRecordDiagnosis(Integer tenantId, Integer patientId, String outpatientNo, UpdateOutpatientMedicalRecords parameter) {
        ArrayList outMedicalRecordDiagnosisList = new ArrayList();
        HashMap<List, Integer> diagnosisMap = new HashMap<List, Integer>();
        diagnosisMap.put(parameter.getDiagnosis(), OutMedicalDiagnosisTypeEnum.DIAGNOSIS.getValue());
        diagnosisMap.put(parameter.getHsDiagnosis(), OutMedicalDiagnosisTypeEnum.MEDICAL_INSURANCE_DIAGNOSIS.getValue());
        diagnosisMap.put(parameter.getCdDiagnosis(), OutMedicalDiagnosisTypeEnum.DIAGNOSIS_OF_MENTE.getValue());
        for (Map.Entry entry : diagnosisMap.entrySet()) {
            List diagnoses = (List)entry.getKey();
            int medicalDiagnosisType = (Integer)entry.getValue();
            if (CollectionUtils.isEmpty((Collection)diagnoses)) continue;
            List collect = diagnoses.stream().map(a -> {
                OutMedicalRecordDiagnosis diagnosis = new OutMedicalRecordDiagnosis();
                BeanUtils.copyProperties((Object)a, (Object)diagnosis);
                diagnosis.setTenantId(tenantId);
                diagnosis.setPatientId(patientId);
                diagnosis.setOutpatientNo(outpatientNo);
                diagnosis.setMedicalDiagnosisType(Integer.valueOf(medicalDiagnosisType));
                return diagnosis;
            }).collect(Collectors.toList());
            outMedicalRecordDiagnosisList.addAll(collect);
        }
        if (!CollectionUtils.isEmpty(outMedicalRecordDiagnosisList)) {
            this.outMedicalRecordDiagnosisService.updateMedicalRecordDiagnosis(tenantId, patientId, outpatientNo, outMedicalRecordDiagnosisList);
            try {
                ArrayList<PatientEntity> list = new ArrayList<PatientEntity>();
                PatientEntity patientEntity = new PatientEntity();
                patientEntity.setId(((OutMedicalRecordDiagnosis)outMedicalRecordDiagnosisList.get(0)).getPatientId());
                for (OutMedicalRecordDiagnosis outMedicalRecordDiagnosis : outMedicalRecordDiagnosisList) {
                    Integer isSusiected = outMedicalRecordDiagnosis.getIsSusiected();
                    Integer diagnosticType = outMedicalRecordDiagnosis.getDiagnosticType();
                    Integer medicalDiagnosisType = outMedicalRecordDiagnosis.getMedicalDiagnosisType();
                    if (medicalDiagnosisType != null) {
                        switch (medicalDiagnosisType) {
                            case 1: {
                                outMedicalRecordDiagnosis.setMedicalDiagnosisTypeName("\u8bca\u65ad");
                                break;
                            }
                            case 2: {
                                outMedicalRecordDiagnosis.setMedicalDiagnosisTypeName("\u533b\u4fdd\u8bca\u65ad");
                                break;
                            }
                            case 3: {
                                outMedicalRecordDiagnosis.setMedicalDiagnosisTypeName("\u95e8\u7279\u75c5\u8bca\u65ad");
                            }
                        }
                    }
                    if (diagnosticType != null) {
                        switch (diagnosticType) {
                            case 1: {
                                outMedicalRecordDiagnosis.setDiagnosticTypeName("\u4e2d\u533b");
                                break;
                            }
                            case 2: {
                                outMedicalRecordDiagnosis.setDiagnosticTypeName("\u897f\u533b");
                            }
                        }
                    }
                    if (isSusiected == null) continue;
                    switch (isSusiected) {
                        case 0: {
                            outMedicalRecordDiagnosis.setIsSusiectedName("\u5426");
                            break;
                        }
                        case 1: {
                            outMedicalRecordDiagnosis.setIsSusiectedName("\u662f");
                        }
                    }
                }
                patientEntity.setMedicalRecordDiagnosisList(outMedicalRecordDiagnosisList);
                list.add(patientEntity);
                String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
                String msg = JSONObject.toJSONString(list);
                this.rocketMQProducer.asyncSendCallbackTimeoutLevel("rocketMQ-out-patientTopic", "TAG3", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void supplementaryMedicalRecords(List<OutMedicalRecordDiagnosis> outMedicalRecordDiagnoses, QueryOutpatientMedicalRecordsVo queryOutpatientMedicalRecordsVo) {
        Map diagnosisDtoMap = OutMedicalDiagnosisTypeEnum.getDiagnosisListMap(outMedicalRecordDiagnoses);
        HashSet allDiagnosisValueSet = new HashSet();
        outMedicalRecordDiagnoses.forEach(x -> {
            if (StringUtils.isNotEmpty((CharSequence)x.getDiagnosis())) {
                allDiagnosisValueSet.add(x.getDiagnosis());
            }
            if (StringUtils.isNotEmpty((CharSequence)x.getHsDiagnosis())) {
                allDiagnosisValueSet.add(x.getHsDiagnosis());
            }
            if (StringUtils.isNotEmpty((CharSequence)x.getCdDiagnosis())) {
                allDiagnosisValueSet.add(x.getCdDiagnosis());
            }
        });
        if (allDiagnosisValueSet.size() > 0) {
            String collect = String.join((CharSequence)",", allDiagnosisValueSet);
            queryOutpatientMedicalRecordsVo.setAllDiagnosisValue(collect);
        }
        queryOutpatientMedicalRecordsVo.setDiagnosis((List)diagnosisDtoMap.get(OutMedicalDiagnosisTypeEnum.DIAGNOSIS.getValue()));
        queryOutpatientMedicalRecordsVo.setHsDiagnosis((List)diagnosisDtoMap.get(OutMedicalDiagnosisTypeEnum.MEDICAL_INSURANCE_DIAGNOSIS.getValue()));
        queryOutpatientMedicalRecordsVo.setCdDiagnosis((List)diagnosisDtoMap.get(OutMedicalDiagnosisTypeEnum.DIAGNOSIS_OF_MENTE.getValue()));
    }

    private static QueryOutpatientMedicalRecordsVo getQueryOutpatientMedicalRecordsVo(OutMedicalRecord outMedicalRecord) {
        QueryOutpatientMedicalRecordsVo queryOutpatientMedicalRecordsVo = new QueryOutpatientMedicalRecordsVo();
        BeanUtils.copyProperties((Object)outMedicalRecord, (Object)queryOutpatientMedicalRecordsVo);
        queryOutpatientMedicalRecordsVo.setOutMedicalRecordId(outMedicalRecord.getId());
        queryOutpatientMedicalRecordsVo.setMedicalHistory(outMedicalRecord.getMedicalHistory());
        queryOutpatientMedicalRecordsVo.setAllergyHistoryText(outMedicalRecord.getAllergyHistoryText());
        queryOutpatientMedicalRecordsVo.setSourceHospital(outMedicalRecord.getSourceHospital());
        queryOutpatientMedicalRecordsVo.setSourceDoctor(outMedicalRecord.getSourceDoctor());
        queryOutpatientMedicalRecordsVo.setDiseaseHistory(JSON.parseArray((String)outMedicalRecord.getDiseaseHistory(), Out_PastHistoryDto.class));
        queryOutpatientMedicalRecordsVo.setSurgicalHistory(JSON.parseArray((String)outMedicalRecord.getSurgicalHistory(), Out_PastHistoryDto.class));
        queryOutpatientMedicalRecordsVo.setAllergyHistory(JSON.parseArray((String)outMedicalRecord.getAllergyHistory(), Out_AllergyHistoryDto.class));
        queryOutpatientMedicalRecordsVo.setFamilyHistory(JSON.parseArray((String)outMedicalRecord.getFamilyHistory(), Out_FamilyHistoryDto.class));
        queryOutpatientMedicalRecordsVo.setSmokingHistory((Out_PersonalHistoryDto)JSON.parseObject((String)outMedicalRecord.getSmokingHistory(), Out_PersonalHistoryDto.class));
        queryOutpatientMedicalRecordsVo.setDrinkingHistroy((Out_PersonalHistoryDto)JSON.parseObject((String)outMedicalRecord.getDrinkingHistroy(), Out_PersonalHistoryDto.class));
        return queryOutpatientMedicalRecordsVo;
    }

    private static OutMedicalRecord getOutMedicalRecord(UpdateOutpatientMedicalRecords parameter) {
        OutMedicalRecord outMedicalRecord = new OutMedicalRecord();
        BeanUtils.copyProperties((Object)parameter, (Object)outMedicalRecord);
        outMedicalRecord.setUpdateId(parameter.getOperatorId());
        outMedicalRecord.setUpdateName(parameter.getOperatorName());
        outMedicalRecord.setDiseaseHistory(ObjectUtils.isEmpty((Object)parameter.getDiseaseHistory()) ? null : JSON.toJSONString((Object)parameter.getDiseaseHistory()));
        outMedicalRecord.setSurgicalHistory(ObjectUtils.isEmpty((Object)parameter.getSurgicalHistory()) ? null : JSON.toJSONString((Object)parameter.getSurgicalHistory()));
        outMedicalRecord.setAllergyHistory(ObjectUtils.isEmpty((Object)parameter.getAllergyHistory()) ? null : JSON.toJSONString((Object)parameter.getAllergyHistory()));
        outMedicalRecord.setFamilyHistory(ObjectUtils.isEmpty((Object)parameter.getFamilyHistory()) ? null : JSON.toJSONString((Object)parameter.getFamilyHistory()));
        outMedicalRecord.setSmokingHistory(ObjectUtils.isEmpty((Object)parameter.getSmokingHistory()) ? null : JSON.toJSONString((Object)parameter.getSmokingHistory()));
        outMedicalRecord.setDrinkingHistroy(ObjectUtils.isEmpty((Object)parameter.getDrinkingHistroy()) ? null : JSON.toJSONString((Object)parameter.getDrinkingHistroy()));
        outMedicalRecord.setMedicalHistory(parameter.getMedicalHistory());
        outMedicalRecord.setAllergyHistoryText(parameter.getAllergyHistoryText());
        return outMedicalRecord;
    }

    private static QueryOutpatientInfomationVo builedOutpatientInformation(OutMedicalRecord outMedicalRecord, AdmissionEntity admissionEntity) {
        QueryOutpatientInfomationVo queryOutpatientInfomationVo = new QueryOutpatientInfomationVo();
        BeanUtils.copyProperties((Object)outMedicalRecord, (Object)queryOutpatientInfomationVo);
        queryOutpatientInfomationVo.setOutMedicalRecordId(outMedicalRecord.getId());
        queryOutpatientInfomationVo.setWaitNo(admissionEntity.getWaitNo());
        queryOutpatientInfomationVo.setOutpatientType(admissionEntity.getOutpatientType());
        queryOutpatientInfomationVo.setMedicalOutpatientType(admissionEntity.getMedicalOutpatientType());
        queryOutpatientInfomationVo.setPhone(admissionEntity.getPhone());
        queryOutpatientInfomationVo.setGender(admissionEntity.getPatientSex());
        queryOutpatientInfomationVo.setAge(admissionEntity.getPatientAge());
        queryOutpatientInfomationVo.setAdmissionStatus(admissionEntity.getStatus());
        queryOutpatientInfomationVo.setMedicalType(admissionEntity.getMedicalType());
        queryOutpatientInfomationVo.setDoctorName(admissionEntity.getDoctorName());
        queryOutpatientInfomationVo.setRegTime(admissionEntity.getRegTime());
        queryOutpatientInfomationVo.setVisitTime(admissionEntity.getVisitTime());
        queryOutpatientInfomationVo.setPatientCardNo(admissionEntity.getPatientCardNo());
        queryOutpatientInfomationVo.setInsuplcAdmdvs(admissionEntity.getInsuplcAdmdvs());
        return queryOutpatientInfomationVo;
    }

    private OutMedicalRecord CheckOutpatientInformation(OutpatientInfomationDto queryParameter, AdmissionEntity admissionEntity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(OutMedicalRecord.getOutpatientInformation());
        queryWrapper.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
        queryWrapper.eq((Object)"tenant_id", (Object)queryParameter.getTenantId());
        queryWrapper.eq((Object)"outpatient_no", (Object)queryParameter.getOutpatientNo());
        OutMedicalRecord outMedicalRecord = (OutMedicalRecord)this.outMedicalRecordMapper.selectOne((Wrapper)queryWrapper);
        if (ObjectUtils.isEmpty((Object)outMedicalRecord)) {
            outMedicalRecord = new OutMedicalRecord();
            outMedicalRecord.setCreateId(queryParameter.getOperatorId());
            outMedicalRecord.setCreateName(queryParameter.getOperatorName());
            outMedicalRecord.setTenantId(queryParameter.getTenantId());
            outMedicalRecord.setPatientId(admissionEntity.getPatientId());
            outMedicalRecord.setPatientName(admissionEntity.getPatientName());
            outMedicalRecord.setMedicalRecordNo(admissionEntity.getMedicalRecordNo());
            outMedicalRecord.setPatientCardNo(admissionEntity.getPatientCardNo());
            outMedicalRecord.setDeptId(admissionEntity.getDeptId());
            outMedicalRecord.setDeptName(admissionEntity.getDeptName());
            outMedicalRecord.setDoctorId(admissionEntity.getDoctorId());
            outMedicalRecord.setDoctorName(admissionEntity.getDoctorName());
            outMedicalRecord.setOutpatientNo(admissionEntity.getOutpatientNo());
            outMedicalRecord.setStatus(OutpatientDataStatusEnum.NORMAL.getStringValue());
            outMedicalRecord.setPatientCardNo(admissionEntity.getPatientCardNo());
            outMedicalRecord.setMedicalRecordNo(admissionEntity.getMedicalRecordNo());
            outMedicalRecord.setType(OutMedicalRecordTypeEnum.MEDICAL_RECORD.getValue());
            this.outMedicalRecordMapper.insert((Object)outMedicalRecord);
            try {
                ArrayList<PatientEntity> list = new ArrayList<PatientEntity>();
                PatientEntity patientEntity = new PatientEntity();
                patientEntity.setId(outMedicalRecord.getPatientId());
                Integer narrator = outMedicalRecord.getNarrator();
                Integer type = outMedicalRecord.getType();
                String bloodType = outMedicalRecord.getBloodType();
                String bloodPressureType = outMedicalRecord.getBloodPressureType();
                String status = outMedicalRecord.getStatus();
                String recordType = outMedicalRecord.getRecordType();
                if (StringUtils.isNotBlank((CharSequence)recordType)) {
                    switch (recordType) {
                        case "1": {
                            outMedicalRecord.setRecordTypeName("\u7535\u8bdd");
                            break;
                        }
                        case "2": {
                            outMedicalRecord.setRecordTypeName("\u77ed\u4fe1");
                            break;
                        }
                        case "3": {
                            outMedicalRecord.setRecordTypeName("\u5fae\u4fe1");
                            break;
                        }
                        case "4": {
                            outMedicalRecord.setRecordTypeName("\u5176\u4ed6");
                        }
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)status)) {
                    switch (status) {
                        case "1": {
                            outMedicalRecord.setStatusName("\u6b63\u5e38");
                            break;
                        }
                        case "0": {
                            outMedicalRecord.setStatusName("\u4f5c\u5e9f");
                        }
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)bloodPressureType)) {
                    switch (bloodPressureType) {
                        case "1": {
                            outMedicalRecord.setBloodPressureTypeName("\u8d77\u5e8a1\u5c0f\u65f6");
                            break;
                        }
                        case "2": {
                            outMedicalRecord.setBloodPressureTypeName("\u5348\u9910\u540e");
                            break;
                        }
                        case "3": {
                            outMedicalRecord.setBloodPressureTypeName("\u665a\u9910\u540e");
                            break;
                        }
                        case "4": {
                            outMedicalRecord.setBloodPressureTypeName("\u5165\u7761\u524d");
                            break;
                        }
                        case "5": {
                            outMedicalRecord.setBloodPressureTypeName("\u5176\u5b83");
                        }
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)bloodType)) {
                    switch (bloodType) {
                        case "1": {
                            outMedicalRecord.setBloodTypeName("\u7a7a\u8179");
                            break;
                        }
                        case "2": {
                            outMedicalRecord.setBloodTypeName("\u65e9\u9910\u540e");
                            break;
                        }
                        case "3": {
                            outMedicalRecord.setBloodTypeName("\u5348\u9910\u524d");
                            break;
                        }
                        case "4": {
                            outMedicalRecord.setBloodTypeName("\u5348\u9910\u540e");
                            break;
                        }
                        case "5": {
                            outMedicalRecord.setBloodTypeName("\u665a\u9910\u524d");
                            break;
                        }
                        case "6": {
                            outMedicalRecord.setBloodTypeName("\u665a\u9910\u540e");
                            break;
                        }
                        case "7": {
                            outMedicalRecord.setBloodTypeName("\u7761\u524d");
                        }
                    }
                }
                if (narrator != null) {
                    switch (narrator) {
                        case 1: {
                            outMedicalRecord.setNarratorStr("\u672c\u4eba");
                            break;
                        }
                        case 2: {
                            outMedicalRecord.setNarratorStr("\u5176\u4ed6");
                        }
                    }
                }
                if (type != null) {
                    switch (type) {
                        case 1: {
                            outMedicalRecord.setTypeName("\u75c5\u5386");
                            break;
                        }
                        case 2: {
                            outMedicalRecord.setTypeName("\u75c5\u7a0b");
                        }
                    }
                }
                ArrayList<OutMedicalRecord> medicalRecordList = new ArrayList<OutMedicalRecord>();
                medicalRecordList.add(outMedicalRecord);
                patientEntity.setMedicalRecordList(medicalRecordList);
                list.add(patientEntity);
                String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
                String msg = JSONObject.toJSONString(list);
                this.rocketMQProducer.asyncSendCallbackTimeoutLevel("rocketMQ-out-patientTopic", "TAG3", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.updatePatientHealthRecords(outMedicalRecord);
        }
        return outMedicalRecord;
    }

    public OutMedicalRecordServiceImpl(RocketMQProducer rocketMQProducer) {
        this.rocketMQProducer = rocketMQProducer;
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

