/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.outpatient.api.model.OutVisitVideoEntity;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.data.repository.OutVisitVideoMapper;
import com.byh.outpatient.web.service.OutVisitVideoService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class OutVisitVideoServiceImpl
implements OutVisitVideoService {
    @Autowired
    private OutVisitVideoMapper outVisitVideoMapper;

    public ResponseData<PageInfo<OutVisitVideoEntity>> pageListByPatientId(OutVisitVideoEntity entity) {
        Integer current = entity.getCurrent() == null ? 1 : entity.getCurrent();
        Integer size = entity.getSize() == null ? 10 : entity.getSize();
        PageHelper.startPage((int)current, (int)size);
        List list = this.outVisitVideoMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutVisitVideoEntity::getTenantId, (Object)entity.getTenantId())).eq(OutVisitVideoEntity::getPatientId, (Object)entity.getPatientId())).orderByDesc(OutVisitVideoEntity::getCreateTime));
        PageInfo pageInfo = new PageInfo(list);
        return ResponseData.success((Object)pageInfo);
    }

    public ResponseData<PageInfo<OutVisitVideoEntity>> pageListByPatientIdAndVisitTime(OutVisitVideoEntity entity) {
        Integer current = entity.getCurrent() == null ? 1 : entity.getCurrent();
        Integer size = entity.getSize() == null ? 10 : entity.getSize();
        PageHelper.startPage((int)current, (int)size);
        List list = this.outVisitVideoMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutVisitVideoEntity::getTenantId, (Object)entity.getTenantId())).eq(OutVisitVideoEntity::getPatientId, (Object)entity.getPatientId())).eq(OutVisitVideoEntity::getVisitTime, (Object)entity.getVisitTime())).orderByDesc(OutVisitVideoEntity::getCreateTime));
        PageInfo pageInfo = new PageInfo(list);
        return ResponseData.success((Object)pageInfo);
    }

    public ResponseData add(OutVisitVideoEntity entity) {
        List videoNameList = entity.getVideoNameList();
        boolean isEmpty = videoNameList != null && videoNameList.size() > 0;
        List videoUrlList = entity.getVideoUrlList();
        List imgUrlList = entity.getImgUrlList();
        boolean imgEmpty = imgUrlList != null && imgUrlList.size() > 0;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String now = format.format(new Date());
        entity.setCreateTime(now);
        int count = 0;
        for (int i = 0; i < videoUrlList.size(); ++i) {
            if (isEmpty) {
                String name = (String)videoNameList.get(i);
                entity.setVideoName(name);
            }
            if (imgEmpty) {
                String imgUrl = (String)imgUrlList.get(i);
                entity.setImgUrl(imgUrl);
            }
            String url = (String)videoUrlList.get(i);
            entity.setVideoUrl(url);
            count += this.outVisitVideoMapper.insert((Object)entity);
        }
        if (count != videoUrlList.size()) {
            return ResponseData.error((String)"\u6dfb\u52a0\u5931\u8d25");
        }
        return ResponseData.success();
    }
}

