/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.outpatient.api.enums.ApprovalIdentifyType;
import com.byh.outpatient.api.model.datacenter.ApprovalDTO;
import com.byh.outpatient.api.model.datacenter.OutApprovalRecordEntity;
import com.byh.outpatient.api.model.datacenter.OutPatientRecordTempDTO;
import com.byh.outpatient.api.model.datacenter.OutPatientRecordTempEntity;
import com.byh.outpatient.api.util.HyposensitizationUtil;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.StringUtil;
import com.byh.outpatient.data.repository.ArchivalFileMapper;
import com.byh.outpatient.data.repository.ArchivalRecordsMapper;
import com.byh.outpatient.data.repository.OutApprovalRecordMapper;
import com.byh.outpatient.data.repository.OutPatientRecordTempMapper;
import com.byh.outpatient.web.feign.SysServiceFeign;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.rocket.RocketMQProducer;
import com.byh.outpatient.web.service.ArchivalFileService;
import com.byh.outpatient.web.service.ArchivalFileTypeService;
import com.byh.outpatient.web.service.OutPatientRecordTempService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OutPatientRecordTempServiceImpl
extends ServiceImpl<OutPatientRecordTempMapper, OutPatientRecordTempEntity>
implements OutPatientRecordTempService {
    private static final Logger log = LoggerFactory.getLogger(OutPatientRecordTempServiceImpl.class);
    private static final String topic = "rocketMQ-out-zkyy-dataCenter";
    @Autowired
    private CommonRequest commonRequest;
    @Autowired
    private OutPatientRecordTempMapper outPatientRecordTempMapper;
    @Autowired
    private OutApprovalRecordMapper outApprovalRecordMapper;
    @Autowired
    private RocketMQProducer rocketMQProducer;
    @Autowired
    private ArchivalFileTypeService archivalFileTypeService;
    @Autowired
    private ArchivalFileService archivalFileService;
    @Autowired
    private ArchivalRecordsMapper mapper;
    @Autowired
    private SysServiceFeign sysServiceFeign;
    private static final String archivalFileTopic = "rocketMQ-out-archivalFileTopic";
    @Autowired
    private ArchivalFileMapper archivalFileMapper;
    @Value(value="${center.baseUrl}")
    private String baseUrl;

    public ResponseData<PageInfo<OutPatientRecordTempEntity>> pageList(OutPatientRecordTempDTO dto) {
        PageHelper.startPage((int)dto.getCurrent(), (int)dto.getSize());
        List outPatientRecordTempEntities = this.outPatientRecordTempMapper.selectPageList(dto);
        for (OutPatientRecordTempEntity record : outPatientRecordTempEntities) {
            String patientName = HyposensitizationUtil.hyposensitizationForName((String)record.getName());
            String phone = HyposensitizationUtil.hyposensitizationForPhone((String)record.getPhone());
            String cardNo = HyposensitizationUtil.hyposensitizationForCardNo((String)record.getCardNo());
            record.setName(patientName);
            record.setPhone(phone);
            record.setCardNo(cardNo);
            String sexName = "";
            switch (record.getSex()) {
                case "1": {
                    sexName = "\u7537";
                    break;
                }
                case "2": {
                    sexName = "\u5973";
                    break;
                }
                case "3": {
                    sexName = "\u672a\u77e5";
                }
            }
            record.setSexName(sexName);
        }
        PageInfo outPatientRecordTempEntityPageInfo = new PageInfo(outPatientRecordTempEntities);
        return ResponseData.success((Object)outPatientRecordTempEntityPageInfo);
    }

    @Transactional
    public ResponseData approval(ApprovalDTO approvalDTO) {
        Long id = approvalDTO.getOutPatientRecordTempId();
        OutPatientRecordTempEntity outPatientRecordTempEntity = (OutPatientRecordTempEntity)this.outPatientRecordTempMapper.selectById((Serializable)id);
        if (Objects.isNull(outPatientRecordTempEntity)) {
            return ResponseData.error((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u8bd5!");
        }
        if (outPatientRecordTempEntity.getApprovalIdentify().equals(ApprovalIdentifyType.APPROVED.getCode())) {
            return ResponseData.error((String)"\u6570\u636e\u5df2\u5ba1\u6279!");
        }
        OutPatientRecordTempEntity outPatientRecordTemp = new OutPatientRecordTempEntity();
        OutApprovalRecordEntity outApprovalRecordEntity = new OutApprovalRecordEntity();
        outApprovalRecordEntity.setOutPatientRecordTempId(approvalDTO.getOutPatientRecordTempId());
        outApprovalRecordEntity.setApprovalName(this.commonRequest.getUserName());
        outApprovalRecordEntity.setApprovalRemake(approvalDTO.getApprovalRemake());
        outApprovalRecordEntity.setApprovalTime(new Date());
        outApprovalRecordEntity.setApprovalStatus(approvalDTO.getApprovalStatus());
        outApprovalRecordEntity.setCreateTime(new Date());
        this.outApprovalRecordMapper.insert((Object)outApprovalRecordEntity);
        outPatientRecordTemp.setId(approvalDTO.getOutPatientRecordTempId());
        outPatientRecordTemp.setApprovalIdentify(ApprovalIdentifyType.APPROVED.getCode());
        this.outPatientRecordTempMapper.updateById((Object)outPatientRecordTemp);
        String approvalStatus = approvalDTO.getApprovalStatus();
        String const2 = "";
        String const3 = "";
        switch (approvalStatus) {
            case "1": {
                const2 = "\u5ba1\u6838\u901a\u8fc7";
                break;
            }
            case "2": {
                const2 = "\u5ba1\u6838\u9a73\u56de";
                const3 = "\u5ba1\u6838\u6750\u6599\u4e0d\u5145\u8db3\uff0c\u8bf7\u6839\u636e\u63d0\u793a\u91cd\u65b0\u4e0a\u4f20";
                break;
            }
            case "3": {
                const2 = "\u5ba1\u6838\u7ec8\u6b62";
            }
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)approvalDTO.getOutPatientRecordTempId());
        jsonObject.put("approvalStatus", (Object)approvalDTO.getApprovalStatus());
        jsonObject.put("approvalRemake", (Object)approvalDTO.getApprovalRemake());
        jsonObject.put("approvalTime", (Object)approvalDTO.getApprovalTime());
        jsonObject.put("approvalName", (Object)this.commonRequest.getUserName());
        jsonObject.put("createTime", (Object)new Date());
        jsonObject.put("patientName", (Object)outPatientRecordTempEntity.getName());
        jsonObject.put("const2", (Object)const2);
        jsonObject.put("const3", (Object)const3);
        String msg = jsonObject.toJSONString();
        log.info("msg--{}", (Object)msg);
        String resStr = HttpUtil.post((String)(this.baseUrl + "/flow/FlowPatientInfo/updatePatientInfoByHisApproval"), (String)msg);
        JSONObject respJson = JSONObject.parseObject((String)resStr);
        if (!"200".equals(respJson.getString("code"))) {
            throw new RuntimeException("\u6750\u6599\u5ba1\u6279\u901a\u8fc7\u8c03\u7528\u6570\u636e\u4e2d\u53f0\u5931\u8d25,\u5165\u53c2:" + msg);
        }
        return ResponseData.success();
    }

    public ResponseData add(OutPatientRecordTempEntity entity) {
        String sex = entity.getSex();
        if (StringUtil.isBlank((String)sex)) {
            return ResponseData.error((String)"\u5fc5\u8981\u53c2\u6570\u7f3a\u5931!");
        }
        PageHelper.startPage((int)1, (int)1);
        OutPatientRecordTempEntity outPatientRecordTempEntity = (OutPatientRecordTempEntity)this.outPatientRecordTempMapper.selectOne((Wrapper)Wrappers.lambdaQuery().orderByDesc(OutPatientRecordTempEntity::getId));
        Long id = outPatientRecordTempEntity.getId();
        boolean checkAdd = id > 100000000L;
        entity.setId(Long.valueOf(checkAdd ? id + 1L : 100000001L));
        entity.setApprovalIdentify("1");
        entity.setCreateTime(new Date());
        this.outPatientRecordTempMapper.insertOutPatientRecordTemp(entity);
        return ResponseData.success();
    }
}

