/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.byh.outpatient.api.dto.hsPrescriptionUpload.FastPrescriptionDto;
import com.byh.outpatient.api.dto.hsPrescriptionUpload.HsPrescriptionUploadDto;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.StringUtil;
import com.byh.outpatient.data.repository.SysParamMapper;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.HsPrescriptionUploadService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/hsPrescriptionUpload"})
@RestController
public class HsPrescriptionUploadController {
    @Autowired
    private CommonRequest commonRequest;
    @Autowired
    private HsPrescriptionUploadService hsPrescriptionUploadService;
    @Autowired
    private SysParamMapper sysParamMapper;

    @PostMapping(value={"/push/uploadChk"})
    public ResponseData uploadChk(@RequestBody HsPrescriptionUploadDto dto) {
        Integer tenant = this.commonRequest.getTenant();
        dto.setTenantId(tenant);
        String signNo = this.commonRequest.getSignNo();
        dto.setSignNo(signNo);
        String sourceTypes = dto.getSourceTypes();
        try {
            String s = this.sysParamMapper.selectByNameReturnValue("hs_upload", Integer.valueOf(1));
            if ("3".equals(sourceTypes) && "1".equals(s)) {
                return this.hsPrescriptionUploadService.uploadChk2(dto);
            }
            return this.hsPrescriptionUploadService.uploadChk(dto);
        }
        catch (Exception e) {
            return ResponseData.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"/push/undoPush"})
    public ResponseData undoPush(@RequestBody HsPrescriptionUploadDto dto) {
        String hiRxno = dto.getHiRxno();
        if (StringUtil.isBlank((String)hiRxno)) {
            return ResponseData.error((String)"\u533b\u4fdd\u5904\u65b9\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Integer tenant = this.commonRequest.getTenant();
        dto.setTenantId(tenant);
        return this.hsPrescriptionUploadService.rxUndo(dto);
    }

    @PostMapping(value={"/fastPrescription"})
    public ResponseData fastPrescription(@RequestBody FastPrescriptionDto dto) {
        String outpatientNo = "";
        try {
            outpatientNo = this.hsPrescriptionUploadService.fastPrescription(dto);
            if (StringUtil.isBlank((String)outpatientNo)) {
                return ResponseData.error((String)"\u4fdd\u5b58\u5904\u65b9\u5931\u8d25\uff01");
            }
            return ResponseData.success((Object)outpatientNo);
        }
        catch (Exception e) {
            return ResponseData.error((String)"\u4fdd\u5b58\u5904\u65b9\u5931\u8d25\uff01");
        }
    }
}

