/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.rabbitListener;

import com.byh.outpatient.api.dto.pay.CancelPaymentDto;
import com.byh.outpatient.data.repository.OutOrderPaymentMapper;
import com.byh.outpatient.web.service.OutPayService;
import com.rabbitmq.client.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrderPaymentOrderTimeoutListener {
    private static final Logger log = LoggerFactory.getLogger(OrderPaymentOrderTimeoutListener.class);
    @Autowired
    private OutPayService outPayService;
    @Autowired
    private OutOrderPaymentMapper outOrderPaymentMapper;

    @RabbitHandler
    @RabbitListener(queues={"outpatient.payment.order.timeout.queue"})
    public void orderTimeoutAndUnpaid(Channel channel, Message message) throws Exception {
        String payOrderNo = new String(message.getBody());
        String messageId = message.getMessageProperties().getMessageId();
        log.info("\u3010\u652f\u4ed8\u8ba2\u5355\u8d85\u65f6MQ\u3011 \u652f\u4ed8\u5355\u53f7\uff1a\u3010{}\u3011\u3002messageId \u3010{}\u3011", (Object)payOrderNo, (Object)messageId);
        try {
            CancelPaymentDto parameter = new CancelPaymentDto();
            parameter.setPayOrderNo(payOrderNo);
            parameter.setIsTimeout(Boolean.valueOf(true));
            this.outPayService.cancelPayment(parameter);
            log.info("\u3010\u652f\u4ed8\u8ba2\u5355\u8d85\u65f6MQ\u3011 \u652f\u4ed8\u5355\u53f7\uff1a\u3010{}\u3011\u3002messageId \u3010{}\u3011\u3002\u53d6\u6d88\u8ba2\u5355:\u652f\u4ed8\u8ba2\u5355\u8d85\u65f6\uff01", (Object)payOrderNo, (Object)messageId);
        }
        catch (Exception e) {
            log.error("\u6d88\u606f\u5904\u7406\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
    }
}

