/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.outpatient.api.dto.admission.QuickTreatementDto;
import com.byh.outpatient.api.dto.hsPrescriptionUpload.FastDiag;
import com.byh.outpatient.api.dto.hsPrescriptionUpload.FastDrug;
import com.byh.outpatient.api.dto.hsPrescriptionUpload.FastPrescriptionDto;
import com.byh.outpatient.api.dto.hsPrescriptionUpload.HsPrescriptionUploadDto;
import com.byh.outpatient.api.dto.order.HsPreparePayDto;
import com.byh.outpatient.api.dto.patient.HsPatientInfoDto;
import com.byh.outpatient.api.enums.DeptEnum;
import com.byh.outpatient.api.enums.InsurancePrescriptionTypeEnum;
import com.byh.outpatient.api.enums.OrderSettleTypeEnum;
import com.byh.outpatient.api.enums.OrderTypeEnum;
import com.byh.outpatient.api.enums.OutpatientDataStatusEnum;
import com.byh.outpatient.api.enums.PrescriptionStatusEnum;
import com.byh.outpatient.api.enums.PrescriptionTypeEnum;
import com.byh.outpatient.api.hsModel.request.DiseinfoRequest;
import com.byh.outpatient.api.hsModel.request.MdtrtinfoRequest;
import com.byh.outpatient.api.hsModel.request.RegPayInfoRequest;
import com.byh.outpatient.api.hsModel.request.RegistrationRequest;
import com.byh.outpatient.api.hsModel.request.UploadInfoDetailRequest;
import com.byh.outpatient.api.hsModel.respones.Datavo;
import com.byh.outpatient.api.hsModel.respones.Insuinfo;
import com.byh.outpatient.api.model.OutIcdItem;
import com.byh.outpatient.api.model.admission.AdmissionEntity;
import com.byh.outpatient.api.model.hsPrescriptionUpload.DiseInfoEntity;
import com.byh.outpatient.api.model.hsPrescriptionUpload.HiRxnoEntity;
import com.byh.outpatient.api.model.hsPrescriptionUpload.HsPrescriptionUploadEntity;
import com.byh.outpatient.api.model.hsPrescriptionUpload.MdtrtInfoEntity;
import com.byh.outpatient.api.model.medicalRecord.OutMedicalRecordDiagnosis;
import com.byh.outpatient.api.model.order.OutOrder;
import com.byh.outpatient.api.model.prescription.OutPrescription;
import com.byh.outpatient.api.model.prescription.OutPrescriptionDrug;
import com.byh.outpatient.api.sysModel.request.SysDictValueDTO;
import com.byh.outpatient.api.sysModel.request.SysDoctorDto;
import com.byh.outpatient.api.sysModel.request.SysDrugEntity;
import com.byh.outpatient.api.sysModel.respones.SysDictValueVo;
import com.byh.outpatient.api.sysModel.respones.SysDoctorIdVo;
import com.byh.outpatient.api.util.DateUtils;
import com.byh.outpatient.api.util.ExceptionUtils;
import com.byh.outpatient.api.util.HttpUtils;
import com.byh.outpatient.api.util.RandomCodeUtils;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.StringUtil;
import com.byh.outpatient.api.util.UUIDUtils;
import com.byh.outpatient.api.vo.admission.AdmissionPatientVo;
import com.byh.outpatient.api.vo.patient.HsPatientInfoVo;
import com.byh.outpatient.data.repository.OutIcdItemMapper;
import com.byh.outpatient.data.repository.OutOrderMapper;
import com.byh.outpatient.data.repository.OutPrescriptionDrugMapper;
import com.byh.outpatient.data.repository.OutPrescriptionMapper;
import com.byh.outpatient.web.feign.HsServiceFeign;
import com.byh.outpatient.web.feign.SysServiceFeign;
import com.byh.outpatient.web.service.AdmissionService;
import com.byh.outpatient.web.service.HsPrescriptionUploadService;
import com.byh.outpatient.web.service.OutMedicalRecordDiagnosisService;
import com.byh.outpatient.web.service.PatientService;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HsPrescriptionUploadServiceImpl
implements HsPrescriptionUploadService {
    private static final Logger log = LoggerFactory.getLogger(HsPrescriptionUploadServiceImpl.class);
    @Autowired
    @Lazy
    private AdmissionService admissionService;
    @Autowired
    private OutPrescriptionMapper prescriptionMapper;
    @Autowired
    private OutOrderMapper outOrderMapper;
    @Autowired
    private OutPrescriptionDrugMapper outPrescriptionDrugMapper;
    @Autowired
    private OutIcdItemMapper outIcdItemMapper;
    @Autowired
    private PatientService patientService;
    @Autowired
    private OutMedicalRecordDiagnosisService outMedicalRecordDiagnosisService;
    @Autowired
    private HsServiceFeign hsServiceFeign;
    @Autowired
    private SysServiceFeign sysServiceFeign;
    private final String keys = "nc095fe67ee7358f8fd8e8zk";
    @Value(value="${center.url}")
    private String url;
    private final String url2 = "http://171.34.133.170:8086";
    private final String uploadChk = "/receiverPr/prData";
    private final String rxUndo = "/push/rxUndo";

    public ResponseData uploadChk(HsPrescriptionUploadDto dto) {
        String sourceTypes;
        if (StringUtil.isNotBlank((String)dto.getOutpatientNo())) {
            List outPrescriptionList = this.prescriptionMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutPrescription::getOutpatientNo, (Object)dto.getOutpatientNo())).eq(OutPrescription::getPrescriptionStatus, (Object)1)).orderByDesc(OutPrescription::getCreateTime));
            dto.setPrescriptionNo(((OutPrescription)outPrescriptionList.get(0)).getPrescriptionNo());
        }
        if (StringUtils.isNotBlank((CharSequence)(sourceTypes = dto.getSourceTypes())) && "2".equals(sourceTypes)) {
            String storeCode = dto.getStoreCode();
            String storeName = dto.getStoreName();
            String druggistcode = dto.getDruggistCode();
            String druggistName = dto.getDruggistName();
            if (StringUtils.isBlank((CharSequence)storeName) || StringUtils.isBlank((CharSequence)storeCode)) {
                return ResponseData.error((String)"\u95e8\u5e97\u7f16\u7801/\u95e8\u5e97\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)druggistcode) || StringUtils.isBlank((CharSequence)druggistName)) {
                return ResponseData.error((String)"\u836f\u5546\u7f16\u7801/\u836f\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
        HsPrescriptionUploadEntity data = this.prescriptionMapper.queryUploadParam(dto);
        List mdtrtInfoEntities = this.prescriptionMapper.queryMdtrtInfoEntity(dto);
        MdtrtInfoEntity mdtrtInfoEntity = (MdtrtInfoEntity)mdtrtInfoEntities.get(0);
        dto.setDiagName(data.getDiagName());
        dto.setDiagCode(data.getDiagCode());
        HsPatientInfoDto hsPatientInfoDto = new HsPatientInfoDto();
        hsPatientInfoDto.setMdtrtCertNo(data.getMdtrtCertNo());
        hsPatientInfoDto.setMdtrtCertType("02");
        hsPatientInfoDto.setMedType(dto.getMedType());
        hsPatientInfoDto.setOutpatientNo(data.getOutpatientNo());
        hsPatientInfoDto.setTenantId(dto.getTenantId());
        ResponseData hsPatientInfoVoResponseData = this.patientService.queryPatientInfoByEcCode(hsPatientInfoDto);
        String code = hsPatientInfoVoResponseData.getCode();
        ExceptionUtils.createException((Logger)log, (boolean)"400".equals(code), (String)hsPatientInfoVoResponseData.getMsg());
        HsPatientInfoVo hsPatientInfoVo = (HsPatientInfoVo)hsPatientInfoVoResponseData.getData();
        List insuinfoList = hsPatientInfoVo.getInsuinfo();
        Insuinfo insuinfo = new Insuinfo();
        for (Insuinfo item : insuinfoList) {
            String psnInsuStas = item.getPsn_insu_stas();
            if (!psnInsuStas.equals("1")) continue;
            String balc = item.getBalc();
            if (insuinfo.getBalc() == null) {
                insuinfo = item;
                continue;
            }
            String balc1 = insuinfo.getBalc();
            if (new BigDecimal(balc).subtract(new BigDecimal(balc1)).intValue() <= 0) continue;
            insuinfo = item;
        }
        if (insuinfo.getPsn_insu_stas() == null) {
            return ResponseData.error((String)"\u60a3\u8005\u4e0d\u5728\u6b63\u5e38\u53c2\u4fdd\u72b6\u6001\uff01");
        }
        String[] diagCodeArr = data.getDiagCode().split(",");
        String[] diagNameArr = data.getDiagName().split(",");
        SysDoctorDto sysDoctorDto = new SysDoctorDto();
        sysDoctorDto.setId(data.getDocId());
        ResponseData newSysDoctorIdVoResponseData = this.sysServiceFeign.newDoctorById(sysDoctorDto);
        if (Objects.isNull(newSysDoctorIdVoResponseData) || !newSysDoctorIdVoResponseData.isSuccess()) {
            return ResponseData.error((String)"\u67e5\u8be2\u533b\u751f\u4fe1\u606f\u5931\u8d25");
        }
        ResponseData sysDoctorIdVoResponseData = this.sysServiceFeign.doctorById(sysDoctorDto);
        if (Objects.isNull(sysDoctorIdVoResponseData) || !sysDoctorIdVoResponseData.isSuccess()) {
            return ResponseData.error((String)("\u67e5\u8be2\u533b\u751f\u4fe1\u606f\u5931\u8d25" + JSONObject.toJSONString((Object)sysDoctorIdVoResponseData)));
        }
        SysDoctorIdVo sysDoctorIdVo = (SysDoctorIdVo)sysDoctorIdVoResponseData.getData();
        if (Objects.isNull(sysDoctorIdVo.getHsCode()) || "".equals(sysDoctorIdVo.getHsCode())) {
            return ResponseData.error((String)"\u67e5\u8be2\u533b\u751f\u8d2f\u6807\u7801\u5931\u8d25\uff0c\u8bf7\u5b8c\u5584\u533b\u751f\u4fe1\u606f\uff01");
        }
        ArrayList<UploadInfoDetailRequest> uploadInfoDetailRequestList = new ArrayList<UploadInfoDetailRequest>();
        OutOrder outOrder1 = (OutOrder)this.outOrderMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutOrder::getTenantId, (Object)dto.getTenantId())).eq(OutOrder::getPrescriptionNo, (Object)dto.getPrescriptionNo()));
        Integer settleTypeCode = 0;
        ArrayList<String> orderNos = new ArrayList<String>();
        orderNos.add(outOrder1.getOrderNo());
        for (String orderNo : orderNos) {
            QueryWrapper query = new QueryWrapper();
            query.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
            query.eq((Object)"order_no", (Object)orderNo);
            OutOrder outOrder = (OutOrder)this.outOrderMapper.selectOne((Wrapper)query);
            if (!OrderTypeEnum.PRESCRIPTION_WESTERN_MEDICINE_ORDERS.getValue().equals(outOrder.getOrderType()) && !OrderTypeEnum.REGISTERED_TRADITIONAL_ORDERS.getValue().equals(outOrder.getOrderType()) && !OrderTypeEnum.REGISTERED_CHINESE_PATENT_DRUG_ORDERS.getValue().equals(outOrder.getOrderType())) continue;
            QueryWrapper queryDrugWrapper = new QueryWrapper();
            queryDrugWrapper.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
            queryDrugWrapper.eq((Object)"prescription_no", (Object)outOrder.getPrescriptionNo());
            List outPrescriptionDrugs = this.outPrescriptionDrugMapper.selectList((Wrapper)queryDrugWrapper);
            settleTypeCode = outOrder.getSettleTypeCode();
            for (int i = 0; i < outPrescriptionDrugs.size(); ++i) {
                OutPrescriptionDrug drug = (OutPrescriptionDrug)outPrescriptionDrugs.get(i);
                UploadInfoDetailRequest uploadInfoDetailRequest = new UploadInfoDetailRequest();
                uploadInfoDetailRequest.setChrg_bchno(outOrder1.getPayOrderNo());
                String feedetl_sn = outOrder1.getPayOrderNo() + "_" + RandomCodeUtils.sixRandom();
                uploadInfoDetailRequest.setFeedetl_sn(feedetl_sn);
                uploadInfoDetailRequest.setPsn_no(hsPatientInfoVo.getPsnNo());
                uploadInfoDetailRequest.setDise_codg(diagCodeArr[0]);
                uploadInfoDetailRequest.setRxno(drug.getPrescriptionNo());
                uploadInfoDetailRequest.setRx_circ_flag("0");
                uploadInfoDetailRequest.setFee_ocur_time(DateUtils.getCurrentDate((String)"yyyy-MM-dd HH:mm:ss"));
                uploadInfoDetailRequest.setMed_list_codg(drug.getMedicalInsuranceCode());
                uploadInfoDetailRequest.setMedins_list_codg(Objects.isNull(drug.getInternalCode()) ? drug.getDrugNo() : drug.getInternalCode());
                uploadInfoDetailRequest.setDet_item_fee_sumamt(drug.getTotalDrugAmount().toString());
                uploadInfoDetailRequest.setCnt(String.valueOf(drug.getQuantity()));
                uploadInfoDetailRequest.setPric(String.valueOf(drug.getDrugPriceAmount()));
                SysDrugEntity sysDrugEntity = new SysDrugEntity();
                sysDrugEntity.setId(drug.getDrugNo());
                ResponseData newSysDrugEntityResponseData = this.sysServiceFeign.newDrugIdDetailsByDual(sysDrugEntity, dto.getTenantId());
                if (Objects.isNull(newSysDrugEntityResponseData) || newSysDrugEntityResponseData.isError()) {
                    return ResponseData.error((String)("\u5f53\u524d\uff1a" + drug.getDrugName() + " \u836f\u54c1\u672a\u542f\u7528"));
                }
                if (!Objects.isNull(newSysDrugEntityResponseData) && newSysDrugEntityResponseData.isSuccess()) {
                    SysDrugEntity result = (SysDrugEntity)newSysDrugEntityResponseData.getData();
                    BigDecimal packSpecification = new BigDecimal(result.getPackSpecification());
                    uploadInfoDetailRequest.setCnt(String.valueOf(packSpecification.multiply(drug.getQuantity())));
                    uploadInfoDetailRequest.setMed_list_codg(result.getMedicalInsuranceCode());
                    uploadInfoDetailRequest.setPric(String.valueOf(drug.getDrugPriceAmount().divide(packSpecification, 6)));
                }
                uploadInfoDetailRequest.setPrd_days(String.valueOf(drug.getMedicationDays()));
                uploadInfoDetailRequest.setBilg_dept_name(sysDoctorIdVo.getDepartmentName());
                uploadInfoDetailRequest.setBilg_dept_codg(sysDoctorIdVo.getDepartmentId());
                uploadInfoDetailRequest.setBilg_dr_name(sysDoctorIdVo.getHsCode());
                uploadInfoDetailRequest.setBilg_dr_name(sysDoctorIdVo.getUserName());
                uploadInfoDetailRequest.setBilg_dept_codg(sysDoctorIdVo.getDepartmentId());
                uploadInfoDetailRequest.setBilg_dept_name(sysDoctorIdVo.getDepartmentName());
                uploadInfoDetailRequest.setBilg_dr_codg(sysDoctorIdVo.getHsCode());
                String insuranceAuditFlag = OrderSettleTypeEnum.HS_SELF.getCode().equals(outOrder.getSettleTypeCode()) ? "2" : drug.getMedicalInsuranceAuditFlag();
                uploadInfoDetailRequest.setHosp_appr_flag(insuranceAuditFlag);
                uploadInfoDetailRequestList.add(uploadInfoDetailRequest);
            }
        }
        HsPreparePayDto hsPreparePayDto = new HsPreparePayDto();
        hsPreparePayDto.setAcctUsedFlag("1");
        hsPreparePayDto.setCardNo(data.getMdtrtCertNo());
        hsPreparePayDto.setCardSn("");
        hsPreparePayDto.setInsuplcAdmdvs(hsPatientInfoVo.getInsuplcAdmdvs());
        hsPreparePayDto.setInsutype(insuinfo.getInsutype());
        hsPreparePayDto.setMdtrtCertNo(data.getMdtrtCertNo());
        hsPreparePayDto.setMdtrtCertType("02");
        hsPreparePayDto.setMedType(dto.getMedType());
        hsPreparePayDto.setOrderNoList(orderNos);
        hsPreparePayDto.setPatientName(hsPatientInfoVo.getPsnName());
        hsPreparePayDto.setPayOrderName("\u5357\u660c\u4f17\u5eb7\u533b\u9662\u6709\u9650\u516c\u53f8");
        hsPreparePayDto.setPsnCertType("01");
        hsPreparePayDto.setPsnNo(data.getMdtrtCertNo());
        hsPreparePayDto.setPsnSetlway("01");
        hsPreparePayDto.setPsnType("11");
        hsPreparePayDto.setSettlementMethod(Integer.valueOf(3));
        hsPreparePayDto.setOutpatientNo(data.getOutpatientNo());
        RegistrationRequest registrationRequest = new RegistrationRequest();
        registrationRequest.setCard_sn("");
        registrationRequest.setCertno(hsPreparePayDto.getCardNo());
        registrationRequest.setPsn_cert_type(hsPreparePayDto.getPsnCertType());
        registrationRequest.setMdtrt_cert_no(hsPreparePayDto.getMdtrtCertNo());
        registrationRequest.setMdtrt_cert_type(hsPreparePayDto.getMdtrtCertType());
        registrationRequest.setIpt_otp_no(hsPreparePayDto.getOutpatientNo());
        registrationRequest.setPsn_no(hsPatientInfoVo.getPsnNo());
        registrationRequest.setBegntime(DateUtils.dateFormat((Date)data.getVisitTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        registrationRequest.setDept_name(mdtrtInfoEntity.getDrDeptName());
        registrationRequest.setDept_code(mdtrtInfoEntity.getDrDeptCode());
        registrationRequest.setAtddr_no(mdtrtInfoEntity.getDrCode());
        registrationRequest.setDr_name(mdtrtInfoEntity.getPrscDrName());
        registrationRequest.setCaty(mdtrtInfoEntity.getCaty());
        registrationRequest.setPsn_name(mdtrtInfoEntity.getPatnName());
        registrationRequest.setPsn_type(insuinfo.getPsn_type());
        MdtrtinfoRequest mdtrtinfo = new MdtrtinfoRequest();
        mdtrtinfo.setDise_codg(hsPreparePayDto.getDiseCodg());
        mdtrtinfo.setDise_name(hsPreparePayDto.getDiseName());
        mdtrtinfo.setPsn_no(hsPreparePayDto.getPsnNo());
        String medType = hsPreparePayDto.getMedType();
        mdtrtinfo.setMed_type(medType);
        AdmissionEntity admission = this.admissionService.queryAdmissionByOutpatientNo(data.getOutpatientNo(), hsPreparePayDto.getTenantId());
        ArrayList<DiseinfoRequest> diseinfo = new ArrayList<DiseinfoRequest>();
        List outMedicalRecordDiagnoses = this.outMedicalRecordDiagnosisService.queryMedicalRecordDiagnosisByOutpatientNo(dto.getTenantId(), data.getOutpatientNo());
        for (int i = 0; i < outMedicalRecordDiagnoses.size(); ++i) {
            OutMedicalRecordDiagnosis outMedicalRecordDiagnosis = (OutMedicalRecordDiagnosis)outMedicalRecordDiagnoses.get(i);
            DiseinfoRequest diseinfoRequest = new DiseinfoRequest();
            diseinfoRequest.setDiag_srt_no(i + 2 + "");
            diseinfoRequest.setDiag_type("2".equals(outMedicalRecordDiagnosis.getDiagnosticType()) ? "3" : "1");
            if (Objects.isNull(outMedicalRecordDiagnosis.getHsIcdCode())) {
                QueryWrapper query = new QueryWrapper();
                query.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
                query.eq((Object)"icd_code", (Object)outMedicalRecordDiagnosis.getIcdCode());
                OutIcdItem outIcdItem = (OutIcdItem)this.outIcdItemMapper.selectOne((Wrapper)query);
                diseinfoRequest.setDiag_code(outIcdItem.getMedicalCode());
                diseinfoRequest.setDiag_name(outIcdItem.getMedicalName());
            } else {
                diseinfoRequest.setDiag_code(outMedicalRecordDiagnosis.getHsIcdCode());
                diseinfoRequest.setDiag_name(outMedicalRecordDiagnosis.getHsDiagnosis());
            }
            diseinfoRequest.setDiag_dept(sysDoctorIdVo.getDepartmentName());
            diseinfoRequest.setDise_dor_name(sysDoctorIdVo.getUserName());
            diseinfoRequest.setDiag_time(DateUtils.dateFormat((Date)admission.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            diseinfoRequest.setVali_flag("1");
            diseinfoRequest.setDise_dor_no(sysDoctorIdVo.getHsCode());
            diseinfo.add(diseinfoRequest);
        }
        RegPayInfoRequest regPayInfoRequest = new RegPayInfoRequest();
        regPayInfoRequest.setInsutype(insuinfo.getInsutype());
        regPayInfoRequest.setCard_sn("");
        regPayInfoRequest.setPsn_setlway("01");
        regPayInfoRequest.setAcct_used_flag("1");
        regPayInfoRequest.setInsuplc_admdvs(insuinfo.getInsuplc_admdvs());
        regPayInfoRequest.setRegistrationRequest(registrationRequest);
        regPayInfoRequest.setMdtrtinfo(mdtrtinfo);
        regPayInfoRequest.setUploadInfoDetailRequest(uploadInfoDetailRequestList);
        regPayInfoRequest.setDiseinfo(diseinfo);
        regPayInfoRequest.setTenantId(dto.getTenantId());
        regPayInfoRequest.setSign_no(dto.getSignNo());
        Datavo datavo = (Datavo)this.hsServiceFeign.hsAdmUpload(regPayInfoRequest).getData();
        dto.setPsnNo(datavo.getPsn_no());
        dto.setPsnCertType(registrationRequest.getPsn_cert_type());
        dto.setInsuplcAdmdvs(insuinfo.getInsuplc_admdvs());
        dto.setMdtrtId(datavo.getMdtrt_id());
        dto.setCertno(registrationRequest.getCertno());
        dto.setMdtrtCertNo(registrationRequest.getMdtrt_cert_no());
        dto.setMdtrtCertType(registrationRequest.getMdtrt_cert_type());
        dto.setBegntime(registrationRequest.getBegntime());
        Integer hireesetlType = -1;
        String hireesetlName = "";
        if (settleTypeCode == null || settleTypeCode == 4) {
            hireesetlType = 0;
            hireesetlName = "\u975e\u533b\u7597\u4fdd\u9669\u7ed3\u7b97";
        } else {
            String insuplcAdmdvs = insuinfo.getInsuplc_admdvs();
            String[] admdvsArr = new String[]{"360100", "360102", "360103", "360104", "360105", "360111", "360112", "360113", "360121", "360123", "360124", "360140", "360141", "360151", "360199"};
            List<String> admdvsList = Arrays.asList(admdvsArr);
            if (admdvsList.contains(insuplcAdmdvs)) {
                hireesetlType = 1;
                hireesetlName = "\u672c\u5730\u533b\u7597\u4fdd\u9669\u7ed3\u7b97";
            } else {
                hireesetlType = 2;
                hireesetlName = "\u5f02\u5730\u533b\u7597\u4fdd\u9669\u7ed3\u7b97";
            }
        }
        dto.setHiFeesetlType(hireesetlType + "");
        dto.setHiFeesetlName(hireesetlName);
        return this.push(dto);
    }

    public ResponseData uploadChk2(HsPrescriptionUploadDto dto) {
        int i;
        if (StringUtil.isNotBlank((String)dto.getOutpatientNo())) {
            List outPrescriptionList = this.prescriptionMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutPrescription::getOutpatientNo, (Object)dto.getOutpatientNo())).eq(OutPrescription::getPrescriptionStatus, (Object)1)).orderByDesc(OutPrescription::getCreateTime));
            dto.setPrescriptionNo(((OutPrescription)outPrescriptionList.get(0)).getPrescriptionNo());
        }
        HsPrescriptionUploadEntity data = this.prescriptionMapper.queryUploadParam(dto);
        List mdtrtInfoEntities = this.prescriptionMapper.queryMdtrtInfoEntity(dto);
        MdtrtInfoEntity mdtrtInfoEntity = (MdtrtInfoEntity)mdtrtInfoEntities.get(0);
        dto.setDiagName(data.getDiagName());
        dto.setDiagCode(data.getDiagCode());
        Insuinfo insuinfo = new Insuinfo();
        String[] diagCodeArr = data.getDiagCode().split(",");
        String[] diagNameArr = data.getDiagName().split(",");
        SysDoctorDto sysDoctorDto = new SysDoctorDto();
        sysDoctorDto.setId(data.getDocId());
        ResponseData newSysDoctorIdVoResponseData = this.sysServiceFeign.newDoctorById(sysDoctorDto);
        if (Objects.isNull(newSysDoctorIdVoResponseData) || !newSysDoctorIdVoResponseData.isSuccess()) {
            return ResponseData.error((String)"\u67e5\u8be2\u533b\u751f\u4fe1\u606f\u5931\u8d25");
        }
        ResponseData sysDoctorIdVoResponseData = this.sysServiceFeign.doctorById(sysDoctorDto);
        if (Objects.isNull(sysDoctorIdVoResponseData) || !sysDoctorIdVoResponseData.isSuccess()) {
            return ResponseData.error((String)("\u67e5\u8be2\u533b\u751f\u4fe1\u606f\u5931\u8d25" + JSONObject.toJSONString((Object)sysDoctorIdVoResponseData)));
        }
        SysDoctorIdVo sysDoctorIdVo = (SysDoctorIdVo)sysDoctorIdVoResponseData.getData();
        if (Objects.isNull(sysDoctorIdVo.getHsCode()) || "".equals(sysDoctorIdVo.getHsCode())) {
            return ResponseData.error((String)"\u67e5\u8be2\u533b\u751f\u8d2f\u6807\u7801\u5931\u8d25\uff0c\u8bf7\u5b8c\u5584\u533b\u751f\u4fe1\u606f\uff01");
        }
        ArrayList<UploadInfoDetailRequest> uploadInfoDetailRequestList = new ArrayList<UploadInfoDetailRequest>();
        OutOrder outOrder1 = (OutOrder)this.outOrderMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutOrder::getTenantId, (Object)dto.getTenantId())).eq(OutOrder::getPrescriptionNo, (Object)dto.getPrescriptionNo()));
        Integer settleTypeCode = 0;
        ArrayList<String> orderNos = new ArrayList<String>();
        orderNos.add(outOrder1.getOrderNo());
        for (String orderNo : orderNos) {
            QueryWrapper query = new QueryWrapper();
            query.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
            query.eq((Object)"order_no", (Object)orderNo);
            OutOrder outOrder = (OutOrder)this.outOrderMapper.selectOne((Wrapper)query);
            if (!OrderTypeEnum.PRESCRIPTION_WESTERN_MEDICINE_ORDERS.getValue().equals(outOrder.getOrderType()) && !OrderTypeEnum.REGISTERED_TRADITIONAL_ORDERS.getValue().equals(outOrder.getOrderType()) && !OrderTypeEnum.REGISTERED_CHINESE_PATENT_DRUG_ORDERS.getValue().equals(outOrder.getOrderType())) continue;
            QueryWrapper queryDrugWrapper = new QueryWrapper();
            queryDrugWrapper.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
            queryDrugWrapper.eq((Object)"prescription_no", (Object)outOrder.getPrescriptionNo());
            List outPrescriptionDrugs = this.outPrescriptionDrugMapper.selectList((Wrapper)queryDrugWrapper);
            settleTypeCode = outOrder.getSettleTypeCode();
            for (i = 0; i < outPrescriptionDrugs.size(); ++i) {
                OutPrescriptionDrug drug = (OutPrescriptionDrug)outPrescriptionDrugs.get(i);
                UploadInfoDetailRequest uploadInfoDetailRequest = new UploadInfoDetailRequest();
                uploadInfoDetailRequest.setChrg_bchno(outOrder1.getPayOrderNo());
                String feedetl_sn = outOrder1.getPayOrderNo() + "_" + RandomCodeUtils.sixRandom();
                uploadInfoDetailRequest.setFeedetl_sn(feedetl_sn);
                uploadInfoDetailRequest.setDise_codg(diagCodeArr[0]);
                uploadInfoDetailRequest.setRxno(drug.getPrescriptionNo());
                uploadInfoDetailRequest.setRx_circ_flag("0");
                uploadInfoDetailRequest.setFee_ocur_time(DateUtils.getCurrentDate((String)"yyyy-MM-dd HH:mm:ss"));
                uploadInfoDetailRequest.setMed_list_codg(drug.getMedicalInsuranceCode());
                uploadInfoDetailRequest.setMedins_list_codg(Objects.isNull(drug.getInternalCode()) ? drug.getDrugNo() : drug.getInternalCode());
                uploadInfoDetailRequest.setDet_item_fee_sumamt(drug.getTotalDrugAmount().toString());
                uploadInfoDetailRequest.setCnt(String.valueOf(drug.getQuantity()));
                uploadInfoDetailRequest.setPric(String.valueOf(drug.getDrugPriceAmount()));
                SysDrugEntity sysDrugEntity = new SysDrugEntity();
                sysDrugEntity.setId(drug.getDrugNo());
                ResponseData newSysDrugEntityResponseData = this.sysServiceFeign.newDrugIdDetails(sysDrugEntity, dto.getTenantId());
                if (Objects.isNull(newSysDrugEntityResponseData) || newSysDrugEntityResponseData.isError()) {
                    return ResponseData.error((String)("\u5f53\u524d\uff1a" + drug.getDrugName() + " \u836f\u54c1\u672a\u542f\u7528"));
                }
                ResponseData sysDrugEntityResponseData = this.sysServiceFeign.drugIdDetails(sysDrugEntity, dto.getTenantId());
                if (!Objects.isNull(sysDrugEntityResponseData) && sysDrugEntityResponseData.isSuccess()) {
                    SysDrugEntity result = (SysDrugEntity)sysDrugEntityResponseData.getData();
                    BigDecimal packSpecification = new BigDecimal(result.getPackSpecification());
                    uploadInfoDetailRequest.setCnt(String.valueOf(packSpecification.multiply(drug.getQuantity())));
                    uploadInfoDetailRequest.setMed_list_codg(result.getMedicalInsuranceCode());
                    uploadInfoDetailRequest.setPric(String.valueOf(drug.getDrugPriceAmount().divide(packSpecification, 6)));
                }
                uploadInfoDetailRequest.setPrd_days(String.valueOf(drug.getMedicationDays()));
                uploadInfoDetailRequest.setBilg_dept_name(sysDoctorIdVo.getDepartmentName());
                uploadInfoDetailRequest.setBilg_dept_codg(sysDoctorIdVo.getDepartmentId());
                uploadInfoDetailRequest.setBilg_dr_name(sysDoctorIdVo.getHsCode());
                uploadInfoDetailRequest.setBilg_dr_name(sysDoctorIdVo.getUserName());
                uploadInfoDetailRequest.setBilg_dept_codg(sysDoctorIdVo.getDepartmentId());
                uploadInfoDetailRequest.setBilg_dept_name(sysDoctorIdVo.getDepartmentName());
                uploadInfoDetailRequest.setBilg_dr_codg(sysDoctorIdVo.getHsCode());
                String insuranceAuditFlag = OrderSettleTypeEnum.HS_SELF.getCode().equals(outOrder.getSettleTypeCode()) ? "2" : drug.getMedicalInsuranceAuditFlag();
                uploadInfoDetailRequest.setHosp_appr_flag(insuranceAuditFlag);
                uploadInfoDetailRequestList.add(uploadInfoDetailRequest);
            }
        }
        HsPreparePayDto hsPreparePayDto = new HsPreparePayDto();
        hsPreparePayDto.setAcctUsedFlag("1");
        hsPreparePayDto.setCardNo(data.getMdtrtCertNo());
        hsPreparePayDto.setCardSn("");
        hsPreparePayDto.setInsutype(insuinfo.getInsutype());
        hsPreparePayDto.setMdtrtCertNo(data.getMdtrtCertNo());
        hsPreparePayDto.setMdtrtCertType("02");
        hsPreparePayDto.setMedType(dto.getMedType());
        hsPreparePayDto.setOrderNoList(orderNos);
        hsPreparePayDto.setPayOrderName("\u5357\u660c\u4f17\u5eb7\u533b\u9662\u6709\u9650\u516c\u53f8");
        hsPreparePayDto.setPsnCertType("01");
        hsPreparePayDto.setPsnNo(data.getMdtrtCertNo());
        hsPreparePayDto.setPsnSetlway("01");
        hsPreparePayDto.setPsnType("11");
        hsPreparePayDto.setSettlementMethod(Integer.valueOf(3));
        hsPreparePayDto.setOutpatientNo(data.getOutpatientNo());
        RegistrationRequest registrationRequest = new RegistrationRequest();
        registrationRequest.setCard_sn("");
        registrationRequest.setCertno(hsPreparePayDto.getCardNo());
        registrationRequest.setPsn_cert_type(hsPreparePayDto.getPsnCertType());
        registrationRequest.setMdtrt_cert_no(hsPreparePayDto.getMdtrtCertNo());
        registrationRequest.setMdtrt_cert_type(hsPreparePayDto.getMdtrtCertType());
        registrationRequest.setIpt_otp_no(hsPreparePayDto.getOutpatientNo());
        registrationRequest.setBegntime(DateUtils.dateFormat((Date)data.getVisitTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        registrationRequest.setDept_name(mdtrtInfoEntity.getDrDeptName());
        registrationRequest.setDept_code(mdtrtInfoEntity.getDrDeptCode());
        registrationRequest.setAtddr_no(mdtrtInfoEntity.getDrCode());
        registrationRequest.setDr_name(mdtrtInfoEntity.getPrscDrName());
        registrationRequest.setCaty(mdtrtInfoEntity.getCaty());
        registrationRequest.setPsn_name(mdtrtInfoEntity.getPatnName());
        registrationRequest.setPsn_type(insuinfo.getPsn_type());
        MdtrtinfoRequest mdtrtinfo = new MdtrtinfoRequest();
        mdtrtinfo.setDise_codg(hsPreparePayDto.getDiseCodg());
        mdtrtinfo.setDise_name(hsPreparePayDto.getDiseName());
        mdtrtinfo.setPsn_no(hsPreparePayDto.getPsnNo());
        mdtrtinfo.setMed_type(hsPreparePayDto.getMedType());
        AdmissionEntity admission = this.admissionService.queryAdmissionByOutpatientNo(data.getOutpatientNo(), hsPreparePayDto.getTenantId());
        ArrayList<DiseinfoRequest> diseinfo = new ArrayList<DiseinfoRequest>();
        List outMedicalRecordDiagnoses = this.outMedicalRecordDiagnosisService.queryMedicalRecordDiagnosisByOutpatientNo(dto.getTenantId(), data.getOutpatientNo());
        for (i = 0; i < outMedicalRecordDiagnoses.size(); ++i) {
            OutMedicalRecordDiagnosis outMedicalRecordDiagnosis = (OutMedicalRecordDiagnosis)outMedicalRecordDiagnoses.get(i);
            DiseinfoRequest diseinfoRequest = new DiseinfoRequest();
            diseinfoRequest.setDiag_srt_no(i + 2 + "");
            diseinfoRequest.setDiag_type("2".equals(outMedicalRecordDiagnosis.getDiagnosticType()) ? "3" : "1");
            if (Objects.isNull(outMedicalRecordDiagnosis.getHsIcdCode())) {
                QueryWrapper query = new QueryWrapper();
                query.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
                query.eq((Object)"icd_code", (Object)outMedicalRecordDiagnosis.getIcdCode());
                OutIcdItem outIcdItem = (OutIcdItem)this.outIcdItemMapper.selectOne((Wrapper)query);
                diseinfoRequest.setDiag_code(outIcdItem.getMedicalCode());
                diseinfoRequest.setDiag_name(outIcdItem.getMedicalName());
            } else {
                diseinfoRequest.setDiag_code(outMedicalRecordDiagnosis.getHsIcdCode());
                diseinfoRequest.setDiag_name(outMedicalRecordDiagnosis.getHsDiagnosis());
            }
            diseinfoRequest.setDiag_dept(sysDoctorIdVo.getDepartmentName());
            diseinfoRequest.setDise_dor_name(sysDoctorIdVo.getUserName());
            diseinfoRequest.setDiag_time(DateUtils.dateFormat((Date)admission.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            diseinfoRequest.setVali_flag("1");
            diseinfoRequest.setDise_dor_no(sysDoctorIdVo.getHsCode());
            diseinfo.add(diseinfoRequest);
        }
        RegPayInfoRequest regPayInfoRequest = new RegPayInfoRequest();
        regPayInfoRequest.setInsutype(insuinfo.getInsutype());
        regPayInfoRequest.setCard_sn("");
        regPayInfoRequest.setPsn_setlway("01");
        regPayInfoRequest.setAcct_used_flag("1");
        regPayInfoRequest.setInsuplc_admdvs(insuinfo.getInsuplc_admdvs());
        regPayInfoRequest.setRegistrationRequest(registrationRequest);
        regPayInfoRequest.setMdtrtinfo(mdtrtinfo);
        regPayInfoRequest.setUploadInfoDetailRequest(uploadInfoDetailRequestList);
        regPayInfoRequest.setDiseinfo(diseinfo);
        regPayInfoRequest.setTenantId(dto.getTenantId());
        regPayInfoRequest.setSign_no(dto.getSignNo());
        dto.setPsnCertType(registrationRequest.getPsn_cert_type());
        dto.setInsuplcAdmdvs(insuinfo.getInsuplc_admdvs());
        dto.setCertno(registrationRequest.getCertno());
        dto.setMdtrtCertNo(registrationRequest.getMdtrt_cert_no());
        dto.setMdtrtCertType(registrationRequest.getMdtrt_cert_type());
        dto.setBegntime(registrationRequest.getBegntime());
        Integer hireesetlType = -1;
        String hireesetlName = "";
        if (settleTypeCode == null || settleTypeCode == 4) {
            hireesetlType = 0;
            hireesetlName = "\u975e\u533b\u7597\u4fdd\u9669\u7ed3\u7b97";
        } else {
            String insuplcAdmdvs = insuinfo.getInsuplc_admdvs();
            String[] admdvsArr = new String[]{"360100", "360102", "360103", "360104", "360105", "360111", "360112", "360113", "360121", "360123", "360124", "360140", "360141", "360151", "360199"};
            List<String> admdvsList = Arrays.asList(admdvsArr);
            if (admdvsList.contains(insuplcAdmdvs)) {
                hireesetlType = 1;
                hireesetlName = "\u672c\u5730\u533b\u7597\u4fdd\u9669\u7ed3\u7b97";
            } else {
                hireesetlType = 2;
                hireesetlName = "\u5f02\u5730\u533b\u7597\u4fdd\u9669\u7ed3\u7b97";
            }
        }
        dto.setHiFeesetlType(hireesetlType + "");
        dto.setHiFeesetlName(hireesetlName);
        return this.push(dto);
    }

    public ResponseData rxUndo(HsPrescriptionUploadDto dto) {
        this.undoPush(dto);
        return ResponseData.success();
    }

    public ResponseData undoPush(HsPrescriptionUploadDto dto) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("keys", "nc095fe67ee7358f8fd8e8zk");
        dto.setPrescriptionNo(dto.getHiRxno());
        HiRxnoEntity data = this.prescriptionMapper.queryHiRxnoEntity(dto);
        data.setHospRxno(dto.getHiRxno());
        param.put("data", (String)data);
        String jsonString = JSON.toJSONString(param);
        String code = "";
        try {
            String s = HttpUtils.doPost((String)"http://171.34.133.170:8086/push/rxUndo", (String)jsonString, (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            JSONObject jsonObject = JSONObject.parseObject((String)s);
            code = jsonObject.get((Object)"code").toString();
            System.out.println(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!"200".equals(code)) {
            return ResponseData.error((String)"\u5904\u65b9\u533b\u4fdd\u4fe1\u606f\u64a4\u9500\u5931\u8d25");
        }
        return ResponseData.success();
    }

    public ResponseData push(HsPrescriptionUploadDto dto) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("keys", "nc095fe67ee7358f8fd8e8zk");
        String[] diagCodeArr = dto.getDiagCode().split(",");
        String[] diagNameArr = dto.getDiagName().split(",");
        String insuplcAdmdvs = dto.getInsuplcAdmdvs();
        HsPrescriptionUploadEntity data = this.prescriptionMapper.queryHsPrescriptionUploadEntity(dto);
        String sourceTypes = dto.getSourceTypes();
        if (StringUtils.isNotBlank((CharSequence)sourceTypes) && "2".equals(sourceTypes)) {
            data.setStoreCode(dto.getStoreCode());
            data.setStoreName(dto.getStoreName());
            data.setDruggistcode(dto.getDruggistCode());
            data.setDruggistName(dto.getDruggistName());
            data.setOrgCode(dto.getDruggistCode());
            data.setOrgName(dto.getDruggistName());
        }
        data.setHiFeesetlType(dto.getHiFeesetlType());
        data.setHiFeesetlName(dto.getHiFeesetlName());
        data.setSourceTypes(dto.getSourceTypes());
        data.setInsuPlcNo(insuplcAdmdvs);
        String shenFangSignUrl = dto.getShenFangSignUrl();
        String kaiFangSignUrl = dto.getKaiFangSignUrl();
        data.setShenFangSignUrl(StringUtil.isBlank((String)shenFangSignUrl) ? "test1" : shenFangSignUrl);
        data.setKaiFangSignUrl(StringUtil.isBlank((String)kaiFangSignUrl) ? "test1" : shenFangSignUrl);
        if (data == null) {
            return ResponseData.error((String)"\u5904\u65b9\u4e0d\u5b58\u5728!");
        }
        List rxDrugDetailEntities = this.prescriptionMapper.queryRxDrugDetailEntity(dto);
        List mdtrtInfoEntities = this.prescriptionMapper.queryMdtrtInfoEntity(dto);
        AtomicBoolean isNull = new AtomicBoolean(false);
        rxDrugDetailEntities.forEach(item -> {
            String drugDosunt = item.getDrugDosunt();
            if (StringUtils.isBlank((CharSequence)drugDosunt)) {
                isNull.set(true);
            }
        });
        ExceptionUtils.createException((Logger)log, (boolean)isNull.get(), (String)"\u5904\u65b9\u836f\u7684drugDosunt(\u6700\u5927\u5305\u88c5\u5355\u4f4d)\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        for (int i = 0; i < mdtrtInfoEntities.size(); ++i) {
            MdtrtInfoEntity item2 = (MdtrtInfoEntity)mdtrtInfoEntities.get(i);
            item2.setHiFeesetlType("1");
            item2.setMaindiagCode(dto.getDiagCode().split(",")[0]);
            item2.setMaindiagName(dto.getDiagName().split(",")[0]);
            item2.setMdtrtId(dto.getMdtrtId());
            item2.setMedType(dto.getMedType());
            item2.setPsnNo(dto.getPsnNo());
            item2.setPsnCertType(dto.getPsnCertType());
            item2.setCertno(dto.getCertno());
            item2.setInsuplcAdmdvs(dto.getInsuplcAdmdvs());
            String drDeptName = item2.getDrDeptName();
            item2.setCaty(DeptEnum.deptA01.getCodeByDept(drDeptName));
            item2.setDrDeptCode(DeptEnum.deptA01.getCodeByDept(drDeptName));
            item2.setPrscDeptCode(DeptEnum.deptA01.getCodeByDept(drDeptName));
            item2.setMdtrtTime(dto.getBegntime());
            item2.setHiFeesetlType(dto.getHiFeesetlType());
            item2.setHiFeesetlName(dto.getHiFeesetlName());
        }
        List diseInfoEntities = this.prescriptionMapper.queryDiseInfoEntity(dto);
        for (DiseInfoEntity item3 : diseInfoEntities) {
            String diagDept = item3.getDiagDept();
            item3.setDiagDeptCode(DeptEnum.deptA01.getCodeByDept(diagDept));
            item3.setDiagTime(dto.getBegntime());
        }
        data.setRxdrugdetail(rxDrugDetailEntities);
        data.setMdtrtinfo((MdtrtInfoEntity)mdtrtInfoEntities.get(0));
        data.setDiseinfo(diseInfoEntities);
        data.setInsuPlcNo(dto.getInsuplcAdmdvs());
        data.setRegTime(dto.getBegntime());
        data.setPharCode("Y360104004006");
        data.setPharName("\u4e01\u5fb7\u796f");
        data.setPharDeptCode("231");
        data.setPharDeptName("\u836f\u5b66\u90e8");
        data.setPharProfttlName("\u4e3b\u4efb\u836f\u5e08");
        data.setPharProfttlCodg("2.1");
        data.setPharCertType("01");
        data.setPharCertno("36073419870416002X");
        param.put("data", (String)data);
        param.put("totalAmount", data.getTotalPrescriptionAmount());
        String jsonString = JSON.toJSONString(param);
        String code = "";
        String msg = "";
        try {
            log.info("\u5373\u5c06\u5f00\u59cb\u63a8\u9001\u5916\u6d41\u5904\u65b9{} \u5165\u53c2\uff1a{}", (Object)data.getHospRxno(), (Object)jsonString);
            String s = HttpUtils.doPost((String)(this.url + "/receiverPr/prData"), (String)jsonString, (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("\u5373\u5c06\u5f00\u59cb\u63a8\u9001\u5916\u6d41\u5904\u65b9{} \u53cd\u53c2\uff1a{}", (Object)data.getHospRxno(), (Object)s);
            JSONObject jsonObject = JSONObject.parseObject((String)s);
            code = jsonObject.get((Object)"code").toString();
            msg = jsonObject.get((Object)"msg").toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!"200".equals(code)) {
            return ResponseData.error((String)msg);
        }
        return ResponseData.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public String fastPrescription(FastPrescriptionDto dto) {
        Integer tenantId = 1;
        QuickTreatementDto quickTreatementDto = new QuickTreatementDto();
        quickTreatementDto.setTenantId(tenantId);
        quickTreatementDto.setOperatorId(Integer.valueOf(1));
        quickTreatementDto.setOperatorName("\u6781\u901f\u5f00\u65b9");
        quickTreatementDto.setName(dto.getPatientName());
        quickTreatementDto.setAge(Integer.valueOf(dto.getPatientAge()));
        quickTreatementDto.setSex(dto.getPatientSex());
        quickTreatementDto.setBirthday(DateUtils.getBirthDayFromIdCard((String)dto.getPatientCardNo()));
        quickTreatementDto.setCardType("01");
        quickTreatementDto.setPhone(dto.getPatientPhone());
        quickTreatementDto.setDeptId(dto.getPatientDeptId());
        quickTreatementDto.setDeptName(dto.getPatientDeptName());
        quickTreatementDto.setDoctorId(dto.getDoctorId());
        quickTreatementDto.setDoctorName(dto.getDoctorName());
        quickTreatementDto.setHospitalName("\u7ebf\u4e0a\u6781\u901f\u5f00\u65b9");
        quickTreatementDto.setMedicalOutpatientType("11");
        quickTreatementDto.setMedicalType("3");
        quickTreatementDto.setOutpatientType("316680");
        quickTreatementDto.setOutpatientTypeName("\u514d\u8d39\u95e8\u8bca\uff080\u5143\uff09");
        quickTreatementDto.setSource("2");
        ResponseData registerRes = this.admissionService.quickTreatement(quickTreatementDto);
        if (registerRes.isError()) {
            throw new RuntimeException("\u6302\u514d\u53f7\u5931\u8d25\uff01");
        }
        log.debug("\u4fdd\u5b58\u5904\u65b9-->\u65b0\u589e\u5904\u65b9[\u5f00\u59cb]");
        String prescriptionNo = UUIDUtils.getPrescriptionNo();
        String lnventoryNumber = "";
        log.debug("\u4fdd\u5b58\u5904\u65b9-->\u751f\u6210\u7684\u5904\u65b9\u7f16\u53f7:{}", (Object)prescriptionNo);
        Date prescriptionTime = new Date();
        OutPrescription prescription = new OutPrescription();
        prescription.setWarehouse("");
        prescription.setTenantId(tenantId);
        prescription.setCreateId(Integer.valueOf(1));
        prescription.setCreateTime(prescriptionTime);
        prescription.setUpdateId(Integer.valueOf(1));
        prescription.setOutpatientNo(((AdmissionPatientVo)registerRes.getData()).getOutpatientNo());
        prescription.setMedicalRecordNo(((AdmissionPatientVo)registerRes.getData()).getMedicalRecordNo());
        prescription.setPrescriptionNo(prescriptionNo);
        prescription.setPrescriptionStatus(PrescriptionStatusEnum.STATUS_NORMAL.getValue());
        prescription.setDiagCode(null);
        prescription.setDiagName(null);
        prescription.setRationalMedicationStatus(null);
        prescription.setPrescriptionAuditStatus(null);
        prescription.setPharmacy(Integer.valueOf(2));
        prescription.setPatientName(((AdmissionPatientVo)registerRes.getData()).getPatientName());
        prescription.setPatientId(((AdmissionPatientVo)registerRes.getData()).getPatientId());
        prescription.setPatientIdentificationNumber(((AdmissionPatientVo)registerRes.getData()).getPatientCardNo());
        prescription.setPatientMobileNumber(((AdmissionPatientVo)registerRes.getData()).getPhone());
        prescription.setPrescribingDoctorId(dto.getDoctorId());
        prescription.setPrescribingDoctorName(dto.getDoctorName());
        prescription.setPrescribingDoctorSignature(null);
        prescription.setPrescribingDepartmentId(dto.getPatientDeptId());
        prescription.setPrescribingDepartmentName(dto.getPatientDeptName());
        prescription.setReviewerId(null);
        prescription.setReviewerName(null);
        prescription.setReviewerSignature(null);
        prescription.setReviewerTime(null);
        prescription.setIssueTime(new Date());
        prescription.setLnventoryNumber(lnventoryNumber);
        prescription.setSource("2");
        prescription.setSource(dto.getSourceName());
        prescription.setMainId(dto.getMainId());
        BigDecimal totalDrugAmount = dto.getDrugList().stream().map(FastDrug::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        Integer prescriptionType = ((FastDiag)dto.getDiagList().get(0)).getDiagnosticType() == 1L ? Integer.valueOf(11) : Integer.valueOf(1);
        BigDecimal drugSize = PrescriptionTypeEnum.WESTERN_MEDICINE.getValue().equals(prescriptionType) ? dto.getDrugList().stream().map(item -> new BigDecimal(item.getQuantity())).reduce(BigDecimal.ZERO, BigDecimal::add) : new BigDecimal(dto.getDrugList().size());
        prescription.setTotalDrugCategories(Integer.valueOf(dto.getDrugList().size()));
        prescription.setTotalDrugQuantity(drugSize);
        prescription.setIsDecoction(Integer.valueOf(1));
        prescription.setTotalDecoctionAmount(new BigDecimal(0));
        prescription.setTotalPrescriptionAmount(prescription.getTotalDecoctionAmount() == null ? totalDrugAmount : totalDrugAmount.add(prescription.getTotalDecoctionAmount()));
        prescription.setTotalDrugsAmount(totalDrugAmount);
        prescription.setPrintCount(Integer.valueOf(0));
        prescription.setIsInsurancePrescription(null);
        prescription.setInsurancePrescriptionType(InsurancePrescriptionTypeEnum.REGULAR_PRESCRIPTION.getValue());
        prescription.setPrescriptionType(prescriptionType);
        prescription.setAdditionalNotes(null);
        prescription.setSingleDoseAmount(totalDrugAmount);
        prescription.setMedicationTime(null);
        prescription.setMedicationTimeId(null);
        prescription.setDailyDosage(null);
        prescription.setSingleDoseUsage(null);
        prescription.setSingleDoseUsageId(null);
        prescription.setDailyFrequency(null);
        prescription.setUsageId(null);
        prescription.setUsageName(null);
        prescription.setDosage(null);
        prescription.setMedicationTaboo(null);
        prescription.setMedicationTabooCode(null);
        prescription.setPrescriptionClassifyType(Integer.valueOf(2));
        prescription.setNanhuaType(Integer.valueOf(0));
        int size = this.prescriptionMapper.insert((Object)prescription);
        log.debug("\u4fdd\u5b58\u5904\u65b9-->\u65b0\u589e\u5904\u65b9[\u7ed3\u675f]=\u6570\u91cf{}", (Object)size);
        log.debug("\u4fdd\u5b58\u5904\u65b9-->\u65b0\u589e\u5904\u65b9\u836f\u54c1[\u5f00\u59cb]");
        List outPrescriptionDrugList = dto.getDrugList().stream().map(item -> {
            String label;
            ResponseData pageResponseData;
            SysDictValueDTO dictParam;
            OutPrescriptionDrug drug = new OutPrescriptionDrug();
            drug.setTenantId(tenantId);
            drug.setPrescriptionNo(prescriptionNo);
            drug.setCreateId(Integer.valueOf(1));
            drug.setCreateTime(prescriptionTime);
            drug.setUpdateId(Integer.valueOf(1));
            drug.setStatus(Integer.valueOf(1));
            drug.setPharmacy(Integer.valueOf(2));
            ArrayList<String> drugCode = new ArrayList<String>();
            drugCode.add(item.getInternalCode());
            ResponseData sysDrugEntityResponseData = this.sysServiceFeign.sysDrugInternalCodes(drugCode, tenantId);
            if (Objects.isNull(sysDrugEntityResponseData) || !sysDrugEntityResponseData.isSuccess()) {
                return null;
            }
            List sysDrugEntityList = JSON.parseArray((String)JSON.toJSONString((Object)sysDrugEntityResponseData.getData()), SysDrugEntity.class);
            SysDrugEntity sysDrugEntity = (SysDrugEntity)sysDrugEntityList.get(0);
            drug.setDrugNo(sysDrugEntity.getId());
            drug.setDrugName(sysDrugEntity.getDrugName());
            drug.setInsuranceDrugCode(sysDrugEntity.getMedicalInsuranceCode());
            drug.setMedicalInsuranceCode(sysDrugEntity.getMedicalInsuranceCode());
            drug.setMedicalInsuranceName(sysDrugEntity.getMedicalInsuranceName());
            drug.setLevel(sysDrugEntity.getLevel());
            drug.setSpecification(sysDrugEntity.getSpecifications());
            drug.setManufacturer(sysDrugEntity.getManufacturer());
            if (((FastDiag)dto.getDiagList().get(0)).getDiagnosticType() == 1L) {
                dictParam = new SysDictValueDTO();
                dictParam.setType("chn_medicine_usage");
                dictParam.setValue(sysDrugEntity.getUsages());
                pageResponseData = this.sysServiceFeign.sysDictValueById(dictParam, tenantId + "");
                if (!((Page)pageResponseData.getData()).getRecords().isEmpty()) {
                    label = ((SysDictValueVo)((Page)pageResponseData.getData()).getRecords().get(0)).getLabel();
                    drug.setDrugUsage(label != null ? label : "");
                }
            } else {
                dictParam = new SysDictValueDTO();
                dictParam.setType("we_medicine_usage");
                dictParam.setValue(sysDrugEntity.getUsages());
                pageResponseData = this.sysServiceFeign.sysDictValueById(dictParam, tenantId + "");
                if (!((Page)pageResponseData.getData()).getRecords().isEmpty()) {
                    label = ((SysDictValueVo)((Page)pageResponseData.getData()).getRecords().get(0)).getLabel();
                    drug.setDrugUsage(label != null ? label : "");
                }
            }
            drug.setUsageCode(sysDrugEntity.getUsages());
            drug.setSingleDose(new BigDecimal(sysDrugEntity.getDefaultSingleDose()));
            drug.setDoseUnitCode(sysDrugEntity.getDefaultUsageUnit());
            dictParam = new SysDictValueDTO();
            dictParam.setType("usage_unit");
            dictParam.setValue(sysDrugEntity.getDefaultSingleDoseUnit());
            pageResponseData = this.sysServiceFeign.sysDictValueById(dictParam, tenantId + "");
            if (!((Page)pageResponseData.getData()).getRecords().isEmpty()) {
                label = ((SysDictValueVo)((Page)pageResponseData.getData()).getRecords().get(0)).getLabel();
                drug.setDoseUnit(label != null ? label : "");
            }
            drug.setFrequency("\u7acb\u5373");
            drug.setFrequencyCode("st");
            drug.setFrequencyRate("1.000000");
            BigDecimal medicationDays = new BigDecimal(item.getQuantity()).multiply(new BigDecimal(sysDrugEntity.getDefaultUsage())).multiply(new BigDecimal(sysDrugEntity.getPackSpecification())).divide(drug.getSingleDose(), 0, RoundingMode.UP);
            drug.setMedicationDays(Integer.valueOf(medicationDays.intValue()));
            drug.setQuantity(new BigDecimal(item.getQuantity()));
            dictParam = new SysDictValueDTO();
            dictParam.setType("unit_type");
            dictParam.setValue(sysDrugEntity.getPackLargeUnits());
            pageResponseData = this.sysServiceFeign.sysDictValueById(dictParam, tenantId + "");
            if (!((Page)pageResponseData.getData()).getRecords().isEmpty()) {
                String label2 = ((SysDictValueVo)((Page)pageResponseData.getData()).getRecords().get(0)).getLabel();
                drug.setQuantityUnit(label2 != null ? label2 : "");
            }
            drug.setQuantityUnitCode(sysDrugEntity.getPackLargeUnits());
            drug.setDrugPriceAmount(sysDrugEntity.getRetailPrice());
            drug.setTotalDrugAmount(sysDrugEntity.getRetailPrice().multiply(new BigDecimal(item.getQuantity())));
            drug.setIsSkinTest(Integer.valueOf(1));
            drug.setDrugProperties(sysDrugEntity.getDrugProperties());
            drug.setInternalCode(sysDrugEntity.getInternalCode());
            drug.setDosageForm(sysDrugEntity.getDosageForm());
            drug.setDefaultUsage(sysDrugEntity.getDefaultUsage());
            drug.setPackSpecification(sysDrugEntity.getPackSpecification());
            drug.setMedicalInsuranceAuditFlag("1");
            return drug;
        }).collect(Collectors.toList());
        if (dto.getDrugList().size() != outPrescriptionDrugList.size()) {
            return null;
        }
        size = this.outPrescriptionDrugMapper.batchInsert(outPrescriptionDrugList);
        log.info("\u65b0\u589e\u836f\u54c1\u6570\u91cf\uff1a{},\u5904\u65b9\u53f7:{}", (Object)size, (Object)prescriptionNo);
        return ((AdmissionPatientVo)registerRes.getData()).getOutpatientNo();
    }
}

