/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.byh.outpatient.api.model.ArchivalFileTypeEntity;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.web.aspect.AntiRefresh;
import com.byh.outpatient.web.mvc.controller.MinioFileController;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.ArchivalFileTypeService;
import io.swagger.annotations.ApiOperation;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ArchivalFileType"})
public class ArchivalFileTypeController {
    @Autowired
    private ArchivalFileTypeService ArchivalFileTypeService;
    @Autowired
    private CommonRequest commonRequest;
    @Autowired
    private MinioFileController minioFileController;

    @ApiOperation(value="\u6839\u636e\u8bca\u65ad\u6863\u6848id\u67e5\u8be2\u6587\u4ef6\u7c7b\u578b")
    @GetMapping(value={"/pageList"})
    @AntiRefresh
    public ResponseData<List<ArchivalFileTypeEntity>> pageList(ArchivalFileTypeEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        entity.setTenantId(tenant);
        Integer archivalRecordsId = entity.getArchivalRecordsId();
        if (archivalRecordsId == null) {
            return ResponseData.error((String)"\u8bca\u65ad\u6863\u6848id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return ResponseData.success((Object)this.ArchivalFileTypeService.pageList(entity));
    }

    @ApiOperation(value="\u6839\u636e\u6587\u4ef6\u7c7b\u578bid\u4fdd\u5b58\u6863\u6848\u6587\u4ef6")
    @PostMapping(value={"/save"})
    @AntiRefresh
    public ResponseData save(HttpServletResponse response, @RequestBody ArchivalFileTypeEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        entity.setTenantId(tenant);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String formatStr = format.format(new Date());
        entity.setCreateTime(formatStr);
        Integer archivalRecordsId = entity.getArchivalRecordsId();
        if (archivalRecordsId == null) {
            return ResponseData.error((String)"\u8bca\u65ad\u6863\u6848id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.ArchivalFileTypeService.save(entity);
        return ResponseData.success();
    }

    @ApiOperation(value="\u5220\u9664\u6587\u4ef6\u7c7b\u578b")
    @PostMapping(value={"/del"})
    @AntiRefresh
    public ResponseData del(HttpServletResponse response, @RequestBody ArchivalFileTypeEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        entity.setTenantId(tenant);
        Integer del = this.ArchivalFileTypeService.del(entity);
        if (del != 1) {
            return ResponseData.error((String)"\u5220\u9664\u5931\u8d25");
        }
        return ResponseData.success();
    }

    @ApiOperation(value="\u7f16\u8f91\u6587\u4ef6\u7c7b\u578b")
    @PostMapping(value={"/edit"})
    @AntiRefresh
    public ResponseData edit(HttpServletResponse response, @RequestBody ArchivalFileTypeEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        entity.setTenantId(tenant);
        Integer update = this.ArchivalFileTypeService.update(entity);
        if (update != 1) {
            return ResponseData.error((String)"\u7f16\u8f91\u5931\u8d25");
        }
        return ResponseData.success();
    }
}

