/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.outpatient.api.dto.ArchivalFileDto;
import com.byh.outpatient.api.model.ArchivalFileEntity;
import com.byh.outpatient.api.model.ArchivalFileTypeEntity;
import com.byh.outpatient.api.model.ArchivalRecordsEntity;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.UUIDUtils;
import com.byh.outpatient.data.repository.ArchivalFileMapper;
import com.byh.outpatient.data.repository.ArchivalFileTypeMapper;
import com.byh.outpatient.data.repository.ArchivalRecordsMapper;
import com.byh.outpatient.web.mvc.controller.RocketMQProducerController;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.rocket.RocketMQProducer;
import com.byh.outpatient.web.service.ArchivalFileService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.rocketmq.client.producer.SendCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArchivalFileServiceImpl
implements ArchivalFileService {
    @Autowired
    private ArchivalFileMapper mapper;
    @Autowired
    private ArchivalRecordsMapper archivalRecordsMapper;
    @Autowired
    private ArchivalFileTypeMapper archivalFileTypeMapper;
    private static final Logger logger = LoggerFactory.getLogger(RocketMQProducerController.class);
    private static final String archivalFileTopic = "rocketMQ-out-archivalFileTopic";
    private final CommonRequest commonRequest;
    private final RocketMQProducer rocketMQProducer;

    public Long save(ArchivalFileDto dto) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        String formatStr = format.format(new Date());
        ArchivalFileEntity entity = new ArchivalFileEntity();
        entity.setSort("0");
        entity.setTenantId(dto.getTenantId());
        entity.setUrl(dto.getUrl());
        entity.setCreateTime(formatStr);
        entity.setIsDel("0");
        entity.setName(dto.getName());
        entity.setMinioFileName(dto.getMinioFileName());
        entity.setFileTypeId(dto.getFileTypeId());
        int insert = this.mapper.insert((Object)entity);
        List archivalFileEntities = this.mapper.selectList((Wrapper)Wrappers.lambdaQuery().orderByDesc(ArchivalFileEntity::getId));
        for (ArchivalFileEntity archivalFileEntity : archivalFileEntities) {
            String name = archivalFileEntity.getName();
            if (!name.equals(dto.getName())) continue;
            Long id = archivalFileEntity.getId();
            try {
                ArchivalFileTypeEntity typeEntity = (ArchivalFileTypeEntity)this.archivalFileTypeMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ArchivalFileTypeEntity::getId, (Object)dto.getFileTypeId())).eq(ArchivalFileTypeEntity::getTenantId, (Object)dto.getTenantId()));
                ArchivalRecordsEntity archivalRecordsDto = new ArchivalRecordsEntity();
                archivalRecordsDto.setId(Long.valueOf(typeEntity.getArchivalRecordsId().intValue()));
                archivalRecordsDto.setTenantId(typeEntity.getTenantId());
                List list = this.archivalRecordsMapper.archivalRecordsList(archivalRecordsDto);
                String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
                String msg = JSONObject.toJSONString((Object)list);
                this.rocketMQProducer.asyncSendCallbackTimeoutLevel(archivalFileTopic, "TAG8", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return id;
        }
        return 0L;
    }

    public String batchSave(ArchivalFileDto dto) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        String formatStr = format.format(new Date());
        List nameList = dto.getNameList();
        List urlList = dto.getUrlList();
        String rspMsg = "\u64cd\u4f5c\u6210\u529f";
        for (int i = 0; i < urlList.size(); ++i) {
            String url = (String)urlList.get(i);
            String substring = url.substring(url.lastIndexOf("."), url.length());
            ArchivalFileEntity entity = new ArchivalFileEntity();
            entity.setSort("0");
            entity.setTenantId(dto.getTenantId());
            entity.setUrl(url);
            entity.setCreateTime(formatStr);
            entity.setIsDel("0");
            entity.setName("name" + substring);
            entity.setFileTypeId(dto.getFileTypeId());
            int n = this.mapper.insert((Object)entity);
        }
        List archivalFileEntities = this.mapper.selectList((Wrapper)Wrappers.lambdaQuery().orderByDesc(ArchivalFileEntity::getId));
        for (ArchivalFileEntity archivalFileEntity : archivalFileEntities) {
            String name = archivalFileEntity.getName();
            if (!name.equals(dto.getName())) continue;
            Long id = archivalFileEntity.getId();
            try {
                ArchivalFileTypeEntity typeEntity = (ArchivalFileTypeEntity)this.archivalFileTypeMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ArchivalFileTypeEntity::getId, (Object)dto.getFileTypeId())).eq(ArchivalFileTypeEntity::getTenantId, (Object)dto.getTenantId()));
                ArchivalRecordsEntity archivalRecordsDto = new ArchivalRecordsEntity();
                archivalRecordsDto.setId(Long.valueOf(typeEntity.getArchivalRecordsId().intValue()));
                archivalRecordsDto.setTenantId(typeEntity.getTenantId());
                List list = this.archivalRecordsMapper.archivalRecordsList(archivalRecordsDto);
                String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
                String msg = JSONObject.toJSONString((Object)list);
                this.rocketMQProducer.asyncSendCallbackTimeoutLevel(archivalFileTopic, "TAG8", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return rspMsg;
    }

    public void del(ArchivalFileEntity entity) {
        ArchivalFileEntity fileEntity = (ArchivalFileEntity)this.mapper.selectById((Serializable)entity.getId());
        this.mapper.deleteById((Serializable)entity.getId());
        try {
            ArchivalFileTypeEntity typeEntity = (ArchivalFileTypeEntity)this.archivalFileTypeMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ArchivalFileTypeEntity::getId, (Object)fileEntity.getFileTypeId())).eq(ArchivalFileTypeEntity::getTenantId, (Object)fileEntity.getTenantId()));
            ArchivalRecordsEntity archivalRecordsDto = new ArchivalRecordsEntity();
            archivalRecordsDto.setId(Long.valueOf(typeEntity.getArchivalRecordsId().intValue()));
            archivalRecordsDto.setTenantId(typeEntity.getTenantId());
            List list = this.archivalRecordsMapper.archivalRecordsList(archivalRecordsDto);
            String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
            String msg = JSONObject.toJSONString((Object)list);
            this.rocketMQProducer.asyncSendCallbackTimeoutLevel(archivalFileTopic, "TAG8", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update(ArchivalFileEntity entity) {
    }

    public void updateFileType(List<ArchivalFileDto> dtos) {
        for (ArchivalFileDto dto : dtos) {
            ArchivalFileEntity fileEntity = new ArchivalFileEntity();
            Long id = dto.getId();
            Integer fileTypeId = dto.getFileTypeId();
            fileEntity.setId(id);
            fileEntity.setFileTypeId(fileTypeId);
            if (fileTypeId == null) continue;
            this.mapper.update((Object)fileEntity, (Wrapper)Wrappers.lambdaUpdate().eq(ArchivalFileEntity::getId, (Object)fileEntity.getId()));
        }
        try {
            ArchivalFileTypeEntity typeEntity = (ArchivalFileTypeEntity)this.archivalFileTypeMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ArchivalFileTypeEntity::getId, (Object)dtos.get(0).getFileTypeId())).eq(ArchivalFileTypeEntity::getTenantId, (Object)dtos.get(0).getTenantId()));
            ArchivalRecordsEntity archivalRecordsDto = new ArchivalRecordsEntity();
            archivalRecordsDto.setId(Long.valueOf(typeEntity.getArchivalRecordsId().intValue()));
            archivalRecordsDto.setTenantId(typeEntity.getTenantId());
            List list = this.archivalRecordsMapper.archivalRecordsList(archivalRecordsDto);
            String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
            String msg = JSONObject.toJSONString((Object)list);
            this.rocketMQProducer.asyncSendCallbackTimeoutLevel(archivalFileTopic, "TAG8", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ResponseData<List<ArchivalFileEntity>> pageList(ArchivalFileEntity entity) {
        List archivalRecordsEntities = this.mapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ArchivalFileEntity::getFileTypeId, (Object)entity.getFileTypeId())).eq(ArchivalFileEntity::getTenantId, (Object)entity.getTenantId())).orderByDesc(ArchivalFileEntity::getSort)).orderByDesc(ArchivalFileEntity::getCreateTime));
        return ResponseData.success((Object)archivalRecordsEntities);
    }

    public int insertBatch(List<ArchivalFileEntity> list) {
        return this.mapper.insertBatch(list);
    }

    public ArchivalFileServiceImpl(CommonRequest commonRequest, RocketMQProducer rocketMQProducer) {
        this.commonRequest = commonRequest;
        this.rocketMQProducer = rocketMQProducer;
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

