/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.controller.checkup;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONObject;
import com.byh.sdk.config.minio.MinioUtil;
import com.byh.sdk.entity.checkup.CheckupDataDTO;
import com.byh.sdk.entity.checkup.CheckupRegForm;
import com.byh.sdk.entity.checkup.PatientRecordDto;
import com.byh.sdk.feign.sys.OutpatientServiceFeign;
import com.byh.sdk.util.ResponseData;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import sun.misc.BASE64Decoder;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/checkup"})
public class CheckupMainController {
    private static final Logger log = LoggerFactory.getLogger(CheckupMainController.class);
    @Resource
    private OutpatientServiceFeign outpatientServiceFeign;
    private static final String SFZ_FORMAT = "bmp";
    private static final String ECG_FORMAT = "bmp";
    private static final String ECG12_FORMAT = "jpg";
    private static final String BMD_FORMAT = "png";
    @Resource
    private MinioUtil minioUtil;

    @PostMapping(value={"/saveAllMeasurementData"})
    @ApiOperation(value="\u4fdd\u5b58\u6240\u6709\u6d4b\u91cf\u6570\u636e")
    public ResponseData saveAllMeasurementData(@RequestBody CheckupDataDTO param) {
        try {
            log.info("\u4f53\u68c0\u5165\u53c2\uff1a{}", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)param));
            CheckupDataDTO.SfzDTO sfz = param.getSfz();
            MultipartFile multipartFile = CheckupMainController.base64ToMultipart((String)sfz.getData(), (String)("sfz_" + System.currentTimeMillis() + "." + "bmp"), (String)"image/bmp");
            JSONObject uploadResult = this.minioUtil.upload(multipartFile);
            String fileUrl = uploadResult.getStr((Object)"url");
            param.getSfz().setData(fileUrl);
            MultipartFile ecg12MultipartFile = CheckupMainController.base64ToMultipart((String)param.getEcg12().getData(), (String)("ecg12_" + System.currentTimeMillis() + "." + "jpg"), (String)"image/jpeg");
            JSONObject ecg12UploadResult = this.minioUtil.upload(ecg12MultipartFile);
            String ecg12FileUrl = ecg12UploadResult.getStr((Object)"url");
            param.getEcg12().setData(ecg12FileUrl);
            String pdfUrl = "";
            try {
                pdfUrl = this.savePdfData(param);
            }
            catch (Exception e) {
                log.error("{}\u751f\u6210\u667a\u80fd\u7ba1\u7406pdf\u5931\u8d25{}", (Object)param.getSfz().getName(), (Object)e.getMessage());
            }
            param.setZnglPdf(pdfUrl);
            ResponseData responseData = this.outpatientServiceFeign.saveAllMeasurementData(param);
            if (!"200".equals(responseData.getCode())) {
                log.info("\u4f53\u68c0\u9519\u8bef\u51fa\u53c2:{}", (Object)responseData.getMsg());
                return ResponseData.error((String)responseData.getMsg());
            }
            log.info("\u4f53\u68c0\u56de\u53c2\uff1a{}", responseData.getData());
            return responseData;
        }
        catch (Exception ex) {
            return ResponseData.error((String)("\u65b0\u589e\u5931\u8d25\uff1a" + ex.getMessage()));
        }
    }

    @GetMapping(value={"/queryCheckupAllInfo"})
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u6d4b\u91cf\u6570\u636e\u660e\u7ec6")
    public ResponseData saveAllMeasurementData(Long id) {
        try {
            return ResponseData.success((Object)this.outpatientServiceFeign.queryCheckupAllInfo(id));
        }
        catch (Exception ex) {
            return ResponseData.error((String)("\u67e5\u8be2\u5931\u8d25\uff1a" + ex.getMessage()));
        }
    }

    @PostMapping(value={"/insertCheckupRegForm"})
    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539\u667a\u5eb7\u517b\u8001\u4e2d\u5fc3\u4f53\u68c0\u767b\u8bb0\u8868")
    public ResponseData insertCheckupRegForm(@RequestBody CheckupRegForm param) {
        try {
            return this.outpatientServiceFeign.insertCheckupRegForm(param);
        }
        catch (Exception ex) {
            return ResponseData.error((String)("\u67e5\u8be2\u5931\u8d25\uff1a" + ex.getMessage()));
        }
    }

    @GetMapping(value={"/CheckupMainRecord"})
    @ApiOperation(value="\u67e5\u8be2\u5065\u5eb7\u8bb0\u5f55")
    public ResponseData CheckupMainRecord(String idCard) {
        try {
            return ResponseData.success((Object)this.outpatientServiceFeign.CheckupMainRecord(idCard));
        }
        catch (Exception ex) {
            return ResponseData.error((String)("\u67e5\u8be2\u5931\u8d25\uff1a" + ex.getMessage()));
        }
    }

    @GetMapping(value={"/findOneByIdCardNumber"})
    @ApiOperation(value="\u6839\u636e\u8bc1\u4ef6\u53f7\u67e5\u8be2\u5355\u6761\u6570\u636e")
    public ResponseData findOneByIdCardNumber(String idCardNumber) {
        try {
            return this.outpatientServiceFeign.findOneByIdCardNumber(idCardNumber);
        }
        catch (Exception ex) {
            return ResponseData.error((String)("\u67e5\u8be2\u5931\u8d25\uff1a" + ex.getMessage()));
        }
    }

    public static MultipartFile base64ToMultipart(String base64Str, String fileName, String contentType) {
        try {
            byte[] decode = Base64.getDecoder().decode(base64Str);
            String s = new String(decode);
            String base64Data = s.contains(",") ? s.split(",")[1] : s;
            byte[] bytes = new BASE64Decoder().decodeBuffer(base64Data);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            return new MockMultipartFile(fileName, fileName, contentType, (InputStream)inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException("base64 \u8f6c MultipartFile \u5931\u8d25" + e.getMessage());
        }
    }

    public String savePdfData(CheckupDataDTO inParam) {
        String idnumber = inParam.getSfz().getIdnumber();
        String birthday = "";
        if (StrUtil.isNotBlank((CharSequence)idnumber)) {
            String birth = idnumber.substring(6, 14);
            birthday = birth.substring(0, 4) + "-" + birth.substring(4, 6) + "-" + birth.substring(6, 8);
        }
        PatientRecordDto patientRecordDto = new PatientRecordDto();
        patientRecordDto.setName(inParam.getSfz().getName());
        patientRecordDto.setName1(inParam.getSfz().getName());
        patientRecordDto.setAge(inParam.getSfz().getAge());
        patientRecordDto.setBirthday(birthday);
        patientRecordDto.setCreate_time(DateUtil.formatDate((Date)new Date()));
        patientRecordDto.setCreate_time1(DateUtil.formatDate((Date)new Date()));
        patientRecordDto.setDiagnosisTime(DateUtil.formatDate((Date)new Date()));
        patientRecordDto.setFamc2("\u80f0\u5c9b\u7d20\u6cbb\u7597");
        patientRecordDto.setJcjy2("\u5e94\u76d1\u6d4b\u7a7a\u8179\u8840\u7cd6\uff0c\u5f53\u6000\u7591\u6709\u4f4e\u8840\u7cd6\u65f6\uff0c\u5e94\u968f\u65f6\u52a0\u6d4b\u8840\u7cd6\uff1b\u5982\u4f7f\u7528\u9884\u6df7\u80f0\u5c9b\u7d20\u6cbb\u7597\uff0c\u5e94\u52a0\u6d4b\u665a\u9910\u524d\u8840\u7cd6");
        patientRecordDto.setJstnbjkjy("1");
        patientRecordDto.setKfjtyzl("1");
        patientRecordDto.setNxgbb("0");
        patientRecordDto.setSex(inParam.getSfz().getSex());
        patientRecordDto.setSex_name("\u7537".equals(inParam.getSfz().getSex()) ? "\u5148\u751f" : "\u5973\u58eb");
        patientRecordDto.setSmoke("1");
        patientRecordDto.setSthdsp("1");
        patientRecordDto.setTnbsb("1");
        patientRecordDto.setTnbyb("1");
        patientRecordDto.setTnbzb("1");
        patientRecordDto.setTnbzwsjbb("1");
        patientRecordDto.setTnbzwxgbb("1");
        patientRecordDto.setType("2");
        patientRecordDto.setXxgbb("2");
        patientRecordDto.setYdszl("1");
        patientRecordDto.setYdxg("1");
        patientRecordDto.setYj("1");
        patientRecordDto.setYyjsjnbjkgl("1");
        String url = "https://data-center.scrmzk.com/api/patientRecord/generatePatientRecord";
        String jsonBody = com.alibaba.fastjson.JSONObject.toJSONString((Object)patientRecordDto);
        log.info("\u751f\u6210\u667a\u80fd\u7ba1\u7406pdf\u5165\u53c2\uff1a{}", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)patientRecordDto));
        HttpResponse response = ((HttpRequest)HttpRequest.post((String)url).body(jsonBody).header("Content-Type", "application/json")).execute();
        byte[] pdfBytes = response.bodyBytes();
        try {
            MockMultipartFile multipartFile = new MockMultipartFile("file", "zngl_" + System.currentTimeMillis() + ".pdf", "application/pdf", (InputStream)new ByteArrayInputStream(pdfBytes));
            JSONObject ecg12UploadResult = this.minioUtil.upload((MultipartFile)multipartFile);
            return ecg12UploadResult.getStr((Object)"url");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

