/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.controller.netHospital;

import com.alibaba.nacos.common.utils.StringUtils;
import com.byh.sdk.entity.netHospital.dto.QueryDTO;
import com.byh.sdk.entity.netHospital.dto.SysDrugStatisticsEntity;
import com.byh.sdk.feign.sys.OutpatientServiceFeign;
import com.byh.sdk.feign.sys.SysServiceFeign;
import com.byh.sdk.util.ResponseData;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/drugStatistics"})
public class DrugStatisticsController {
    @Autowired
    private SysServiceFeign sysServiceFeign;
    @Autowired
    private OutpatientServiceFeign outpatientServiceFeign;

    @ApiOperation(value="\u7edf\u8ba1\u836f\u54c1\u521d\u59cb\u5316")
    @GetMapping(value={"/drugInfo"})
    public ResponseData drugInfo() {
        return this.sysServiceFeign.QueryDrugInfo();
    }

    @GetMapping(value={"/drugSell"})
    public ResponseData drugSell() {
        List list = (List)this.sysServiceFeign.QueryDrugInfo().getData();
        List strList = list.stream().map(SysDrugStatisticsEntity::getDrugsId).collect(Collectors.toList());
        String drugsId = StringUtils.join(strList, (String)",");
        return this.outpatientServiceFeign.QueryDrugSell(drugsId);
    }

    @PostMapping(value={"/purchaseMedicine"})
    public ResponseData purchaseMedicine(@RequestBody QueryDTO dto) {
        return this.outpatientServiceFeign.purchaseMedicine(dto);
    }

    @PostMapping(value={"/list"})
    public ResponseData selectDrugList(@RequestBody QueryDTO dto) {
        return this.outpatientServiceFeign.selectDrugList(dto);
    }

    @GetMapping(value={"/selectPatientList"})
    public ResponseData selectPatientList() {
        List list = (List)this.sysServiceFeign.QueryDrugInfo().getData();
        List strList = list.stream().map(SysDrugStatisticsEntity::getDrugsId).collect(Collectors.toList());
        String drugsId = StringUtils.join(strList, (String)",");
        return this.outpatientServiceFeign.selectPatientList(drugsId);
    }
}

