/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.controller.selfHelp;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.byh.sdk.entity.admission.AdmissionEntity;
import com.byh.sdk.entity.department.SysDepartmentDTO;
import com.byh.sdk.entity.doctor.DoctorTypeDto;
import com.byh.sdk.entity.doctor.SysDoctorDto;
import com.byh.sdk.entity.drug.SysDictValueDTO;
import com.byh.sdk.entity.order.FeeBillCreationDto;
import com.byh.sdk.entity.order.HsPayDto;
import com.byh.sdk.entity.order.HsPreparePayDto;
import com.byh.sdk.entity.order.HsRefundDto;
import com.byh.sdk.entity.order.PayDto;
import com.byh.sdk.entity.order.PayRefundDto;
import com.byh.sdk.entity.order.QueryFeeDetailsDto;
import com.byh.sdk.entity.order.QueryFeeDetailsListDto;
import com.byh.sdk.entity.order.QueryFeeDetailsVo;
import com.byh.sdk.entity.outpatientType.QueryOutpatientTypeDto;
import com.byh.sdk.entity.selfHelp.DeptInfo;
import com.byh.sdk.entity.selfHelp.DoctorInfo;
import com.byh.sdk.entity.selfHelp.ItemInfo;
import com.byh.sdk.entity.selfHelp.dto.PatientInfoDTO;
import com.byh.sdk.entity.selfHelp.dto.PaymentRecordsDto;
import com.byh.sdk.entity.selfHelp.dto.QueryRecordDto;
import com.byh.sdk.entity.selfHelp.dto.QueryScheduleRecordDto;
import com.byh.sdk.entity.selfHelp.dto.QuickTreatementDto;
import com.byh.sdk.entity.selfHelp.dto.SysDrugDto;
import com.byh.sdk.entity.selfHelp.dto.SysInvoiceDto;
import com.byh.sdk.entity.selfHelp.dto.SysTreatmentItemDto;
import com.byh.sdk.feign.sys.HsServiceFeign;
import com.byh.sdk.feign.sys.OutpatientServiceFeign;
import com.byh.sdk.feign.sys.SysServiceFeign;
import com.byh.sdk.hsModel.request.PatientInfoRequest;
import com.byh.sdk.hsModel.respones.HsBaseResponse;
import com.byh.sdk.service.DepartmentService;
import com.byh.sdk.service.OrdSeeDoctorRecordService;
import com.byh.sdk.util.AesEncryptUtils;
import com.byh.sdk.util.ExceptionUtil;
import com.byh.sdk.util.ResponseData;
import com.byh.sdk.util.Result;
import io.swagger.annotations.ApiOperation;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/selfHelp"})
public class DataPushController {
    private static Logger logger = LoggerFactory.getLogger(DataPushController.class);
    private static final String KEY = "7S5TDKu9cRNmckAZ8s1pWA==";
    private final SysServiceFeign sysServiceFeign;
    private final OutpatientServiceFeign outpatientServiceFeign;
    private final DepartmentService departmentService;
    private final OrdSeeDoctorRecordService ordSeeDoctorRecordService;
    private final HsServiceFeign hsServiceFeign;

    @ApiOperation(value="\u30101101\u3011\u533b\u4fdd\u83b7\u53d6\u60a3\u8005\u53c2\u4fdd\u4fe1\u606f")
    @PostMapping(value={"/inusrPatientInfo"})
    public Result PatientInfo(@RequestBody JSONObject jsonObject) {
        try {
            if (!jsonObject.containsKey((Object)"dataEncryption")) {
                return Result.error((String)"\u672a\u83b7\u53d6\u5230\u5165\u53c2\uff1a dataEncryption");
            }
            String dataEncryption = jsonObject.getString("dataEncryption");
            String s1 = AesEncryptUtils.decryptNew((String)dataEncryption, (String)KEY);
            logger.info("\u81ea\u52a9\u673a1101\u65b9\u6cd5,\u5165\u53c2: {}", (Object)s1);
            PatientInfoRequest patientInfoRequest = (PatientInfoRequest)JSON.parseObject((String)s1, PatientInfoRequest.class);
            patientInfoRequest.setTenantId(Integer.valueOf(1));
            ResponseData responseData = this.hsServiceFeign.hsPatientInfo(patientInfoRequest);
            logger.info("\u81ea\u52a9\u673a1101\u65b9\u6cd5,\u51fa\u53c2: {}", (Object)JSONObject.toJSONString((Object)responseData));
            if (!responseData.isSuccess()) {
                logger.info("\u81ea\u52a9\u673a1101\u65b9\u6cd5,\u9519\u8bef\u51fa\u53c2:{}", (Object)((HsBaseResponse)responseData.getData()).getErr_msg());
                return Result.error((String)((HsBaseResponse)responseData.getData()).getErr_msg());
            }
            String s = AesEncryptUtils.encryptNew((String)JSON.toJSONString((Object)responseData.getData()), (String)KEY);
            return Result.success((Object)s);
        }
        catch (Exception e) {
            return ExceptionUtil.handleException((Exception)e);
        }
    }

    @PostMapping(value={"/getDeptInfo"})
    @DS(value="mysql")
    public Result getDeptInfo(@RequestBody JSONObject jsonObject) {
        try {
            if (!jsonObject.containsKey((Object)"dataEncryption")) {
                return Result.error((String)"\u672a\u83b7\u53d6\u5230\u5165\u53c2\uff1a dataEncryption");
            }
            String dataEncryption = jsonObject.getString("dataEncryption");
            String s1 = AesEncryptUtils.decryptNew((String)dataEncryption, (String)KEY);
            logger.info("\u81ea\u52a9\u673a getDeptInfo \u65b9\u6cd5,\u5165\u53c2: {}", (Object)s1);
            DeptInfo deptInfo = (DeptInfo)JSON.parseObject((String)s1, DeptInfo.class);
            logger.info("\u89e3\u5bc6{}", (Object)deptInfo);
            List list = this.departmentService.getDeptInfo(deptInfo);
            logger.info("\u81ea\u52a9\u673a getDeptInfo \u65b9\u6cd5,\u51fa\u53c2: {}", (Object)list);
            String s = AesEncryptUtils.encryptNew((String)JSON.toJSONString((Object)list), (String)KEY);
            return Result.success((Object)s);
        }
        catch (Exception e) {
            return ExceptionUtil.handleException((Exception)e);
        }
    }

    @PostMapping(value={"/getDoctorInfo"})
    public Result getDoctorInfo(@RequestBody JSONObject jsonObject) {
        try {
            String deptCode;
            if (!jsonObject.containsKey((Object)"dataEncryption")) {
                return Result.error((String)"\u672a\u83b7\u53d6\u5230\u5165\u53c2\uff1a dataEncryption");
            }
            String dataEncryption = jsonObject.getString("dataEncryption");
            String s1 = AesEncryptUtils.decryptNew((String)dataEncryption, (String)KEY);
            logger.info("\u81ea\u52a9\u673a getDoctorInfo \u65b9\u6cd5,\u5165\u53c2: {}", (Object)s1);
            DoctorInfo doctorInfo = (DoctorInfo)JSON.parseObject((String)s1, DoctorInfo.class);
            SysDoctorDto dto = new SysDoctorDto();
            String doctorCode = doctorInfo.getDoctorCode();
            if (StrUtil.isNotEmpty((CharSequence)doctorCode)) {
                dto.setId(Integer.valueOf(doctorCode));
            }
            if (StrUtil.isNotEmpty((CharSequence)(deptCode = doctorInfo.getDeptCode()))) {
                dto.setDepartmentId(deptCode);
            }
            ResponseData responseData = this.sysServiceFeign.getDoctorInfo(dto);
            List data = (List)responseData.getData();
            logger.info("\u81ea\u52a9\u673a getDoctorInfo \u65b9\u6cd5,\u51fa\u53c2: {}", responseData.getData());
            String s = AesEncryptUtils.encryptNew((String)JSON.toJSONString((Object)data), (String)KEY);
            logger.info(s);
            return Result.success((Object)s);
        }
        catch (Exception e) {
            return ExceptionUtil.handleException((Exception)e);
        }
    }

    @PostMapping(value={"/getCommodityPrice"})
    @DS(value="mysql")
    public Result getCommodityPrice(@RequestBody JSONObject jsonObject) {
        try {
            if (!jsonObject.containsKey((Object)"dataEncryption")) {
                return Result.error((String)"\u672a\u83b7\u53d6\u5230\u5165\u53c2\uff1a dataEncryption");
            }
            String dataEncryption = jsonObject.getString("dataEncryption");
            String s1 = AesEncryptUtils.decryptNew((String)dataEncryption, (String)KEY);
            logger.info("\u81ea\u52a9\u673a getCommodityPrice \u65b9\u6cd5,\u5165\u53c2: {}", (Object)s1);
            ItemInfo itemInfo = (ItemInfo)JSON.parseObject((String)s1, ItemInfo.class);
            String itemType = itemInfo.getItemType();
            if ("1".equals(itemType)) {
                SysTreatmentItemDto dto = new SysTreatmentItemDto();
                dto.setSearch(itemInfo.getSearchCode());
                dto.setCurrent(1);
                dto.setSize(-1);
                ResponseData responseData = this.sysServiceFeign.getCommodityPrice(dto);
                logger.info("\u81ea\u52a9\u673a getCommodityPrice \u65b9\u6cd5,\u51fa\u53c2: {}", responseData.getData());
                String s = AesEncryptUtils.encryptNew((String)JSON.toJSONString((Object)responseData.getData()), (String)KEY);
                return Result.success((Object)s);
            }
            if ("2".equals(itemType)) {
                SysDrugDto dto = new SysDrugDto();
                dto.setSearch(itemInfo.getSearchCode());
                ResponseData responseData = this.sysServiceFeign.getCommodityPriceDrug(dto);
                String s = AesEncryptUtils.encryptNew((String)JSON.toJSONString((Object)responseData.getData()), (String)KEY);
                return Result.success((Object)s);
            }
            return Result.error((String)"\u67e5\u8be2\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        catch (Exception e) {
            return ExceptionUtil.handleException((Exception)e);
        }
    }

    @PostMapping(value={"/getIncInfo"})
    public Result getIncInfo(@RequestBody JSONObject jsonObject) {
        try {
            if (!jsonObject.containsKey((Object)"dataEncryption")) {
                return Result.error((String)"\u672a\u83b7\u53d6\u5230\u5165\u53c2\uff1a dataEncryption");
            }
            String dataEncryption = jsonObject.getString("dataEncryption");
            String s1 = AesEncryptUtils.decryptNew((String)dataEncryption, (String)KEY);
            SysInvoiceDto dto = (SysInvoiceDto)JSON.parseObject((String)s1, SysInvoiceDto.class);
            ResponseData incInfo = this.sysServiceFeign.getIncInfo(dto);
            List records = (List)incInfo.getData();
            logger.info("\u81ea\u52a9\u673a getIncInfo \u65b9\u6cd5,\u5165\u53c2: {}", (Object)s1);
            logger.info("\u81ea\u52a9\u673a getIncInfo \u65b9\u6cd5,\u51fa\u53c2: {}", incInfo.getData());
            String s = AesEncryptUtils.encryptNew((String)JSON.toJSONString((Object)records), (String)KEY);
            return Result.success((Object)s);
        }
        catch (Exception e) {
            return ExceptionUtil.handleException((Exception)e);
        }
    }

    @PostMapping(value={"/getHpSettlement"})
    public Result getHpSettlement(@RequestBody JSONObject jsonObject) {
        try {
            if (!jsonObject.containsKey((Object)"dataEncryption")) {
                return Result.error((String)"\u672a\u83b7\u53d6\u5230\u5165\u53c2\uff1a dataEncryption");
            }
            String dataEncryption = jsonObject.getString("dataEncryption");
            String s1 = AesEncryptUtils.decryptNew((String)dataEncryption, (String)KEY);
            logger.info("\u81ea\u52a9\u673a getHpSettlement \u65b9\u6cd5,\u5165\u53c2: {}", (Object)s1);
            PaymentRecordsDto dto = (PaymentRecordsDto)JSON.parseObject((String)s1, PaymentRecordsDto.class);
            dto.setCurrent(Integer.valueOf(1));
            dto.setSize(Integer.valueOf(20));
            dto.setTenantId(Integer.valueOf(1));
            ResponseData responseData = this.outpatientServiceFeign.getHpSettlement(dto);
            List records = (List)responseData.getData();
            logger.info("\u81ea\u52a9\u673a getHpSettlement \u65b9\u6cd5,\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)records));
            String s = AesEncryptUtils.encryptNew((String)JSON.toJSONString((Object)records), (String)KEY);
            return Result.success((Object)s);
        }
        catch (Exception e) {
            return ExceptionUtil.handleException((Exception)e);
        }
    }

    @PostMapping(value={"/getDeptSchedule"})
    @DS(value="mysql3")
    public Result getDeptSchedule(@RequestBody JSONObject jsonObject) {
        try {
            if (!jsonObject.containsKey((Object)"dataEncryption")) {
                return Result.error((String)"\u672a\u83b7\u53d6\u5230\u5165\u53c2\uff1a dataEncryption");
            }
            String dataEncryption = jsonObject.getString("dataEncryption");
            String s1 = AesEncryptUtils.decryptNew((String)dataEncryption, (String)KEY);
            logger.info("\u81ea\u52a9\u673a getDeptSchedule \u65b9\u6cd5,\u5165\u53c2: {}", (Object)s1);
            QueryScheduleRecordDto dto = (QueryScheduleRecordDto)JSON.parseObject((String)s1, QueryScheduleRecordDto.class);
            List records = this.ordSeeDoctorRecordService.getScheduleRecord(dto);
            logger.info("\u81ea\u52a9\u673a getDeptSchedule \u65b9\u6cd5,\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)records));
            String s = AesEncryptUtils.encryptNew((String)JSON.toJSONString((Object)records), (String)KEY);
            return Result.success((Object)s);
        }
        catch (Exception e) {
            return ExceptionUtil.handleException((Exception)e);
        }
    }

    @PostMapping(value={"/getScheduleInfo"})
    public Result getScheduleInfo(@RequestBody JSONObject jsonObject) {
        try {
            if (!jsonObject.containsKey((Object)"dataEncryption")) {
                return Result.error((String)"\u672a\u83b7\u53d6\u5230\u5165\u53c2\uff1a dataEncryption");
            }
            String dataEncryption = jsonObject.getString("dataEncryption");
            String s1 = AesEncryptUtils.decryptNew((String)dataEncryption, (String)KEY);
            logger.info("\u81ea\u52a9\u673a getScheduleInfo \u65b9\u6cd5,\u5165\u53c2: {}", (Object)s1);
            QueryScheduleRecordDto dto = (QueryScheduleRecordDto)JSON.parseObject((String)s1, QueryScheduleRecordDto.class);
            ResponseData scheduleInfo = null;
            scheduleInfo = StrUtil.isEmptyIfStr((Object)dto) ? this.outpatientServiceFeign.getScheduleInfo(new QueryScheduleRecordDto()) : this.outpatientServiceFeign.getScheduleInfo(dto);
            List records = (List)scheduleInfo.getData();
            logger.info("\u81ea\u52a9\u673a getScheduleInfo \u65b9\u6cd5,\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)records));
            String s = AesEncryptUtils.encryptNew((String)JSON.toJSONString((Object)records), (String)KEY);
            return Result.success((Object)s);
        }
        catch (Exception e) {
            return ExceptionUtil.handleException((Exception)e);
        }
    }

    @PostMapping(value={"/getPapers"})
    public Result getPapers(@RequestBody JSONObject jsonObject) {
        try {
            if (!jsonObject.containsKey((Object)"dataEncryption")) {
                return Result.error((String)"\u672a\u83b7\u53d6\u5230\u5165\u53c2\uff1a dataEncryption");
            }
            String dataEncryption = jsonObject.getString("dataEncryption");
            String s1 = AesEncryptUtils.decryptNew((String)dataEncryption, (String)KEY);
            logger.info("\u81ea\u52a9\u673agetPapers\u65b9\u6cd5,\u5165\u53c2: {}", (Object)s1);
            SysDictValueDTO dto = (SysDictValueDTO)JSON.parseObject((String)s1, SysDictValueDTO.class);
            dto.setType("id_card_type");
            ResponseData responseData = this.sysServiceFeign.valueQuery(dto);
            List data = (List)responseData.getData();
            logger.info("\u81ea\u52a9\u673agetPapers\u65b9\u6cd5,\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)responseData.getData()));
            String s = AesEncryptUtils.encryptNew((String)JSON.toJSONString((Object)data), (String)KEY);
            return Result.success((Object)s);
        }
        catch (Exception e) {
            return ExceptionUtil.handleException((Exception)e);
        }
    }

    @PostMapping(value={"/getMedicalInsurance"})
    public Result getMedicalInsurance(@RequestBody JSONObject jsonObject) {
        try {
            if (!jsonObject.containsKey((Object)"dataEncryption")) {
                return Result.error((String)"\u672a\u83b7\u53d6\u5230\u5165\u53c2\uff1a dataEncryption");
            }
            String dataEncryption = jsonObject.getString("dataEncryption");
            String s1 = AesEncryptUtils.decryptNew((String)dataEncryption, (String)KEY);
            logger.info("\u81ea\u52a9\u673agetMedicalInsurance\u65b9\u6cd5,\u5165\u53c2: {}", (Object)s1);
            SysDictValueDTO dto = (SysDictValueDTO)JSON.parseObject((String)s1, SysDictValueDTO.class);
            dto.setType("medical_insurance_type");
            ResponseData responseData = this.sysServiceFeign.valueQuery(dto);
            List data = (List)responseData.getData();
            logger.info("\u81ea\u52a9\u673agetMedicalInsurance\u65b9\u6cd5,\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)responseData.getData()));
            String s = AesEncryptUtils.encryptNew((String)JSON.toJSONString((Object)data), (String)KEY);
            return Result.success((Object)s);
        }
        catch (Exception e) {
            return ExceptionUtil.handleException((Exception)e);
        }
    }

    @PostMapping(value={"/getMedicalCategory"})
    public Result getMedicalCategory(@RequestBody JSONObject jsonObject) {
        try {
            if (!jsonObject.containsKey((Object)"dataEncryption")) {
                return Result.error((String)"\u672a\u83b7\u53d6\u5230\u5165\u53c2\uff1a dataEncryption");
            }
            String dataEncryption = jsonObject.getString("dataEncryption");
            String s1 = AesEncryptUtils.decryptNew((String)dataEncryption, (String)KEY);
            logger.info("\u81ea\u52a9\u673agetMedicalCategory\u65b9\u6cd5,\u5165\u53c2: {}", (Object)s1);
            SysDictValueDTO dto = (SysDictValueDTO)JSON.parseObject((String)s1, SysDictValueDTO.class);
            dto.setType("med_type");
            ResponseData responseData = this.sysServiceFeign.valueQuery(dto);
            List data = (List)responseData.getData();
            logger.info("\u81ea\u52a9\u673agetMedicalCategory\u65b9\u6cd5,\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)responseData.getData()));
            String s = AesEncryptUtils.encryptNew((String)JSON.toJSONString((Object)data), (String)KEY);
            return Result.success((Object)s);
        }
        catch (Exception e) {
            return ExceptionUtil.handleException((Exception)e);
        }
    }

    @PostMapping(value={"/getOutpatientType"})
    public Result getOutpatientType(@RequestBody JSONObject jsonObject) {
        try {
            if (!jsonObject.containsKey((Object)"dataEncryption")) {
                return Result.error((String)"\u672a\u83b7\u53d6\u5230\u5165\u53c2\uff1a dataEncryption");
            }
            String dataEncryption = jsonObject.getString("dataEncryption");
            String s1 = AesEncryptUtils.decryptNew((String)dataEncryption, (String)KEY);
            logger.info("\u81ea\u52a9\u673agetOutpatientType\u65b9\u6cd5,\u5165\u53c2: {}", (Object)s1);
            QueryOutpatientTypeDto dto = (QueryOutpatientTypeDto)JSON.parseObject((String)s1, QueryOutpatientTypeDto.class);
            ArrayList<Integer> deptIds = new ArrayList<Integer>();
            deptIds.add(8);
            dto.setDeptIds(deptIds);
            ResponseData responseData = this.outpatientServiceFeign.getOutpatientType(dto);
            List data = (List)responseData.getData();
            String s = AesEncryptUtils.encryptNew((String)JSON.toJSONString((Object)data), (String)KEY);
            return Result.success((Object)s);
        }
        catch (Exception e) {
            return ExceptionUtil.handleException((Exception)e);
        }
    }

    @PostMapping(value={"/getDept"})
    public Result getDept(@RequestBody JSONObject jsonObject) {
        try {
            if (!jsonObject.containsKey((Object)"dataEncryption")) {
                return Result.error((String)"\u672a\u83b7\u53d6\u5230\u5165\u53c2\uff1a dataEncryption");
            }
            String dataEncryption = jsonObject.getString("dataEncryption");
            String s1 = AesEncryptUtils.decryptNew((String)dataEncryption, (String)KEY);
            logger.info("\u81ea\u52a9\u673agetDept\u65b9\u6cd5,\u5165\u53c2: {}", (Object)s1);
            SysDepartmentDTO dto = (SysDepartmentDTO)JSON.parseObject((String)s1, SysDepartmentDTO.class);
            dto.setSize(-1);
            dto.setDepartmentType("0");
            ResponseData responseData = this.sysServiceFeign.valueQuery(dto);
            List data = (List)responseData.getData();
            String s = AesEncryptUtils.encryptNew((String)JSON.toJSONString((Object)data), (String)KEY);
            return Result.success((Object)s);
        }
        catch (Exception e) {
            return ExceptionUtil.handleException((Exception)e);
        }
    }

    @PostMapping(value={"/getDoctor"})
    public Result getDoctor(@RequestBody JSONObject jsonObject) {
        try {
            if (!jsonObject.containsKey((Object)"dataEncryption")) {
                return Result.error((String)"\u672a\u83b7\u53d6\u5230\u5165\u53c2\uff1a dataEncryption");
            }
            String dataEncryption = jsonObject.getString("dataEncryption");
            String s1 = AesEncryptUtils.decryptNew((String)dataEncryption, (String)KEY);
            logger.info("\u81ea\u52a9\u673agetDoctor\u65b9\u6cd5,\u5165\u53c2: {}", (Object)s1);
            SysDoctorDto dto = (SysDoctorDto)JSON.parseObject((String)s1, SysDoctorDto.class);
            dto.setType("0");
            ResponseData responseData = this.sysServiceFeign.doctorQuery(dto);
            String s = AesEncryptUtils.encryptNew((String)JSON.toJSONString((Object)responseData.getData()), (String)KEY);
            return Result.success((Object)s);
        }
        catch (Exception e) {
            return ExceptionUtil.handleException((Exception)e);
        }
    }

    @PostMapping(value={"/outpatientRegistration"})
    public Result outpatientRegistration(@RequestBody JSONObject jsonObject) {
        try {
            if (!jsonObject.containsKey((Object)"dataEncryption")) {
                return Result.error((String)"\u672a\u83b7\u53d6\u5230\u5165\u53c2\uff1a dataEncryption");
            }
            String dataEncryption = jsonObject.getString("dataEncryption");
            String s1 = AesEncryptUtils.decryptNew((String)dataEncryption, (String)KEY);
            QuickTreatementDto dto = (QuickTreatementDto)JSON.parseObject((String)s1, QuickTreatementDto.class);
            Integer opter = dto != null ? dto.getOperatorId() : null;
            String opterString = opter != null ? opter.toString() : "";
            logger.info("\u81ea\u52a9\u673a{}outpatientRegistration\u65b9\u6cd5,\u5165\u53c2: {}", (Object)opterString, (Object)s1);
            ResponseData responseData = this.outpatientServiceFeign.outpatientRegistration(dto);
            if (!"200".equals(responseData.getCode())) {
                logger.info("\u81ea\u52a9\u673a{}outpatientRegistration\u65b9\u6cd5,\u9519\u8bef\u51fa\u53c2:{}", (Object)opterString, (Object)responseData.getMsg());
                return Result.error((String)responseData.getMsg());
            }
            logger.info("\u81ea\u52a9\u673a{}outpatientRegistration\u65b9\u6cd5,\u51fa\u53c2: {}", (Object)opterString, (Object)JSON.toJSONString((Object)responseData.getData()));
            String s = AesEncryptUtils.encryptNew((String)JSON.toJSONString((Object)responseData.getData()), (String)KEY);
            return Result.success((Object)s);
        }
        catch (Exception e) {
            return ExceptionUtil.handleException((Exception)e);
        }
    }

    @PostMapping(value={"/createPatient"})
    public Result createPatient(@RequestBody JSONObject jsonObject) {
        try {
            if (!jsonObject.containsKey((Object)"dataEncryption")) {
                return Result.error((String)"\u672a\u83b7\u53d6\u5230\u5165\u53c2\uff1a dataEncryption");
            }
            String dataEncryption = jsonObject.getString("dataEncryption");
            String s1 = AesEncryptUtils.decryptNew((String)dataEncryption, (String)KEY);
            logger.info("\u81ea\u52a9\u673acreatePatient\u65b9\u6cd5,\u5165\u53c2: {}", (Object)s1);
            QuickTreatementDto dto = (QuickTreatementDto)JSON.parseObject((String)s1, QuickTreatementDto.class);
            ResponseData responseData = this.outpatientServiceFeign.createPatient(dto);
            if (!"200".equals(responseData.getCode())) {
                return Result.error((String)responseData.getMsg());
            }
            logger.info("\u81ea\u52a9\u673acreatePatient\u65b9\u6cd5,\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)responseData.getData()));
            String s = AesEncryptUtils.encryptNew((String)JSON.toJSONString((Object)responseData.getData()), (String)KEY);
            return Result.success((Object)s);
        }
        catch (Exception e) {
            return ExceptionUtil.handleException((Exception)e);
        }
    }

    @PostMapping(value={"/orderCharge"})
    public Result orderCharge(@RequestBody JSONObject jsonObject) {
        try {
            if (!jsonObject.containsKey((Object)"dataEncryption")) {
                return Result.error((String)"\u672a\u83b7\u53d6\u5230\u5165\u53c2\uff1a dataEncryption");
            }
            String dataEncryption = jsonObject.getString("dataEncryption");
            String s1 = AesEncryptUtils.decryptNew((String)dataEncryption, (String)KEY);
            FeeBillCreationDto dto = (FeeBillCreationDto)JSON.parseObject((String)s1, FeeBillCreationDto.class);
            Integer opter = dto != null ? dto.getOperatorId() : null;
            String opterString = opter != null ? opter.toString() : "";
            logger.info("\u81ea\u52a9\u673a{}orderCharge\u65b9\u6cd5,\u5165\u53c2: {}", (Object)opterString, (Object)s1);
            ResponseData responseData = this.outpatientServiceFeign.orderCharge(dto);
            if (!"200".equals(responseData.getCode())) {
                logger.info("\u81ea\u52a9\u673a{}orderCharge\u65b9\u6cd5,\u9519\u8bef\u51fa\u53c2:{}", (Object)opterString, (Object)responseData.getMsg());
                return Result.error((String)responseData.getMsg());
            }
            logger.info("\u81ea\u52a9\u673a{}orderCharge\u65b9\u6cd5,\u51fa\u53c2: {}", (Object)opterString, (Object)JSON.toJSONString((Object)responseData.getData()));
            String s = AesEncryptUtils.encryptNew((String)JSON.toJSONString((Object)responseData.getData()), (String)KEY);
            return Result.success((Object)s);
        }
        catch (Exception e) {
            return ExceptionUtil.handleException((Exception)e);
        }
    }

    @PostMapping(value={"/queryChargeItem"})
    public Result queryChargeItem(@RequestBody JSONObject jsonObject) {
        try {
            if (!jsonObject.containsKey((Object)"dataEncryption")) {
                return Result.error((String)"\u672a\u83b7\u53d6\u5230\u5165\u53c2\uff1a dataEncryption");
            }
            String dataEncryption = jsonObject.getString("dataEncryption");
            String s1 = AesEncryptUtils.decryptNew((String)dataEncryption, (String)KEY);
            logger.info("\u81ea\u52a9\u673aqueryChargeItem\u65b9\u6cd5,\u5165\u53c2: {}", (Object)s1);
            QueryFeeDetailsDto dto = (QueryFeeDetailsDto)JSON.parseObject((String)s1, QueryFeeDetailsDto.class);
            ResponseData responseData = this.outpatientServiceFeign.queryChargeItem(dto);
            logger.info("\u81ea\u52a9\u673aqueryChargeItem\u65b9\u6cd5,\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)responseData.getData()));
            QueryFeeDetailsVo data = (QueryFeeDetailsVo)responseData.getData();
            String s = AesEncryptUtils.encryptNew((String)JSON.toJSONString((Object)data), (String)KEY);
            return Result.success((Object)s);
        }
        catch (Exception e) {
            return ExceptionUtil.handleException((Exception)e);
        }
    }

    @PostMapping(value={"/paymentRecords"})
    public Result paymentRecords(@RequestBody JSONObject jsonObject) {
        try {
            if (!jsonObject.containsKey((Object)"dataEncryption")) {
                return Result.error((String)"\u672a\u83b7\u53d6\u5230\u5165\u53c2\uff1a dataEncryption");
            }
            String dataEncryption = jsonObject.getString("dataEncryption");
            String s1 = AesEncryptUtils.decryptNew((String)dataEncryption, (String)KEY);
            logger.info("\u81ea\u52a9\u673apaymentRecords\u65b9\u6cd5,\u5165\u53c2: {}", (Object)s1);
            PaymentRecordsDto dto = (PaymentRecordsDto)JSON.parseObject((String)s1, PaymentRecordsDto.class);
            ResponseData responseData = this.outpatientServiceFeign.paymentRecords(dto);
            logger.info("\u81ea\u52a9\u673apaymentRecords\u65b9\u6cd5,\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)responseData.getData()));
            String s = AesEncryptUtils.encryptNew((String)JSON.toJSONString((Object)responseData.getData()), (String)KEY);
            return Result.success((Object)s);
        }
        catch (Exception e) {
            return ExceptionUtil.handleException((Exception)e);
        }
    }

    @PostMapping(value={"/queryChargeItemDetails"})
    public Result queryChargeItemDetails(@RequestBody JSONObject jsonObject) {
        try {
            if (!jsonObject.containsKey((Object)"dataEncryption")) {
                return Result.error((String)"\u672a\u83b7\u53d6\u5230\u5165\u53c2\uff1a dataEncryption");
            }
            String dataEncryption = jsonObject.getString("dataEncryption");
            String s1 = AesEncryptUtils.decryptNew((String)dataEncryption, (String)KEY);
            logger.info("\u81ea\u52a9\u673aqueryChargeItemDetails\u65b9\u6cd5,\u5165\u53c2: {}", (Object)s1);
            QueryFeeDetailsListDto dto = (QueryFeeDetailsListDto)JSON.parseObject((String)s1, QueryFeeDetailsListDto.class);
            ResponseData responseData = this.outpatientServiceFeign.queryChargeItemDetails(dto);
            if (!"200".equals(responseData.getCode())) {
                return Result.error((String)responseData.getMsg());
            }
            logger.info("\u81ea\u52a9\u673aqueryChargeItemDetails\u65b9\u6cd5,\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)responseData.getData()));
            String s = AesEncryptUtils.encryptNew((String)JSON.toJSONString((Object)responseData.getData()), (String)KEY);
            return Result.success((Object)s);
        }
        catch (Exception e) {
            return ExceptionUtil.handleException((Exception)e);
        }
    }

    @PostMapping(value={"/doPayment"})
    public Result doPayment(@RequestBody JSONObject jsonObject) {
        try {
            if (!jsonObject.containsKey((Object)"dataEncryption")) {
                return Result.error((String)"\u672a\u83b7\u53d6\u5230\u5165\u53c2\uff1a dataEncryption");
            }
            String dataEncryption = jsonObject.getString("dataEncryption");
            String s1 = AesEncryptUtils.decryptNew((String)dataEncryption, (String)KEY);
            PayDto dto = (PayDto)JSON.parseObject((String)s1, PayDto.class);
            Integer opter = dto != null ? dto.getOperatorId() : null;
            String opterString = opter != null ? opter.toString() : "";
            logger.info("\u81ea\u52a9\u673a{}doPayment\u65b9\u6cd5,\u5165\u53c2: {}", (Object)opterString, (Object)s1);
            ResponseData responseData = this.outpatientServiceFeign.doPayment(dto);
            if (!"200".equals(responseData.getCode())) {
                logger.info("\u81ea\u52a9\u673a{}doPayment\u65b9\u6cd5,\u9519\u8bef\u51fa\u53c2:{}", (Object)opterString, (Object)responseData.getMsg());
                return Result.error((String)responseData.getMsg());
            }
            logger.info("\u81ea\u52a9\u673a{}doPayment\u65b9\u6cd5,\u51fa\u53c2: {}", (Object)opterString, (Object)JSON.toJSONString((Object)responseData.getData()));
            String s = AesEncryptUtils.encryptNew((String)JSON.toJSONString((Object)responseData.getData()), (String)KEY);
            return Result.success((Object)s);
        }
        catch (Exception e) {
            return ExceptionUtil.handleException((Exception)e);
        }
    }

    @PostMapping(value={"/queryPaymentRecordItems"})
    public Result queryPaymentRecordItems(@RequestBody JSONObject jsonObject) {
        try {
            if (!jsonObject.containsKey((Object)"dataEncryption")) {
                return Result.error((String)"\u672a\u83b7\u53d6\u5230\u5165\u53c2\uff1a dataEncryption");
            }
            String dataEncryption = jsonObject.getString("dataEncryption");
            String s1 = AesEncryptUtils.decryptNew((String)dataEncryption, (String)KEY);
            logger.info("\u81ea\u52a9\u673aqueryPaymentRecordItems\u65b9\u6cd5,\u5165\u53c2: {}", (Object)s1);
            QueryFeeDetailsListDto dto = (QueryFeeDetailsListDto)JSON.parseObject((String)s1, QueryFeeDetailsListDto.class);
            ResponseData responseData = this.outpatientServiceFeign.queryPaymentRecordItems(dto);
            if (!"200".equals(responseData.getCode())) {
                logger.info("\u81ea\u52a9\u673aqueryPaymentRecordItems\u65b9\u6cd5\u9519\u8bef\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)responseData));
                return Result.error((String)responseData.getMsg());
            }
            logger.info("\u81ea\u52a9\u673aqueryPaymentRecordItems\u65b9\u6cd5,\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)responseData.getData()));
            String s = AesEncryptUtils.encryptNew((String)JSON.toJSONString((Object)responseData.getData()), (String)KEY);
            return Result.success((Object)s);
        }
        catch (Exception e) {
            return ExceptionUtil.handleException((Exception)e);
        }
    }

    @PostMapping(value={"/doPayRefund"})
    public Result doPayRefund(@RequestBody JSONObject jsonObject) {
        try {
            if (!jsonObject.containsKey((Object)"dataEncryption")) {
                return Result.error((String)"\u672a\u83b7\u53d6\u5230\u5165\u53c2\uff1a dataEncryption");
            }
            String dataEncryption = jsonObject.getString("dataEncryption");
            String s1 = AesEncryptUtils.decryptNew((String)dataEncryption, (String)KEY);
            logger.info("\u81ea\u52a9\u673adoPayRefund\u65b9\u6cd5,\u5165\u53c2: {}", (Object)s1);
            PayRefundDto dto = (PayRefundDto)JSON.parseObject((String)s1, PayRefundDto.class);
            ResponseData responseData = this.outpatientServiceFeign.doPayRefund(dto);
            if (!"200".equals(responseData.getCode())) {
                return Result.error((String)responseData.getMsg());
            }
            logger.info("\u81ea\u52a9\u673adoPayRefund\u65b9\u6cd5,\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)responseData.getData()));
            String s = AesEncryptUtils.encryptNew((String)JSON.toJSONString((Object)responseData.getData()), (String)KEY);
            return Result.success((Object)s);
        }
        catch (Exception e) {
            return ExceptionUtil.handleException((Exception)e);
        }
    }

    @PostMapping(value={"/insurPreSettlement"})
    public Result insurPreSettlement(@RequestBody JSONObject jsonObject) {
        try {
            if (!jsonObject.containsKey((Object)"dataEncryption")) {
                return Result.error((String)"\u672a\u83b7\u53d6\u5230\u5165\u53c2\uff1a dataEncryption");
            }
            String dataEncryption = jsonObject.getString("dataEncryption");
            String s1 = AesEncryptUtils.decryptNew((String)dataEncryption, (String)KEY);
            HsPreparePayDto dto = (HsPreparePayDto)JSON.parseObject((String)s1, HsPreparePayDto.class);
            String opter = dto != null ? dto.getOpter() : "";
            logger.info("\u81ea\u52a9\u673a{}insurPreSettlement\u65b9\u6cd5,\u5165\u53c2: {}", (Object)opter, (Object)s1);
            ResponseData responseData = this.outpatientServiceFeign.insurPreSettlement(dto);
            if (!"200".equals(responseData.getCode())) {
                logger.info("\u81ea\u52a9\u673a{}insurPreSettlement\u65b9\u6cd5,\u9519\u8bef\u51fa\u53c2: {}", (Object)opter, (Object)responseData.getMsg());
                return Result.error((String)responseData.getMsg());
            }
            logger.info("\u81ea\u52a9\u673a{}insurPreSettlement\u65b9\u6cd5,\u51fa\u53c2: {}", (Object)opter, (Object)JSON.toJSONString((Object)responseData.getData()));
            String s = AesEncryptUtils.encryptNew((String)JSON.toJSONString((Object)responseData.getData()), (String)KEY);
            return Result.success((Object)s);
        }
        catch (Exception e) {
            return ExceptionUtil.handleException((Exception)e);
        }
    }

    @PostMapping(value={"/insurSettlement"})
    public Result insurSettlement(@RequestBody JSONObject jsonObject) {
        try {
            if (!jsonObject.containsKey((Object)"dataEncryption")) {
                return Result.error((String)"\u672a\u83b7\u53d6\u5230\u5165\u53c2\uff1a dataEncryption");
            }
            String dataEncryption = jsonObject.getString("dataEncryption");
            String s1 = AesEncryptUtils.decryptNew((String)dataEncryption, (String)KEY);
            HsPayDto dto = (HsPayDto)JSON.parseObject((String)s1, HsPayDto.class);
            String opter = dto != null ? dto.getOpter() : "";
            logger.info("\u81ea\u52a9\u673a{}insurSettlement\u65b9\u6cd5,\u5165\u53c2: {}", (Object)opter, (Object)s1);
            ResponseData responseData = this.outpatientServiceFeign.insurSettlement(dto, Integer.valueOf(1), Integer.valueOf(1), URLEncoder.encode("\u81ea\u52a9\u673a"));
            if (!"200".equals(responseData.getCode())) {
                logger.info("\u81ea\u52a9\u673a{}insurSettlement\u65b9\u6cd5,\u9519\u8bef\u51fa\u53c2:{}", (Object)opter, (Object)responseData.getMsg());
                return Result.error((String)responseData.getMsg());
            }
            logger.info("\u81ea\u52a9\u673a{}insurSettlement\u65b9\u6cd5,\u51fa\u53c2: {}", (Object)opter, (Object)JSON.toJSONString((Object)responseData.getData()));
            String s = AesEncryptUtils.encryptNew((String)JSON.toJSONString((Object)responseData.getData()), (String)KEY);
            return Result.success((Object)s);
        }
        catch (Exception e) {
            return ExceptionUtil.handleException((Exception)e);
        }
    }

    @PostMapping(value={"/insurRefund"})
    public Result insurRefund(@RequestBody JSONObject jsonObject) {
        try {
            if (!jsonObject.containsKey((Object)"dataEncryption")) {
                return Result.error((String)"\u672a\u83b7\u53d6\u5230\u5165\u53c2\uff1a dataEncryption");
            }
            String dataEncryption = jsonObject.getString("dataEncryption");
            String s1 = AesEncryptUtils.decryptNew((String)dataEncryption, (String)KEY);
            logger.info("\u81ea\u52a9\u673ainsurRefund\u65b9\u6cd5,\u5165\u53c2: {}", (Object)s1);
            HsRefundDto dto = (HsRefundDto)JSON.parseObject((String)s1, HsRefundDto.class);
            ResponseData responseData = this.outpatientServiceFeign.insurRefund(dto);
            if (!"200".equals(responseData.getCode())) {
                return Result.error((String)responseData.getMsg());
            }
            logger.info("\u81ea\u52a9\u673ainsurRefund\u65b9\u6cd5,\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)responseData.getData()));
            String s = AesEncryptUtils.encryptNew((String)JSON.toJSONString((Object)responseData.getData()), (String)KEY);
            return Result.success((Object)s);
        }
        catch (Exception e) {
            return ExceptionUtil.handleException((Exception)e);
        }
    }

    @PostMapping(value={"/getPatientInfo"})
    public Result getPatientInfo(@RequestBody JSONObject jsonObject) {
        try {
            if (!jsonObject.containsKey((Object)"dataEncryption")) {
                return Result.error((String)"\u672a\u83b7\u53d6\u5230\u5165\u53c2\uff1a dataEncryption");
            }
            String dataEncryption = jsonObject.getString("dataEncryption");
            String s1 = AesEncryptUtils.decryptNew((String)dataEncryption, (String)KEY);
            logger.info("\u81ea\u52a9\u673agetPatientInfo\u65b9\u6cd5,\u5165\u53c2: {}", (Object)s1);
            PatientInfoDTO dto = (PatientInfoDTO)JSON.parseObject((String)s1, PatientInfoDTO.class);
            ResponseData responseData = this.outpatientServiceFeign.getPatientInfo(dto);
            if (!"200".equals(responseData.getCode())) {
                logger.info("\u81ea\u52a9\u673agetPatientInfo\u65b9\u6cd5:\u9519\u8bef\u51fa\u53c2: {}", (Object)responseData.getMsg());
                return Result.error((String)responseData.getMsg());
            }
            String responseJson = JSON.toJSONString((Object)responseData.getData());
            logger.info("\u81ea\u52a9\u673agetPatientInfo\u65b9\u6cd5:\u51fa\u53c2: {}", (Object)responseJson);
            return Result.success((Object)AesEncryptUtils.encryptNew((String)responseJson, (String)KEY));
        }
        catch (Exception e) {
            return ExceptionUtil.handleException((Exception)e);
        }
    }

    @PostMapping(value={"/getDoctorType"})
    public Result getDoctorType(@RequestBody JSONObject jsonObject) {
        try {
            if (!jsonObject.containsKey((Object)"dataEncryption")) {
                return Result.error((String)"\u672a\u83b7\u53d6\u5230\u5165\u53c2\uff1a dataEncryption");
            }
            String dataEncryption = jsonObject.getString("dataEncryption");
            String s1 = AesEncryptUtils.decryptNew((String)dataEncryption, (String)KEY);
            logger.info("\u81ea\u52a9\u673agetDoctorType\u65b9\u6cd5,\u5165\u53c2: {}", (Object)s1);
            DoctorTypeDto dto = (DoctorTypeDto)JSON.parseObject((String)s1, DoctorTypeDto.class);
            dto.setTenantId(Integer.valueOf(1));
            ResponseData responseData = this.outpatientServiceFeign.getQueryDoctorType(dto);
            List data = (List)responseData.getData();
            String s = AesEncryptUtils.encryptNew((String)JSON.toJSONString((Object)data), (String)KEY);
            return Result.success((Object)s);
        }
        catch (Exception e) {
            return ExceptionUtil.handleException((Exception)e);
        }
    }

    @PostMapping(value={"/getDoctorAndRegFee"})
    public Result getDoctorAndRegFee(@RequestBody JSONObject jsonObject) {
        try {
            if (!jsonObject.containsKey((Object)"dataEncryption")) {
                return Result.error((String)"\u672a\u83b7\u53d6\u5230\u5165\u53c2\uff1a dataEncryption");
            }
            String dataEncryption = jsonObject.getString("dataEncryption");
            String s1 = AesEncryptUtils.decryptNew((String)dataEncryption, (String)KEY);
            logger.info("\u81ea\u52a9\u673agetDoctorAndRegFee\u65b9\u6cd5,\u5165\u53c2: {}", (Object)s1);
            QueryRecordDto dto = (QueryRecordDto)JSON.parseObject((String)s1, QueryRecordDto.class);
            ResponseData responseData = this.outpatientServiceFeign.getDoctorAndRegFee(dto);
            if (!"200".equals(responseData.getCode())) {
                return Result.error((String)responseData.getMsg());
            }
            logger.info("\u81ea\u52a9\u673agetDoctorAndRegFee\u65b9\u6cd5,\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)responseData.getData()));
            String s = AesEncryptUtils.encryptNew((String)JSON.toJSONString((Object)responseData.getData()), (String)KEY);
            return Result.success((Object)s);
        }
        catch (Exception e) {
            return ExceptionUtil.handleException((Exception)e);
        }
    }

    @PostMapping(value={"/cancelRegist"})
    public Result cancelRegist(@RequestBody JSONObject jsonObject) {
        try {
            if (!jsonObject.containsKey((Object)"dataEncryption")) {
                return Result.error((String)"\u672a\u83b7\u53d6\u5230\u5165\u53c2\uff1a dataEncryption");
            }
            String dataEncryption = jsonObject.getString("dataEncryption");
            String s1 = AesEncryptUtils.decryptNew((String)dataEncryption, (String)KEY);
            logger.info("\u81ea\u52a9\u673acancelRegist\u65b9\u6cd5,\u5165\u53c2: {}", (Object)s1);
            AdmissionEntity dto = (AdmissionEntity)JSON.parseObject((String)s1, AdmissionEntity.class);
            ResponseData responseData = this.outpatientServiceFeign.cancelRegist(dto);
            if (!"200".equals(responseData.getCode())) {
                return Result.error((String)responseData.getMsg());
            }
            logger.info("\u81ea\u52a9\u673acancelRegist\u65b9\u6cd5,\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)responseData.getData()));
            String s = AesEncryptUtils.encryptNew((String)JSON.toJSONString((Object)responseData.getData()), (String)KEY);
            return Result.success((Object)s);
        }
        catch (Exception e) {
            return ExceptionUtil.handleException((Exception)e);
        }
    }

    @PostMapping(value={"/unilateralAccount"})
    @ApiOperation(value="\u5355\u8fb9\u8d26\u9000\u8d39 \u7cfb\u7edf\u663e\u793a\u9000\u8d39\u6210\u529f,\u60a3\u8005\u6ca1\u6536\u5230\u94b1", httpMethod="POST")
    public Result unilateralAccount(@RequestParam(value="payOrderNo") String payOrderNo) {
        try {
            logger.info("\u81ea\u52a9\u673a\u5355\u8fb9\u8d26\u9000\u8d39\u65b9\u6cd5,\u5165\u53c2: {}", (Object)payOrderNo);
            return Result.success((Object)this.outpatientServiceFeign.unilateralAccount(payOrderNo));
        }
        catch (Exception e) {
            return ExceptionUtil.handleException((Exception)e);
        }
    }

    @PostMapping(value={"/unilateralAccountByWX"})
    @ApiOperation(value="\u5355\u8fb9\u8d26\u9000\u8d39  \u60a3\u8005\u4ed8\u4e86\u94b1 , \u7cfb\u7edf\u663e\u793a\u672a\u6536\u8d39", httpMethod="POST")
    public Result unilateralAccountByWX(@RequestParam(value="payOutTradeNo") String payOutTradeNo, @RequestParam(value="refundAmt") String refundAmt) {
        try {
            logger.info("\u81ea\u52a9\u673a\u5355\u8fb9\u8d26\u9000\u8d39\u65b9\u6cd5,\u5165\u53c2\u539f\u4ea4\u6613\u5355\u53f7: {}\uff0c\u9000\u8d39\u91d1\u989d: {}", (Object)payOutTradeNo, (Object)refundAmt);
            return Result.success((Object)this.outpatientServiceFeign.unilateralAccountByWX(payOutTradeNo, refundAmt));
        }
        catch (Exception e) {
            return ExceptionUtil.handleException((Exception)e);
        }
    }

    public DataPushController(SysServiceFeign sysServiceFeign, OutpatientServiceFeign outpatientServiceFeign, DepartmentService departmentService, OrdSeeDoctorRecordService ordSeeDoctorRecordService, HsServiceFeign hsServiceFeign) {
        this.sysServiceFeign = sysServiceFeign;
        this.outpatientServiceFeign = outpatientServiceFeign;
        this.departmentService = departmentService;
        this.ordSeeDoctorRecordService = ordSeeDoctorRecordService;
        this.hsServiceFeign = hsServiceFeign;
    }
}

