/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.byh.sdk.entity.dispensingMachine.ConsisPrescDtlvm;
import com.byh.sdk.entity.dispensingMachine.ConsisPrescMstvm;
import com.byh.sdk.entity.dispensingMachine.DispensingPrescription;
import com.byh.sdk.entity.dispensingMachine.confirm.ConfirmDispensing;
import com.byh.sdk.entity.dispensingMachine.confirm.ConfirmMstvw;
import com.byh.sdk.entity.dispensingMachine.confirm.ConfirmResult;
import com.byh.sdk.mapper.DispensingMachineMapper;
import com.byh.sdk.service.DispensingMachineService;
import com.byh.sdk.util.ExceptionUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DispensingMachineServiceImpl
implements DispensingMachineService {
    private static final Logger log = LoggerFactory.getLogger(DispensingMachineServiceImpl.class);
    @Autowired
    private DispensingMachineMapper dispensingMachineMapper;

    public DispensingPrescription getPrescriptionByOutpatientNo(String outpatientNo) {
        DispensingPrescription dispensingPrescription = new DispensingPrescription();
        List prescriptionList = this.dispensingMachineMapper.getPatientPrescription(outpatientNo);
        ExceptionUtils.createException((Logger)log, (boolean)CollectionUtils.isEmpty((Collection)prescriptionList), (String)"\u5f53\u524d\u5904\u65b9\u53ef\u80fd\u672a\u7f34\u8d39\u3001\u88ab\u5220\u9664\u6216\u8005\u5df2\u5f52\u6863");
        List prescIds = prescriptionList.stream().map(ConsisPrescMstvm::getPRESC_NO).collect(Collectors.toList());
        List drugList = this.dispensingMachineMapper.getPatientPrescriptionDrug(prescIds);
        Map<String, List<ConsisPrescDtlvm>> dtlvmMap = drugList.stream().collect(Collectors.groupingBy(ConsisPrescDtlvm::getPRESC_NO));
        for (ConsisPrescMstvm entry : prescriptionList) {
            ExceptionUtils.createException((Logger)log, (boolean)CollectionUtils.isEmpty((Collection)dtlvmMap.get(entry.getPRESC_NO())), (String)("\u5904\u65b9\u53f7\uff1a" + entry.getPRESC_NO() + "\u83b7\u53d6\u5904\u65b9\u660e\u7ec6\u5f02\u5e38"));
            entry.setCONSIS_PRESC_DTLVW(dtlvmMap.get(entry.getPRESC_NO()));
            BigDecimal amount = dtlvmMap.get(entry.getPRESC_NO()).stream().map(ConsisPrescDtlvm::getPAYMENTS).collect(Collectors.toList()).stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            entry.setPAYMENTS(amount);
        }
        dispensingPrescription.setCONSIS_PRESC_MSTVM(prescriptionList);
        return dispensingPrescription;
    }

    public ConfirmResult confirmPrescriptionDispensing(ConfirmDispensing confirmDispensing) {
        ConfirmResult confirmResult = new ConfirmResult();
        List prescNoIds = confirmDispensing.getCONSIS_PRESC_MSTVW().stream().map(ConfirmMstvw::getPRESC_NO).collect(Collectors.toList());
        int a = this.dispensingMachineMapper.confirmPrescriptionDispensing(prescNoIds);
        System.out.println(confirmDispensing);
        if (a > 0) {
            confirmResult.setRETVAL(Integer.valueOf(0));
            confirmResult.setRETMSG("\u53d1\u836f\u786e\u8ba4\u6210\u529f");
            confirmResult.setRETCODE(Integer.valueOf(1));
        } else {
            confirmResult.setRETVAL(Integer.valueOf(0));
            confirmResult.setRETMSG("\u53d1\u836f\u786e\u8ba4\u5931\u8d25");
            confirmResult.setRETCODE(Integer.valueOf(0));
        }
        return confirmResult;
    }
}

