/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.byh.sdk.entity.drug.DrugPharmacyStorageDto;
import com.byh.sdk.feign.sys.SysServiceFeign;
import com.byh.sdk.service.DrugPharmacyStorageService;
import com.byh.sdk.service.GeoCodingService;
import com.byh.sdk.util.JsonUtils;
import com.byh.sdk.util.ResponseData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DrugPharmacyStorageServiceImpl
implements DrugPharmacyStorageService {
    private static final Logger log = LoggerFactory.getLogger(DrugPharmacyStorageServiceImpl.class);
    @Autowired
    private SysServiceFeign sysServiceFeign;
    @Autowired
    private GeoCodingService geoCodingService;

    public ResponseData sysDrugStorageSelect(DrugPharmacyStorageDto dto) {
        dto.setSize(-1);
        return this.sysServiceFeign.withoutSelectPage(dto);
    }

    public ResponseData sysDrugStorageSelectByAddr(DrugPharmacyStorageDto dto) {
        JSONObject address = this.geoCodingService.getAddress(dto.getLongitude(), dto.getLatitude());
        JSONObject json = JsonUtils.create((Object)address).getObjectValue("result").getObjectValue("addressComponent").toJsonObject().getJson();
        String province = String.valueOf(json.get((Object)"province"));
        String city = String.valueOf(json.get((Object)"city"));
        String district = String.valueOf(json.get((Object)"district"));
        dto.setAddrIdent(province + "-" + city + "-" + district);
        dto.setSize(-1);
        return this.sysServiceFeign.withoutSelectPage(dto);
    }
}

