/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.byh.sdk.entity.HlyyEntity;
import com.byh.sdk.entity.portals.PortalsVo;
import com.byh.sdk.entity.portals.QueryVisitCountByMonthVo;
import com.byh.sdk.feign.sys.SysServiceFeign;
import com.byh.sdk.mapper.OutAdmissionMapper;
import com.byh.sdk.mapper.OutPrescriptionMapper;
import com.byh.sdk.mapper.PatientMapper;
import com.byh.sdk.mapper.portals.PortalsMapper;
import com.byh.sdk.service.PortalsService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PortalsServiceImpl
implements PortalsService {
    @Autowired
    private PortalsMapper portalsMapper;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private OutAdmissionMapper outAdmissionMapper;
    @Autowired
    private OutPrescriptionMapper outPrescriptionMapper;
    @Autowired
    private SysServiceFeign sysServiceFeign;

    public Map<String, Object> queryTreatmentData() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Long patientTotalCount = this.portalsMapper.queryPatientCount();
        Long visitCount = this.portalsMapper.queryVisitCount();
        Long prescriptionCount = this.portalsMapper.queryPrescriptionCount();
        Long drugTotalActual = this.portalsMapper.queryDrugTotalActual();
        List visitCountOnYear = this.portalsMapper.queryVisitCountOnYear();
        Map outpatientCount = this.portalsMapper.queryOutpatientCount();
        List diagnosisCount = this.portalsMapper.queryDiagnosisCount();
        HashMap diagnosisCountMap = new HashMap();
        ArrayList<String> diagnosisCountList = new ArrayList<String>();
        ArrayList<String> diagnosisNameList = new ArrayList<String>();
        for (Map stringStringMap : diagnosisCount) {
            String count = stringStringMap.get("count").toString();
            String diagnosis = stringStringMap.get("diagnosis").toString();
            diagnosisCountList.add(count);
            diagnosisNameList.add(diagnosis);
        }
        diagnosisCountMap.put("diagnosisCountList", diagnosisCountList);
        diagnosisCountMap.put("diagnosisNameList", diagnosisNameList);
        List outpatientRecordByOffline = this.portalsMapper.queryOutpatientRecord("1");
        List outpatientRecordByOnline = this.portalsMapper.queryOutpatientRecord("4");
        Map totalVisitCountByWeek = this.portalsMapper.queryTotalVisitCountByWeek();
        List newOfflinePatientCountByWeek = this.portalsMapper.queryNewOfflinePatientCountByWeek();
        List newOnlinePatientCountByWeek = this.portalsMapper.queryNewOnlinePatientCountByWeek();
        Map firstAndManyVisitCount = this.portalsMapper.queryFirstAndManyVisitCount();
        List sysDoctorEntities = this.portalsMapper.queryDoctorAvatar();
        List avatarList = sysDoctorEntities.stream().map(item -> {
            String avatar = item.getAvatar();
            if (StringUtils.isBlank((CharSequence)avatar)) {
                avatar = "https://his.guahao.cn/static/images/avatar_male_02e8f850..png";
            }
            return avatar;
        }).collect(Collectors.toList());
        List docNameList = sysDoctorEntities.stream().map(item -> {
            String name = item.getUserName();
            if (StringUtils.isBlank((CharSequence)name)) {
                name = "";
            }
            return name;
        }).collect(Collectors.toList());
        HashMap avatarMap = new HashMap();
        avatarMap.put("avatarList", avatarList);
        avatarMap.put("docNameList", docNameList);
        map.put("patientTotalCount", patientTotalCount);
        map.put("visitCount", visitCount);
        map.put("prescriptionCount", prescriptionCount);
        map.put("outpatientCount", outpatientCount);
        map.put("diagnosisCount", diagnosisCountMap);
        map.put("outpatientRecordByOffline", outpatientRecordByOffline);
        map.put("outpatientRecordByOnline", outpatientRecordByOnline);
        map.put("totalVisitCountByWeek", totalVisitCountByWeek);
        map.put("newOfflinePatientCountByWeek", newOfflinePatientCountByWeek);
        map.put("newOnlinePatientCountByWeek", newOnlinePatientCountByWeek);
        map.put("avatarMap", avatarMap);
        map.put("drugTotalActual", drugTotalActual);
        map.put("visitCountOnYear", visitCountOnYear);
        map.put("firstVisitCount", firstAndManyVisitCount.get("firstVisitCount"));
        map.put("manyVisitCount", firstAndManyVisitCount.get("manyVisitCount"));
        map.put("visitCountByWeek", newOnlinePatientCountByWeek);
        map.put("outpatientRecord", outpatientRecordByOffline);
        return map;
    }

    public List<HlyyEntity> hlyy() {
        List list = this.portalsMapper.hlyy();
        return list;
    }

    public PortalsVo queryPortals() {
        PortalsVo vo = new PortalsVo();
        List fundPayTypeVos = this.portalsMapper.queryFundPayTypeVo();
        List paymentForAddressVos = this.portalsMapper.queryPaymentForAddressVo();
        List paymentForAddressCountyVos = this.portalsMapper.queryPaymentForAddressCountyVo();
        List totalAmountByMonthVos = this.portalsMapper.queryTotalAmountByMonthVo();
        List diagnosisProportionVos = this.portalsMapper.queryDiagnosisProportionVo();
        List drugProportionVos = this.portalsMapper.queryDrugProportionVo();
        List queryNewPatientCountByMonthVos = this.portalsMapper.queryNewPatientCountByMonth();
        List newPatientCountByAgeGroupVos = this.portalsMapper.queryNewPatientCountByAgeGroup();
        List queryVisitCountByMonthVos = this.portalsMapper.queryVisitCountByMonth();
        PortalsVo portalsVo = this.portalsMapper.queryVisitAccount();
        HashMap visitCountMap = new HashMap();
        List collect = queryVisitCountByMonthVos.stream().map(item -> {
            Integer month = -1;
            if (item != null) {
                String time = item.getTime();
                String[] split = time.split("-");
                month = Integer.parseInt(split[1]);
            }
            return month;
        }).collect(Collectors.toList());
        ArrayList<String> firstList = new ArrayList<String>();
        ArrayList<String> manyList = new ArrayList<String>();
        for (int i = 1; i < 13; ++i) {
            if (!collect.contains(i)) {
                firstList.add("0");
                manyList.add("0");
                continue;
            }
            QueryVisitCountByMonthVo queryVisitCountByMonthVo = (QueryVisitCountByMonthVo)queryVisitCountByMonthVos.get(collect.indexOf(i));
            String first = queryVisitCountByMonthVo.getFirst();
            String many = queryVisitCountByMonthVo.getMany();
            firstList.add(first);
            manyList.add(many);
        }
        visitCountMap.put("firstList", firstList);
        visitCountMap.put("manyList", manyList);
        Long patientTotalCount = this.portalsMapper.queryPatientCount();
        vo.setFundPayTypes(fundPayTypeVos);
        vo.setPaymentForAddressVos(paymentForAddressVos);
        vo.setPaymentForAddressCountyVos(paymentForAddressCountyVos);
        vo.setTotalAmountByMonthVos(totalAmountByMonthVos);
        vo.setDiagnosisProportionVos(diagnosisProportionVos);
        vo.setDrugProportionVos(drugProportionVos);
        vo.setPatientTotalCount(patientTotalCount);
        vo.setNewPatientCountByMonth(queryNewPatientCountByMonthVos);
        vo.setNewPatientCountByAgeGroup(newPatientCountByAgeGroupVos);
        vo.setVisitCountMap(visitCountMap);
        vo.setFirstAccount(portalsVo.getFirstAccount());
        vo.setManyAccount(portalsVo.getManyAccount());
        return vo;
    }
}

