/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.sdk.entity.tisane.ReceiveDto;
import com.byh.sdk.entity.tisane.ReceivePatientDto;
import com.byh.sdk.entity.tisane.ReceivePrescriptionDto;
import com.byh.sdk.entity.tisane.TisaneDrugEntity;
import com.byh.sdk.entity.tisane.TisaneEntity;
import com.byh.sdk.entity.tisane.TisanePrescriptionEntity;
import com.byh.sdk.mapper.ReceiveDrugMapper;
import com.byh.sdk.mapper.ReceivePatientMapper;
import com.byh.sdk.mapper.ReceivePrescriptionMapper;
import com.byh.sdk.mapper.TisaneMapper;
import com.byh.sdk.service.TisaneService;
import com.byh.sdk.util.DateUtils;
import com.byh.sdk.util.ErrorEnum;
import com.byh.sdk.util.ExceptionUtils;
import com.byh.sdk.util.HttpUtils;
import com.byh.sdk.util.PingYinUtil;
import com.byh.sdk.util.exception.BusinessException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class TisaneServiceImpl
implements TisaneService {
    private static final Logger log = LoggerFactory.getLogger(TisaneServiceImpl.class);
    @Resource
    private TisaneMapper tisaneMapper;
    @Value(value="${dh.push.prescription}")
    private String pushUrl;
    @Value(value="${dh.select.prescription}")
    private String selectUrl;
    @Resource
    private ReceivePrescriptionMapper receivePrescriptionMapper;
    @Resource
    private ReceiveDrugMapper receiveDrugMapper;
    @Resource
    private ReceivePatientMapper receivePatientMapper;

    public String pushPrescription(String preId) {
        TisaneEntity tisaneEntity = new TisaneEntity();
        List list = this.tisaneMapper.selectPrescriptionByNo(preId, Integer.valueOf(1));
        List drugList = this.tisaneMapper.selectPrescriptionDrugByNo(preId, Integer.valueOf(1));
        for (TisanePrescriptionEntity n : list) {
            for (TisaneDrugEntity m : drugList) {
                m.setTienum(n.getDose());
                m.setDrugweight(String.valueOf((float)Integer.parseInt(n.getDose()) * Float.valueOf(m.getDrugallnum()).floatValue()));
            }
        }
        tisaneEntity.setPrescription(list);
        tisaneEntity.setDrug(drugList);
        return this.send(this.pushUrl, JSON.toJSONString((Object)tisaneEntity));
    }

    public String selectPrescription(String phone) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("phone", phone);
        String result = HttpUtils.get((String)this.selectUrl, params);
        return result;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void receivePrescription(ReceiveDto dto) {
        ReceivePrescriptionDto receivePrescription = dto.getReceivePrescription();
        List receiveDrugList = dto.getReceiveDrugList();
        ReceivePatientDto receivePatient = dto.getReceivePatient();
        String medicalRecordNo = "0";
        ReceivePatientDto patient = (ReceivePatientDto)this.receivePatientMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ReceivePatientDto::getTenantId, (Object)receivePrescription.getTenantId())).eq(ReceivePatientDto::getCardNo, (Object)receivePatient.getCardNo()));
        if (null == patient) {
            medicalRecordNo = this.generateMedicalRecordNo(receivePrescription.getTenantId(), this.receivePatientMapper.queryMaxMedicalNo(receivePrescription.getTenantId()));
            receivePatient.setNamePinyin(PingYinUtil.getFirstSpell((String)receivePatient.getName()).toUpperCase());
            receivePatient.setMedicalRecordNo(medicalRecordNo);
            int receivePatientFlag = this.receivePatientMapper.insert((Object)receivePatient);
            receivePrescription.setPatientId(receivePatient.getId());
            ExceptionUtils.createException((Logger)log, (int)receivePatientFlag, (String)ErrorEnum.PATIENT_PUT_RECORD_FAIL.getCode(), (String)ErrorEnum.PATIENT_PUT_RECORD_FAIL.getName());
        } else {
            medicalRecordNo = patient.getMedicalRecordNo();
            receivePrescription.setPatientId(patient.getId());
        }
        List prescriptionList = this.receivePrescriptionMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ReceivePrescriptionDto::getTenantId, (Object)receivePrescription.getTenantId())).eq(ReceivePrescriptionDto::getPrescriptionNo, (Object)receivePrescription.getPrescriptionNo())).and(w -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)w.eq(ReceivePrescriptionDto::getPrescriptionStatus, (Object)"1")).or()).eq(ReceivePrescriptionDto::getPrescriptionStatus, (Object)"99");
        }));
        ExceptionUtils.createException((Logger)log, (!CollectionUtils.isEmpty((Collection)prescriptionList) ? 1 : 0) != 0, (String)ErrorEnum.PRESCRIPTION_REPEAT.getCode(), (String)ErrorEnum.PRESCRIPTION_REPEAT.getName());
        receivePrescription.setTotalDrugQuantity(String.valueOf(receiveDrugList.size()));
        receivePrescription.setPrescriptionClassifyType("4");
        receivePrescription.setPatientName(receivePatient.getName());
        receivePrescription.setMedicalRecordNo(medicalRecordNo);
        receivePrescription.setSource("3");
        int prescriptionFlag = this.receivePrescriptionMapper.insert((Object)receivePrescription);
        ExceptionUtils.createException((Logger)log, (int)prescriptionFlag, (String)ErrorEnum.PRESCRIPTION_UPLOAD_FAIL.getCode(), (String)ErrorEnum.PRESCRIPTION_UPLOAD_FAIL.getName());
        int receiveDrugFlag = this.receiveDrugMapper.insertBatch(receiveDrugList, receivePrescription.getPrescriptionNo());
        ExceptionUtils.createException((Logger)log, (int)receiveDrugFlag, (String)ErrorEnum.PRESCRIPTION_DRUG_UPLOAD_FAIL.getCode(), (String)ErrorEnum.PRESCRIPTION_DRUG_UPLOAD_FAIL.getName());
    }

    public String send(String url, String param) {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"jsondhy", (Object)param);
        HttpEntity requestEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        String response = (String)restTemplate.postForObject(url, (Object)requestEntity, String.class, new Object[0]);
        System.out.println(response);
        return response;
    }

    private String generateMedicalRecordNo(Integer tenantId, String no) {
        Integer endNo = Objects.isNull(no) ? Integer.valueOf(0) : Integer.valueOf(Integer.parseInt(no));
        String currentDate = DateUtils.getCurrentDate((String)"yyMMdd");
        Integer suffix = tenantId + 1000000 + endNo;
        return currentDate + suffix;
    }
}

