/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.byh.sdk.entity.bot.BotResult;
import com.byh.sdk.entity.bot.Content01Vo;
import com.byh.sdk.entity.bot.ContentEntity;
import com.byh.sdk.entity.bot.Intelligent01BotChatResponse;
import com.byh.sdk.entity.bot.MessageEntity;
import com.byh.sdk.entity.weChat.ImageMsg;
import com.byh.sdk.entity.weChat.MsgInfo;
import com.byh.sdk.entity.weChat.QueryWeChatMsg;
import com.byh.sdk.entity.weChat.QueryWeChatMsgResponse;
import com.byh.sdk.entity.weChat.SendMsgRequest;
import com.byh.sdk.entity.weChat.SendMsgResponse;
import com.byh.sdk.entity.weChat.TextMsg;
import com.byh.sdk.entity.weChat.WxEventPush;
import com.byh.sdk.entity.weChat.WxKfEventPush;
import com.byh.sdk.entity.weChat.WxPushResponse;
import com.byh.sdk.service.Intelligent01BotService;
import com.byh.sdk.service.WeChatCustomerService;
import com.byh.sdk.service.WeChatRemoteService;
import com.byh.sdk.util.RedisUtil;
import com.byh.sdk.util.weChat.WeChatUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class WeChatCustomerServiceImpl
implements WeChatCustomerService {
    private static final Logger log = LoggerFactory.getLogger(WeChatCustomerServiceImpl.class);
    @Autowired
    private WeChatRemoteService weChatRemoteService;
    @Autowired
    private Intelligent01BotService intelligent01BotService;
    @Autowired
    private RedisUtil redisUtil;
    public static final String MSG_CURSOR = "MSG_CURSOR_";

    public String handleWxMsg(WxEventPush wxEventPush) {
        log.info("\u83b7\u53d6\u56de\u590d\u4fe1\u606f\u5165\u53c2:{}", (Object)wxEventPush);
        WxPushResponse wxPushResponse = new WxPushResponse();
        wxPushResponse.setFromUserName(wxEventPush.getToUserName());
        wxPushResponse.setToUserName(wxEventPush.getFromUserName());
        wxPushResponse.setCreateTime(wxEventPush.getCreateTime());
        List contents = null;
        try {
            log.info("\u8c03\u7528\u7075\u533b\u5165\u53c2:{}", (Object)JSON.toJSONString(contents));
            String botChatResponse = this.intelligent01BotService.chat(contents);
            String xmlString = WeChatUtil.getXmlString((WxPushResponse)wxPushResponse);
            log.info("xmlString\u8fd4\u56de:{}", (Object)xmlString);
            SendMsgRequest sendMsgRequest = new SendMsgRequest();
            sendMsgRequest.setTouser(wxPushResponse.getToUserName());
            sendMsgRequest.setMsgtype(wxPushResponse.getMsgType());
            TextMsg textMsg = new TextMsg();
            textMsg.setContent(wxPushResponse.getContent());
            sendMsgRequest.setText(textMsg);
            log.info("\u53d1\u9001\u6d88\u606f:{}", (Object)JSON.toJSONString((Object)sendMsgRequest));
            SendMsgResponse sendMsgResponse = this.weChatRemoteService.sendMsg(sendMsgRequest);
            return xmlString;
        }
        catch (IOException e) {
            e.printStackTrace();
            log.info("\u83b7\u53d6\u53d1\u9001\u4fe1\u606f\u5931\u8d25:{}", (Object)e.getMessage());
            wxPushResponse.setMsgType("text");
            wxPushResponse.setContent("\u62b1\u6b49\uff0c\u6211\u4e0d\u660e\u767d\u60a8\u7684\u610f\u601d\uff0c\u8bf7\u8054\u7cfb\u4eba\u5de5\u5ba2\u670d\u3002");
            String xmlString = WeChatUtil.getXmlString((WxPushResponse)wxPushResponse);
            log.info("xmlString\u5f02\u5e38:{}", (Object)xmlString);
            SendMsgRequest sendMsgRequest = new SendMsgRequest();
            sendMsgRequest.setTouser(wxPushResponse.getToUserName());
            sendMsgRequest.setMsgtype(wxPushResponse.getMsgType());
            TextMsg textMsg = new TextMsg();
            textMsg.setContent(wxPushResponse.getContent());
            sendMsgRequest.setText(textMsg);
            log.info("\u53d1\u9001\u6d88\u606f:{}", (Object)JSON.toJSONString((Object)sendMsgRequest));
            SendMsgResponse sendMsgResponse = this.weChatRemoteService.sendMsg(sendMsgRequest);
            return xmlString;
        }
    }

    public String handleWxKfMsg(WxKfEventPush wxKfEventPush) throws IOException {
        QueryWeChatMsg queryWeChatMsg = new QueryWeChatMsg();
        Object o = this.redisUtil.get(MSG_CURSOR + wxKfEventPush.getOpenKfId());
        if (Objects.nonNull(o)) {
            queryWeChatMsg.setCursor(o.toString());
        }
        queryWeChatMsg.setOpen_kfid(wxKfEventPush.getOpenKfId());
        queryWeChatMsg.setToken(wxKfEventPush.getToken());
        log.info("\u62c9\u53d6\u6d88\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)queryWeChatMsg));
        QueryWeChatMsgResponse queryWeChatMsgResponse = this.weChatRemoteService.syncMsg(queryWeChatMsg);
        log.info("queryWeChatMsgResponse:{}", (Object)queryWeChatMsgResponse);
        if (0 != queryWeChatMsgResponse.getErrcode()) {
            log.info("\u62c9\u53d6\u6d88\u606f\u5931\u8d25:{}", (Object)JSON.toJSONString((Object)queryWeChatMsgResponse));
            return null;
        }
        this.redisUtil.del(new String[]{MSG_CURSOR + wxKfEventPush.getOpenKfId()});
        this.redisUtil.set(MSG_CURSOR + wxKfEventPush.getOpenKfId(), (Object)queryWeChatMsgResponse.getNext_cursor());
        List msg_list = queryWeChatMsgResponse.getMsg_list();
        if (CollectionUtils.isEmpty((Collection)msg_list)) {
            log.info("\u62c9\u53d6\u6d88\u606f\u96c6\u5408\u4e3a\u7a7a:{}", (Object)JSON.toJSONString((Object)queryWeChatMsgResponse));
            return null;
        }
        List msgInfoList = msg_list.stream().filter(x -> x.getOrigin() == 3).collect(Collectors.toList());
        Map<String, List<MsgInfo>> listMap = msgInfoList.stream().collect(Collectors.groupingBy(x -> x.getOpen_kfid() + "&" + x.getExternal_userid()));
        for (Map.Entry<String, List<MsgInfo>> stringListEntry : listMap.entrySet()) {
            String key = stringListEntry.getKey();
            List<MsgInfo> value = stringListEntry.getValue();
            List contentList = this.build01Message(value);
            String botChatResponse = this.intelligent01BotService.chat(contentList);
            SendMsgRequest sendMsgRequest = new SendMsgRequest();
            sendMsgRequest.setTouser(key.split("&")[1]);
            sendMsgRequest.setOpen_kfid(key.split("&")[0]);
            this.handle01Response(botChatResponse, sendMsgRequest);
            log.info("\u53d1\u9001\u6d88\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)sendMsgRequest));
            SendMsgResponse sendMsgResponse = this.weChatRemoteService.sendMsg(sendMsgRequest);
            log.info("\u53d1\u9001\u6d88\u606f\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)sendMsgResponse));
        }
        return "successful";
    }

    /*
     * WARNING - void declaration
     */
    public Content01Vo get01Response(String botChatResponse) {
        void var7_9;
        Content01Vo content01Vo = new Content01Vo();
        String[] split = botChatResponse.split("event:messagedata:");
        List<Object> messageEntities = new ArrayList();
        String[] stringArray = split;
        int n = stringArray.length;
        boolean bl = false;
        while (var7_9 < n) {
            Intelligent01BotChatResponse intelligent01BotChatResponse;
            List result;
            String s = stringArray[var7_9];
            if (!StringUtils.isEmpty((CharSequence)s) && !CollectionUtils.isEmpty((Collection)(result = (intelligent01BotChatResponse = (Intelligent01BotChatResponse)JSON.parseObject((String)s, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0])).getResult()))) {
                for (BotResult botResult : result) {
                    List messages = botResult.getMessages();
                    log.info("messages:{}", (Object)JSON.toJSONString((Object)messages));
                    messageEntities.addAll(messages);
                }
            }
            ++var7_9;
        }
        messageEntities = messageEntities.stream().sorted(Comparator.comparing(MessageEntity::getSentence_id)).collect(Collectors.toList());
        StringBuffer sb = new StringBuffer();
        for (MessageEntity messageEntity : messageEntities) {
            List content = messageEntity.getContent();
            for (ContentEntity contentEntity : content) {
                content01Vo.setMsgType(contentEntity.getType());
                sb.append(contentEntity.getBody());
            }
        }
        content01Vo.setContent(sb.toString());
        return content01Vo;
    }

    private void handle01Response(String botChatResponse, SendMsgRequest sendMsgRequest) {
        log.info("\u5904\u7406\u7075\u533b\u8fd4\u56de\u5165\u53c2:{}", (Object)botChatResponse);
        try {
            String msgType = "";
            Content01Vo content01Vo = this.get01Response(botChatResponse);
            msgType = content01Vo.getMsgType();
            String content = content01Vo.getContent();
            if (StringUtils.isEmpty((CharSequence)content) || StringUtils.isEmpty((CharSequence)msgType)) {
                sendMsgRequest.setMsgtype("text");
                TextMsg textMsg = new TextMsg();
                textMsg.setContent("\u62b1\u6b49\uff0c\u6211\u4e0d\u592a\u660e\u767d\u60a8\u7684\u610f\u601d\uff0c\u8bf7\u8054\u7cfb\u4eba\u5de5\u5ba2\u670d\u3002");
                sendMsgRequest.setText(textMsg);
            } else {
                this.buildWxMsgType(msgType, content, sendMsgRequest);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("01\u8fd4\u56de\u4fe1\u606f\u5904\u7406\u5f02\u5e38:{}", (Object)e.getMessage());
            sendMsgRequest.setMsgtype("text");
            TextMsg textMsg = new TextMsg();
            textMsg.setContent("\u62b1\u6b49\uff0c\u6211\u597d\u50cf\u51fa\u9519\u4e86\uff0c\u8bf7\u8054\u7cfb\u4eba\u5de5\u5ba2\u670d\u3002");
            sendMsgRequest.setText(textMsg);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) {
        void var7_9;
        String str = "event:messagedata:{\"logid\":\"a405f198-c6be-4d40-b79b-8a42fa819ceb\",\"error_msg\":\"\",\"client_id\":\"\",\"result\":[{\"session_id\":\"593dbea4-e2bf-4f1b-9008-1e62eb62bf48-1721633029607937\",\"messages\":[{\"extend\":null,\"kg_base\":\"\",\"kg_ids\":null,\"plugin\":{\"from\":\"\",\"model\":\"\"},\"id\":\"\",\"version\":\"api-v2\",\"message_group_id\":\"\",\"message_id\":\"25e34e59-2251-47b1-ac31-5c04ed6da1fa\",\"role\":\"assistant\",\"intention\":\"third-common-v1-faq\",\"pre_intention\":\"\",\"block_intention\":\"\",\"from\":\"medical-doc\",\"llm_service\":\"\",\"candidate_questions\":null,\"recommend_questions\":null,\"content\":[{\"type\":\"markdown\",\"body\":\"**\u6ca1\u6709\u4ece\u77e5\u8bc6\u7ba1\u7406\u7684\u77e5\u8bc6\u4e2d\u627e\u5230\u76f8\u5173\u7b54\u6848\uff0c\u4ee5\u4e0b\u662f\u5927\u6a21\u578b\u7684\u56de\u7b54\u4f9b\u60a8\u53c2\u8003:**  \\n\u60a8\u597d\uff0c\u5173\u4e8e\u611f\u5192\u7684\u95ee\u9898\uff0c\u6211\u60f3\u7ed9\u60a8\u4e00\u4e9b\u5efa\u8bae\u3002\u611f\u5192\u662f\u4e00\u79cd\u5e38\u89c1\u7684\u547c\u5438\u9053\u75be\u75c5\uff0c\u901a\u5e38\u8868\u73b0\u4e3a\u9f3b\u585e\u3001\u54b3\u55fd\u3001\u5589\u5499\u75db\u7b49\u75c7\u72b6\u3002\u5728\u611f\u5192\u671f\u95f4\uff0c\u5efa\u8bae\u60a8\u591a\u4f11\u606f\uff0c\u4fdd\u6301\u5145\u8db3\u7684\u7761\u7720\uff0c\u8fd9\u6709\u52a9\u4e8e\u8eab\u4f53\u6062\u590d\u3002\u540c\u65f6\uff0c\u591a\u559d\u6c34\uff0c\u4fdd\u6301\u8eab\u4f53\u6c34\u5206\u5145\u8db3\uff0c\u6709\u52a9\u4e8e\u7f13\u89e3\u5589\u5499\u4e0d\u9002\u3002\\n\\n\u5728\u996e\u98df\u4e0a\uff0c\u53ef\u4ee5\u9009\u62e9\u6e05\u6de1\u6613\u6d88\u5316\u7684\u98df\u7269\uff0c\u5982\u7ca5\u3001\u9762\u6761\u7b49\uff0c\u907f\u514d\u8f9b\u8fa3\u3001\u6cb9\u817b\u7b49\u523a\u6fc0\u6027\u98df\u7269\u3002\u5982\u679c\u75c7\u72b6\u8f83\u4e3a\u4e25\u91cd\uff0c\u53ef\u4ee5\u8003\u8651\u9002\u5f53\u670d\u7528\u611f\u5192\u836f\uff0c\u4f46\u8bf7\u52a1\u5fc5\u6309\u7167\u8bf4\u660e\u4e66\u6216\u533b\u751f\u5efa\u8bae\u7684\u5242\u91cf\u670d\u7528\u3002\\n\\n\u6700\u540e\uff0c\u8bf7\u6ce8\u610f\u4e2a\u4eba\u536b\u751f\uff0c\u52e4\u6d17\u624b\uff0c\u907f\u514d\u53bb\u4eba\u7fa4\u5bc6\u96c6\u7684\u5730\u65b9\uff0c\u4ee5\u51cf\u5c11\u75c5\u6bd2\u4f20\u64ad\u7684\u98ce\u9669\u3002\u5e0c\u671b\u8fd9\u4e9b\u5efa\u8bae\u80fd\u5bf9\u60a8\u6709\u6240\u5e2e\u52a9\uff0c\u795d\u60a8\u65e9\u65e5\u5eb7\u590d\uff01\",\"category\":\"\"}],\"source\":[],\"sentence_id\":0,\"created\":1721633041,\"ban_round\":0,\"status\":0,\"scene\":0,\"platform\":0,\"is_end\":true,\"refresh_answer\":false,\"need_clear_history\":false,\"non_medical_qa\":false,\"usage\":{\"prompt_tokens\":0,\"completion_tokens\":0,\"total_tokens\":0},\"ignore\":false}],\"created\":1721633041,\"stream\":true}],\"error_code\":0,\"user_id\":348021613689}";
        Content01Vo content01Vo = new Content01Vo();
        String[] split = str.split("event:messagedata:");
        List<Object> messageEntities = new ArrayList();
        String[] stringArray = split;
        int n = stringArray.length;
        boolean bl = false;
        while (var7_9 < n) {
            Intelligent01BotChatResponse intelligent01BotChatResponse;
            List result;
            String s = stringArray[var7_9];
            if (!StringUtils.isEmpty((CharSequence)s) && !CollectionUtils.isEmpty((Collection)(result = (intelligent01BotChatResponse = (Intelligent01BotChatResponse)JSON.parseObject((String)s, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0])).getResult()))) {
                for (BotResult botResult : result) {
                    List messages = botResult.getMessages();
                    log.info("messages:{}", (Object)JSON.toJSONString((Object)messages));
                    messageEntities.addAll(messages);
                }
            }
            ++var7_9;
        }
        messageEntities = messageEntities.stream().sorted(Comparator.comparing(MessageEntity::getSentence_id)).collect(Collectors.toList());
        StringBuffer sb = new StringBuffer();
        for (MessageEntity messageEntity : messageEntities) {
            List content = messageEntity.getContent();
            for (ContentEntity contentEntity : content) {
                content01Vo.setMsgType(contentEntity.getType());
                sb.append(contentEntity.getBody());
            }
        }
        content01Vo.setContent(sb.toString());
        System.out.println(JSON.toJSONString((Object)content01Vo));
    }

    private void buildWxMsgType(String msgType, String content, SendMsgRequest sendMsgRequest) {
        switch (msgType) {
            case "text": {
                sendMsgRequest.setMsgtype("text");
                TextMsg textMsg = new TextMsg();
                textMsg.setContent(content);
                sendMsgRequest.setText(textMsg);
                break;
            }
            case "image": {
                sendMsgRequest.setMsgtype("image");
                ImageMsg imageMsg = new ImageMsg();
                imageMsg.setImage(content);
                sendMsgRequest.setImage(imageMsg);
                break;
            }
            default: {
                sendMsgRequest.setMsgtype("text");
                TextMsg textMsg1 = new TextMsg();
                textMsg1.setContent(content);
                sendMsgRequest.setText(textMsg1);
            }
        }
    }

    private List<ContentEntity> build01Message(List<MsgInfo> msgInfoList) {
        ArrayList<ContentEntity> contentEntityList = new ArrayList<ContentEntity>();
        for (MsgInfo msgInfo : msgInfoList) {
            String msgType;
            ContentEntity contentEntity = new ContentEntity();
            contentEntity.setRole("user");
            switch (msgType = msgInfo.getMsgtype()) {
                case "text": {
                    contentEntity.setType("text");
                    contentEntity.setBody(msgInfo.getText().getContent());
                    break;
                }
                case "image": {
                    contentEntity.setType("image");
                    contentEntity.setUrl(msgInfo.getImage().getMedia_id());
                    break;
                }
                default: {
                    contentEntity.setType("text");
                    contentEntity.setUrl("\u672a\u77e5\u4fe1\u606f");
                }
            }
            contentEntityList.add(contentEntity);
        }
        return contentEntityList;
    }

    private void handleWxCallBackMsg(WxEventPush wxEventPush) {
        QueryWeChatMsgResponse queryWeChatMsgResponse;
        QueryWeChatMsg queryWeChatMsg = new QueryWeChatMsg();
        queryWeChatMsg.setToken(wxEventPush.getTOKEN());
        queryWeChatMsg.setLimit(1000);
        queryWeChatMsg.setVoice_format(0);
        queryWeChatMsg.setOpen_kfid(wxEventPush.getOpenKfId());
        queryWeChatMsg.setCursor(null);
        Object o = this.redisUtil.get(wxEventPush.getOpenKfId());
        if (Objects.nonNull(o)) {
            queryWeChatMsg.setCursor(o.toString());
        }
        if (Objects.isNull(queryWeChatMsgResponse = this.weChatRemoteService.syncMsg(queryWeChatMsg))) {
            log.info("\u83b7\u53d6\u4fe1\u606f\u8fd4\u56de\u4e3a\u7a7a:");
            return;
        }
        if (0 != queryWeChatMsgResponse.getErrcode()) {
            log.info("\u83b7\u53d6\u804a\u5929\u4fe1\u606f\u8fd4\u56de\u9519\u8bef\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)queryWeChatMsgResponse));
            return;
        }
        this.redisUtil.set(wxEventPush.getOpenKfId(), (Object)queryWeChatMsgResponse.getNext_cursor());
        List msg_list = queryWeChatMsgResponse.getMsg_list();
        if (!CollectionUtils.isEmpty((Collection)msg_list)) {
            Map<String, List<MsgInfo>> msgListMap = msg_list.stream().collect(Collectors.groupingBy(x -> x.getOpen_kfid() + "&&" + x.getExternal_userid()));
            for (Map.Entry<String, List<MsgInfo>> stringListEntry : msgListMap.entrySet()) {
                String key = stringListEntry.getKey();
                List<MsgInfo> value = stringListEntry.getValue();
                String testMMsg = "\u6d4b\u8bd5\u53d1\u9001\u4e00\u4e0b\u53d1\u9001\u6d88\u606f";
                String[] split = key.split("&&");
                SendMsgRequest sendMsgRequest = new SendMsgRequest();
                sendMsgRequest.setOpen_kfid(split[0]);
                sendMsgRequest.setTouser(split[1]);
                sendMsgRequest.setMsgtype("text");
                TextMsg textMsg = new TextMsg();
                textMsg.setContent(testMMsg);
                sendMsgRequest.setText(textMsg);
                SendMsgResponse sendMsgResponse = this.weChatRemoteService.sendMsg(sendMsgRequest);
                if (0 == sendMsgResponse.getErrcode()) continue;
                log.error("\u53d1\u9001\u6d88\u606f\u8fd4\u56de\u5931\u8d25:{}", (Object)JSON.toJSONString((Object)sendMsgResponse));
            }
        }
    }
}

