/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.byh.sdk.entity.weChat.AccessTokenResponse;
import com.byh.sdk.entity.weChat.QueryWeChatMsg;
import com.byh.sdk.entity.weChat.QueryWeChatMsgResponse;
import com.byh.sdk.entity.weChat.SendMsgRequest;
import com.byh.sdk.entity.weChat.SendMsgResponse;
import com.byh.sdk.entity.weChat.kf.AddKfResponse;
import com.byh.sdk.entity.weChat.kf.KfAddDto;
import com.byh.sdk.entity.weChat.kf.KfRequest;
import com.byh.sdk.entity.weChat.kf.KfServersList;
import com.byh.sdk.entity.weChat.kf.WeChatKfList;
import com.byh.sdk.exception.RunDisplayException;
import com.byh.sdk.service.WeChatRemoteService;
import com.byh.sdk.util.HttpUtils;
import com.byh.sdk.util.RedisUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class WeChatRemoteServiceImpl
implements WeChatRemoteService {
    private static final Logger log = LoggerFactory.getLogger(WeChatRemoteServiceImpl.class);
    @Value(value="${weChat.corpid}")
    private String corpId;
    @Value(value="${weChat.corpsecret}")
    private String corpSecret;
    @Value(value="${weChat.accessTokenUrl}")
    private String accessTokenUrl;
    @Value(value="${weChat.syncMsgUrl}")
    private String syncMsgUrl;
    @Value(value="${weChat.sendMsgUrl}")
    private String sendMsgUrl;
    @Value(value="${weChat.kfAccountListUrl}")
    private String kfAccountListUrl;
    @Value(value="${weChat.kfAddUrl}")
    private String kfAddUrl;
    @Autowired
    private RedisUtil redisUtil;
    public static final String ACCESS_TOKEN_KEY = "WE_CHAT_ACCESS_TOKEN";
    public static final String KF_ACCESS_TOKEN_KEY = "WE_CHAT_KF_ACCESS_TOKEN";

    public String getAccessToken(Boolean forceFresh) {
        if (!Boolean.TRUE.equals(forceFresh)) {
            Object token = this.redisUtil.get(ACCESS_TOKEN_KEY);
            log.info("reids.weChat.accessToken {}", token);
            if (Objects.nonNull(token)) {
                return token.toString();
            }
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("corpid", this.corpId);
        paramMap.put("corpsecret", this.corpSecret);
        log.info("\u83b7\u53d6token\u51ed\u8bc1url:{},param:{}", (Object)this.accessTokenUrl, (Object)JSON.toJSONString(paramMap));
        String result = HttpUtils.get((String)this.accessTokenUrl, paramMap);
        log.info("\u83b7\u53d6token\u51ed\u8bc1\u8fd4\u56de:{}", (Object)result);
        AccessTokenResponse accessTokenResponse = (AccessTokenResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), AccessTokenResponse.class);
        if (0 != accessTokenResponse.getErrcode()) {
            throw new RunDisplayException(accessTokenResponse.getErrmsg());
        }
        String access_token = accessTokenResponse.getAccess_token();
        this.redisUtil.del(new String[]{ACCESS_TOKEN_KEY});
        this.redisUtil.set(ACCESS_TOKEN_KEY, (Object)access_token, 6500L);
        return access_token;
    }

    public QueryWeChatMsgResponse syncMsg(QueryWeChatMsg queryWeChatMsg) {
        String accessToken = this.getAccessToken(Boolean.FALSE);
        if (StringUtils.isEmpty((CharSequence)accessToken)) {
            throw new IllegalArgumentException("\u83b7\u53d6token\u5931\u8d25");
        }
        Map paramMap = (Map)JSONObject.parseObject((String)JSON.toJSONString((Object)queryWeChatMsg), Map.class);
        String syncKfMsgUrl = this.syncMsgUrl + accessToken + "&debug=1";
        try {
            log.info("\u62c9\u53d6\u6d88\u606furl:{},param:{}", (Object)syncKfMsgUrl, (Object)JSON.toJSONString((Object)paramMap));
            String result = HttpUtils.doPost((String)syncKfMsgUrl, (String)JSON.toJSONString((Object)queryWeChatMsg), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("\u62c9\u53d6\u6d88\u606f\u8fd4\u56de:{}", (Object)result);
            QueryWeChatMsgResponse queryWeChatMsgResponse = (QueryWeChatMsgResponse)JSON.parseObject((String)result, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            return queryWeChatMsgResponse;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RunDisplayException("\u67e5\u8be2\u6d88\u606f\u5f02\u5e38:" + e.getMessage());
        }
    }

    public SendMsgResponse sendMsg(SendMsgRequest sendMsgRequest) {
        String accessToken = this.getAccessToken(Boolean.FALSE);
        if (StringUtils.isEmpty((CharSequence)accessToken)) {
            throw new IllegalArgumentException("\u83b7\u53d6token\u5931\u8d25");
        }
        if (Objects.isNull(sendMsgRequest.getMsgtype())) {
            sendMsgRequest.setMsgtype("text");
        }
        Map paramMap = (Map)JSONObject.parseObject((String)JSON.toJSONString((Object)sendMsgRequest), Map.class);
        String kfSendMsgUrl = this.sendMsgUrl + accessToken;
        try {
            log.info("\u53d1\u9001\u6d88\u606furl:{},param:{}", (Object)kfSendMsgUrl, (Object)JSON.toJSONString((Object)paramMap));
            String result = HttpUtils.doPost((String)kfSendMsgUrl, (String)JSON.toJSONString((Object)sendMsgRequest), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("\u53d1\u9001\u6d88\u606f\u8fd4\u56de\uff1a{}", (Object)result);
            SendMsgResponse sendMsgResponse = (SendMsgResponse)JSON.parseObject((String)result, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            return sendMsgResponse;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RunDisplayException("\u53d1\u9001\u6d88\u606f\u5f02\u5e38:" + e.getMessage());
        }
    }

    public WeChatKfList getKfList(KfRequest kfRequest) {
        String accessToken = this.getAccessToken(Boolean.FALSE);
        if (StringUtils.isEmpty((CharSequence)accessToken)) {
            throw new IllegalArgumentException("\u83b7\u53d6token\u5931\u8d25");
        }
        Map paramMap = (Map)JSONObject.parseObject((String)JSON.toJSONString((Object)kfRequest), Map.class);
        String kfAccListUrl = this.kfAccountListUrl + accessToken;
        try {
            log.info("\u53d1\u9001\u6d88\u606furl:{},param:{}", (Object)kfAccListUrl, (Object)JSON.toJSONString((Object)paramMap));
            String result = HttpUtils.post((String)kfAccListUrl, (Map)paramMap);
            log.info("\u53d1\u9001\u6d88\u606f\u8fd4\u56de\uff1a{}", (Object)result);
            WeChatKfList kfList = (WeChatKfList)JSON.parseObject((String)result, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            return kfList;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RunDisplayException("\u83b7\u53d6\u5ba2\u670d\u4fe1\u606f\u5f02\u5e38:" + e.getMessage());
        }
    }

    public KfServersList servicerList(KfRequest kfRequest) {
        return null;
    }

    public AddKfResponse addKf(KfAddDto kfAddDto) {
        String accessToken = this.getAccessToken(Boolean.FALSE);
        if (StringUtils.isEmpty((CharSequence)accessToken)) {
            throw new IllegalArgumentException("\u83b7\u53d6token\u5931\u8d25");
        }
        Map paramMap = (Map)JSONObject.parseObject((String)JSON.toJSONString((Object)kfAddDto), Map.class);
        String addKfUrl = this.kfAddUrl + accessToken;
        try {
            log.info("\u53d1\u9001\u6d88\u606furl:{},param:{}", (Object)addKfUrl, (Object)JSON.toJSONString((Object)kfAddDto));
            String result = HttpUtils.doPost((String)addKfUrl, (String)JSON.toJSONString((Object)kfAddDto), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("\u53d1\u9001\u6d88\u606f\u8fd4\u56de\uff1a{}", (Object)result);
            AddKfResponse addKfResponse = (AddKfResponse)JSON.parseObject((String)result, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            return addKfResponse;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RunDisplayException("\u6dfb\u52a0\u5ba2\u670d\u4fe1\u606f\u5f02\u5e38:" + e.getMessage());
        }
    }
}

