/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.util;

import cn.hutool.core.util.StrUtil;
import com.byh.sdk.entity.request.SysUserEntity;
import com.byh.sdk.mapper.sys.SysUserMapper;
import com.byh.sdk.util.ExceptionUtils;
import com.byh.sdk.util.enums.SysCommonEnum;
import com.byh.sdk.util.enums.SystemEnum;
import com.byh.sdk.util.exception.BusinessException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CommonRequest {
    private static final Logger log = LoggerFactory.getLogger(CommonRequest.class);
    @Value(value="${remote.tenantId}")
    private Integer tenantId;
    @Value(value="${remote.userId}")
    private Integer userId;
    @Value(value="${remote.userName}")
    private String userName;
    @Autowired
    private HttpServletRequest request;
    @Resource
    private SysUserMapper sysUserMapper;

    public Integer getTenant() {
        return this.tenantId;
    }

    public Integer getTenant2() {
        String tenant_id = this.request.getHeader("tenantId");
        if (StrUtil.isNotEmpty((CharSequence)tenant_id)) {
            return Integer.parseInt(tenant_id);
        }
        return this.tenantId;
    }

    public String getDrugRoomId() {
        String drugRoomId = this.request.getHeader("drugRoomId");
        if (StrUtil.isNotEmpty((CharSequence)drugRoomId)) {
            return drugRoomId;
        }
        throw new BusinessException(SystemEnum.DRUG_ROOM_ID_IS_NOT_NULL.getCode(), SystemEnum.DRUG_ROOM_ID_IS_NOT_NULL.getMsg());
    }

    public Integer getUserId() {
        return this.userId;
    }

    public SysUserEntity getUserInfo() {
        Integer usId = null;
        String userId = this.request.getHeader("userId");
        if (StrUtil.isNotEmpty((CharSequence)userId)) {
            usId = Integer.parseInt(userId);
        }
        SysUserEntity user = (SysUserEntity)this.sysUserMapper.selectById((Serializable)usId);
        return user;
    }

    public String getUserName() {
        try {
            return URLEncoder.encode(this.userName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return this.userName;
        }
    }

    public String getSignNo() {
        return Objects.isNull(this.request.getHeader("signNo")) ? "99999" : this.request.getHeader("signNo");
    }

    public void checkNumber(Integer ... number) {
        for (Integer i : number) {
            ExceptionUtils.createException((Logger)log, (i < 0 ? 1 : 0) != 0, (String)SysCommonEnum.PRICE_OR_NUMBER_LESS_ZERO.getCode(), (String)SysCommonEnum.PRICE_OR_NUMBER_LESS_ZERO.getName());
        }
    }

    public void checkPrice(BigDecimal ... price) {
        BigDecimal zero = BigDecimal.ZERO;
        for (BigDecimal p : price) {
            ExceptionUtils.createException((Logger)log, (p.compareTo(zero) < 0 ? 1 : 0) != 0, (String)SysCommonEnum.PRICE_OR_NUMBER_LESS_ZERO.getCode(), (String)SysCommonEnum.PRICE_OR_NUMBER_LESS_ZERO.getName());
        }
    }
}

