/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.util;

import com.alibaba.fastjson.JSONObject;
import com.byh.sdk.util.exception.BusinessException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class RSAUtils {
    private static Logger logger = LoggerFactory.getLogger(RSAUtils.class);
    public static final String PRIVATE_KEY = "PRIVATE_KEY";
    public static final String PUBLIC_KEY = "PUBLIC_KEY";
    private static final String ALGORITHM = "RSA";
    private static final String SIGN_TYPE = "SHA256withRSA";
    private static final Integer KEY_LENGTH = 1024;
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;

    public static PublicKey getPublicKey() throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        ClassPathResource resourcePublic = new ClassPathResource("rsa/rsa_public_key.pem");
        byte[] publicKeyBytes = Files.readAllBytes(Paths.get(resourcePublic.getURI()));
        String publicKeyStr = new String(publicKeyBytes, "UTF-8").replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "").replaceAll("\\s", "").trim();
        byte[] keyBytes = Base64.getDecoder().decode(publicKeyStr);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
        return keyFactory.generatePublic(keySpec);
    }

    public static PrivateKey getPrivateKey() throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        String publicKeyStr = "MIIEowIBAAKCAQEA2gxzn5gBHGJbDe/uLP7eF+cN3UZZndNnJXd9Ca/q4xV5XQ+gJaG8ez1ClCimR0xW1DHuI11aZdFUrr7UrvqKS0ClMNQxSZV/b2OpGujTNj87pyGrIDswv1SLGJFxk18NKnL0Rujbw7Iev1LPcFmbskU4WMCUrusJKL4/0TFHwhMKQy0LlbULJbCb9DP0pLUdHlIG+i13cTaHw/RRsrfg5GZbqVyxiOA9yP3LA5Kq3dxLSM8jFTcZ9Br+/QHhtCnG8SWYESISL5nOIDhGO/yljZMG/aWb9JD8hCaTqCzrMXtlBO/ZaWthzPEZ3x8npEkG4cYG1t8vWE/qqOrtE2PuMwIDAQABAoIBAHQ0tJ42VUk6RcqctvN19QkKE4J8zp/lHZCDKLkz7tuNAzwMas4Dbz7CvCvXqh5PWesGnSJtyxJ+SEJE43ZJgdBvKFpoi8fqi5rioyn7MS007+a3c8reoLEnLmYuhTgELTEVSIhN62lVETvntzPqHacZatkp8VNzYVM8aShkuhh8L1jWjhC9gbYPIy3rCLiq+ANvva3Q5FUIxFkI4Xm0ua/EzyclkMdUtV1fmWOQHXvz6AQnS55sMCHdKXgj/jVS7YSyvgw6/SUfZkS5/MnwYJGRk2CRqrEY6yKgabKcXRtlRvHH52zEfrz3VSSPA3WMR+M1UoI15oWSBfdbAg5HZmkCgYEA8MdQXHeqlYr+Ngqf7aBcYCxlAVI33bXm5LV2mG9ZBFiC6MbMmviwM8FEw+2UM8SirN0Nfbd+TKD0o+zXjCSdQBTCTlyamK1cXTpWfmkoS9C5g/+saOHwQr+L5VWlgMpxknWJTR/UGCTPj0X+0v9G7JgIGMyxaooJPu6iqHCOETcCgYEA59VIlzplEHO4JIofpq3jpoVY7V5/isAl2wbUfMhVudoZRTjbIPyUxZBj51zB4O4DrkRbkZQM0v9dAojKxqk7EwyOTpn+8aWfiYJ/lv6V+N7V+M58HHDWcyD/LoJU/YBftxxIjcrc/P5N5jB1dqgw73rRtuU9+BZbwQoOvDsJuOUCgYEAmmHh5/gem1YMm1ACrVVmBZBRjyBNi84HZtvnV+QFOqEaBvD43eDY8cZZNhtOLEdHWvk9nj8aLz4Avl6s8kHDxgPJdn8v7PczQt+V9+WrHbmOSdGUlYdRCytQItLglIy5d4P/bkEbOAPaRe5GbrmZmzf78RLGKx6owP43szLAFM8CgYAVTz2E6RExGfHrKecO4xzxyYALEYyXrGHOaCpP7fozQyDfhAJgXdcu8b69HYGUs0wTUKU6FGm5W0+pU/mPmS6c6aKLBwywGZE4io4/ytbuMU1puVEfLCAKJRZPqBs30fz6T9c7cVIuzxFJ/1pMtdkJqjhsn1W64BM/AzWnh6W1IQKBgB5yjh2qfwmXRKSv5YRRz3kBppIjIhSYTLsJ+QTzaceSceWSsWyZdo06l6Hi9hX/oyrbxzgOF5ADrZx6xR0WPlmA3ADNp6jVWIszjOeq6j3zvEV4VArlh6UpEnXU6vX4sxGvn6oa6tf0ffbBsAaE35y+9vqXOFDQFOQcXZ+DS8R7";
        byte[] keyBytes = Base64.getDecoder().decode(publicKeyStr);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
        return keyFactory.generatePrivate(keySpec);
    }

    public static String createSign(String source, PrivateKey privateKey) throws Exception {
        byte[] contentBytes = source.getBytes();
        Signature signature = Signature.getInstance(SIGN_TYPE);
        signature.initSign(privateKey);
        signature.update(contentBytes);
        byte[] signatureBytes = signature.sign();
        return Base64.getEncoder().encodeToString(signatureBytes);
    }

    public static Map<String, Key> genKeyPair() throws Exception {
        HashMap<String, Key> keyMap = new HashMap<String, Key>();
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(ALGORITHM);
        keyPairGenerator.initialize(KEY_LENGTH);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        keyMap.put(PUBLIC_KEY, publicKey);
        keyMap.put(PRIVATE_KEY, privateKey);
        return keyMap;
    }

    public static String privateKeyFromPkcs1ToPkcs8(String privateKeyInPKCS1) throws Exception {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(privateKeyInPKCS1));
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        return Base64.getEncoder().encodeToString(privateKey.getEncoded());
    }

    public static String getPublicKey2() throws IOException {
        ClassPathResource resourcePublic = new ClassPathResource("rsa/rsa_public_key.pem");
        byte[] publicKeyBytes = Files.readAllBytes(Paths.get(resourcePublic.getURI()));
        String publicKeyPEM = new String(publicKeyBytes, "UTF-8").replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "").replaceAll("\\s", "").trim();
        return publicKeyPEM;
    }

    public static String getPrivateKey2() throws IOException {
        ClassPathResource resourcePrivate = new ClassPathResource("rsa/rsa_private_key.pem");
        byte[] privateKeyBytes = Files.readAllBytes(Paths.get(resourcePrivate.getURI()));
        String privateKeyPEM = new String(privateKeyBytes, "UTF-8").replace("-----BEGIN RSA PRIVATE KEY-----", "").replace("-----END RSA PRIVATE KEY-----", "").replaceAll("\\s", "");
        return privateKeyPEM;
    }

    public static byte[] createSign2(String source, String privateKeyBase64Encoded) throws Exception {
        byte[] privateKeyDER = Base64.getDecoder().decode(privateKeyBase64Encoded);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyDER);
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        Signature signet = Signature.getInstance(SIGN_TYPE);
        signet.initSign(privateKey);
        signet.update(source.getBytes());
        return signet.sign();
    }

    public static JSONObject getICBCApi(String url, String uuid, String format, String appId, String base64Str, String cateSign) throws IOException {
        String line;
        URL ul = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)ul.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setDoOutput(true);
        JSONObject jo = new JSONObject();
        jo.put("app_id", (Object)appId);
        jo.put("time_stamp", (Object)format);
        jo.put("data", (Object)base64Str);
        jo.put("nonce", (Object)uuid);
        jo.put("sign_type", (Object)"RSA2");
        jo.put("sign", (Object)cateSign);
        OutputStream os = connection.getOutputStream();
        os.write(jo.toJSONString().getBytes());
        os.flush();
        BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuilder response = new StringBuilder();
        while ((line = br.readLine()) != null) {
            response.append(line);
        }
        br.close();
        connection.disconnect();
        logger.info("\n \u5de5\u884c\u652f\u4ed8\u4e0b\u5355\u54cd\u5e94\uff1a\n" + response.toString());
        JSONObject jsonObj = JSONObject.parseObject((String)response.toString());
        String code = jsonObj.getString("return_code");
        if ("SUCCESS".equals(code)) {
            String data = jsonObj.getString("data");
            byte[] decodedBytes = Base64.getDecoder().decode(data);
            String decodedString = new String(decodedBytes);
            logger.info("\n \u5c06\u8fd4\u56de\u7ed3\u679c\u96c6\u4f7f\u7528base64\u89e3\u5bc6\u51fa\u6765\uff1a" + decodedString);
            return JSONObject.parseObject((String)decodedString);
        }
        if ("FAIL".equals(code)) {
            String msg = jsonObj.getString("return_msg");
            throw new BusinessException("\u5de5\u884c\u8fd4\u56de\u7ed3\u679c\u96c6\uff01{msg}" + msg);
        }
        return jsonObj;
    }

    public static void main(String[] args) {
        try {
            String line;
            URL url = new URL("https://pay-test.bx.com.cn/api/order/micropay");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("app_id", (Object)"1165464651");
            jsonObject.put("time_stamp", (Object)"20201231152732");
            jsonObject.put("data", (Object)"eyJtZXJjaElkIjoiMTgzMzA2Iiwib3JkZXJObyI6IjIwMjAxMjI4MTQzNTE4MjEifQ==");
            jsonObject.put("nonce", (Object)"A337314CCCF74F8B8B3E1966C7F85411");
            jsonObject.put("sign_type", (Object)"RSA2");
            jsonObject.put("sign", (Object)"gDDK1gyDK97zxMBj5HufG3bofRCWqghCnvWiDqim3Gm+4mF8j7XY41EwAbZbKnivX3dornJ8opTTUPgOtMvtIlPtDTTbTjGe21CA26tr0Mb0bDzHjFbwMaIPhQof5kGDXGc6HErJOI3ULQ155epQ0FfI2GIpGzrBg0G9xi0WyIw+ZoN02dhlaj45iOT4eSfAF+G1ruXcpZB6Au7IwN16kaGl3STfY0ecJZXNI1zXv4PVN5eNwb2vVd6nMN3yBoqy5F++YB/ZenzFlxZy1rQ6gzOPaLOG75uMyp7rBSnpoNJE90zFyLTE86gzwN49AOZLXxDSW/B2bx5nF5AbpBtaLw==");
            OutputStream os = connection.getOutputStream();
            os.write(jsonObject.toJSONString().getBytes());
            os.flush();
            BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((line = br.readLine()) != null) {
                response.append(line);
            }
            br.close();
            System.out.println("\u5de5\u884c\u626b\u7801\u652f\u4ed8\u63a5\u53e3\u54cd\u5e94\uff1a" + response.toString());
            connection.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

