/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.util.weChat;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.byh.sdk.entity.weChat.AccessTokenResponse;
import com.byh.sdk.entity.weChat.WxPushResponse;
import com.byh.sdk.util.HttpUtils;
import com.byh.sdk.util.RedisUtil;
import com.byh.sdk.util.weChat.AesException;
import com.byh.sdk.util.weChat.WXBizMsgCrypt;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class WeChatUtil {
    private static final Logger log = LoggerFactory.getLogger(WeChatUtil.class);
    @Value(value="${weChat.corpid}")
    private String corpId;
    @Value(value="${weChat.corpsecret}")
    private String corpSecret;
    @Value(value="${weChat.accessTokenUrl}")
    private String accessTokenUrl;
    @Value(value="${weChat.token}")
    private String token;
    @Value(value="${weChat.encodingAESKey}")
    private String encodingAESKey;
    @Autowired
    private RedisUtil redisUtil;
    public static final String ACCESS_TOKEN_KEY = "WE_CHAT_ACCESS_TOKEN";

    public String getAccessToken() {
        Object token = this.redisUtil.get("WE_CHAT_ACCESS_TOKEN");
        log.info("reids.weChat.accessToken {}", token);
        if (Objects.nonNull(token)) {
            return token.toString();
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("corpid", this.corpId);
        paramMap.put("corpsecret", this.corpSecret);
        String result = HttpUtils.get((String)this.accessTokenUrl, paramMap);
        log.info("reomote.accessToken\u8fd4\u56de:{}", (Object)result);
        AccessTokenResponse accessTokenResponse = (AccessTokenResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), AccessTokenResponse.class);
        if (0 != accessTokenResponse.getErrcode()) {
            throw new IllegalArgumentException(accessTokenResponse.getErrmsg());
        }
        String access_token = accessTokenResponse.getAccess_token();
        this.redisUtil.set("WE_CHAT_ACCESS_TOKEN", (Object)access_token, 6500L);
        return access_token;
    }

    public boolean checkSignature(String signature, String timestamp, String nonce) {
        log.info("token:{}", (Object)timestamp, (Object)nonce);
        Object[] arr = new String[]{this.token, timestamp, nonce};
        Arrays.sort(arr);
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            content.append((String)arr[i]);
        }
        MessageDigest md = null;
        String tmpStr = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
            byte[] digest = md.digest(content.toString().getBytes());
            tmpStr = WeChatUtil.byteToStr((byte[])digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        content = null;
        return tmpStr != null ? tmpStr.equals(signature.toUpperCase()) : false;
    }

    private static String byteToStr(byte[] byteArray) {
        String strDigest = "";
        for (int i = 0; i < byteArray.length; ++i) {
            strDigest = strDigest + WeChatUtil.byteToHexStr((byte)byteArray[i]);
        }
        return strDigest;
    }

    private static String byteToHexStr(byte mByte) {
        char[] Digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] tempArr = new char[]{Digit[mByte >>> 4 & 0xF], Digit[mByte & 0xF]};
        String s = new String(tempArr);
        return s;
    }

    public static String getXmlString(WxPushResponse eventPush) {
        String xml = "";
        if (eventPush != null) {
            xml = "<xml>";
            xml = xml + "<ToUserName><![CDATA[";
            xml = xml + eventPush.getToUserName();
            xml = xml + "]]></ToUserName>";
            xml = xml + "<FromUserName><![CDATA[";
            xml = xml + eventPush.getFromUserName();
            xml = xml + "]]></FromUserName>";
            xml = xml + "<CreateTime>";
            xml = xml + eventPush.getCreateTime();
            xml = xml + "</CreateTime>";
            xml = xml + "<MsgType><![CDATA[";
            xml = xml + eventPush.getMsgType();
            xml = xml + "]]></MsgType>";
            xml = xml + "<Content><![CDATA[";
            xml = xml + eventPush.getContent();
            xml = xml + "]]></Content>";
            xml = xml + "</xml>";
        }
        return xml;
    }

    public static Document getDocument(HttpServletRequest request) {
        SAXReader reader = new SAXReader();
        try {
            ServletInputStream ins = request.getInputStream();
            Document doc = reader.read((InputStream)ins);
            return doc;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Map<String, String> docToMap(Document doc) {
        HashMap<String, String> map = new HashMap<String, String>();
        Element root = doc.getRootElement();
        List list = root.elements();
        for (Element element : list) {
            map.put(element.getName(), element.getText());
        }
        return map;
    }

    public String qwCheckSignature(String msgSignature, String nonce, String echoStr, String timeStamp) {
        WXBizMsgCrypt wxcpt = null;
        String sEchoStr = null;
        try {
            wxcpt = new WXBizMsgCrypt(this.token, this.encodingAESKey, this.corpId);
            sEchoStr = wxcpt.VerifyURL(msgSignature, timeStamp, nonce, echoStr);
        }
        catch (AesException e) {
            e.printStackTrace();
        }
        return sEchoStr;
    }

    public String handleSecret(HttpServletRequest request, String msgSignature, String timeStamp, String nonce, String postData) throws IOException, AesException {
        log.info("postData\uff1a{}", (Object)postData);
        WXBizMsgCrypt wxcpt = new WXBizMsgCrypt(this.token, this.encodingAESKey, this.corpId);
        String sMsg = wxcpt.DecryptMsg(msgSignature, timeStamp, nonce, postData);
        return sMsg;
    }
}

