/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.controller.icbc;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sdk.entity.icbc.ICBCOrderDto;
import com.byh.sdk.entity.icbc.ICBCOrderEntity;
import com.byh.sdk.entity.icbc.IcbcApiRequest;
import com.byh.sdk.entity.icbc.IcbcMicroPayDto;
import com.byh.sdk.entity.icbc.IcbcRefundDto;
import com.byh.sdk.service.ICBCOrderService;
import com.byh.sdk.util.CommonRequest;
import com.byh.sdk.util.RSAUtils;
import com.byh.sdk.util.ResponseData;
import com.byh.sdk.util.UUIDUtils;
import com.byh.sdk.util.exception.BusinessException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.PrivateKey;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/qrCode"})
public class IcbcChargeController {
    @Value(value="${icbc.url}")
    private String urlDev;
    @Value(value="${icbc.appId}")
    private String appId;
    @Value(value="${icbc.merchId}")
    private String merchId;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ICBCOrderService icbcOrderService;
    private final CommonRequest commonRequest;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/microPay"})
    @DS(value="mysql3")
    public ResponseData microPay(@RequestBody IcbcMicroPayDto dto) {
        try {
            ICBCOrderEntity vailIcbcOrder = this.doVailCharge(dto.getOrderNo());
            if (vailIcbcOrder != null) {
                return ResponseData.success((Object)vailIcbcOrder);
            }
            IcbcApiRequest icbcApiRequest = new IcbcApiRequest();
            icbcApiRequest.setServiceId("/order/micropay");
            icbcApiRequest.setBizdata(JSON.parseObject((String)JSON.toJSONString((Object)dto)));
            JSONObject outData = this.sendIcbcApiRequest(icbcApiRequest);
            String tradeStatus = outData.getString("tradeStatus");
            ICBCOrderEntity icbcOrderEntity = (ICBCOrderEntity)outData.toJavaObject(ICBCOrderEntity.class);
            icbcOrderEntity.setMerchId(this.merchId);
            icbcOrderEntity.setTenantId(this.commonRequest.getTenant());
            icbcOrderEntity.setCreateId(this.commonRequest.getUserId());
            icbcOrderEntity.setCreateTime(new Date());
            icbcOrderEntity.setPayTime(this.getFormDate());
            icbcOrderEntity.setSettleStatus("10");
            icbcOrderEntity.setSettleType("1");
            icbcOrderEntity.setTradeStatus("\u6b63\u5728\u652f\u4ed8\u4e2d");
            this.icbcOrderService.save((Object)icbcOrderEntity);
            this.logger.info("\u5de5\u884c\u652f\u4ed8\u4e1a\u52a1\u53d7\u7406\u6210\u529f,\u5f00\u59cb\u67e5\u8be2\u6536\u8d39\u7ed3\u679c");
            String code = "";
            if ("SUCCESS".equals(tradeStatus)) {
                icbcOrderEntity.setSettleStatus("1");
                icbcOrderEntity.setSettleType("1");
                icbcOrderEntity.setTradeStatus("\u652f\u4ed8\u6210\u529f");
                this.icbcOrderService.updateById((Object)icbcOrderEntity);
                return ResponseData.success((Object)icbcOrderEntity);
            }
            int count = 1;
            int seconds = 1000;
            while (true) {
                if (count > 5) {
                    this.logger.error("\u7b49\u5f855\u6b21\u67e5\u8be2\u90fd\u672a\u67e5\u8be2\u5230\u5f00\u5177\u7ed3\u679c");
                    throw new BusinessException("\u5de5\u884c\u652f\u4ed8\u5931\u8d25,\u72b6\u6001\u7801\u4e3a(" + code + "),\u8bf7\u7a0d\u540e\u91cd\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458");
                }
                try {
                    Thread.sleep(seconds);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                finally {
                    seconds *= 2;
                }
                icbcApiRequest = new IcbcApiRequest();
                icbcApiRequest.setServiceId("/order/orderquery");
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("orderNo", (Object)dto.getOrderNo());
                jsonObject.put("oriTxDate", (Object)this.getFormDateTime());
                icbcApiRequest.setBizdata(jsonObject);
                JSONObject queryData = this.sendIcbcApiRequest(icbcApiRequest);
                tradeStatus = queryData.getString("tradeStatus");
                if ("NOTPAY".equals(tradeStatus)) {
                    this.icbcOrderService.removeById((Object)icbcOrderEntity);
                    throw new BusinessException("\u5de5\u884c\u652f\u4ed8\u5931\u8d25,\u72b6\u6001\u7801\u4e3a(" + tradeStatus + "),\u8bf7\u7a0d\u540e\u91cd\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458");
                }
                if ("SUCCESS".equals(tradeStatus)) {
                    icbcOrderEntity.setPayTime(this.getFormDate());
                    icbcOrderEntity.setSettleStatus("1");
                    icbcOrderEntity.setSettleType("1");
                    icbcOrderEntity.setTradeStatus("\u652f\u4ed8\u6210\u529f");
                    this.icbcOrderService.updateById((Object)icbcOrderEntity);
                    return ResponseData.success((Object)icbcOrderEntity);
                }
                code = tradeStatus;
                ++count;
            }
        }
        catch (Exception e) {
            return ResponseData.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"/refund"})
    @DS(value="mysql3")
    public ResponseData refund(@RequestBody IcbcRefundDto dto) {
        try {
            Integer payDays = dto.getPayDays();
            if (0 == payDays) {
                throw new BusinessException("\u9000\u6b3e\u5929\u6570\u5df2\u7ecf\u8fc7\u4e09\u4e2a\u6708 \u4e0d\u80fd\u9000\u6b3e!" + payDays);
            }
            ICBCOrderEntity chargeOrder = (ICBCOrderEntity)this.icbcOrderService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ICBCOrderEntity::getOrderNo, (Object)dto.getOriOrderNo())).eq(ICBCOrderEntity::getTenantId, (Object)this.commonRequest.getTenant())).eq(ICBCOrderEntity::getSettleType, (Object)"1")).eq(ICBCOrderEntity::getSettleStatus, (Object)"1"));
            if (chargeOrder == null) {
                throw new BusinessException("\u672a\u627e\u5230\u6536\u8d39\u8bb0\u5f55");
            }
            List orderEntityList = this.icbcOrderService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ICBCOrderEntity::getOrderNo, (Object)dto.getOriOrderNo())).eq(ICBCOrderEntity::getTenantId, (Object)this.commonRequest.getTenant())).eq(ICBCOrderEntity::getSettleType, (Object)"2")).eq(ICBCOrderEntity::getSettleStatus, (Object)"2"));
            if (orderEntityList != null && !orderEntityList.isEmpty()) {
                Integer userPayamt = chargeOrder.getUserPayamt();
                Integer amountRefunded = orderEntityList.stream().map(ICBCOrderEntity::getRefundFee).reduce(0, Integer::sum);
                Integer currentRefundFee = dto.getRefundFee();
                if (userPayamt.compareTo(Integer.sum(amountRefunded, currentRefundFee)) < 0) {
                    throw new BusinessException(String.format("\u5f53\u524d\u8ba2\u5355\u5b9e\u9645\u652f\u4ed8\u91d1\u989d\uff1a%s\uff0c\u5df2\u9000\u91d1\u989d\uff1a%s\uff0c\u5f53\u524d\u7533\u8bf7\u9000\u6b3e\u91d1\u989d%s\uff0c\u4e0d\u80fd\u518d\u8fdb\u884c\u9000\u6b3e\u4e86", userPayamt.toString(), amountRefunded.toString(), currentRefundFee.toString()));
                }
            }
            dto.setOrderNo(UUIDUtils.getRandom((int)5, (boolean)true));
            IcbcApiRequest icbcApiRequest = new IcbcApiRequest();
            icbcApiRequest.setServiceId("/order/refund");
            JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)dto));
            jsonObject.put("opUse", (Object)this.merchId);
            icbcApiRequest.setBizdata(jsonObject);
            JSONObject outData = this.sendIcbcApiRequest(icbcApiRequest);
            String returnCode = outData.getString("return_code");
            if (!"SUCCESS".equals(returnCode)) {
                chargeOrder.setRefundFee(Integer.valueOf(chargeOrder.getRefundFee() == null ? 0 : chargeOrder.getRefundFee()));
                chargeOrder.setRefundFee(Integer.valueOf(Integer.sum(chargeOrder.getRefundFee(), outData.getInteger("refundFee"))));
                this.icbcOrderService.updateById((Object)chargeOrder);
                String oriOrderNo = outData.getString("oriOrderNo");
                String orderNo = outData.getString("orderNo");
                String refundFee = outData.getString("refundFee");
                chargeOrder.setId(null);
                chargeOrder.setOrderNo(oriOrderNo);
                chargeOrder.setNewOrderNo(orderNo);
                chargeOrder.setTradeStatus("\u9000\u6b3e\u6210\u529f");
                chargeOrder.setRefundFee(Integer.valueOf(Integer.parseInt(refundFee)));
                chargeOrder.setMerchId(this.merchId);
                chargeOrder.setTenantId(this.commonRequest.getTenant());
                chargeOrder.setCreateId(this.commonRequest.getUserId());
                chargeOrder.setCreateTime(new Date());
                chargeOrder.setPayTime(this.getFormDate());
                chargeOrder.setSettleStatus("2");
                chargeOrder.setSettleType("2");
                this.icbcOrderService.save((Object)chargeOrder);
                return ResponseData.success((Object)chargeOrder);
            }
            throw new BusinessException("\u5de5\u884c\u652f\u4ed8\u9000\u6b3e\u5931\u8d25,\u72b6\u6001\u4e3a(" + returnCode + ")");
        }
        catch (Exception e) {
            return ResponseData.error((String)e.getMessage());
        }
    }

    public JSONObject sendIcbcApiRequest(IcbcApiRequest icbcApiRequest) {
        JSONObject resJsonObject = new JSONObject();
        JSONObject bizdata = icbcApiRequest.getBizdata();
        bizdata.put("merchId", (Object)this.merchId);
        try {
            String uuid = UUIDUtils.getRandom((int)5, (boolean)true);
            String base64Str = Base64.getEncoder().encodeToString(bizdata.toJSONString().getBytes());
            String formDate = this.getFormDate();
            String queryString = "app_id=" + this.appId.concat("&data=" + base64Str).concat("&nonce=" + uuid).concat("&sign_type=RSA2").concat("&time_stamp=" + formDate);
            JSONObject jo = new JSONObject();
            jo.put("app_id", (Object)this.appId);
            jo.put("time_stamp", (Object)formDate);
            jo.put("data", (Object)base64Str);
            jo.put("nonce", (Object)uuid);
            jo.put("sign_type", (Object)"RSA2");
            jo.put("sign", (Object)RSAUtils.createSign((String)queryString, (PrivateKey)RSAUtils.getPrivateKey()));
            this.logger.info("\u5de5\u884c\u652f\u4ed8\u8c03\u7528\u670d\u52a1:" + icbcApiRequest.getServiceId() + "; \u5165\u53c2:" + bizdata.toJSONString());
            HttpRequest httpRequest = HttpUtil.createPost((String)(this.urlDev + icbcApiRequest.getServiceId()));
            httpRequest.contentType("application/json");
            httpRequest.body(jo.toJSONString());
            this.logger.info("\u5de5\u884c\u652f\u4ed8\u8c03\u7528\u670d\u52a1:" + icbcApiRequest.getServiceId() + "\uff1b\u5373\u5c06\u5f00\u59cb\u8bf7\u6c42\uff01\uff01\uff01\uff01\uff01 ");
            HttpResponse httpResponse = httpRequest.execute();
            String response = httpResponse.body();
            this.logger.info("\u5de5\u884c\u652f\u4ed8\u8c03\u7528\u670d\u52a1:" + icbcApiRequest.getServiceId() + "; \u5bc6\u6587\u56de\u53c2:" + response);
            resJsonObject = JSONObject.parseObject((String)response);
            JSONObject jsonObj = JSONObject.parseObject((String)response);
            String code = jsonObj.getString("return_code");
            if ("SUCCESS".equals(code)) {
                String data = jsonObj.getString("data");
                String decodedString = new String(Base64.getDecoder().decode(data));
                this.logger.info("\u5de5\u884c\u652f\u4ed8\u8c03\u7528\u670d\u52a1:" + icbcApiRequest.getServiceId() + "; \u660e\u6587\u56de\u53c2:" + decodedString);
                resJsonObject = JSONObject.parseObject((String)decodedString);
                return resJsonObject;
            }
            if ("FAIL".equals(code)) {
                throw new BusinessException(jsonObj.getString("return_msg"));
            }
            return jsonObj;
        }
        catch (Exception e) {
            String stackTrace;
            this.logger.error("\u5de5\u884c\u652f\u4ed8\u8c03\u7528\u670d\u52a1:" + icbcApiRequest.getServiceId() + "; \u5165\u53c2:" + bizdata.toJSONString());
            this.logger.error("\u5de5\u884c\u652f\u4ed8\u8c03\u7528\u670d\u52a1:" + icbcApiRequest.getServiceId() + "; \u8fd4\u53c2:" + resJsonObject);
            if (StrUtil.isEmpty((CharSequence)e.getMessage())) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                stackTrace = sw.toString();
            } else {
                stackTrace = e.getMessage();
            }
            throw new BusinessException("\u5de5\u884c\u652f\u4ed8\u8c03\u7528\u670d\u52a1\u5931\u8d25:" + stackTrace);
        }
    }

    private String getFormDate() {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        return now.format(formatter);
    }

    private String getFormDateTime() {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        return now.format(formatter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICBCOrderEntity doVailCharge(String orderNo) {
        this.logger.info("\u5de5\u884c\u6536\u8d39\u9a8c\u8bc1\uff0c\u8ba2\u5355\u53f7\uff1a{}", (Object)orderNo);
        ICBCOrderEntity icbcOrderEntity = (ICBCOrderEntity)this.icbcOrderService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ICBCOrderEntity::getOrderNo, (Object)orderNo)).eq(ICBCOrderEntity::getSettleType, (Object)"1")).eq(ICBCOrderEntity::getTenantId, (Object)this.commonRequest.getTenant()));
        if (icbcOrderEntity == null) {
            return null;
        }
        if ("1".equals(icbcOrderEntity.getSettleStatus())) {
            return icbcOrderEntity;
        }
        int count = 1;
        int seconds = 1000;
        String code = "";
        while (true) {
            if (count > 5) {
                this.logger.error("\u7b49\u5f855\u6b21\u67e5\u8be2\u90fd\u672a\u67e5\u8be2\u5230\u5f00\u5177\u7ed3\u679c");
                throw new BusinessException("\u5de5\u884c\u652f\u4ed8\u5931\u8d25,\u72b6\u6001\u7801\u4e3a(" + code + "),\u8bf7\u7a0d\u540e\u91cd\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            try {
                Thread.sleep(seconds);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                seconds *= 2;
            }
            IcbcApiRequest icbcApiRequest = new IcbcApiRequest();
            icbcApiRequest.setServiceId("/order/orderquery");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("orderNo", (Object)orderNo);
            jsonObject.put("oriTxDate", (Object)this.getFormDateTime());
            icbcApiRequest.setBizdata(jsonObject);
            JSONObject queryData = this.sendIcbcApiRequest(icbcApiRequest);
            String tradeStatus = queryData.getString("tradeStatus");
            if ("SUCCESS".equals(tradeStatus)) {
                icbcOrderEntity.setPayTime(this.getFormDate());
                icbcOrderEntity.setSettleStatus("1");
                icbcOrderEntity.setSettleType("1");
                icbcOrderEntity.setTradeStatus("\u652f\u4ed8\u6210\u529f");
                this.icbcOrderService.updateById((Object)icbcOrderEntity);
                return icbcOrderEntity;
            }
            if ("NOTPAY".equals(tradeStatus)) {
                this.icbcOrderService.removeById((Object)icbcOrderEntity);
                this.logger.error("\u9a8c\u8bc1\u5de5\u884c\u652f\u4ed8\u5931\u8d25,\u652f\u4ed8\u72b6\u6001\u4e3a: {} , \u8bf7\u7a0d\u540e\u91cd\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458", (Object)code);
                throw new BusinessException("\u9a8c\u8bc1\u5de5\u884c\u652f\u4ed8\u5931\u8d25,\u652f\u4ed8\u72b6\u6001\u4e3a:" + code + ",\u8bf7\u7a0d\u540e\u91cd\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            code = tradeStatus;
            ++count;
        }
    }

    @GetMapping(value={"/pageICBC"})
    @DS(value="mysql3")
    public ResponseData pageICBC(Page page, ICBCOrderDto dto) {
        Integer tenantId = this.commonRequest.getTenant();
        dto.setTenantId(tenantId);
        IPage iPage = this.icbcOrderService.pageICBC(page, dto);
        return ResponseData.success((Object)page);
    }

    public IcbcChargeController(ICBCOrderService icbcOrderService, CommonRequest commonRequest) {
        this.icbcOrderService = icbcOrderService;
        this.commonRequest = commonRequest;
    }
}

