/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.controller.syt;

import com.alibaba.fastjson.JSONObject;
import com.byh.sdk.entity.request.SysDrugEntity;
import com.byh.sdk.entity.syt.SytDto;
import com.byh.sdk.feign.sys.SysServiceFeign;
import com.byh.sdk.mapper.SysDrugMapper;
import com.byh.sdk.service.SYTSystemService;
import com.byh.sdk.util.CommonRequest;
import com.byh.sdk.util.ExceptionUtils;
import com.byh.sdk.util.JsonUtils;
import com.byh.sdk.util.ResponseData;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/syt/check"})
public class SYTCheckController {
    private static final Logger log = LoggerFactory.getLogger(SYTCheckController.class);
    @Autowired
    public SysServiceFeign sysServiceFeign;
    @Autowired
    private CommonRequest commonRequest;
    @Autowired
    private SYTSystemService sytSystemService;
    @Autowired
    private SysDrugMapper sysDrugMapper;

    @RequestMapping(value={"/send"})
    public ResponseData check(@RequestBody JSONObject json) {
        HashMap<String, JSONObject> jsonMap = new HashMap<String, JSONObject>(5);
        for (Map.Entry entry : json.entrySet()) {
            if ("false".equals(String.valueOf(entry.getValue()))) continue;
            SysDrugEntity drugEntity = this.sysDrugMapper.select((String)entry.getKey(), this.commonRequest.getTenant2());
            ExceptionUtils.createException((Logger)log, (boolean)Objects.isNull(drugEntity), (String)("\u836f\u54c1ID\uff1a" + (String)entry.getKey() + "\u836f\u54c1\u672a\u627e\u5230\u6216\u88ab\u505c\u7528"));
            SytDto sytDto = new SytDto(String.valueOf(entry.getValue()));
            JSONObject jsonObject = this.sytSystemService.inScanCodeInfo(sytDto);
            ExceptionUtils.createException((Logger)log, (!"0".equals(String.valueOf(jsonObject.get((Object)"msg_code"))) ? 1 : 0) != 0, (String)String.valueOf(jsonObject.get((Object)"msg_info")));
            JsonUtils arrayValue = JsonUtils.create((Object)jsonObject).getObjectValue("result").getObjectValue("code_info").getArrayValue();
            ExceptionUtils.createException((Logger)log, (boolean)CollectionUtils.isEmpty((Collection)arrayValue.getList()), (String)(drugEntity.getDrugsName() + ":" + String.valueOf(entry.getKey()) + "\u672a\u67e5\u8be2\u5230\u8ffd\u6eaf\u7801\u4fe1\u606f"));
            JSONObject codeInfo = (JSONObject)arrayValue.getList().get(0);
            String prodId = String.valueOf(codeInfo.get((Object)"prod_id"));
            String physicName = String.valueOf(codeInfo.get((Object)"physic_name"));
            String prepnSpec = String.valueOf(codeInfo.get((Object)"prepn_spec"));
            String pkgSpec = String.valueOf(codeInfo.get((Object)"pkg_spec"));
            String spliteName = prodId + "-" + physicName + "-" + prepnSpec + "*" + pkgSpec;
            if (null == drugEntity.getSytDrugName() || spliteName.equals(drugEntity.getSytDrugName())) continue;
            jsonMap.put(drugEntity.getDrugsName(), codeInfo);
        }
        return ResponseData.success(jsonMap);
    }
}

