/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.sdk.entity.FlDataCallBack.FlDataCallBackEntity;
import com.byh.sdk.entity.FlDataCallBack.MessageAlReadyEntity;
import com.byh.sdk.entity.FlDataCallBack.PushDownloadLocalbillEntity;
import com.byh.sdk.mapper.FlDataCallBackMapper;
import com.byh.sdk.service.FlDataCallBackService;
import com.byh.sdk.util.HttpUtils;
import com.byh.sdk.util.exception.BusinessException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FlDataCallBackServiceImpl
implements FlDataCallBackService {
    private static final Logger log = LoggerFactory.getLogger(FlDataCallBackServiceImpl.class);
    private String server_url = "http://171.34.133.170:8012";
    @Resource
    private FlDataCallBackMapper flDataCallBackMapper;

    @Transactional(rollbackFor={BusinessException.class})
    public Map<String, Object> getLastOrderNo(FlDataCallBackEntity entity) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        JSONObject jsonObject = JSONObject.parseObject((String)entity.getDataitem_content());
        Object o = jsonObject.get((Object)"bill");
        if (Objects.nonNull(o)) {
            JSONObject json = new JSONObject();
            json.put("result", o);
            json.put("msg_info", (Object)"\u8bf7\u6c42\u6210\u529f");
            json.put("msg_code", (Object)0);
            entity.setDataitem_content(json.toJSONString());
        }
        int msgType = 0;
        System.out.println(entity.getDataitem_methodname());
        if ("push_download_localbill".equals(entity.getDataitem_methodname())) {
            msgType = 2;
            entity = this.pushDownloadLocalbill(entity);
        } else if ("push_download_upbill".equals(entity.getDataitem_methodname())) {
            entity = this.pushDownloadUpbill(entity);
            msgType = 1;
        }
        List ls = this.flDataCallBackMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(PushDownloadLocalbillEntity::getBill_code, (Object)entity.getBill_code()));
        if (!ls.isEmpty()) {
            this.messageAlready(new MessageAlReadyEntity(entity.getPush_msgid(), Integer.valueOf(msgType), "1", "\u6570\u636e\u91cd\u590d\u63a8\u9001\uff0c\u4e0d\u518d\u8fdb\u884c\u4fdd\u5b58"));
            map.put("msg_code", 0);
            map.put("msg_info", "\u6570\u636e\u91cd\u590d\u63a8\u9001\uff0c\u4e0d\u518d\u8fdb\u884c\u4fdd\u5b58");
            return map;
        }
        int a = this.flDataCallBackMapper.insert((Object)entity);
        if (a <= 0) {
            this.messageAlready(new MessageAlReadyEntity(entity.getPush_msgid(), Integer.valueOf(msgType), "2", "\u6570\u636e\u63d2\u5165\u6570\u636e\u5e93\u5931\u8d25"));
            map.put("msg_code", 500);
            map.put("msg_info", "\u8bf7\u6c42\u5931\u8d25\uff0c\u63d2\u5165\u6570\u636e\u5e93\u51fa\u73b0\u5f02\u5e38");
            return map;
        }
        this.messageAlready(new MessageAlReadyEntity(entity.getPush_msgid(), Integer.valueOf(msgType), "1", "\u6570\u636e\u63d2\u5165\u6570\u636e\u5e93\u6210\u529f"));
        map.put("msg_code", 0);
        map.put("msg_info", "\u8bf7\u6c42\u6210\u529f");
        return map;
    }

    public JSONObject messageAlready(MessageAlReadyEntity entity) {
        try {
            String response = HttpUtils.post((String)(this.server_url + "/system/pushmsgreceipt"), (String)JSONObject.toJSONString((Object)entity));
            return this.formatJsonStr(response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private FlDataCallBackEntity pushDownloadLocalbill(FlDataCallBackEntity entity) {
        Map m = (Map)JSONObject.parseObject((String)entity.getDataitem_content(), HashMap.class);
        JSONObject billJson = JSONObject.parseObject((String)((JSONObject)m.get("result")).toString());
        entity.setFromrefentid(billJson.get((Object)"fromrefentid").toString());
        entity.setFromentname(billJson.get((Object)"fromentname").toString());
        entity.setTorefentid(billJson.get((Object)"torefentid").toString());
        entity.setToentname(billJson.get((Object)"toentname").toString());
        entity.setPush_msgid(billJson.get((Object)"push_msgid").toString());
        entity.setBill_code(billJson.get((Object)"bill_code").toString());
        return entity;
    }

    private FlDataCallBackEntity pushDownloadUpbill(FlDataCallBackEntity entity) {
        Map m = (Map)JSONObject.parseObject((String)entity.getDataitem_content(), HashMap.class);
        JSONObject billJson = JSONObject.parseObject((String)((JSONObject)m.get("result")).get((Object)"bill").toString());
        entity.setFromrefentid(billJson.get((Object)"fromrefentid").toString());
        entity.setFromentname(billJson.get((Object)"fromentname").toString());
        entity.setTorefentid(billJson.get((Object)"torefentid").toString());
        entity.setToentname(billJson.get((Object)"toentname").toString());
        entity.setPush_msgid(billJson.get((Object)"push_msgid").toString());
        entity.setBill_code(billJson.get((Object)"bill_code").toString());
        return entity;
    }

    private JSONObject formatJsonStr(String jsonStr) {
        String replace = jsonStr.replace("\\", "");
        JSONObject json = JSON.parseObject((String)replace);
        return json;
    }
}

