/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.controller.syt;

import com.alibaba.fastjson.JSONObject;
import com.byh.sdk.entity.SysDrugGiveWarningLogEntity;
import com.byh.sdk.entity.request.SysDrugEntity;
import com.byh.sdk.entity.syt.SytDto;
import com.byh.sdk.feign.sys.SysServiceFeign;
import com.byh.sdk.mapper.SysDrugGiveWarningLogMapper;
import com.byh.sdk.mapper.SysDrugMapper;
import com.byh.sdk.mapper.sys.SysParamMapper;
import com.byh.sdk.service.SYTSystemService;
import com.byh.sdk.util.CommonRequest;
import com.byh.sdk.util.ExceptionUtils;
import com.byh.sdk.util.JsonUtils;
import com.byh.sdk.util.ResponseData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/syt/check"})
public class SYTCheckController {
    private static final Logger log = LoggerFactory.getLogger(SYTCheckController.class);
    @Autowired
    public SysServiceFeign sysServiceFeign;
    @Autowired
    private CommonRequest commonRequest;
    @Autowired
    private SYTSystemService sytSystemService;
    @Autowired
    private SysDrugMapper sysDrugMapper;
    @Autowired
    private SysParamMapper sysParamMapper;
    @Autowired
    private SysDrugGiveWarningLogMapper sysDrugGiveWarningLogMapper;

    @RequestMapping(value={"/send"})
    public ResponseData check(HttpServletRequest request, @RequestBody JSONObject json) {
        String drugRoomId = request.getHeader("drugRoomId");
        String pharmacyIds = this.sysParamMapper.selectByNameReturnValue("check_codg_pharmacy", this.commonRequest.getTenant());
        if (pharmacyIds.indexOf(drugRoomId) == -1) {
            return ResponseData.success().data((Object)new JSONObject());
        }
        log.info("\u6821\u9a8c\u64cd\u4f5c\uff1a1 ========== \u53d1\u836f\u68c0\u9a8c\u5f00\u59cb\uff1b\u5165\u53c2\uff1a\u5904\u65b9\u53f7\uff1a{}\uff1b\u8ffd\u6eaf\u7801\uff1a{}", json.get((Object)"prescriptionNo"), (Object)JSONObject.toJSONString((Object)json.get((Object)"drugList")));
        String value = this.sysParamMapper.selectByNameReturnValue("drug_code_check", this.commonRequest.getTenant());
        if ("0".equals(value)) {
            log.info("\u6821\u9a8c\u64cd\u4f5c\uff1a1-1 ========== \u68c0\u67e5\u5230\u5f53\u524d\u7cfb\u7edf\u914d\u7f6e\u4e0d\u8fdb\u884c\u6821\u9a8c\uff0c\u8df3\u51fa\u6821\u9a8c\uff1b");
            return ResponseData.success().data((Object)new JSONObject());
        }
        HashMap jsonMap = new HashMap(5);
        HashMap map = (HashMap)JSONObject.parseObject((String)JSONObject.toJSONString((Object)json.get((Object)"drugList")), HashMap.class);
        HashMap quantityMap = (HashMap)JSONObject.parseObject((String)JSONObject.toJSONString((Object)json.get((Object)"quantityList")), HashMap.class);
        for (Map.Entry entry : map.entrySet()) {
            log.info("\u6821\u9a8c\u64cd\u4f5c\uff1a2 ========== \u5f00\u59cb\u5faa\u73af\u5165\u53c2\uff1akey(\u836f\u54c1id)-{};value(\u8ffd\u6eaf\u7801)-{}", entry.getKey(), entry.getValue());
            if ("false".equals(String.valueOf(entry.getValue()))) {
                log.info("\u6821\u9a8c\u64cd\u4f5c\uff1a2-1 ========== \u836f\u54c1id\uff1a{}\u4e0d\u8fdb\u884c\u8ffd\u6eaf\u7801\u4e0a\u4f20\u3002\u51c6\u5907\u8fdb\u884c\u4e0b\u4e00\u4e2a\u836f\u54c1\u8ffd\u6eaf\u7801\u6821\u9a8c\uff1b", entry.getKey());
                continue;
            }
            SysDrugEntity drugEntity = this.sysDrugMapper.select((String)entry.getKey(), this.commonRequest.getTenant2());
            int codesLength = String.valueOf(entry.getValue()).split(",").length;
            int quantity = Integer.parseInt(String.valueOf(quantityMap.get(entry.getKey())));
            log.info("\u6821\u9a8c\u64cd\u4f5c\uff1a3 ========== \u6821\u9a8c\u53d1\u836f\u6570\u548c\u8ffd\u6eaf\u7801\u6570\u91cf\uff1b\u53d1\u836f\u6570\u91cf\uff1a{}\uff1b\u8ffd\u6eaf\u7801\u6570\u91cf\uff1a{}", (Object)quantity, (Object)codesLength);
            ExceptionUtils.createException((Logger)log, (codesLength != quantity ? 1 : 0) != 0, (String)("\u836f\u54c1\uff1a" + drugEntity.getDrugsName() + "\u8ffd\u6eaf\u7801\u6570\u91cf\u5f02\u5e38\uff1b\u53d1\u836f\u6570\u91cf\uff1a" + quantity + "\uff1b\u8ffd\u6eaf\u7801\u6570\u91cf\uff1a" + codesLength));
            log.info("\u6821\u9a8c\u64cd\u4f5c\uff1a4 ========== \u83b7\u53d6\u5f53\u524d\u836f\u54c1\u57fa\u672c\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)drugEntity));
            ExceptionUtils.createException((Logger)log, (boolean)Objects.isNull(drugEntity), (String)("\u836f\u54c1ID\uff1a" + (String)entry.getKey() + "\u836f\u54c1\u672a\u627e\u5230\u6216\u88ab\u505c\u7528"));
            if ("1".equals(drugEntity.getImportType())) {
                log.info("\u6821\u9a8c\u64cd\u4f5c\uff1a4-1 ========== \u68c0\u6d4b\u5230\u836f\u54c1\uff1a{}-{}\u4e3a\u8fdb\u53e3\u836f\uff0c\u51c6\u5907\u8fdb\u884c\u4e0b\u4e00\u836f\u54c1\u8ffd\u6eaf\u7801\u6821\u9a8c", (Object)drugEntity.getId(), (Object)drugEntity.getDrugsName());
                continue;
            }
            log.info("\u6821\u9a8c\u64cd\u4f5c\uff1a5 ========== \u8ffd\u6eaf\u7801\u6e90\u6570\u636e{}", entry.getValue());
            SytDto sytDto = new SytDto(String.valueOf(entry.getValue()).replaceAll(" ", "").trim());
            log.info("\u6821\u9a8c\u64cd\u4f5c\uff1a6 ========== \u67e5\u8be2\u8ffd\u6eaf\u7801\u660e\u7ec6\uff1b\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)sytDto));
            JSONObject jsonObject = this.sytSystemService.inScanCodeInfo(sytDto);
            ExceptionUtils.createException((Logger)log, (!"0".equals(String.valueOf(jsonObject.get((Object)"msg_code"))) ? 1 : 0) != 0, (String)(drugEntity.getDrugsName() + "\uff1b" + String.valueOf(jsonObject.get((Object)"msg_info"))));
            JsonUtils arrayValue = JsonUtils.create((Object)jsonObject).getObjectValue("result").getObjectValue("code_info").getArrayValue();
            ExceptionUtils.createException((Logger)log, (boolean)CollectionUtils.isEmpty((Collection)arrayValue.getList()), (String)(drugEntity.getDrugsName() + ":" + String.valueOf(entry.getKey()) + "\u672a\u67e5\u8be2\u5230\u8ffd\u6eaf\u7801\u4fe1\u606f"));
            ArrayList<JSONObject> exceptionDrugList = new ArrayList<JSONObject>();
            for (JSONObject codeInfo : arrayValue.getList()) {
                String prodId = String.valueOf(codeInfo.get((Object)"prod_id"));
                String physicName = String.valueOf(codeInfo.get((Object)"physic_name"));
                String prepnSpec = String.valueOf(codeInfo.get((Object)"prepn_spec"));
                String pkgSpec = String.valueOf(codeInfo.get((Object)"pkg_spec"));
                String spliteName = prodId + "-" + physicName + "-" + prepnSpec + "*" + pkgSpec;
                log.info("\u6821\u9a8c\u64cd\u4f5c\uff1a7 ========== \u7801\u4e0a\u653e\u5fc3\u7ec4\u5408\u6807\u8bc6\uff1a{}", (Object)spliteName);
                log.info("\u6821\u9a8c\u64cd\u4f5c\uff1a8 ========== \u57fa\u672c\u4fe1\u606f\u7ec4\u5408\u6807\u8bc6\uff1a{}", (Object)drugEntity.getSytDrugName());
                if (null != drugEntity.getSytDrugName()) {
                    if (!spliteName.equals(drugEntity.getSytDrugName())) {
                        log.info("\u6821\u9a8c\u64cd\u4f5c\uff1a8-1 ========== \u5339\u914d\u5f02\u5e38");
                        codeInfo.put("drugsName", (Object)drugEntity.getDrugsName());
                        exceptionDrugList.add(codeInfo);
                        continue;
                    }
                    log.info("\u6821\u9a8c\u64cd\u4f5c\uff1a8-2 ========== \u5339\u914d\u6b63\u5e38");
                    continue;
                }
                log.info("\u6821\u9a8c\u64cd\u4f5c\uff1a8-3 ========== \u836f\u54c1{}-{}\u6ca1\u6709\u5bf9\u996e\u7684\u6eaf\u6613\u901a\u540d\u79f0", (Object)drugEntity.getId(), (Object)drugEntity.getDrugsName());
            }
            if (exceptionDrugList.isEmpty()) continue;
            jsonMap.put(drugEntity.getId(), exceptionDrugList);
        }
        log.info("\u6821\u9a8c\u64cd\u4f5c\uff1a8 ========== \u6821\u9a8c\u5b8c\u6210\uff1a{}.....\u51c6\u5907\u7edf\u8ba1\u4e0d\u5339\u914d\u8ffd\u6eaf\u7801\u6570\u91cf", jsonMap);
        for (Map.Entry entry : jsonMap.entrySet()) {
            for (JSONObject valueItem : (List)entry.getValue()) {
                ArrayList<String> codeList = new ArrayList<String>();
                List infoList = JsonUtils.create((Object)valueItem).getObjectValue("produce_info_list").getArrayValue().getList();
                for (JSONObject item : infoList) {
                    List codes = JsonUtils.create((Object)item).getObjectValue("codes").getArrayValue().getList();
                    for (JSONObject code : codes) {
                        codeList.add(String.valueOf(code.get((Object)"code")));
                    }
                }
                valueItem.put("codeList", codeList);
            }
        }
        log.info("\u6821\u9a8c\u64cd\u4f5c\uff1a9 ========== \u7edf\u8ba1\u5b8c\u6210\uff1a{}\uff1b\u6821\u9a8c\u7ed3\u675f", jsonMap);
        return ResponseData.success(jsonMap);
    }

    @RequestMapping(value={"/give/warning/log"})
    public ResponseData log(@RequestBody SysDrugGiveWarningLogEntity entity) {
        entity.setCreateId(this.commonRequest.getUserId());
        int a = this.sysDrugGiveWarningLogMapper.insert((Object)entity);
        return ResponseData.success(new ArrayList());
    }
}

