/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.entity;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.springframework.web.multipart.MultipartFile;

public class Base64DecodedMultipartFile
implements MultipartFile {
    private final byte[] fileContent;
    private final String extension;
    private final String contentType;

    public Base64DecodedMultipartFile(String base64, String dataUri) {
        this.fileContent = Base64.getDecoder().decode(base64.getBytes(StandardCharsets.UTF_8));
        this.extension = dataUri.split(";")[0].split("/")[1];
        this.contentType = dataUri.split(";")[0].split(":")[1];
    }

    public Base64DecodedMultipartFile(String base64, String extension, String contentType) {
        this.fileContent = Base64.getDecoder().decode(base64.getBytes(StandardCharsets.UTF_8));
        this.extension = extension;
        this.contentType = contentType;
    }

    public String getName() {
        return "param_" + System.currentTimeMillis();
    }

    public String getOriginalFilename() {
        return "file_" + System.currentTimeMillis() + "." + this.extension;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isEmpty() {
        return this.fileContent == null || this.fileContent.length == 0;
    }

    public long getSize() {
        return this.fileContent.length;
    }

    public byte[] getBytes() throws IOException {
        return this.fileContent;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.fileContent);
    }

    public void transferTo(File file) throws IOException, IllegalStateException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(this.fileContent);
        }
    }
}

