/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import cn.hutool.core.util.StrUtil;
import com.byh.sdk.entity.RevenueDto;
import com.byh.sdk.entity.admission.DeptRevenueProportionVo;
import com.byh.sdk.entity.admission.DoctorVisitDetailVo;
import com.byh.sdk.entity.admission.DrugRevenueDetailVo;
import com.byh.sdk.entity.admission.DrugSaleDetailVo;
import com.byh.sdk.entity.admission.DrugTotalSaleNumVo;
import com.byh.sdk.entity.admission.OutpatientDetailVisitVo;
import com.byh.sdk.entity.admission.OutpatientRevenueVo;
import com.byh.sdk.entity.admission.OutpatientTotalVisitVo;
import com.byh.sdk.entity.admission.OutpatientVisitRevenueDetailVo;
import com.byh.sdk.entity.admission.QuickTreatementDto;
import com.byh.sdk.entity.admission.RevenueTrendTotalVo;
import com.byh.sdk.entity.admission.RevenueTrendVo;
import com.byh.sdk.entity.admission.TreatmentRevenueDetailVo;
import com.byh.sdk.entity.admission.VisitCountTrendTotalVo;
import com.byh.sdk.entity.admission.VisitCountTrendVo;
import com.byh.sdk.entity.doctor.SysDoctorDto;
import com.byh.sdk.entity.outpatientType.OutpatientTypeEntity;
import com.byh.sdk.entity.outpatientType.QueryOutpatientTypeDto;
import com.byh.sdk.feign.sys.OutpatientServiceFeign;
import com.byh.sdk.feign.sys.SysServiceFeign;
import com.byh.sdk.mapper.OutAdmissionMapper;
import com.byh.sdk.service.AdmissionService;
import com.byh.sdk.util.ResponseData;
import com.byh.sdk.util.exception.BusinessException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdmissionServiceImpl
implements AdmissionService {
    private Logger logger = LoggerFactory.getLogger(AdmissionServiceImpl.class);
    @Autowired
    private OutpatientServiceFeign outpatientServiceFeign;
    @Autowired
    private SysServiceFeign sysServiceFeign;
    @Resource
    private OutAdmissionMapper outAdmissionMapper;

    public List<OutpatientVisitRevenueDetailVo> selectOutpatientVisitRevenueDetail(RevenueDto dto) {
        return this.outAdmissionMapper.selectOutpatientVisitRevenueDetail(dto.getStartDate(), dto.getEndDate());
    }

    public List<TreatmentRevenueDetailVo> selectTreatmentRevenueDetail(RevenueDto dto) {
        return this.outAdmissionMapper.selectTreatmentRevenueDetail(dto.getStartDate(), dto.getEndDate());
    }

    public List<DrugRevenueDetailVo> selectDrugRevenueDetail(RevenueDto dto) {
        return this.outAdmissionMapper.selectDrugRevenueDetail(dto.getStartDate(), dto.getEndDate());
    }

    public List<DoctorVisitDetailVo> selectDoctorVisitDetail(RevenueDto dto) {
        return this.outAdmissionMapper.selectDoctorVisitDetail(dto.getStartDate(), dto.getEndDate());
    }

    public OutpatientTotalVisitVo selectOutpatientTotalVisit(RevenueDto dto) {
        String startDate = dto.getStartDate();
        String endDate = dto.getEndDate();
        List detailList = this.outAdmissionMapper.selectOutpatientDetailVisit(startDate, endDate);
        List beforeList = this.outAdmissionMapper.selectPatientCardNoBerforeDate(startDate);
        Map<String, String> beforeMap = beforeList.stream().collect(Collectors.toMap(OutpatientDetailVisitVo::getPatientCardNo, OutpatientDetailVisitVo::getPatientCardNo));
        for (OutpatientDetailVisitVo detail : detailList) {
            String patientCardNo = detail.getPatientCardNo();
            String oldPatientCardNo = beforeMap.get(patientCardNo);
            if (StrUtil.isEmpty((CharSequence)oldPatientCardNo)) {
                detail.setFirstCount(Integer.valueOf(1));
                continue;
            }
            detail.setOldCount(Integer.valueOf(1));
        }
        Integer totalVisitCount = 0;
        Integer onlineVisitCount = 0;
        Integer offlineVisitCount = 0;
        Integer firstCount = 0;
        Integer oldCount = 0;
        for (OutpatientDetailVisitVo detail : detailList) {
            if (detail.getTotalVisitCount() != null) {
                totalVisitCount = totalVisitCount + detail.getTotalVisitCount();
            }
            if (detail.getOnlineVisitCount() != null) {
                onlineVisitCount = onlineVisitCount + detail.getOnlineVisitCount();
            }
            if (detail.getOfflineVisitCount() != null) {
                offlineVisitCount = offlineVisitCount + detail.getOfflineVisitCount();
            }
            if (detail.getFirstCount() != null) {
                firstCount = firstCount + detail.getFirstCount();
            }
            if (detail.getOldCount() == null) continue;
            oldCount = oldCount + detail.getOldCount();
        }
        OutpatientTotalVisitVo totalVisitVo = new OutpatientTotalVisitVo();
        totalVisitVo.setTotalVisitCount(totalVisitCount);
        totalVisitVo.setOnlineVisitCount(onlineVisitCount);
        totalVisitVo.setOfflineVisitCount(offlineVisitCount);
        totalVisitVo.setFirstCount(firstCount);
        totalVisitVo.setOldCount(oldCount);
        return totalVisitVo;
    }

    public List<DrugSaleDetailVo> selectDrugSaleDetail(RevenueDto dto) {
        return this.outAdmissionMapper.selectDrugSaleDetail(dto.getStartDate(), dto.getEndDate());
    }

    public DrugTotalSaleNumVo selectDrugTotalSaleNum(RevenueDto dto) {
        return this.outAdmissionMapper.selectDrugTotalSaleNum(dto.getStartDate(), dto.getEndDate());
    }

    public OutpatientRevenueVo selectOutpatientRevenueByDate(RevenueDto dto) {
        return this.outAdmissionMapper.selectOutpatientRevenueByDate(dto.getStartDate(), dto.getEndDate());
    }

    public VisitCountTrendTotalVo selectVisitCountTrendByDate(RevenueDto dto) {
        String startDate = dto.getStartDate();
        String endDate = dto.getEndDate();
        List visitCountTrendVoList = this.outAdmissionMapper.selectVisitCountTrendByDate(startDate, endDate);
        Map<String, Integer> visitCountTrendMap = visitCountTrendVoList.stream().collect(Collectors.toMap(VisitCountTrendVo::getVisitDate, VisitCountTrendVo::getVisitCount));
        Integer allTotalVisitCount = visitCountTrendVoList.stream().map(VisitCountTrendVo::getVisitCount).filter(visitCount -> visitCount != null).reduce(0, Integer::sum);
        List dateList = this.getDateRange(startDate, endDate);
        LinkedHashMap<String, Integer> visitTrendMap = new LinkedHashMap<String, Integer>();
        for (String date : dateList) {
            Integer visitCount2 = visitCountTrendMap.getOrDefault(date, 0);
            visitTrendMap.put(date, visitCount2);
        }
        VisitCountTrendTotalVo trendTotalVo = new VisitCountTrendTotalVo();
        trendTotalVo.setTotalVisitCount(allTotalVisitCount);
        trendTotalVo.setVisitCountTrendMap(visitTrendMap);
        return trendTotalVo;
    }

    public List<DeptRevenueProportionVo> selectDeptRevenueProportionByDate(RevenueDto dto) {
        String startDate = dto.getStartDate();
        String endDate = dto.getEndDate();
        List deptRevenueProportionList = this.outAdmissionMapper.selectDeptRevenueProportionByDate(startDate, endDate);
        BigDecimal allTotalAmount = deptRevenueProportionList.stream().map(DeptRevenueProportionVo::getTotalAmount).filter(amount -> amount != null).reduce(BigDecimal.ZERO, BigDecimal::add);
        for (DeptRevenueProportionVo vo : deptRevenueProportionList) {
            BigDecimal deptTotalAmount = vo.getTotalAmount();
            String proportion = "0.0000%";
            if (deptTotalAmount == null || allTotalAmount == null || deptTotalAmount.compareTo(BigDecimal.ZERO) == 0 || allTotalAmount.compareTo(BigDecimal.ZERO) == 0) {
                vo.setProportion(proportion);
                continue;
            }
            BigDecimal ratio = deptTotalAmount.divide(allTotalAmount, 6, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
            DecimalFormat decimalFormat = new DecimalFormat("0.######");
            proportion = decimalFormat.format(ratio) + "%";
            vo.setProportion(proportion);
        }
        return deptRevenueProportionList;
    }

    public RevenueTrendTotalVo selectRevenueTrendByDate(RevenueDto dto) {
        String startDate = dto.getStartDate();
        String endDate = dto.getEndDate();
        List revenueTrendVoList = this.outAdmissionMapper.selectRevenueTrendByDate(startDate, endDate);
        Map<String, BigDecimal> revenueTrendDateMap = revenueTrendVoList.stream().collect(Collectors.toMap(RevenueTrendVo::getRevenueDate, RevenueTrendVo::getTotalAmount));
        BigDecimal allTotalAmount = revenueTrendVoList.stream().map(RevenueTrendVo::getTotalAmount).filter(amount -> amount != null).reduce(BigDecimal.ZERO, BigDecimal::add);
        List dateList = this.getDateRange(startDate, endDate);
        LinkedHashMap<String, BigDecimal> revenueTrendMap = new LinkedHashMap<String, BigDecimal>();
        for (String date : dateList) {
            BigDecimal revenueAmount = revenueTrendDateMap.getOrDefault(date, BigDecimal.ZERO);
            revenueTrendMap.put(date, revenueAmount);
        }
        RevenueTrendTotalVo trendTotalVo = new RevenueTrendTotalVo();
        trendTotalVo.setTotalAmount(allTotalAmount);
        trendTotalVo.setRevenueTrendMap(revenueTrendMap);
        return trendTotalVo;
    }

    private List<String> getDateRange(String startDate, String endDate) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate start = LocalDate.parse(startDate, formatter);
        LocalDate end = LocalDate.parse(endDate, formatter);
        ArrayList<String> dateList = new ArrayList<String>();
        while (!start.isAfter(end)) {
            dateList.add(start.format(formatter));
            start = start.plusDays(1L);
        }
        return dateList;
    }

    public Integer selectTodayDrugSaleNum() {
        String today = this.getTodayForStr();
        return this.outAdmissionMapper.selectDrugSaleNum(today, today);
    }

    public Integer selectVisitCount() {
        String today = this.getTodayForStr();
        return this.outAdmissionMapper.selectVisitCount(today, today);
    }

    public BigDecimal selectYearTotalRevenue() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate firstDayOfYear = LocalDate.now().withDayOfYear(1);
        String startDate = firstDayOfYear.format(formatter);
        LocalDate lastDayOfYear = LocalDate.now().withMonth(12).withDayOfMonth(31);
        String endDate = lastDayOfYear.format(formatter);
        return this.outAdmissionMapper.selectRevenueInfo(startDate, endDate);
    }

    public BigDecimal selectTodayRevenue() {
        String today = this.getTodayForStr();
        return this.outAdmissionMapper.selectRevenueInfo(today, today);
    }

    private String getTodayForStr() {
        return LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }

    @Transactional(rollbackFor={BusinessException.class})
    public ResponseData registration(QuickTreatementDto dto) {
        ResponseData responseData = this.outpatientServiceFeign.registration(dto);
        return responseData;
    }

    public ResponseData<List<OutpatientTypeEntity>> selectOupatientTypeByName(QueryOutpatientTypeDto dto) {
        return this.outpatientServiceFeign.queryOutpatientTypeByName(dto);
    }

    public ResponseData selectDoctorPageList(SysDoctorDto dto) {
        return this.sysServiceFeign.withoutSelectPageList(dto);
    }
}

