/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.controller.hisFront;

import com.byh.sdk.entity.base.FrontRequest;
import com.byh.sdk.entity.base.FrontResponse;
import com.byh.sdk.entity.drug.DrugInventoryResponse;
import com.byh.sdk.entity.drug.DrugRequestDTO;
import com.byh.sdk.entity.drug.DrugResponse;
import com.byh.sdk.entity.drug.OutPrescriptionDto;
import com.byh.sdk.entity.drug.SysDrugPharmacySimpleDto;
import com.byh.sdk.entity.drug.SysDrugPharmacyStorageDto;
import com.byh.sdk.service.DrugService;
import com.byh.sdk.util.CommonRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u836f\u54c1\u76ee\u5f55"})
@RestController
@RequestMapping(value={"/drug"})
public class DrugController {
    @Autowired
    private DrugService drugService;
    private final CommonRequest commonRequest;

    @PostMapping(value={"/query/drugInfo"})
    @ApiOperation(value="\u67e5\u8be2\u836f\u54c1\u4fe1\u606f")
    public FrontResponse<List<DrugResponse>> drugList(@RequestBody FrontRequest<DrugRequestDTO> param) {
        param.setTenantId(this.commonRequest.getTenant());
        return this.drugService.queryDrugList(param);
    }

    @PostMapping(value={"/query/drugBaseInfo"})
    @ApiOperation(value="\u67e5\u8be2\u836f\u54c1\u57fa\u672c\u4fe1\u606f")
    public FrontResponse<List<DrugResponse>> drugBaseList(@RequestBody FrontRequest<DrugRequestDTO> param) {
        param.setTenantId(this.commonRequest.getTenant());
        return this.drugService.queryDrugBaseList(param);
    }

    @PostMapping(value={"/query/inventory"})
    @ApiOperation(value="\u67e5\u8be2\u836f\u54c1\u5e93\u5b58\u4fe1\u606f")
    public FrontResponse<List<DrugInventoryResponse>> drugInventoryList(@RequestBody FrontRequest<DrugRequestDTO> param) {
        param.setTenantId(this.commonRequest.getTenant());
        return this.drugService.drugInventory(param);
    }

    @PostMapping(value={"/pharmacyOut/search"})
    @ApiOperation(value="\u836f\u623f\u836f\u54c1\u67e5\u8be2\u4fe1\u606f")
    public FrontResponse pharmacyOutSearch(@RequestBody FrontRequest<SysDrugPharmacySimpleDto> param) {
        param.setTenantId(this.commonRequest.getTenant());
        return this.drugService.pharmacyOutSearch(param);
    }

    @PostMapping(value={"/storage/search"})
    @ApiOperation(value="\u836f\u623f\u67e5\u8be2\u4fe1\u606f")
    public FrontResponse storageList(@RequestBody FrontRequest<SysDrugPharmacyStorageDto> param) {
        param.setTenantId(this.commonRequest.getTenant());
        return this.drugService.storageList(param);
    }

    @PostMapping(value={"/dispenseMedicine"})
    @ApiOperation(value="\u53d1\u836f")
    public FrontResponse dispenseMedicine(@RequestBody FrontRequest<OutPrescriptionDto> param) {
        param.setTenantId(this.commonRequest.getTenant());
        param.setOperatorId(this.commonRequest.getUserId());
        param.setOperatorName(this.commonRequest.getUserName());
        return this.drugService.dispenseMedicine(param);
    }

    @PostMapping(value={"/withdrawalOfMedication"})
    @ApiOperation(value="\u9000\u836f")
    public FrontResponse withdrawalOfMedication(@RequestBody FrontRequest<OutPrescriptionDto> param) {
        param.setTenantId(this.commonRequest.getTenant());
        param.setOperatorId(this.commonRequest.getUserId());
        param.setOperatorName(this.commonRequest.getUserName());
        return this.drugService.withdrawalOfMedication(param);
    }

    public DrugController(CommonRequest commonRequest) {
        this.commonRequest = commonRequest;
    }
}

