/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.sdk.entity.patient.PatientEntity;
import com.byh.sdk.mapper.PatientMapper;
import com.byh.sdk.service.PatientService;
import com.byh.sdk.util.DateUtils;
import com.byh.sdk.util.ExceptionUtils;
import com.byh.sdk.util.StringPinYinUtil;
import com.byh.sdk.util.exception.BusinessException;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PatientServiceImpl
extends ServiceImpl<PatientMapper, PatientEntity>
implements PatientService {
    private Logger logger = LoggerFactory.getLogger(PatientServiceImpl.class);
    @Resource
    private PatientMapper patientMapper;

    @Transactional(rollbackFor={BusinessException.class})
    public void insert(PatientEntity patient) {
        PatientEntity dbPatient;
        if (patient == null) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u5fc5\u8981\u53c2\u6570\u7f3a\u5931");
        }
        if (StrUtil.isEmpty((CharSequence)patient.getCardNo())) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u8bc1\u4ef6\u53f7\u7801\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (patient.getTenantId() == null) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u79df\u6237ID\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if ((dbPatient = (PatientEntity)this.patientMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(PatientEntity.class).eq(patient.getTenantId() != null, PatientEntity::getTenantId, (Object)patient.getTenantId())).eq(PatientEntity::getCardNo, (Object)patient.getCardNo()))) == null) {
            String no = this.patientMapper.queryMaxMedicalNo(patient.getTenantId());
            Integer endNo = StrUtil.isEmpty((CharSequence)no) ? Integer.valueOf(0) : Integer.valueOf(Integer.parseInt(no));
            String currentDate = DateUtils.getCurrentDate((String)"yyMMdd");
            Integer suffix = patient.getTenantId() + 1000000 + endNo;
            patient.setMedicalRecordNo(currentDate + suffix);
            patient.setNamePinyin(StringPinYinUtil.toFirstChar((String)patient.getName()));
            this.patientMapper.insert((Object)patient);
        } else {
            patient.setId(dbPatient.getId());
            BeanUtils.copyProperties((Object)patient, (Object)dbPatient);
            this.patientMapper.updateById((Object)dbPatient);
        }
    }

    public List<PatientEntity> queryPatientDetail(PatientEntity patient) {
        List patientEntities = this.patientMapper.queryPatientDetail(patient);
        return patientEntities;
    }
}

