/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.controller.hisFront;

import com.byh.sdk.entity.base.FrontRequest;
import com.byh.sdk.entity.base.FrontResponse;
import com.byh.sdk.entity.order.FeeBillCreationDto;
import com.byh.sdk.entity.order.HsPayDto;
import com.byh.sdk.entity.order.HsPreparePayDto;
import com.byh.sdk.entity.order.HsRefundDto;
import com.byh.sdk.entity.order.OnlineHsPayDto;
import com.byh.sdk.entity.order.OnlineHsRefundDto;
import com.byh.sdk.entity.order.PayDto;
import com.byh.sdk.entity.order.PayRefundDto;
import com.byh.sdk.service.OrderService;
import com.byh.sdk.util.CommonRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"order"})
@Api(tags={"\u8ba2\u5355\u76f8\u5173\u63a5\u53e3"})
public class OrderController {
    @Autowired
    private OrderService orderService;
    private final CommonRequest commonRequest;

    @RequestMapping(value={"/createCharge"}, method={RequestMethod.POST})
    @ApiOperation(value="\u751f\u6210\u9884\u652f\u4ed8\u8ba2\u5355")
    public FrontResponse queryCardInfo(@RequestBody FrontRequest<FeeBillCreationDto> param) {
        param.setTenantId(this.commonRequest.getTenant());
        param.setOperatorName(this.commonRequest.getUserName());
        param.setOperatorId(this.commonRequest.getUserId());
        return this.orderService.createCharge(param);
    }

    @RequestMapping(value={"/payment"}, method={RequestMethod.POST})
    @ApiOperation(value="\u8ba2\u5355\u652f\u4ed8")
    public FrontResponse payment(@RequestBody FrontRequest<PayDto> param) {
        param.setTenantId(this.commonRequest.getTenant());
        param.setOperatorName(this.commonRequest.getUserName());
        param.setOperatorId(this.commonRequest.getUserId());
        return this.orderService.payment(param);
    }

    @RequestMapping(value={"/refund"}, method={RequestMethod.POST})
    @ApiOperation(value="\u8ba2\u5355\u9000\u8d39")
    public FrontResponse refund(@RequestBody FrontRequest<PayRefundDto> param) {
        param.setTenantId(this.commonRequest.getTenant());
        param.setOperatorName(this.commonRequest.getUserName());
        param.setOperatorId(this.commonRequest.getUserId());
        return this.orderService.refund(param);
    }

    @RequestMapping(value={"/hsPayment"}, method={RequestMethod.POST})
    @ApiOperation(value="\u533b\u4fdd\u7ed3\u7b97")
    public FrontResponse hsPayment(@RequestBody FrontRequest<OnlineHsPayDto> param) {
        param.setTenantId(this.commonRequest.getTenant());
        param.setOperatorName(this.commonRequest.getUserName());
        param.setOperatorId(this.commonRequest.getUserId());
        return this.orderService.hsPayment(param);
    }

    @RequestMapping(value={"/hsRefund"}, method={RequestMethod.POST})
    @ApiOperation(value="\u533b\u4fdd\u9000\u6b3e")
    public FrontResponse hsRefund(@RequestBody FrontRequest<OnlineHsRefundDto> param) {
        param.setTenantId(this.commonRequest.getTenant());
        param.setOperatorName(this.commonRequest.getUserName());
        param.setOperatorId(this.commonRequest.getUserId());
        return this.orderService.hsRefund(param);
    }

    @PostMapping(value={"/ihosHsPreparePay"})
    @ApiOperation(value="\u4e92\u533b\u5f02\u5730\u533b\u4fdd\u9884\u7ed3\u7b97")
    public FrontResponse<Object> ihosHsPreparePay(@RequestBody FrontRequest<HsPreparePayDto> param) {
        param.setTenantId(this.commonRequest.getTenant());
        param.setOperatorName(this.commonRequest.getUserName());
        param.setOperatorId(this.commonRequest.getUserId());
        return this.orderService.ihosHsPreparePay(param);
    }

    @PostMapping(value={"/ihosHsPayment"})
    @ApiOperation(value="\u4e92\u533b\u5f02\u5730\u533b\u4fdd\u7ed3\u7b97")
    public FrontResponse<String> ihosHsPayment(@RequestBody FrontRequest<HsPayDto> param) {
        param.setTenantId(this.commonRequest.getTenant());
        param.setOperatorName(this.commonRequest.getUserName());
        param.setOperatorId(this.commonRequest.getUserId());
        return this.orderService.ihosHsPayment(param);
    }

    @RequestMapping(value={"/ihosHsRefund"}, method={RequestMethod.POST})
    @ApiOperation(value="\u533b\u4fdd\u9000\u6b3e")
    public FrontResponse ihosHsRefund(@RequestBody FrontRequest<HsRefundDto> param) {
        param.setTenantId(this.commonRequest.getTenant());
        param.setOperatorName(this.commonRequest.getUserName());
        param.setOperatorId(this.commonRequest.getUserId());
        return this.orderService.ihosHsRefund(param);
    }

    public OrderController(CommonRequest commonRequest) {
        this.commonRequest = commonRequest;
    }
}

