/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.entity.base;

import com.byh.sdk.entity.base.IError;

public class FrontResponse<T> {
    private String transactionId;
    private String code;
    private String errCode;
    private String message;
    private T body;
    private T result;
    public static final String SUCCESS_CODE = "1";
    public static final String FAILED_CODE = "0";
    public static final String ERROR_CODE = "-1";

    public static <T> FrontResponse<T> success(String transactionId, T body) {
        FrontResponse response = new FrontResponse();
        response.setTransactionId(transactionId);
        response.setCode(SUCCESS_CODE);
        response.setBody(body);
        return response;
    }

    public FrontResponse(String transactionId, String code, String message, T body) {
        this.transactionId = transactionId;
        this.code = code;
        this.message = message;
        this.body = body;
    }

    public static <T> FrontResponse<T> error(String transactionId, String errCode, String message) {
        FrontResponse response = new FrontResponse();
        response.setTransactionId(transactionId);
        response.setCode(FAILED_CODE);
        response.setErrCode(errCode);
        response.setMessage(message);
        return response;
    }

    public static <T> FrontResponse<T> error(String transactionId, IError error) {
        FrontResponse response = new FrontResponse();
        response.setTransactionId(transactionId);
        response.setCode(FAILED_CODE);
        response.setErrCode(error.getErrCode());
        response.setMessage(error.getMsg());
        return response;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getBody() {
        return (T)this.body;
    }

    public void setBody(T body) {
        this.body = body;
    }

    public T getResult() {
        return (T)this.result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public String toString() {
        return "FrontResponse{transactionId='" + this.transactionId + '\'' + ", code='" + this.code + '\'' + ", errCode='" + this.errCode + '\'' + ", message='" + this.message + '\'' + ", result='" + this.result + '\'' + ", body=" + this.body + '}';
    }

    public FrontResponse(String transactionId, String code, String errCode, String message, T body, T result) {
        this.transactionId = transactionId;
        this.code = code;
        this.errCode = errCode;
        this.message = message;
        this.body = body;
        this.result = result;
    }

    public FrontResponse() {
    }
}

