/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.sdk.entity.OutGroupHistoryMsgEntity;
import com.byh.sdk.entity.im.IMGenerateDto;
import com.byh.sdk.entity.im.IMSessionHistoryPatientVo;
import com.byh.sdk.feign.sys.OutpatientServiceFeign;
import com.byh.sdk.feign.sys.SysServiceFeign;
import com.byh.sdk.mapper.OutGroupHistoryMsgMapper;
import com.byh.sdk.service.IMGenerateService;
import com.byh.sdk.util.HttpUtils;
import com.byh.sdk.util.ResponseData;
import com.tencentyun.TLSSigAPIv2;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.internal.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class IMGenerateServiceImpl
implements IMGenerateService {
    private Logger logger = LoggerFactory.getLogger(IMGenerateServiceImpl.class);
    @Value(value="${IMConfig.sdkAppId}")
    private long sdkAppId;
    @Value(value="${IMConfig.secretKey}")
    private String secretKey;
    @Autowired
    private OutGroupHistoryMsgMapper groupHistoryMsgMapper;
    @Autowired
    private OutpatientServiceFeign outpatientServiceFeign;
    @Autowired
    private SysServiceFeign sysServiceFeign;
    private long expier = 604800L;
    private long adminExpier = 604800L;
    private long userExpier = 2592000L;
    private String BASE_URL = "https://data-center.scrmzk.com/api/im";
    private String GET_SESSION_LIST = "/getSessionList";
    private String GET_MSG_HISTORY = "/getMsgHistory";

    public String generateUserId(IMGenerateDto dto) {
        JSONObject jsonObject;
        TLSSigAPIv2 api = new TLSSigAPIv2(this.sdkAppId, this.secretKey);
        String userSig = api.genSig("administrator", this.expier);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("UserID", dto.getUserId());
        if (StrUtil.isNotEmpty((CharSequence)dto.getUserName())) {
            map.put("Nick", dto.getUserName());
        }
        if (StrUtil.isNotEmpty((CharSequence)dto.getFaceUrl())) {
            map.put("FaceUrl", dto.getFaceUrl());
        }
        String postUrl = String.format("https://console.tim.qq.com/v4/im_open_login_svc/account_import?sdkappid=%s&identifier=%s&usersig=%s&contenttype=json", this.sdkAppId, "administrator", userSig);
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity(map, (MultiValueMap)headers);
        ResponseEntity response = restTemplate.exchange(postUrl, HttpMethod.POST, entity, String.class, new Object[0]);
        String responseBody = (String)response.getBody();
        if (responseBody != null && (jsonObject = JSONObject.parseObject((String)responseBody)).get((Object)"ErrorCode").toString().equals("0")) {
            return api.genSig(dto.getUserId(), this.expier);
        }
        return responseBody;
    }

    public ResponseData<List<IMSessionHistoryPatientVo>> getSessionList(String cardNo) throws IOException {
        if (StringUtils.isBlank((CharSequence)cardNo)) {
            return ResponseData.error((String)"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.logger.info("\u67e5\u8be2\u5bf9\u8bdd\u5217\u8868--------\u8eab\u4efd\u8bc1\u53f7\uff1a{}", (Object)cardNo);
        String url = this.BASE_URL + this.GET_SESSION_LIST + "?cardNo=" + cardNo;
        String s = HttpUtils.get((String)url);
        JSONObject parse = (JSONObject)JSONObject.parse((String)s);
        List data = JSONObject.parseArray((String)parse.get((Object)"data").toString(), IMSessionHistoryPatientVo.class);
        return ResponseData.success((Object)data);
    }

    public ResponseData getMsgHistory(Integer id) throws IOException {
        if (id == null) {
            return ResponseData.error((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.logger.info("\u67e5\u8be2\u5bf9\u8bdd\u8be6\u60c5--------\u5bf9\u8bddid\uff1a{}", (Object)id);
        String url = this.BASE_URL + this.GET_MSG_HISTORY + "?id=" + id;
        String s = HttpUtils.get((String)url);
        JSONObject parse = (JSONObject)JSONObject.parse((String)s);
        String code = parse.get((Object)"code").toString();
        if ("200".equals(code)) {
            String msg = parse.get((Object)"msg").toString();
            JSONObject JSONMsg = (JSONObject)JSONObject.parse((String)msg);
            return ResponseData.success((Object)JSONMsg);
        }
        return ResponseData.error((String)code);
    }

    public JSONObject getGroupMsgHistory(JSONObject jsonObject) {
        TLSSigAPIv2 api = new TLSSigAPIv2(this.sdkAppId, this.secretKey);
        String userSig = api.genSig("administrator", this.adminExpier);
        Integer random = RandomUtils.nextInt();
        String postUrl = String.format("https://console.tim.qq.com/v4/group_open_http_svc/group_msg_get_simple?sdkappid=%s&identifier=%s&usersig=%s&random=%s&contenttype=json", this.sdkAppId, "administrator", userSig, random);
        String responseBody = HttpUtil.post((String)postUrl, (String)jsonObject.toString());
        this.logger.info(responseBody);
        JSONObject resultJson = JSONObject.parseObject((String)responseBody);
        return resultJson;
    }

    public ResponseData<OutGroupHistoryMsgEntity> queryByGroupId(OutGroupHistoryMsgEntity param) {
        String groupId = param.getGroupId();
        if (StringUtil.isBlank((String)groupId)) {
            return ResponseData.error((String)"\u7fa4\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        OutGroupHistoryMsgEntity entity = (OutGroupHistoryMsgEntity)this.groupHistoryMsgMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(StringUtils.isNotBlank((CharSequence)groupId), OutGroupHistoryMsgEntity::getGroupId, (Object)groupId)).like(StringUtils.isNotBlank((CharSequence)param.getUserIds()), OutGroupHistoryMsgEntity::getUserIds, (Object)("-" + param.getUserIds() + "-"))).like(StringUtils.isNotBlank((CharSequence)param.getUserNames()), OutGroupHistoryMsgEntity::getUserNames, (Object)("-" + param.getUserNames() + "-"))).like(StringUtils.isNotBlank((CharSequence)param.getPatientIds()), OutGroupHistoryMsgEntity::getPatientIds, (Object)("-" + param.getPatientIds() + "-"))).like(StringUtils.isNotBlank((CharSequence)param.getPatientNames()), OutGroupHistoryMsgEntity::getPatientNames, (Object)("-" + param.getPatientNames() + "-"))).like(StringUtils.isNotBlank((CharSequence)param.getPatientCardNos()), OutGroupHistoryMsgEntity::getPatientCardNos, (Object)("-" + param.getPatientCardNos() + "-")));
        if (entity == null) {
            return ResponseData.error((String)"\u672a\u67e5\u8be2\u5230\u8be5\u7fa4\u7ec4\u5bf9\u8bdd\u8bb0\u5f55\uff01");
        }
        return ResponseData.success((Object)entity);
    }

    public ResponseData addOrUpdateHistory(OutGroupHistoryMsgEntity entity) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        String timeStr = format.format(new Date());
        JSONObject param = new JSONObject();
        param.put("GroupId", (Object)entity.getGroupId());
        param.put("ReqMsgNumber", (Object)20);
        JSONObject groupMsgHistory = this.getGroupMsgHistory(param);
        JSONArray rspMsgList = groupMsgHistory.getJSONArray("RspMsgList");
        List list = this.groupHistoryMsgMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(OutGroupHistoryMsgEntity::getGroupId, (Object)entity.getGroupId()));
        this.montageStr(entity);
        if (list.size() == 0) {
            entity.setCreateTime(timeStr);
            if (groupMsgHistory != null) {
                JSONObject rspMsg = rspMsgList.getJSONObject(0);
                Integer msgSeq = rspMsg.getInteger("MsgSeq");
                entity.setHistory(rspMsgList.toString());
                entity.setLastMsgSeq(msgSeq + "");
            } else {
                entity.setLastMsgSeq("0");
            }
            this.groupHistoryMsgMapper.insert((Object)entity);
        } else {
            OutGroupHistoryMsgEntity outGroupHistoryMsgEntity = (OutGroupHistoryMsgEntity)list.get(0);
            String history = outGroupHistoryMsgEntity.getHistory();
            JSONArray jsonArray = JSONArray.parseArray((String)history);
            String lastMsgSeq = outGroupHistoryMsgEntity.getLastMsgSeq();
            JSONArray arr = this.pullingHistory(null, Integer.valueOf(Integer.parseInt(lastMsgSeq)), entity.getGroupId());
            if (arr.size() == 0) {
                return ResponseData.success();
            }
            jsonArray.addAll((Collection)arr);
            jsonArray = this.deduplicateByMsgSeq(jsonArray).getJSONArray(0);
            jsonArray.sort((a, b) -> ((JSONObject)a).getInteger("MsgSeq") - ((JSONObject)b).getInteger("MsgSeq"));
            entity.setLastMsgSeq(jsonArray.getJSONObject(jsonArray.size() - 1).getString("MsgSeq"));
            entity.setHistory(jsonArray.toString());
            entity.setUpdateTime(timeStr);
            this.groupHistoryMsgMapper.update((Object)entity, (Wrapper)Wrappers.lambdaUpdate().eq(OutGroupHistoryMsgEntity::getGroupId, (Object)entity.getGroupId()));
        }
        return ResponseData.success();
    }

    public JSONArray deduplicateByMsgSeq(JSONArray originalArray) {
        ArrayList<JSONObject> resultList = new ArrayList<JSONObject>();
        HashSet<String> msgSeqSet = new HashSet<String>();
        if (originalArray == null || originalArray.isEmpty()) {
            return new JSONArray();
        }
        for (Object obj : originalArray) {
            JSONObject jsonObject;
            Object msgSeqObj;
            if (!(obj instanceof JSONObject) || (msgSeqObj = (jsonObject = (JSONObject)obj).get((Object)"MsgSeq")) == null) continue;
            String msgSeq = msgSeqObj.toString();
            if (!msgSeqSet.contains(msgSeq) && !jsonObject.containsKey((Object)"$ref")) {
                System.out.println("Adding MsgSeq: " + msgSeq);
                resultList.add(jsonObject);
                msgSeqSet.add(msgSeq);
                continue;
            }
            System.out.println("Skipping duplicate MsgSeq: " + msgSeq);
        }
        return new JSONArray(Collections.singletonList(resultList));
    }

    private void montageStr(OutGroupHistoryMsgEntity entity) {
        String groupMember = entity.getGroupMember();
        String userIds = "-";
        String userNames = "-";
        String patientIds = "-";
        String patientNames = "-";
        String patientCardNos = "-";
        groupMember = groupMember.replaceAll("\\\\\"", "\"");
        JSONObject memberJson = JSONObject.parseObject((String)groupMember);
        JSONArray userArr = memberJson.getJSONArray("user");
        for (int i = 0; i < userArr.size(); ++i) {
            JSONObject user = userArr.getJSONObject(i);
            String userId = user.getString("userId");
            String userName = user.getString("userName");
            if (StringUtils.isNotBlank((CharSequence)userId)) {
                userIds = userIds + userId + "-";
            }
            if (!StringUtils.isNotBlank((CharSequence)userName)) continue;
            userNames = userNames + userName + "-";
        }
        JSONArray patientArr = memberJson.getJSONArray("patient");
        for (int i = 0; i < patientArr.size(); ++i) {
            JSONObject patient = patientArr.getJSONObject(i);
            String patientId = patient.getString("patientId");
            String patientName = patient.getString("patientName");
            String cardNo = patient.getString("cardNo");
            if (StringUtils.isNotBlank((CharSequence)patientId)) {
                patientIds = patientIds + patientId + "-";
            }
            if (StringUtils.isNotBlank((CharSequence)patientName)) {
                patientNames = patientNames + patientName + "-";
            }
            if (!StringUtils.isNotBlank((CharSequence)cardNo)) continue;
            patientCardNos = patientCardNos + cardNo + "-";
        }
        entity.setUserIds(userIds);
        entity.setUserNames(userNames);
        entity.setPatientIds(patientIds);
        entity.setPatientNames(patientNames);
        entity.setPatientCardNos(patientCardNos);
    }

    private JSONArray pullingHistory(JSONArray arr, Integer lastSeq, String groupId) {
        JSONObject param = new JSONObject();
        param.put("GroupId", (Object)groupId);
        param.put("ReqMsgNumber", (Object)20);
        if (arr == null) {
            arr = this.getGroupMsgHistory(param).getJSONArray("RspMsgList");
            int c = 0;
            for (int i = 0; i < arr.size(); ++i) {
                Integer msgSeq = arr.getJSONObject(i).getInteger("MsgSeq");
                if (msgSeq <= lastSeq) {
                    arr.remove(i);
                    --i;
                    ++c;
                }
                if (c == arr.size()) break;
            }
            if (arr.size() == 0) {
                return arr;
            }
        }
        JSONObject jsonObject = arr.getJSONObject(0);
        int msgSeq = jsonObject.getInteger("MsgSeq") + 1;
        param.put("ReqMsgSeq", (Object)msgSeq);
        JSONObject groupMsgHistory = this.getGroupMsgHistory(param);
        JSONArray rspMsgList = groupMsgHistory.getJSONArray("RspMsgList");
        for (int i = 0; i < rspMsgList.size(); ++i) {
            JSONObject json = rspMsgList.getJSONObject(i);
            msgSeq = json.getInteger("MsgSeq");
            if (lastSeq >= msgSeq) continue;
            arr.add((Object)jsonObject);
        }
        Integer minSeq = rspMsgList.getJSONObject(rspMsgList.size() - 1).getInteger("MsgSeq");
        if (minSeq > lastSeq + 1) {
            this.pullingHistory(arr, lastSeq, groupId);
        }
        return arr;
    }
}

