/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.util.exception;

import com.byh.sdk.util.ResponseData;
import com.byh.sdk.util.exception.BusinessException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class ExceptionAdvice {
    public static Logger logger = LoggerFactory.getLogger(ExceptionAdvice.class);
    @Autowired
    private HttpServletRequest request;

    @ResponseBody
    @ExceptionHandler(value={Exception.class})
    public ResponseData handleException(Exception e) {
        logger.error("\u7cfb\u7edf\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
        e.printStackTrace();
        ResponseData responseData = new ResponseData();
        if (e instanceof BusinessException) {
            BusinessException be = (BusinessException)e;
            return ResponseData.error((String)be.getErrorCode(), (String)e.getMessage()).data((Object)Boolean.FALSE);
        }
        if (e instanceof MethodArgumentNotValidException) {
            MethodArgumentNotValidException me = (MethodArgumentNotValidException)e;
            FieldError field = me.getFieldError();
            me.printStackTrace();
            return ResponseData.error((String)ResponseData.ResponseEnum.BAD_REQUEST.getCode(), (String)field.getDefaultMessage()).data((Object)Boolean.FALSE);
        }
        if (e instanceof NullPointerException) {
            NullPointerException ne = (NullPointerException)e;
            ne.printStackTrace();
            return ResponseData.error((String)ResponseData.ResponseEnum.NULL_POINTER_EXCEPTION.getCode(), (String)ResponseData.ResponseEnum.NULL_POINTER_EXCEPTION.getCodeName()).data((Object)Boolean.FALSE);
        }
        responseData.setMsg(e.getMessage());
        responseData.setData((Object)Boolean.FALSE);
        return responseData;
    }
}

