/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.byh.sdk.entity.request.DrugDto;
import com.byh.sdk.entity.request.MedicationDeliveryOrderDto;
import com.byh.sdk.entity.request.MedicationDeliveryOrderEntity;
import com.byh.sdk.mapper.MedicationDeliveryOrderMapper;
import com.byh.sdk.service.MedicationDeliveryOrderService;
import com.byh.sdk.util.HttpUtils;
import com.byh.sdk.util.ResponseData;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MedicationDeliveryOrderServiceImpl
implements MedicationDeliveryOrderService {
    private static Logger log = LoggerFactory.getLogger(MedicationDeliveryOrderServiceImpl.class);
    private final String orderSite = "HTTP://123.56.176.15:8886";
    @Autowired
    MedicationDeliveryOrderMapper medicationDeliveryOrderMapper;

    @Override
    public ResponseData<PageInfo<MedicationDeliveryOrderDto>> searchMedicationDeliveryOrderList(MedicationDeliveryOrderDto dto) {
        String endTime;
        PageHelper.startPage((int)dto.getCurrent(), (int)dto.getSize());
        String startTime = dto.getStartTime();
        if (startTime != null && !startTime.equals("")) {
            startTime = startTime + " 00:00:00";
        }
        if ((endTime = dto.getEndTime()) != null && !endTime.equals("")) {
            endTime = endTime + " 23:59:59";
        }
        List<MedicationDeliveryOrderDto> dtos = this.medicationDeliveryOrderMapper.searchMedicationDeliveryOrderList(dto);
        PageInfo medicationDeliveryOrderDtoPageInfo = new PageInfo(dtos);
        for (MedicationDeliveryOrderDto medicationDeliveryOrderDto : dtos) {
            List<DrugDto> drugDtos = this.searchDrugByOrderNo(medicationDeliveryOrderDto);
            medicationDeliveryOrderDto.setDrugList(drugDtos);
        }
        medicationDeliveryOrderDtoPageInfo.setList(dtos);
        return ResponseData.success(medicationDeliveryOrderDtoPageInfo);
    }

    @Override
    public ResponseData<MedicationDeliveryOrderDto> searchMedicationDeliveryOrderByOne(MedicationDeliveryOrderDto dto) {
        if (dto.getId() == null || dto.getOrderNo() == null || dto.getOrderNo().equals("")) {
            ResponseData.error("\u8ba2\u5355\u7f16\u53f7\u6216id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MedicationDeliveryOrderDto medicationDeliveryOrderDto = this.medicationDeliveryOrderMapper.searchMedicationDeliveryOrderByOne(dto);
        List<DrugDto> drugDtos = this.searchDrugByOrderNo(medicationDeliveryOrderDto);
        medicationDeliveryOrderDto.setDrugList(drugDtos);
        return ResponseData.success(medicationDeliveryOrderDto);
    }

    @Override
    public List<DrugDto> searchDrugByOrderNo(MedicationDeliveryOrderDto dto) {
        List<DrugDto> drugDtos = this.medicationDeliveryOrderMapper.searchDrugByOrderNo(dto);
        return drugDtos;
    }

    @Override
    public ResponseData updateMedicationDeliveryOrder(MedicationDeliveryOrderEntity param) {
        this.medicationDeliveryOrderMapper.updateMedicationDeliveryOrder(param);
        return ResponseData.success();
    }

    @Override
    public ResponseData saveMedicationDeliveryOrder(MedicationDeliveryOrderDto param) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dataStr = format.format(new Date());
        param.setCreateTime(dataStr);
        String takeType = param.getTakeType();
        if (takeType == null || takeType.equals("")) {
            return ResponseData.error("\u53d6\u8d27\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (takeType.equals("2")) {
            if (param.getBuyerName().equals("") || param.getBuyerName() == null || param.getBuyerPhone().equals("") || param.getBuyerPhone() == null || param.getProvinceName().equals("") || param.getProvinceName() == null || param.getCityName().equals("") || param.getCityName() == null || param.getDistrictName().equals("") || param.getDistrictName() == null || param.getBuyerAddress().equals("") || param.getBuyerAddress() == null) {
                return ResponseData.error("\u6536\u8d27\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else if (takeType.equals("1")) {
            List<MedicationDeliveryOrderDto> medicationDeliveryOrderDtos;
            Random random = new Random();
            String str = "";
            MedicationDeliveryOrderDto medicationDeliveryOrderDto = new MedicationDeliveryOrderDto();
            do {
                int i;
                str = (i = random.nextInt(10000)) < 10 ? "000" + i : (i < 100 ? "00" + i : (i < 1000 ? "0" + i : "" + i));
                medicationDeliveryOrderDto.setOrderTakeSelfCode(str);
                medicationDeliveryOrderDto.setTenantId(param.getTenantId());
                medicationDeliveryOrderDto.setIsFinish("0");
            } while ((medicationDeliveryOrderDtos = this.medicationDeliveryOrderMapper.searchMedicationDeliveryOrderList(medicationDeliveryOrderDto)).size() != 0);
            param.setOrderTakeSelfCode(str);
        }
        List<DrugDto> drugDtos = this.medicationDeliveryOrderMapper.searchDrugByOrderNo(param);
        MedicationDeliveryOrderDto medicationDeliveryOrderDto = this.medicationDeliveryOrderMapper.searchMedicationDeliveryOrderByOne(param);
        Class<?> aClass = medicationDeliveryOrderDto.getClass();
        for (Method method : aClass.getMethods()) {
            String name = method.getName();
            if (!name.contains("get") || name.contains("getClass") || name.contains("getId") || name.contains("getCurrent") || name.contains("getSize")) continue;
            try {
                Object invoke = method.invoke((Object)medicationDeliveryOrderDto, new Object[0]);
                if (invoke == null || invoke.equals("")) continue;
                Method method1 = aClass.getMethod(name.replaceAll("get", "set"), String.class);
                method1.invoke((Object)param, invoke);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        param.setDrugList(drugDtos);
        String url = "HTTP://123.56.176.15:8886/api/Order/InsertOrder";
        log.info("=======>\u8bf7\u6c42\u9001\u836f\u8ba2\u5355------>url{},\u53c2\u6570{}", (Object)url, (Object)JSON.toJSONString((Object)param));
        String respStr = null;
        try {
            respStr = HttpUtils.doPost(url, JSON.toJSONString((Object)param), Consts.UTF_8.name(), ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u8bf7\u6c42\u9001\u836f\u8fd4\u56de\u7684\u7ed3\u679c{}", (Object)respStr);
            String substring = respStr.substring(1, respStr.length() - 1);
            String resultCode = JSON.parseObject((String)substring.replaceAll("\\\\", "")).getString("resultcode");
            if (resultCode != null && !resultCode.equals("1000")) {
                log.error("=======>\u8bf7\u6c42\u8c03\u7528\u5931\u8d25{}", (Object)JSON.parseObject((String)respStr).getString("resultDesc"));
                return ResponseData.error("\u8bf7\u6c42\u8c03\u7528\u5931\u8d25");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        param.setIsFinish("0");
        param.setStatus("0");
        this.medicationDeliveryOrderMapper.saveMedicationDeliveryOrder(param);
        return ResponseData.success();
    }

    @Override
    public ResponseData cancelOrder(MedicationDeliveryOrderEntity param) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("orgCode", "d73d27");
        map.put("orderNo", param.getOrderNo());
        try {
            String url = "HTTP://123.56.176.15:8886/api/Order/CancelOrder";
            log.info("=========>\u8bf7\u6c42\u53d6\u6d88\u8ba2\u5355------->url{},\u53c2\u6570{}", (Object)url, (Object)JSON.toJSONString(map));
            String respStr = HttpUtils.doPost(url, JSON.toJSONString(map), Consts.UTF_8.name(), ContentType.APPLICATION_JSON.getMimeType());
            String substring = respStr.substring(1, respStr.length() - 1);
            JSONObject jsonObject = JSON.parseObject((String)substring.replaceAll("\\\\", ""));
            log.info("=========>\u8bf7\u6c42\u76f8\u5e94\u4fe1\u606f{}", (Object)respStr);
            String resultCode = jsonObject.getString("resultcode");
            if (resultCode.equals("-1")) {
                log.error("==========>\u8bf7\u6c42\u8c03\u7528\u5931\u8d25{}", (Object)jsonObject.getString("resultDesc"));
                return ResponseData.error("\u8bf7\u6c42\u8c03\u7528\u5931\u8d25");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        param.setStatus("2");
        param.setIsFinish("1");
        this.medicationDeliveryOrderMapper.updateMedicationDeliveryOrder(param);
        return ResponseData.success();
    }

    @Override
    public Map<String, Object> receiveOrder(MedicationDeliveryOrderDto param) {
        if (param.getStatus().length() > 1) {
            param.setStatus("1");
        }
        MedicationDeliveryOrderEntity entity = new MedicationDeliveryOrderEntity();
        String orderid = param.getOrderid();
        param.setOrderNo(orderid);
        BeanUtils.copyProperties((Object)param, (Object)((Object)entity));
        this.medicationDeliveryOrderMapper.updateMedicationDeliveryOrder(entity);
        HashMap<String, Object> resp = new HashMap<String, Object>();
        resp.put("resultCode", 1000);
        resp.put("resultDesc", "success");
        return resp;
    }
}

