/*
 * Decompiled with CFR 0.152.
 */
package com.byh.chat.core.utils;

import com.byh.chat.core.utils.DESCryptUtils;
import com.byh.chat.core.utils.RongCloudConfig;
import io.rong.RongCloud;
import io.rong.models.Result;
import io.rong.models.group.GroupModel;
import io.rong.models.message.GroupMessage;
import io.rong.models.message.MessageModel;
import io.rong.models.message.SystemMessage;
import io.rong.models.response.GroupUserQueryResult;
import io.rong.models.response.ResponseResult;
import io.rong.models.response.TokenResult;
import io.rong.models.user.UserModel;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.jboss.logging.Logger;

public class RongCloudApi {
    private static Logger log = Logger.getLogger(RongCloudApi.class);
    private static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static RongCloud rongCloud = null;

    public static String getRongCloudUserId(Integer userId, Integer userType) {
        if (null == userId || null == userType) {
            return null;
        }
        DESCryptUtils des = new DESCryptUtils();
        return des.getEncString(String.valueOf(userType) + "-" + String.valueOf(userId));
    }

    public static String getUserToken(UserModel user) {
        try {
            TokenResult result = RongCloudApi.rongCloud.user.register(user);
            log.info((Object)("getToken:  " + String.valueOf(result)));
            if (result.getCode() == 200) {
                return result.getToken();
            }
        }
        catch (Exception e) {
            log.error((Object)"\u83b7\u53d6\u7528\u6237Token\u5931\u8d25\u3002", (Throwable)e);
        }
        return "";
    }

    public static String createGroup(GroupModel groupModel) {
        try {
            Result result = RongCloudApi.rongCloud.group.create(groupModel);
            log.info((Object)result);
            return String.valueOf(result.getCode());
        }
        catch (Exception e) {
            log.error((Object)"\u521b\u5efa\u7fa4\u7ec4\u5931\u8d25\u3002", (Throwable)e);
            return "";
        }
    }

    public static String joinGroup(GroupModel groupModel) {
        try {
            Result result = RongCloudApi.rongCloud.group.join(groupModel);
            log.info((Object)result);
            return String.valueOf(result.getCode());
        }
        catch (Exception e) {
            log.error((Object)"\u52a0\u5165\u7fa4\u7ec4\u5931\u8d25\u3002", (Throwable)e);
            return "";
        }
    }

    public static String quitGroup(GroupModel groupModel) {
        try {
            Result result = RongCloudApi.rongCloud.group.quit(groupModel);
            log.info((Object)result);
            return String.valueOf(result.getCode());
        }
        catch (Exception e) {
            log.error((Object)"\u9000\u51fa\u7fa4\u7ec4\u5931\u8d25\u3002", (Throwable)e);
            return "";
        }
    }

    public static String dismissGroup(GroupModel groupModel) {
        try {
            Result result = RongCloudApi.rongCloud.group.dismiss(groupModel);
            log.info((Object)result);
            return String.valueOf(result.getCode());
        }
        catch (Exception e) {
            log.error((Object)"\u89e3\u6563\u7fa4\u7ec4\u5931\u8d25\u3002", (Throwable)e);
            return "";
        }
    }

    public static String updateGroup(GroupModel groupModel) {
        try {
            Result result = RongCloudApi.rongCloud.group.update(groupModel);
            log.info((Object)result);
            return String.valueOf(result.getCode());
        }
        catch (Exception e) {
            log.error((Object)"\u4fee\u6539\u7fa4\u7ec4\u5931\u8d25\u3002", (Throwable)e);
            return "";
        }
    }

    public static String getGroup(GroupModel groupModel) {
        try {
            GroupUserQueryResult result = RongCloudApi.rongCloud.group.get(groupModel);
            log.info((Object)result);
            if (result.getCode() == 200) {
                return String.valueOf(result.getMembers());
            }
        }
        catch (Exception e) {
            log.error((Object)"\u4fee\u6539\u7fa4\u7ec4\u5931\u8d25\u3002", (Throwable)e);
        }
        return "";
    }

    public static String sendSystem(SystemMessage systemMessage) {
        try {
            ResponseResult result = RongCloudApi.rongCloud.message.system.send((MessageModel)systemMessage);
            log.info((Object)result);
            return String.valueOf(result.getCode());
        }
        catch (Exception e) {
            log.error((Object)"\u53d1\u9001\u7cfb\u7edf\u6d88\u606f\u5931\u8d25\u3002", (Throwable)e);
            return "";
        }
    }

    public static String sendGroup(GroupMessage groupMessage) {
        try {
            ResponseResult result = RongCloudApi.rongCloud.message.group.send(groupMessage);
            log.info((Object)result);
            return String.valueOf(result.getCode());
        }
        catch (Exception e) {
            log.error((Object)"\u53d1\u9001\u7cfb\u7edf\u6d88\u606f\u5931\u8d25\u3002", (Throwable)e);
            return "";
        }
    }

    static {
        try {
            rongCloud = RongCloud.getInstance((String)RongCloudConfig.APPKEY, (String)RongCloudConfig.APPSECRET);
        }
        catch (Exception e) {
            log.error((Object)"\u521d\u59cb\u5316\u878d\u4e91\u5de5\u5177\u7c7b\u5931\u8d25\u3002", (Throwable)e);
        }
    }
}

