/*
 * Decompiled with CFR 0.152.
 */
package com.byh.chat.core.api;

import com.byh.chat.api.vo.SystemMessageVo;
import com.byh.chat.core.enums.ReturnCodeEnum;
import com.byh.chat.core.manager.RongCloudManager;
import com.byh.chat.core.service.IApiRongCloudMessageService;
import com.hxgy.commons.core.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/message"})
@Api(tags={"\u878d\u4e91\u4fe1\u606f\u4ea4\u4e92"})
public class RongCloudMessageController {
    private static final Logger log = LoggerFactory.getLogger(RongCloudMessageController.class);
    @Autowired
    private RongCloudManager rongCloudManager;
    @Autowired
    private IApiRongCloudMessageService iApiRongCloudMessageService;

    @ApiOperation(value="\u63a5\u6536\u878d\u4e91\u63a8\u9001\u6d88\u606f")
    @PostMapping(value={"/receive"})
    public BaseResponse receiveMessage(HttpServletRequest request) throws IOException {
        boolean insert = this.rongCloudManager.receiveMessage(request);
        if (insert) {
            return BaseResponse.success();
        }
        return BaseResponse.error((String)ReturnCodeEnum.FAILURE.getDisplay());
    }

    @ApiOperation(value="\u53d1\u9001\u7cfb\u7edf\u6d88\u606f")
    @PostMapping(value={"/sendsystem_message"})
    public BaseResponse sendSystemMessage(@RequestBody SystemMessageVo systemMessageVo) {
        log.info("==========\u53d1\u9001\u7cfb\u7edf\u6d88\u606f\u5165\u53c2\uff1a" + systemMessageVo.toString() + "============");
        String result = this.iApiRongCloudMessageService.sendSystemMessage(systemMessageVo.getFromUserId(), systemMessageVo.getToUserIds(), systemMessageVo.getContent(), systemMessageVo.getExtra());
        if ("200".equals(result)) {
            return BaseResponse.success();
        }
        return BaseResponse.error((String)ReturnCodeEnum.FAILURE.getDisplay());
    }

    @ApiOperation(value="\u53d1\u9001\u7fa4\u7ec4\u6d88\u606f")
    @PostMapping(value={"/sendgroup_message"})
    public BaseResponse sendgroup_message(@RequestBody SystemMessageVo systemMessageVo) {
        log.info("==========\u53d1\u9001\u7cfb\u7edf\u6d88\u606f\u5165\u53c2\uff1a" + systemMessageVo.toString() + "============");
        if (systemMessageVo.getToUserIds().length > 3) {
            return BaseResponse.error((String)"\u7fa4\u7ec4id\u4e0d\u80fd\u8d85\u8fc7\u4e09\u4e2a\uff01");
        }
        String result = this.iApiRongCloudMessageService.sendGroupMessage(systemMessageVo.getFromUserId(), systemMessageVo.getToUserIds(), systemMessageVo.getObjectName(), systemMessageVo.getContent(), systemMessageVo.getExtra());
        if ("200".equals(result)) {
            return BaseResponse.success();
        }
        return BaseResponse.error((String)ReturnCodeEnum.FAILURE.getDisplay());
    }
}

