/*
 * Decompiled with CFR 0.152.
 */
package com.byh.chat.core.service.impl;

import com.byh.chat.api.pojo.UserRongCloudAssociationEntity;
import com.byh.chat.core.dao.UserRongCloudAssociationMapper;
import com.byh.chat.core.feign.DoctorFeignClient;
import com.byh.chat.core.service.IUserRongCloudAssociationService;
import com.doctoruser.api.pojo.dto.BaseDTO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import com.hxgy.commons.core.response.BaseResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserRongCloudAssociationServiceImpl
implements IUserRongCloudAssociationService {
    private static final Logger log = LoggerFactory.getLogger(UserRongCloudAssociationServiceImpl.class);
    @Autowired
    private UserRongCloudAssociationMapper userRongCloudAssociationMapper;
    @Autowired
    private DoctorFeignClient doctorFeignClient;

    public void save(UserRongCloudAssociationEntity userRongCloudAssociationEntity) {
        log.info("rong cloud param: [{}]", (Object)userRongCloudAssociationEntity.toString());
        UserRongCloudAssociationEntity userRongCloudAssociation = this.userRongCloudAssociationMapper.selectUserRongCloudAssociationListByUserId(userRongCloudAssociationEntity.getUserId());
        if (userRongCloudAssociation == null) {
            log.info("userRongCloudAssociation [{}]  is null", (Object)userRongCloudAssociation);
            userRongCloudAssociationEntity.setStatus(Integer.valueOf(1));
            this.userRongCloudAssociationMapper.insertSelective(userRongCloudAssociationEntity);
        } else {
            log.info("userRongCloudAssociation: [{}]", (Object)userRongCloudAssociation.toString());
            userRongCloudAssociationEntity.setId(userRongCloudAssociation.getId());
            this.userRongCloudAssociationMapper.updateByPrimaryKeySelective(userRongCloudAssociationEntity);
        }
    }

    public void updateById(UserRongCloudAssociationEntity userRongCloudAssociationEntity) {
        this.userRongCloudAssociationMapper.updateByPrimaryKeySelective(userRongCloudAssociationEntity);
    }

    public void deleteById(Long id) {
        this.userRongCloudAssociationMapper.deleteByPrimaryKey(id);
    }

    public UserRongCloudAssociationEntity getUserRongCloudAssociationListByUserId(Long userId) {
        return this.userRongCloudAssociationMapper.selectUserRongCloudAssociationListByUserId(userId);
    }

    public DoctorEntityInfoVO getDoctorInfoByRongCloudId(String rongCloudId) {
        UserRongCloudAssociationEntity userRongCloudAssociationEntity = this.userRongCloudAssociationMapper.getDoctorInfoByRongCloudId(rongCloudId);
        BaseDTO baseDTO = new BaseDTO();
        baseDTO.setId(Integer.valueOf(userRongCloudAssociationEntity.getUserId().intValue()));
        BaseResponse baseResponse = this.doctorFeignClient.endQueryDoctorDetailInfo(baseDTO);
        DoctorEntityInfoVO doctorEntityInfoVO = (DoctorEntityInfoVO)baseResponse.getData();
        return doctorEntityInfoVO;
    }
}

