/*
 * Decompiled with CFR 0.152.
 */
package com.byh.chat.core.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jboss.logging.Logger;

public class EmojiFilterUtil {
    private static Logger log = Logger.getLogger(EmojiFilterUtil.class);

    public static String filter(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        String pattern = "[\ud83c\udc00-\ud83c\udfff]|[\ud83d\udc00-\ud83d\udfff]|[\u2600-\u27ff]";
        String reStr = "";
        Pattern emoji = Pattern.compile(pattern);
        Matcher emojiMatcher = emoji.matcher(str);
        str = emojiMatcher.replaceAll(reStr);
        return str;
    }

    public static String emojiConvert1(String str) throws UnsupportedEncodingException {
        String patternString = "([\\x{10000}-\\x{10ffff}\ud800-\udfff])";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            try {
                matcher.appendReplacement(sb, "[[" + URLEncoder.encode(matcher.group(1), "UTF-8") + "]]");
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)("\u5c06\u5b57\u7b26\u4e32\u4e2d\u7684emoji\u8868\u60c5\u8f6c\u6362\u6210\u53ef\u4ee5\u5728utf-8\u5b57\u7b26\u96c6\u6570\u636e\u5e93\u4e2d\u4fdd\u5b58\u7684\u683c\u5f0f\u5931\u8d25\u3002" + e));
                throw e;
            }
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String emojiRecovery2(String str) throws UnsupportedEncodingException {
        String patternString = "\\[\\[(.*?)\\]\\]";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            try {
                matcher.appendReplacement(sb, URLDecoder.decode(matcher.group(1), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)("\u8fd8\u539futf8\u6570\u636e\u5e93\u4e2d\u4fdd\u5b58\u7684\u542b\u8f6c\u6362\u540eemoji\u8868\u60c5\u7684\u5b57\u7b26\u4e32\u5931\u8d25\u3002" + e));
                throw e;
            }
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

