/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.api.enums;

import java.util.HashMap;
import java.util.Map;

public class AccountEnums {

    public static enum LoginTypeEnum {
        LOGIN(0, "\u767b\u5f55"),
        LOGOUT(1, "\u767b\u51fa");

        private Integer type;
        private String desc;

        private LoginTypeEnum(Integer loginType, String loginTypeDesc) {
            this.type = loginType;
            this.desc = loginTypeDesc;
        }

        public Integer getType() {
            return this.type;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum AccountOperationEnum {
        REGISTER(0, "\u6ce8\u518c\u8d26\u53f7"),
        PERFECT_INFORMATION(1, "\u5b8c\u5584\u8d44\u6599"),
        MODIFYING_DATA(2, "\u4fee\u6539\u8d44\u6599"),
        ACCOUNT_CANCELLATION(3, "\u8d26\u6237\u6ce8\u9500"),
        UPDATE_PASSWORD(4, "\u4fee\u6539\u5bc6\u7801"),
        UPDATE_USER_INFO(5, "\u4fee\u6539\u4e2a\u4eba\u8d44\u6599"),
        UPDATE_ACCOUNT_NO(6, "\u4fee\u6539\u767b\u5f55\u5e10\u53f7"),
        PROHIBIT_ACCOUNT(7, "\u7981\u7528\u8d26\u6237"),
        ENABLE_ACCOUNT(8, "\u542f\u7528\u8d26\u6237");

        private Integer value;
        private String desc;

        private AccountOperationEnum(Integer operationValue, String operationValueDesc) {
            this.value = operationValue;
            this.desc = operationValueDesc;
        }

        public Integer getValue() {
            return this.value;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum AccountStatusEnum {
        NO_REGISTER(6, "\u672a\u6ce8\u518c"),
        NORMAL(1, "\u6b63\u5e38"),
        PROHIBIT(2, "\u7981\u7528"),
        CANCELLATION(3, "\u6ce8\u9500");

        private Integer value;
        private String desc;

        private AccountStatusEnum(Integer accountStatusValue, String accountStatusDesc) {
            this.value = accountStatusValue;
            this.desc = accountStatusDesc;
        }

        public Integer getValue() {
            return this.value;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum ActiveEnum {
        ACTIVE_NO(0, "\u672a\u6fc0\u6d3b"),
        ACTIVE_YES(1, "\u5df2\u63a5\u53d7");

        private Integer value;
        private String desc;
        private static Map<Integer, ActiveEnum> valueMap;

        private ActiveEnum(Integer accountStatusValue, String accountStatusDesc) {
            this.value = accountStatusValue;
            this.desc = accountStatusDesc;
        }

        public Integer getValue() {
            return this.value;
        }

        public String getDesc() {
            return this.desc;
        }

        public static ActiveEnum getByValue(Integer value) {
            ActiveEnum result = valueMap.get(value);
            if (result == null) {
                throw new IllegalArgumentException("No element matches " + value);
            }
            return result;
        }

        static {
            valueMap = new HashMap<Integer, ActiveEnum>();
            for (ActiveEnum e : ActiveEnum.values()) {
                valueMap.put(e.value, e);
            }
        }
    }

    public static enum AccountTypeEnum {
        CELL_PHONE(0, "\u624b\u673a\u53f7\u7801"),
        EMAIL(1, "\u90ae\u7bb1\u5730\u5740"),
        IDENTIFICATION(2, "\u8bc1\u4ef6\u53f7\u7801"),
        CUSTOM(3, "\u81ea\u5b9a\u4e49");

        private Integer value;
        private String desc;

        private AccountTypeEnum(Integer accountTypeValue, String accountTypeDesc) {
            this.value = accountTypeValue;
            this.desc = accountTypeDesc;
        }

        public Integer getValue() {
            return this.value;
        }

        public String getDesc() {
            return this.desc;
        }
    }
}

