/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.api.util;

import java.util.Objects;

public class ResponseData<T> {
    private String code;
    private String msg;
    private T data;

    public ResponseData(String code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public ResponseData(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public ResponseData(String msg) {
        this.msg = msg;
    }

    public T getData() {
        if (this.data == null) {
            this.data = Boolean.TRUE;
        }
        return this.data;
    }

    public static ResponseData success() {
        return new ResponseData(ResponseEnum.SUCCESS.getCode(), ResponseEnum.SUCCESS.getCodeName());
    }

    public static <T> ResponseData success(T data) {
        ResponseData<T> result = new ResponseData<T>(ResponseEnum.SUCCESS.getCode(), ResponseEnum.SUCCESS.getCodeName());
        result.setData(data);
        return result;
    }

    public ResponseData alreadyUpdateStatus() {
        this.msg("\u72b6\u6001\u5df2\u66f4\u6539");
        return this;
    }

    public ResponseData save() {
        this.msg("\u4fdd\u5b58\u6210\u529f");
        return this;
    }

    public ResponseData update() {
        this.msg("\u4fee\u6539\u6210\u529f");
        return this;
    }

    public ResponseData delete() {
        this.msg("\u5220\u9664\u6210\u529f");
        return this;
    }

    public ResponseData saveUpdate() {
        this.msg("\u4fdd\u5b58\u6216\u4fee\u6539\u6210\u529f");
        return this;
    }

    public ResponseData confirm() {
        this.msg("\u72b6\u6001\u5df2\u786e\u8ba4");
        return this;
    }

    public static ResponseData error(String code, String msg) {
        return new ResponseData(code, msg);
    }

    public static ResponseData error(String msg) {
        return new ResponseData(ResponseEnum.BAD_REQUEST.code, msg);
    }

    public static ResponseData tp() {
        ResponseData response = new ResponseData();
        response.setCode("0");
        return response;
    }

    public ResponseData code(String code) {
        this.setCode(code);
        return this;
    }

    public ResponseData data(T data) {
        this.setData(data);
        return this;
    }

    public ResponseData msg(String msg) {
        this.setMsg(msg);
        return this;
    }

    public static ResponseData customResult(String code, String msg) {
        return new ResponseData(code, msg);
    }

    public static ResponseData serviceError() {
        return new ResponseData(ResponseEnum.SERVICE_REFUSE.getCode(), ResponseEnum.SERVICE_ERROR.getCodeName());
    }

    public static ResponseData noAuthen() {
        return new ResponseData(ResponseEnum.NO_AUTH.getCode(), ResponseEnum.NO_AUTH.getCodeName());
    }

    public static ResponseData timeOut() {
        return new ResponseData(ResponseEnum.TIME_OUT.getCode(), ResponseEnum.NO_AUTH.getCodeName());
    }

    public static ResponseData serviceRefuse() {
        return new ResponseData(ResponseEnum.SERVICE_REFUSE.getCode(), ResponseEnum.SERVICE_REFUSE.getCodeName());
    }

    public boolean isSuccess() {
        return Objects.equals(this.code, "200");
    }

    public ResponseData() {
    }

    public String getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResponseData)) {
            return false;
        }
        ResponseData other = (ResponseData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResponseData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "ResponseData(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
    }

    public static enum ResponseEnum {
        SUCCESS("200", "\u64cd\u4f5c\u6210\u529f"),
        BAD_REQUEST("400", "\u64cd\u4f5c\u5931\u8d25"),
        SERVICE_ERROR("500", "\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef"),
        NO_AUTH("401", "\u672a\u6388\u6743"),
        TIME_OUT("408", "\u670d\u8bf7\u6c42\u8d85\u65f6"),
        SERVICE_REFUSE("403", "\u670d\u52a1\u5668\u62d2\u7edd\u8bbf\u95ee\uff08\u65e0\u6743\u9650\uff09");

        private String code;
        private String codeName;

        private ResponseEnum() {
        }

        private ResponseEnum(String code, String codeName) {
            this.code = code;
            this.codeName = codeName;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getCodeName() {
            return this.codeName;
        }

        public void setCodeName(String codeName) {
            this.codeName = codeName;
        }
    }
}

