/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.api.util;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.fastjson.JSON;
import com.byh.sys.api.excel.CustomMergeStrategy;
import com.byh.sys.api.excel.ExcelMergeStrategy;
import com.byh.sys.api.excel.ImportExcelListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class EasyExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(EasyExcelUtil.class);

    public static <T> List<T> importExcel(MultipartFile file, Object entity, Object listener) throws IOException {
        List objects = ((ExcelReaderBuilder)((ExcelReaderBuilder)EasyExcel.read((InputStream)file.getInputStream()).head(entity.getClass())).registerReadListener((ReadListener)listener)).sheet().doReadSync();
        return objects;
    }

    public static void exportExcel(HttpServletResponse response, String excelName, String sheetName, List<?> list, Object data) throws IOException {
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
        String format = LocalDateTime.now(ZoneOffset.ofHours(8)).format(dateTimeFormatter);
        String fileName = URLEncoder.encode(excelName + format, "UTF-8").replaceAll("\\+", "%20");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
        ((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream()).head(data.getClass())).registerWriteHandler((WriteHandler)new ExcelMergeStrategy(data.getClass()))).excelType(ExcelTypeEnum.XLSX).sheet(sheetName).doWrite(list);
    }

    public static void exportExcel(HttpServletResponse response, String excelName, String sheetName, List<?> list, Class<?> pojoClass) {
        try {
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
            String format = LocalDateTime.now(ZoneOffset.ofHours(8)).format(dateTimeFormatter);
            String fileName = null;
            fileName = URLEncoder.encode(excelName + format, "UTF-8").replaceAll("\\+", "%20");
            response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
            ((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream()).head(pojoClass)).registerWriteHandler((WriteHandler)new ExcelMergeStrategy(pojoClass))).excelType(ExcelTypeEnum.XLSX).sheet(sheetName).doWrite(list);
        }
        catch (Exception e) {
            log.info("\u5bfc\u51faexcel\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
    }

    public static String importExcelMerge(MultipartFile file, Object dataVo) throws IOException {
        String object_str = null;
        AtomicReference<Object> ar = new AtomicReference<Object>(new Object());
        try (ExcelReader excelReader = EasyExcelFactory.read((InputStream)file.getInputStream()).build();){
            ReadSheet dealerSheet = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcelFactory.readSheet((Integer)0).head(dataVo.getClass())).registerReadListener(new ImportExcelListener(data -> {
                log.info("\u516c\u53f8\u4fe1\u606f\u6570\u636e----------------------------------------------");
                log.info("\u516c\u53f8\u4fe1\u606f\u6570\u636e\uff1a" + JSON.toJSONString((Object)data));
                ar.set(data);
                log.info("\u516c\u53f8\u4fe1\u606f\u6570\u636e----------------------------------------------");
            }, null))).headRowNumber(Integer.valueOf(2))).build();
            excelReader.read(new ReadSheet[]{dealerSheet});
            object_str = JSON.toJSON((Object)ar.get()).toString();
        }
        catch (IOException e) {
            log.error("\u5904\u7406excel\u5931\u8d25\uff0c" + e.getMessage());
        }
        return object_str;
    }

    public static void exportExcelMerge(HttpServletResponse response, String excelName, String sheetName, Object data, List<?> companyList, List<?> contactList) {
        try (ServletOutputStream out = response.getOutputStream();){
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2");
            String format = LocalDateTime.now(ZoneOffset.ofHours(8)).format(dateTimeFormatter);
            String fileName = URLEncoder.encode(excelName + format, "UTF-8").replaceAll("\\+", "%20");
            response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
            EasyExcelUtil.handleExcel((OutputStream)out, sheetName, data, companyList, contactList);
            out.flush();
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    private static void handleExcel(OutputStream out, String sheetName, Object data, List<?> companyList, List<?> contactList) {
        try (ExcelWriter excelWriter = EasyExcelFactory.write((OutputStream)out).build();){
            WriteSheet medicineSheet = ((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)EasyExcelFactory.writerSheet((Integer)0, (String)sheetName).head(data.getClass())).registerWriteHandler((WriteHandler)new CustomMergeStrategy(companyList.size(), 0))).registerWriteHandler((WriteHandler)new CustomMergeStrategy(companyList.size(), 6))).registerWriteHandler((WriteHandler)new CustomMergeStrategy(companyList.size(), 7))).build();
            excelWriter.write(companyList, medicineSheet);
        }
    }
}

