/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.annotation.UserOptLogger;
import com.byh.sys.api.dto.chargeItem.SysChargeItemDto;
import com.byh.sys.api.excel.ExcelSysChargeItem;
import com.byh.sys.api.request.HsBaseRequest;
import com.byh.sys.api.util.EasyExcelUtil;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.vo.chargeItem.SysChargeItemVo;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysChargeItemService;
import io.swagger.annotations.ApiOperation;
import io.swagger.v3.oas.annotations.Operation;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sysChargeItem"})
public class SysChargeItemController {
    @Autowired
    private CommonRequest commonRequest;
    @Autowired
    private SysChargeItemService sysChargeItemService;

    @ApiOperation(value="\u79fb\u9664\u533b\u4fdd\u5bf9\u7167\u4fe1\u606f")
    @PostMapping(value={"/deleteMedicalInfo"})
    public ResponseData deleteMedicalInfo(@RequestBody Integer id) {
        this.sysChargeItemService.deleteMedicalInfo(id);
        return ResponseData.success((Object)"\u533b\u4fdd\u5bf9\u7167\u4fe1\u606f\u79fb\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u5bfc\u51fa\u6536\u8d39\u9879\u76ee")
    @PostMapping(value={"/exportChargeItemList"})
    @AntiRefresh
    public void exportChargeItemList(HttpServletResponse response) {
        Integer tenantId = this.commonRequest.getTenant();
        this.sysChargeItemService.exportChargeItemList(response, tenantId);
    }

    @PostMapping(value={"/insert"})
    @ApiOperation(value="\u65b0\u589e\u6536\u8d39\u9879\u76ee")
    @UserOptLogger(operation="\u6536\u8d39\u9879\u76ee\u6a21\u5757")
    public ResponseData insert(@RequestBody @Valid SysChargeItemDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setCreateId(this.commonRequest.getUserId());
        dto.setCreateName(this.commonRequest.getUserName());
        dto.setSignNo(this.commonRequest.getSignNo());
        this.sysChargeItemService.insert(dto);
        return ResponseData.success().save();
    }

    @PostMapping(value={"/page/list/select"})
    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5bf9\u5e94\u7684\u5206\u9875\u5217\u8868\u4fe1\u606f")
    @AntiRefresh
    public ResponseData selectPageList(@RequestBody SysChargeItemDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        Page page = this.sysChargeItemService.selectPageList(dto);
        return ResponseData.success((Object)page);
    }

    @PostMapping(value={"/page/list/excel"})
    @Operation(description="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5bf9\u5e94\u7684\u5206\u9875\u5217\u8868\u4fe1\u606f")
    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5bf9\u5e94\u7684\u5206\u9875\u5217\u8868\u4fe1\u606f", httpMethod="POST", notes="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5bf9\u5e94\u7684\u5206\u9875\u5217\u8868\u4fe1\u606f")
    public void excel(HttpServletResponse response, @RequestBody SysChargeItemDto dto) {
        dto.setSize(99999);
        dto.setCurrent(1);
        Page page = this.sysChargeItemService.selectPageList(dto);
        List records = page.getRecords();
        ArrayList<ExcelSysChargeItem> excelList = new ArrayList<ExcelSysChargeItem>();
        for (SysChargeItemVo record : records) {
            ExcelSysChargeItem excel = new ExcelSysChargeItem();
            BeanUtils.copyProperties((Object)record, (Object)excel);
            excelList.add(excel);
        }
        EasyExcelUtil.exportExcel((HttpServletResponse)response, (String)"\u6536\u8d39\u9879\u76ee", (String)"\u6536\u8d39\u9879\u76ee", excelList, ExcelSysChargeItem.class);
    }

    @PutMapping(value={"/update"})
    @ApiOperation(value="\u7f16\u8f91\u6536\u8d39\u9879\u76ee")
    @UserOptLogger(operation="\u6536\u8d39\u9879\u76ee\u6a21\u5757")
    public ResponseData update(@RequestBody SysChargeItemDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setUpdateId(this.commonRequest.getUserId());
        dto.setSignNo(this.commonRequest.getSignNo());
        dto.setUpdateName(this.commonRequest.getUserName());
        this.sysChargeItemService.update(dto);
        return ResponseData.success().update();
    }

    @DeleteMapping(value={"/list/delete"})
    @ApiOperation(value="\u5355\u4e2a\u6216\u6279\u91cf\u5220\u9664\u6536\u8d39\u9879\u76ee")
    @UserOptLogger(operation="\u6536\u8d39\u9879\u76ee\u6a21\u5757")
    public ResponseData deleteList(@RequestBody Integer[] ids) {
        this.sysChargeItemService.deleteList(ids);
        return ResponseData.success().delete();
    }

    @PostMapping(value={"/uploadMedicalInsurance"})
    @ApiOperation(value="\u4e0a\u4f20\u533b\u4fdd\u64cd\u4f5c")
    @UserOptLogger(operation="\u6536\u8d39\u9879\u76ee\u6a21\u5757")
    public ResponseData uploadMedicalInsurance(@RequestBody Integer[] ids) {
        HsBaseRequest hsBaseRequest = new HsBaseRequest();
        hsBaseRequest.setTenantId(this.commonRequest.getTenant());
        hsBaseRequest.setSign_no(this.commonRequest.getSignNo());
        hsBaseRequest.setOpter_type("1");
        hsBaseRequest.setOpter(this.commonRequest.getUserId().toString());
        hsBaseRequest.setOpter_name(this.commonRequest.getUserName());
        hsBaseRequest.setUserId(this.commonRequest.getUserId());
        hsBaseRequest.setIds(ids);
        this.sysChargeItemService.uploadMedicalInsurance(hsBaseRequest);
        return ResponseData.success((Object)"\u533b\u4fdd\u4e0a\u4f20\u5df2\u5b8c\u6210\uff01");
    }
}

