/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller;

import com.byh.sys.api.annotation.UserOptLogger;
import com.byh.sys.api.dto.SysEasyEntity;
import com.byh.sys.api.dto.sysParam.GetSysParamPageDto;
import com.byh.sys.api.model.SysParamEntity;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.vo.SysParamVo;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysParamService;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SysParamController {
    @Autowired
    private SysParamService sysParamService;
    @Autowired
    private CommonRequest commonRequest;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u53c2\u6570\u914d\u7f6e\u5217\u8868")
    @RequestMapping(value={"/sysParam/selectPageList"})
    public ResponseData selectPageList(@RequestBody GetSysParamPageDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.sysParamService.selectPageList(dto));
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u53c2\u6570\u914d\u7f6e")
    @UserOptLogger(operation="\u5220\u9664\u53c2\u6570\u914d\u7f6e")
    @RequestMapping(value={"/sysParam/deleteSysParamByIds"})
    public ResponseData deleteSysParamByIds(@RequestBody String[] ids) {
        this.sysParamService.deleteSysParamByIds(ids, this.commonRequest.getTenant(), this.commonRequest.getUserId(), this.commonRequest.getUserName());
        return ResponseData.success((Object)"\u6279\u91cf\u5220\u9664\u53c2\u6570\u914d\u7f6e\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u7f16\u8f91\u53c2\u6570\u914d\u7f6e")
    @UserOptLogger(operation="\u7f16\u8f91\u53c2\u6570\u914d\u7f6e")
    @RequestMapping(value={"/sysParam/updateSysParam"})
    public ResponseData updateSysParam(@RequestBody SysParamEntity entity) {
        entity.setTenantId(this.commonRequest.getTenant());
        entity.setUpdateId(this.commonRequest.getUserId());
        entity.setUpdateName(this.commonRequest.getUserName());
        this.sysParamService.updateSysParam(entity);
        return ResponseData.success((Object)"\u53c2\u6570\u914d\u7f6e\u7f16\u8f91\u6210\u529f");
    }

    @ApiOperation(value="\u65b0\u589e\u53c2\u6570\u914d\u7f6e")
    @UserOptLogger(operation="\u65b0\u589e\u53c2\u6570\u914d\u7f6e")
    @RequestMapping(value={"/sysParam/insertSysParam"})
    public ResponseData insertSysParam(@RequestBody SysParamEntity entity) {
        entity.setTenantId(this.commonRequest.getTenant());
        entity.setCreateId(this.commonRequest.getUserId());
        entity.setCreateName(this.commonRequest.getUserName());
        this.sysParamService.insertSysParam(entity);
        return ResponseData.success((Object)"\u53c2\u6570\u914d\u7f6e\u65b0\u589e\u6210\u529f");
    }

    @RequestMapping(value={"/sys/param/save"})
    public ResponseData sysParamSave(@RequestBody @Valid SysParamEntity entity) {
        entity.setTenantId(this.commonRequest.getTenant());
        this.sysParamService.sysParamSave(entity);
        return ResponseData.success().save();
    }

    @GetMapping(value={"/sys/param/select"}, produces={"application/json;charset=UTF-8"})
    public ResponseData sysParamSelect(SysParamEntity entity) {
        entity.setTenantId(this.commonRequest.getTenant());
        List list = this.sysParamService.sysParamSelect(entity);
        return ResponseData.success((Object)list);
    }

    @GetMapping(value={"/sys/param/select/byName"}, produces={"application/json;charset=UTF-8"})
    public ResponseData sysParamSelectByName(SysParamEntity entity) {
        entity.setTenantId(this.commonRequest.getTenant());
        SysParamVo vo = this.sysParamService.sysParamSelectByName(entity);
        return ResponseData.success((Object)vo);
    }

    @RequestMapping(value={"/sys/param/update"})
    public ResponseData sysParamUpdate(@RequestBody @Valid SysParamEntity entity) {
        this.sysParamService.sysParamUpdate(entity);
        return ResponseData.success().update();
    }

    @RequestMapping(value={"/sys/param/delete"})
    public ResponseData sysParamDelete(@RequestBody @Valid SysEasyEntity entity) {
        this.sysParamService.sysParamDelete(entity);
        return ResponseData.success().delete();
    }
}

